<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt"
		xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java"
                extension-element-prefixes="barcode" 
    xmlns:cal="xalan://java.util.GregorianCalendar">

<xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

<xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <xsl:attribute-set name="bordas"> 
	  <xsl:attribute name="border-after-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-after-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-before-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-before-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-left-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-left-style">solid</xsl:attribute> 
  	  <xsl:attribute name="border-right-width">1pt</xsl:attribute> 
  	  <xsl:attribute name="border-right-style">solid</xsl:attribute> 
  </xsl:attribute-set>
    
  <xsl:attribute-set name="cabecalhoLeftCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRightCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoLeft">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRight">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinza">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinzaEscuro">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegrito">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoBig">
	<xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoItalico">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="total">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="totalLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>  

 <xsl:attribute-set name="cabecalho">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoCenter">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBigCur">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenter">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenterBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRight">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtRightShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>   

  <xsl:attribute-set name="txtRightBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="linhaTotal">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="border-top-style">solid</xsl:attribute>
	<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <!-- Define a body (or default) page. -->
      <fo:simple-page-master master-name="A4-landscape" page-height="21cm" page-width="29.6cm" margin-top="30pt" margin-left="30pt" margin-right="25pt" margin-bottom="20pt">

        <!-- Central part of page -->
        <fo:region-body column-count="1" margin-top="1.15in" margin-bottom="0.2in"/>

        <!-- Header -->
        <fo:region-before border-after-style="solid" extent="1.15in" margin-bottom="0.2in"/>

        <!-- Footer -->
        <fo:region-after border-before-style="solid" extent="0.2in" margin-bottom="0.2in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>

    <!-- Body page -->
    <fo:page-sequence master-reference="A4-landscape">

      <!-- Define the contents of the header. -->
      <fo:static-content flow-name="xsl-region-before">
		<xsl:call-template name="cabecalho"/>
      </fo:static-content>

      <!-- Define the contents of the footer. -->
      <fo:static-content flow-name="xsl-region-after">
		<fo:table text-align="center" width="780pt" table-layout="fixed">
		<fo:table-column column-width="115pt"/>
		<fo:table-column column-width="550pt"/>
		<fo:table-column column-width="115pt"/>
		
		 <fo:table-body>
		   <fo:table-row>
			<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
			  <fo:block>
			  </fo:block>
			</fo:table-cell>
		  </fo:table-row>
		  <fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtCenter">
					P&#225;gina <fo:page-number/> de <fo:page-number-citation ref-id="last-page"/>
				</fo:block>
			</fo:table-cell>
      
      <xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')"/>
      <xsl:variable name="tmp" select="cal:new()"/>
      <xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)"/>

			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="cal:get($tmp, 11)" />:<xsl:value-of select="cal:get($tmp, 12)" />:<xsl:value-of select="cal:get($tmp, 13)" /> 
				</fo:block>
			</fo:table-cell>
      
		  </fo:table-row>
		 </fo:table-body>
		</fo:table>
      </fo:static-content>

      <!-- The main contents of the body page, that is, the catalog entries 
	   ########## CORPO DO TEXTO DOS RELATRIOS #########
	    -->
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="8.0pt" font-family="serif">
		 <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 <xsl:apply-templates select="mensagens-verificacao"/>

		 <fo:block id="last-page"/>
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<!--
#############################################
#### UC055 Relatrio de Mensagens 
############################################# 
-->	

<!--
##########################
#### CABEALHO
##########################
-->
<xsl:template name="cabecalho">

<!-- Testes para validacao do path de imagens -->
<!--
<xsl:variable name="figura" select="Brasao.jpg"></xsl:variable>
<xsl:variable name="classLoader" select="java:java.lang.ClassLoader.getSystemClassLoader()"></xsl:variable>
<xsl:variable name="url" select="PAD6/PAD6003"></xsl:variable>
<xsl:variable name="caminho" select="jar:file:/C:/$url/padDesktop.jar!/br/gov/rs/tce/pad/imagens/Brasao.jpg"></xsl:variable>

<xsl:variable name="url"><xsl:value-of select="classLoader.getResource($figura).getPath()"></xsl:value-of></xsl:variable>
-->

<xsl:variable name="PathImagem"><xsl:value-of select="mensagens-verificacao/path-imagens"/></xsl:variable>

 <fo:block>
   <fo:table table-layout="fixed">
	<fo:table-column column-width="42pt"/>
	<fo:table-column column-width="696pt"/>
	<fo:table-column column-width="42pt"/>
	
	<fo:table-body>
	 
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt"><fo:block></fo:block>
	 </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	 <fo:table-cell padding-bottom="3pt">
	  <fo:block>
		  <xsl:if test="$PathImagem=''">
        <fo:external-graphic src="imagens/Brasao.jpg"/>
      </xsl:if>
      <xsl:if test="$PathImagem!=''">
        <fo:external-graphic src="{$PathImagem}/Brasao.jpg"/>
      </xsl:if>
	  </fo:block>
	 </fo:table-cell>

	 <fo:table-cell  >
	  <fo:block padding-bottom="1pt">
		<fo:table>
			<fo:table-column column-width="155pt"/>
			<fo:table-column column-width="400pt"/>
			<fo:table-column column-width="141pt"/>
				
			<fo:table-body>
			  <fo:table-row>
				<fo:table-cell padding-left="15pt" padding-top="1pt">
				  <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL</fo:block>
				</fo:table-cell>
					<fo:table-cell number-columns-spanned="1">
						<fo:block xsl:use-attribute-sets="titNegrito">SIAPC - Sistema de Informa&#231;&#245;es para Auditoria e Presta&#231;&#227;o de Contas</fo:block>
					</fo:table-cell>
			   </fo:table-row>

				<fo:table-row>
					<fo:table-cell padding-left="15pt">
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:text>TRIBUNAL DE CONTAS DO ESTADO</xsl:text>
						</fo:block>
					</fo:table-cell>

					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito">Programa Autenticador de Dados - PAD - Vers&#227;o: <xsl:value-of select="mensagens-verificacao/versao-pad"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito">
						</fo:block>
					</fo:table-cell>

					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito">Relat&#243;rio de Erros e Avisos</fo:block>
					</fo:table-cell>
				</fo:table-row>

			  </fo:table-body>
			</fo:table>
		  </fo:block>
		</fo:table-cell>

		<fo:table-cell padding-top="5pt">
		 <fo:block>
		  <xsl:if test="$PathImagem=''">
        <fo:external-graphic src="imagens/tce_2025.jpg"/>
      </xsl:if>
      <xsl:if test="$PathImagem!=''">
        <fo:external-graphic src="{$PathImagem}/tce_2025.jpg"/>
      </xsl:if>     
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
			   
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
	   <fo:block>
	    <fo:table text-align="center" width="780pt" table-layout="fixed">
			<fo:table-column column-width="275pt"/>
			<fo:table-column column-width="305pt"/>
			<fo:table-column column-width="200pt"/>
						
			<fo:table-body>
			 <fo:table-row>
			  <fo:table-cell padding-left="60pt">
			   <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CabecalhoRow/NOME"/></fo:block>
			  </fo:table-cell>
			  <fo:table-cell padding-left="1pt">
			   <fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="mensagens-verificacao/cnpj-entidade"/> - <xsl:value-of select="mensagens-verificacao/entidade"/> - 
                           <!-- <xsl:if test="mensagens-verificacao/bimestre != ''">
                           <xsl:value-of select="mensagens-verificacao/bimestre"/>/
                           </xsl:if> -->
                           <xsl:value-of select="mensagens-verificacao/ano"/></fo:block>
		  	  </fo:table-cell>
			  <fo:table-cell>
			   <fo:block xsl:use-attribute-sets="txtRight">
			 	<xsl:value-of select="mensagens-verificacao/periodo-inicio"/> a <xsl:value-of select="mensagens-verificacao/periodo-fim"/>
			   </fo:block>
			  </fo:table-cell>
		     </fo:table-row>
			</fo:table-body>
		</fo:table>
	  </fo:block>
	</fo:table-cell>
   </fo:table-row>

	  </fo:table-body>
	 </fo:table>
    </fo:block>
</xsl:template>
<!-- #### FIM - CABEALHO ####-->

<!-- INICIO CORPO RELATRIO -->
<xsl:template match="mensagens-verificacao">
  <fo:table width="780pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="105pt"/>
  <fo:table-column column-number="2" column-width="105pt"/>
  <fo:table-column column-number="3" column-width="60pt"/>
  <fo:table-column column-number="4" column-width="60pt"/>
  <fo:table-column column-number="5" column-width="95pt"/>
  <fo:table-column column-number="6" column-width="355pt"/>
   
  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">Nome do Arquivo </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">C&#243;digo do Erro </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">Linha </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">Campo </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">Status </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeftBig">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <xsl:for-each select="mensagens">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:value-of select="arquivo"/>
	 </fo:block>
    </fo:table-cell>    
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:value-of select="codigo-mensagem"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:value-of select="linha"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:value-of select="coluna"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:if test="tipo='W'">
		<xsl:text>Aviso</xsl:text>
	  </xsl:if>
	  <xsl:if test="tipo='J'">
		<xsl:text>Aviso Justificado</xsl:text>
	  </xsl:if>
	  <xsl:if test="tipo='E'">
		<xsl:text>Erro</xsl:text>
	  </xsl:if>
	  <xsl:if test="tipo='I'">
		<xsl:text>Informativo</xsl:text>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" border="solid">
     <fo:block xsl:use-attribute-sets="txtLeftBigCur">
	  <xsl:value-of select="texto"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </fo:table-body>

 </fo:table>
</xsl:template>
<!-- FIM CORPO RELATRIO -->

<!-- #### FIM - UC055 Relatrio de Mensagens ####-->
</xsl:stylesheet>