<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java" extension-element-prefixes="barcode"
	xmlns:cal="xalan://java.util.GregorianCalendar"
	xmlns:exslt="http://exslt.org/common">

	<xsl:output method="xml" encoding="ISO-8859-1" indent="yes" />

	<xsl:decimal-format decimal-separator="," grouping-separator="." />

	<!-- Variaveis de ambiente de execucao -->
	<xsl:param name="PATH_IMAGENS" select="'imagens/'" />
	<xsl:param name="PATH_REMESSA" select="'remessa/'" />

	<xsl:variable name="pageWidthInternal" select="'784pt'" />

	<!-- ######### Styles para os textos do documento ######### -->
	<xsl:attribute-set name="bordas">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>

		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<!-- xsl:attribute name="border-top-width">1pt</xsl:attribute> <xsl:attribute 
			name="border-top-style">solid</xsl:attribute> <xsl:attribute name="border-bottom-width">1pt</xsl:attribute> 
			<xsl:attribute name="border-bottom-style">solid</xsl:attribute -->
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasLR">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasL">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasR">
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasB">
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasTB">
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasAll">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="bordasTableHeader">
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set-->

	<!-- xsl:attribute-set name="bordas2">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordas3">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="bordasUltColuna">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<!-- xsl:attribute-set name="bordasDireita1pt">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">1pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeftCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRightCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeft">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRight">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titFCinza">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titFCinzaEscuro">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegrito">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titNegritoLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titNegritoRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titNegritoBig">
		<xsl:attribute name="font-size">16.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titNegritoMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoItalico">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="total">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="totalLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalho">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<!-- <xsl:attribute name="space-after">1mm</xsl:attribute> -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtLeftShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftShort2">
		<xsl:attribute name="font-size">7.2pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBigCur">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtCenterBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtRightShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRightBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="linhaTotal">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtQuadroTce">
		<xsl:attribute name="font-size">7.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titTabelaHeader">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- xsl:attribute name="background-color">#EEEEEE</xsl:attribute-->
	</xsl:attribute-set>

	<!--
	Muenchian Grouping/Method:
	http://www.jenitennison.com/xslt/grouping/muenchian.html 
	-->
	<xsl:key name="ReceitaRow-group" match="/dc-balorc/Receita/ReceitaRow" use="CD_CONTA_REC"/>
	<xsl:key name="ReceitaRefinanciamentoRow-group" match="/dc-balorc/ReceitaRefinanciamento/ReceitaRefinanciamentoRow" use="CD_CONTA_REC"/>
	<!-- <xsl:key name="SaldosExerciciosAnterioresRow-group" match="/dc-balorc/SaldosExerciciosAnteriores/SaldosExerciciosAnterioresRow" use="CD_CONTA"/> -->
	
	<xsl:key name="DespesaRow-group" match="/dc-balorc/Despesa/DespesaRow" use="CD_ELEM"/>
	<xsl:key name="AmortizacaoDividaRow-group" match="/dc-balorc/AmortizacaoDivida/AmortizacaoDividaRow" use="CD_ELEM"/>
	
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<!-- ******* Define a configuracao da pagina (Folha) ******* -->
				<fo:simple-page-master master-name="default-master"
					page-height="21cm" page-width="29.6cm" margin-top="15pt"
					margin-left="20pt" margin-right="35pt" margin-bottom="15pt">

					<!-- ******* Parte central da pagina (Margens) ******* -->
					<fo:region-body column-count="1" margin-top="1.30in"
						margin-bottom="0.5in" />

					<!-- ******* Cabecalho (Margens) ******* -->
					<fo:region-before border-after-style="solid"
						extent="1.30in" margin-bottom="0.2in" />

					<!-- ******* Rodape (Margens) ******* -->
					<fo:region-after border-before-style="solid"
						extent="0.2in" margin-bottom="0.2in" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<!-- Body page -->
			<!-- ******* Corpo da pagina (Conteudo) ******* -->
			<fo:page-sequence master-reference="default-master">

				<!-- ******* Definindo o conteudo do cabecalho ******* -->
				<fo:static-content flow-name="xsl-region-before">
					<xsl:apply-templates select="dc-balorc/Cabecalho" />
				</fo:static-content>

				<!-- ******* Definindo o conteudo do rodape ******* -->
				<fo:static-content flow-name="xsl-region-after">

					<!-- ******* Variaveis locais ******* -->
					<!-- variaveis para obter a data e hora atual -->
					<xsl:variable name="timeZone1"
						select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
					<xsl:variable name="tmp" select="cal:new()" />
					<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />
					<!-- ******* ******* -->

					<fo:table text-align="center" table-layout="fixed">
						<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
						<fo:table-column column-width="162pt" />
						<fo:table-column column-width="178pt" />
						<fo:table-column column-width="162pt" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
									<fo:block />
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtLeft">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="10pt">
									<fo:block xsl:use-attribute-sets="txtCenter">
										P&#225;gina <fo:page-number />
										de <fo:page-number-citation ref-id="last-page" />
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
								<xsl:variable name="tmp" select="cal:new()" />
								<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />

								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtRight">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), cal:getTime())" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				
				<xsl:variable name="temUnidadeNaoRPPS" select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO [../IDENTIFICADOR!=5]) + sum(dc-balorc/Despesa/DespesaRow/VL_EMPENHADO [../IDENTIFICADOR!=5]) != 0" />
				<xsl:variable name="temRPPS" select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO [../IDENTIFICADOR=5]) + sum(dc-balorc/Despesa/DespesaRow/VL_EMPENHADO [../IDENTIFICADOR=5]) != 0" />

				<!-- ******* Definindo o conteudo do corpo da pagina ******* -->
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="7.0pt" font-family="serif">

						<!--xxxxxxxxxxx BLOCO PRINCIPAL xxxxxxxxxxxxx -->
						
						<!-- <fo:block xsl:use-attribute-sets="titNegritoLeft">Este Demonstrativo esta em fase de testes. Em caso de discordancia, apontar em Notas Explicativas.</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block> -->
						
						<!-- <fo:block>temRPPS: <xsl:value-of select="$temRPPS"/>
							;; <xsl:value-of select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO)" /> ;;
							<xsl:value-of select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO [IDENTIFICADOR=5])" /> ;;
							<xsl:value-of select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO [../IDENTIFICADOR=5])" /> ;;
							<xsl:value-of select="sum(dc-balorc/Receita/ReceitaRow/VL_SALDO [dc-balorc/Receita/ReceitaRow/IDENTIFICADOR=5])" />
						</fo:block> -->

						<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_A">a. Quadro Principal - Receitas e Despesas</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						
						<xsl:apply-templates select="dc-balorc/Receita"/>
						<!-- 
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<xsl:apply-templates select="dc-balorc/ReceitaIntra"/>
						-->
						
						<!--
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						-->
						<fo:block break-after="page"/>
						<!--
						<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_B">b. DESPESAS</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						-->
						
						<xsl:apply-templates select="dc-balorc/Despesa"/>
						<!-- 
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<xsl:apply-templates select="dc-balorc/DespesaIntra"/>
						-->
						
						<xsl:if test="$temUnidadeNaoRPPS and $temRPPS">
						
							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_A_1">a.1 Quadro Principal - Receitas e Despesas -
								<xsl:choose>
									<xsl:when test="dc-balorc/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
										Prefeitura
									</xsl:when>
									<xsl:otherwise>
										Demais Entidades
									</xsl:otherwise>
								</xsl:choose>
							</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-balorc/Receita">
								<xsl:with-param name="receitas" select="dc-balorc/Receita/ReceitaRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="recexant" select="dc-balorc/ReceitaArrecadacaoExerciciosAnteriores/ReceitaArrecadacaoExerciciosAnterioresRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="recrefin" select="dc-balorc/ReceitaRefinanciamento/ReceitaRefinanciamentoRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="saldoexant" select="dc-balorc/SaldosExerciciosAnteriores/SaldosExerciciosAnterioresRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="despesaEmpenhado" select="sum(dc-balorc/Despesa/DespesaRow/VL_EMPENHADO [../IDENTIFICADOR=1]) + sum(dc-balorc/DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO [../IDENTIFICADOR=1]) + sum(dc-balorc/AmortizacaoDivida/AmortizacaoDividaRow/VL_EMPENHADO [../IDENTIFICADOR=1])"/>
								<xsl:with-param name="quadroSintetico" select="false()"/>
							</xsl:apply-templates>
							
							<fo:block break-after="page"/>
							<xsl:apply-templates select="dc-balorc/Despesa">
								<xsl:with-param name="despesas" select="dc-balorc/Despesa/DespesaRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="amortizacao" select="dc-balorc/AmortizacaoDivida/AmortizacaoDividaRow [IDENTIFICADOR=1]"/>
								<xsl:with-param name="tot5arrecadado" select="sum(dc-balorc/Receita/ReceitaRow/VL_ARRECADADO [../NR_NIVEL=1][../IDENTIFICADOR=1]) + sum(dc-balorc/ReceitaRefinanciamento/ReceitaRefinanciamentoRow/VL_ARRECADADO [../NR_NIVEL=2][../IDENTIFICADOR=1])" />
								<xsl:with-param name="quadroSintetico" select="false()"/>
							</xsl:apply-templates>

							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_A_2">a.2 Quadro Principal - Receitas e Despesas - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-balorc/Receita">
								<xsl:with-param name="receitas" select="dc-balorc/Receita/ReceitaRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="recexant" select="dc-balorc/ReceitaArrecadacaoExerciciosAnteriores/ReceitaArrecadacaoExerciciosAnterioresRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="recrefin" select="dc-balorc/ReceitaRefinanciamento/ReceitaRefinanciamentoRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="saldoexant" select="dc-balorc/SaldosExerciciosAnteriores/SaldosExerciciosAnterioresRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="despesaEmpenhado" select="sum(dc-balorc/Despesa/DespesaRow/VL_EMPENHADO [../IDENTIFICADOR=5]) + sum(dc-balorc/DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO [../IDENTIFICADOR=5]) + sum(dc-balorc/AmortizacaoDivida/AmortizacaoDividaRow/VL_EMPENHADO [../IDENTIFICADOR=5])"/>
								<xsl:with-param name="quadroSintetico" select="false()"/>
							</xsl:apply-templates>
							
							<fo:block break-after="page"/>
							<xsl:apply-templates select="dc-balorc/Despesa">
								<xsl:with-param name="despesas" select="dc-balorc/Despesa/DespesaRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="amortizacao" select="dc-balorc/AmortizacaoDivida/AmortizacaoDividaRow [IDENTIFICADOR=5]"/>
								<xsl:with-param name="tot5arrecadado" select="sum(dc-balorc/Receita/ReceitaRow/VL_ARRECADADO [../NR_NIVEL=1][../IDENTIFICADOR=5]) + sum(dc-balorc/ReceitaRefinanciamento/ReceitaRefinanciamentoRow/VL_ARRECADADO [../NR_NIVEL=2][../IDENTIFICADOR=5])" />
								<xsl:with-param name="quadroSintetico" select="false()"/>
							</xsl:apply-templates>
						
						</xsl:if>

						<fo:block break-after="page"/>
						<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_B">b. Quadro da Execu&#231;&#227;o dos Restos a Pagar</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						<xsl:apply-templates select="dc-balorc/Restos"/>
						
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_C">c. Notas Explicativas</fo:block>

						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						<xsl:apply-templates select="dc-balorc/NotasExplicativas"/>

						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<xsl:apply-templates select="dc-balorc/Assinaturas"/>
						
						<!--xxxxxxxxxxx BLOCO PRINCIPAL - FIM xxxxxxx -->
						
						<!-- QUEBRA DE PAGINA -->
						<!-- fo:block break-after="page" /-->

						<!--=========== MENSAGEM ============ -->

						<!-- fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
							<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
							<fo:table-column column-number="1" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell padding-left="50pt">
										<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"
											language="pt" id="RVE_7_1">
											CERTIFICAMOS, com base nos registros constantes na Entidade, a
											consist&#234;ncia das informa&#231;&#245;es apresentadas
											neste relat&#243;rio com as
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="txtLeft">
											enviadas ao TCE.
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="txtLeft" />
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block-->
						
						<!--=========== MENSAGEM ============ -->

						<!--xxxxxxxxxxx ITEM PRINCIPAL [7] - FIM xxxxxxxxxxx -->

						<fo:block id="last-page" />

					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- ########################## #### CABECALHO ########################## -->
	<xsl:template match="Cabecalho">
		<xsl:variable name="periodoFinal">
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 1">
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
			</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
		</xsl:variable>

		<xsl:variable name="tipoRelatorio">
			<xsl:value-of select="CabecalhoRow/TP_RELATORIO" />
		</xsl:variable>

		<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
		<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
		<xsl:variable name="horario" select="substring($dataHora, 12, 8)" />
		<xsl:variable name="dia" select="substring($data, 9, 2)" />
		<xsl:variable name="mes" select="substring($data, 6, 2)" />
		<xsl:variable name="ano" select="substring($data, 1, 4)" />
		<xsl:variable name="hora" select="substring($horario, 1, 2)" />
		<xsl:variable name="minuto" select="substring($horario, 4, 2)" />
		<xsl:variable name="segundo" select="substring($horario, 7, 2)" />

		<fo:block>
			<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
				<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
				<fo:table-column column-width="60pt" />
				<fo:table-column column-width="623pt" />
				<fo:table-column column-width="101pt" />

				<fo:table-body>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block />
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell padding-bottom="3pt">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}" width="50pt" />
							</fo:block>
						</fo:table-cell>

						<fo:table-cell>
							<fo:block padding-bottom="1pt">
								<fo:table table-layout="fixed">
									<fo:table-column column-width="423pt" />
									<fo:table-column column-width="200pt" />
									<fo:table-column column-width="0pt" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="15pt" padding-top="1pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="txtCenter">
												ESTADO DO RIO GRANDE DO SUL - TRIBUNAL DE CONTAS DO ESTADO
												</fo:block>
											</fo:table-cell>
										</fo:table-row>

										<fo:table-row>
											<fo:table-cell padding-left="15pt">
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													SIAPC - Sistema de Informa&#231;&#245;es para
													Auditoria e Presta&#231;&#227;o de Contas
												</fo:block>
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													Programa Autenticador de Dados - Vers&#227;o:
													<xsl:value-of select="CabecalhoRow/VERSAO_PAD" />
													<xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
												</fo:block>
											</fo:table-cell>
											<!-- BARCODE -->
											<fo:table-cell number-rows-spanned="2" text-align="center">
												<fo:block xsl:use-attribute-sets="txtRight">

													<fo:instream-foreign-object>
														<barcode:barcode xmlns:barcode="http://barcode4j.krysalis.org/ns"
															message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-dc-bo}">
															<barcode:code128>
																<barcode:height>15mm</barcode:height>
															</barcode:code128>
														</barcode:barcode>
													</fo:instream-foreign-object>


												</fo:block>
											</fo:table-cell>
											<!-- /BARCODE -->
										</fo:table-row>
										<!-- fo:table-row>
											<fo:table-cell number-columns-spanned="2"
												padding-left="90pt">
												<fo:block xsl:use-attribute-sets="txtLeft"
													font-weight="bold">
													Programa Autenticador de Dados - PAD Vers&#227;o:
													<xsl:value-of select="CabecalhoRow/VERSAO_PAD" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row-->
										<fo:table-row>
											<fo:table-cell padding-left="40pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="titNegritoBig" font-weight="normal">Balan&#231;o Or&#231;ament&#225;rio</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>

						<fo:table-cell padding-top="5pt" text-align="right">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}"
									width="42pt" />
							</fo:block>
							<fo:block xsl:use-attribute-sets="txtRight"> <!-- txtRightShort -->
								<xsl:value-of select="$dia" />
								/
								<xsl:value-of select="$mes" />
								/
								<xsl:value-of select="$ano" />
								-
								<xsl:value-of select="$hora" />
								:
								<xsl:value-of select="$minuto" />
								:
								<xsl:value-of select="$segundo" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block>
								<fo:table text-align="center" table-layout="fixed">
									<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
								
									<fo:table-column column-width="281pt" />
									<fo:table-column column-width="90pt" />
									<fo:table-column column-width="90pt" />
									<fo:table-column column-width="95pt" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="60pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													<xsl:value-of select="CabecalhoRow/NOME" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													ORG&#195;O N&#186;:
													<xsl:value-of
														select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													CNPJ:
													<xsl:value-of select="CabecalhoRow/CNPJ" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="txtRight">
													01/01/<xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
													a
													<xsl:value-of select="$periodoFinal" /><xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- #### FIM - CABE&#199;ALHO #### -->

<!-- #############################################  ############################################# -->

<xsl:template match="Receita">
	<xsl:param name="receitas" select="ReceitaRow"/>
	<xsl:param name="recexant" select="../ReceitaArrecadacaoExerciciosAnteriores/ReceitaArrecadacaoExerciciosAnterioresRow"/>
	<xsl:param name="recrefin" select="../ReceitaRefinanciamento/ReceitaRefinanciamentoRow"/>
	<xsl:param name="saldoexant" select="../SaldosExerciciosAnteriores/SaldosExerciciosAnterioresRow"/>
	<xsl:param name="despesaEmpenhado" select="sum(../Despesa/DespesaRow/VL_EMPENHADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO)+sum(../AmortizacaoDivida/AmortizacaoDividaRow/VL_EMPENHADO)"/>
	<xsl:param name="quadroSintetico" select="true()"/>

	<!-- fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_1">1. RECEITAS <!- - (EXCETO INTRA-ORCAMENTARIAS) (I) - -></fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block-->

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasB">
		<fo:table-column column-width="339pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />

		<xsl:call-template name="ReceitaHeaderRow">
			<xsl:with-param name="COL1_DESC" select="'RECEITAS OR&#199;AMENT&#193;RIAS'"/>
		</xsl:call-template>

		<fo:table-body>
			<xsl:variable name="tot1orcado" select="sum($receitas/VL_ORCADO [../NR_NIVEL=1])" />
			<xsl:variable name="tot1orcadoAtual" select="sum($receitas/VL_ORCADO_ATUAL [../NR_NIVEL=1])" />
			<xsl:variable name="tot1arrecadado" select="sum($receitas/VL_ARRECADADO [../NR_NIVEL=1])" />
			<xsl:variable name="tot1saldo" select="sum($receitas/VL_SALDO [../NR_NIVEL=1])" />
			<!-- <xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECEITAS DO EXERC&#205;CIO CORRENTE (I)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot1orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot1orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot1arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot1saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template> -->
			
			<xsl:variable name="grupoContas">1</xsl:variable>
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECEITAS CORRENTES (I)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="sum($receitas/VL_ORCADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($receitas/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_ARRECADADO" select="sum($receitas/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_SALDO" select="sum($receitas/VL_SALDO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
			<xsl:for-each select="$receitas [count(.|key('ReceitaRow-group', CD_CONTA_REC)[1])=1]"> <!-- Iterar pelos grupos -->
				<xsl:variable name="ReceitaRowX" select="key('ReceitaRow-group', CD_CONTA_REC)"/> <!-- Obter grupo -->
				<!-- <fo:table-row><fo:table-cell>
				<fo:block>contarec: <xsl:value-of select="CD_CONTA_REC"/>;</fo:block>
				</fo:table-cell></fo:table-row> -->
				<!-- <xsl:apply-templates select="$ReceitaRowX [GRUPO_CONTAS=1][NR_NIVEL>0]"/> -->
				<!-- <xsl:apply-templates select="$receitas [GRUPO_CONTAS=1][NR_NIVEL>0]"/> -->
				<xsl:if test="sum($ReceitaRowX/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1]) + sum($ReceitaRowX/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1]) != 0">
					<xsl:call-template name="ReceitaRow">
						<xsl:with-param name="DS_CONTA_REC" select="$ReceitaRowX[1]/DS_CONTA_REC"/>
						<xsl:with-param name="NR_NIVEL" select="$ReceitaRowX[1]/NR_NIVEL"/>
						<xsl:with-param name="VL_ORCADO" select="sum($ReceitaRowX/VL_ORCADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($ReceitaRowX/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_ARRECADADO" select="sum($ReceitaRowX/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_SALDO" select="sum($ReceitaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$receitas [GRUPO_CONTAS=$grupoContas][NR_NIVEL>0]"/>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:variable name="grupoContas">2</xsl:variable>
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECEITAS DE CAPITAL (II)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="sum($receitas/VL_ORCADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($receitas/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_ARRECADADO" select="sum($receitas/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="VL_SALDO" select="sum($receitas/VL_SALDO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
			<xsl:for-each select="$receitas [count(.|key('ReceitaRow-group', CD_CONTA_REC)[1])=1]"> <!-- Iterar pelos grupos -->
				<xsl:variable name="ReceitaRowX" select="key('ReceitaRow-group', CD_CONTA_REC)"/> <!-- Obter grupo -->
				<xsl:if test="sum($ReceitaRowX/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1]) + sum($ReceitaRowX/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1]) != 0">
					<xsl:call-template name="ReceitaRow">
						<xsl:with-param name="DS_CONTA_REC" select="$ReceitaRowX[1]/DS_CONTA_REC"/>
						<xsl:with-param name="NR_NIVEL" select="$ReceitaRowX[1]/NR_NIVEL"/>
						<xsl:with-param name="VL_ORCADO" select="sum($ReceitaRowX/VL_ORCADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($ReceitaRowX/VL_ORCADO_ATUAL [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_ARRECADADO" select="sum($ReceitaRowX/VL_ARRECADADO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
						<xsl:with-param name="VL_SALDO" select="sum($ReceitaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas][../NR_NIVEL=1])"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$receitas [GRUPO_CONTAS=$grupoContas][NR_NIVEL>0]"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<!--
			<xsl:variable name="tot2orcado" select="sum($recexant/VL_ORCADO)" />
			<xsl:variable name="tot2orcadoAtual" select="sum($recexant/VL_ORCADO_ATUAL)" />
			<xsl:variable name="tot2arrecadado" select="sum($recexant/VL_ARRECADADO)" />
			<xsl:variable name="tot2saldo" select="sum($recexant/VL_SALDO)" />
			
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECURSOS ARRECADADOS EM EXERC&#205;CIOS ANTERIORES (III)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot2orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot2orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot2arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot2saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			-->
			
			<!-- 
			<xsl:variable name="tot2orcado" select="sum(../ReceitaIntra/ReceitaIntraRow/VL_ORCADO [../NR_NIVEL=2])" />
			<xsl:variable name="tot2orcadoAtual" select="sum(../ReceitaIntra/ReceitaIntraRow/VL_ORCADO [../NR_NIVEL=2])" />
			<xsl:variable name="tot2arrecadado" select="sum(../ReceitaIntra/ReceitaIntraRow/VL_ARRECADADO [../NR_NIVEL=2])" />
			<xsl:variable name="tot2saldo" select="sum(../ReceitaIntra/ReceitaIntraRow/VL_SALDO [../NR_NIVEL=2])" />
			-->
			<!-- 
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECEITAS (INTRA-OR&#199;AMENT&#193;RIAS) (II)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot2orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot2orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot2arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot2saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			 -->
			<xsl:variable name="tot3orcado" select="$tot1orcado" />
			<xsl:variable name="tot3orcadoAtual" select="$tot1orcadoAtual" />
			<xsl:variable name="tot3arrecadado" select="$tot1arrecadado" />
			<xsl:variable name="tot3saldo" select="$tot1saldo" />
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">SUBTOTAL DAS RECEITAS (III) = (I + II)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot3orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot3orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot3arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot3saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">OPERA&#199;&#213;ES DE CR&#201;DITO / REFINANCIAMENTO (IV)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="sum($recrefin/VL_ORCADO [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($recrefin/VL_ORCADO_ATUAL [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_ARRECADADO" select="sum($recrefin/VL_ARRECADADO [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_SALDO" select="sum($recrefin/VL_SALDO [../NR_NIVEL=2])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:choose>
				<xsl:when test="$quadroSintetico">
					<!-- <xsl:for-each select="$recrefin [count(.|key('ReceitaRefinanciamentoRow-group', CD_CONTA_REC)[1])=1]"> --> <!-- Iterar pelos grupos -->
					<xsl:for-each select="$recrefin"> <!-- Iterar pelos grupos -->
						<xsl:variable name="ReceitaRefinanciamentoRowX" select="key('ReceitaRefinanciamentoRow-group', CD_CONTA_REC)"/> <!-- Obter grupo -->
						<!-- <fo:table-row><fo:table-cell>
						<fo:block>recrefin: <xsl:value-of select="CD_CONTA_REC"/>;<xsl:value-of select="IDENTIFICADOR"/>;<xsl:value-of select="count(.)"/>;<xsl:value-of select="count(key('ReceitaRefinanciamentoRow-group', CD_CONTA_REC)[1])"/>;</fo:block>
						</fo:table-cell></fo:table-row> -->
						<xsl:if test="count(.|key('ReceitaRefinanciamentoRow-group', CD_CONTA_REC)[1])=1">
						<xsl:call-template name="ReceitaRow">
							<xsl:with-param name="DS_CONTA_REC" select="$ReceitaRefinanciamentoRowX[1]/DS_CONTA_REC"/>
							<xsl:with-param name="NR_NIVEL" select="$ReceitaRefinanciamentoRowX[1]/NR_NIVEL"/>
							<xsl:with-param name="VL_ORCADO" select="sum($ReceitaRefinanciamentoRowX/VL_ORCADO)"/>
							<xsl:with-param name="VL_ORCADO_ATUAL" select="sum($ReceitaRefinanciamentoRowX/VL_ORCADO_ATUAL)"/>
							<xsl:with-param name="VL_ARRECADADO" select="sum($ReceitaRefinanciamentoRowX/VL_ARRECADADO)"/>
							<xsl:with-param name="VL_SALDO" select="sum($ReceitaRefinanciamentoRowX/VL_SALDO)"/>
						</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$recrefin"/>
				</xsl:otherwise>
			</xsl:choose>

			<xsl:variable name="tot5orcado" select="$tot3orcado + sum($recrefin/VL_ORCADO [../NR_NIVEL=2])" />
			<xsl:variable name="tot5orcadoAtual" select="$tot3orcadoAtual + sum($recrefin/VL_ORCADO_ATUAL [../NR_NIVEL=2])" />
			<xsl:variable name="tot5arrecadado" select="$tot3arrecadado + sum($recrefin/VL_ARRECADADO [../NR_NIVEL=2])" />
			<xsl:variable name="tot5saldo" select="$tot3saldo + sum($recrefin/VL_SALDO [../NR_NIVEL=2])" />

			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">SUBTOTAL COM REFINANCIAMENTO (V) = (III + IV)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot5orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot5orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot5arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot5saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:variable name="defcit">
				<xsl:choose>
					<xsl:when test="$despesaEmpenhado > $tot5arrecadado">
						<xsl:value-of select="$despesaEmpenhado - $tot5arrecadado"></xsl:value-of>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">D&#201;FICIT (VI)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="'-'"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="'-'"/>
				<xsl:with-param name="VL_ARRECADADO" select="$defcit"/>
				<xsl:with-param name="VL_SALDO" select="'-'"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">TOTAL (VII) = (V + VI)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot5orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot5orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot5arrecadado + $defcit"/>
				<xsl:with-param name="VL_SALDO" select="$tot5saldo"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:variable name="tot2orcado" select="sum($recexant/VL_ORCADO)" />
			<xsl:variable name="tot2orcadoAtual" select="sum($recexant/VL_ORCADO_ATUAL)" />
			<xsl:variable name="tot2arrecadado" select="sum($recexant/VL_ARRECADADO)" />
			<xsl:variable name="tot2saldo" select="sum($recexant/VL_SALDO)" />
			
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">SALDOS DE EXERC&#205;CIOS ANTERIORES<!-- (UTILIZADOS PARA CR&#201;DITOS ADICIONAIS)--></xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<!-- <xsl:with-param name="VL_ORCADO_ATUAL" select="sum($saldoexant/VL_ORCADO_ATUAL)"/> -->
				<xsl:with-param name="VL_ORCADO" select="$tot2orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot2orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="sum($saldoexant/VL_ARRECADADO)+$tot2arrecadado"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">Recursos Arrecadados em Exerccios Anteriores</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="$tot2orcado"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="$tot2orcadoAtual"/>
				<xsl:with-param name="VL_ARRECADADO" select="$tot2arrecadado"/>
				<xsl:with-param name="VL_SALDO" select="$tot2saldo"/>
				<!--<xsl:with-param name="_titulo">true</xsl:with-param>-->
			</xsl:call-template>

			<!-- <xsl:apply-templates select="$saldoexant"/> -->
			<!-- <xsl:for-each select="$saldoexant [count(.|key('SaldosExerciciosAnterioresRow-group', CD_CONTA)[1])=1]"> Iterar pelos grupos
				<xsl:variable name="SaldosExerciciosAnterioresRowX" select="key('SaldosExerciciosAnterioresRow-group', CD_CONTA)"/> Obter grupo
				<xsl:call-template name="ReceitaRow">
					<xsl:with-param name="DS_CONTA_REC" select="$SaldosExerciciosAnterioresRowX[1]/DS_CONTA_REC"/>
					<xsl:with-param name="NR_NIVEL" select="$SaldosExerciciosAnterioresRowX[1]/NR_NIVEL"/>
					<xsl:with-param name="VL_ORCADO_ATUAL" select="'-'"/>
					<xsl:with-param name="VL_ARRECADADO" select="sum($SaldosExerciciosAnterioresRowX/VL_ARRECADADO)"/>
					<xsl:with-param name="VL_SALDO" select="'-'"/>
				</xsl:call-template>
			</xsl:for-each> -->
			<!-- <xsl:for-each select="$saldoexant [CD_CONTA = key('SaldosExerciciosAnterioresRow-group', CD_CONTA)/CD_CONTA]"> -->
			<!--
			<xsl:for-each select="$saldoexant">
				<xsl:if test="VL_ARRECADADO &gt; 0">
					<xsl:call-template name="ReceitaRow">
					-->
						<!-- <xsl:with-param name="DS_CONTA_REC">
							<xsl:choose>
								<xsl:when test="IDENTIFICADOR = 5"><xsl:value-of select="concat(DS_CONTA_REC, ' (RPPS)')"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="DS_CONTA_REC"/></xsl:otherwise>
							</xsl:choose>
						</xsl:with-param> -->
						<!-- <xsl:with-param name="DS_CONTA_REC" select="concat(' - ',CD_CONTA, ' -|-', key('SaldosExerciciosAnterioresRow-group', CD_CONTA)/CD_CONTA)"/> -->
						<!--
						<xsl:with-param name="VL_ORCADO_ATUAL" select="'-'"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:for-each>
			-->

			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">Superavit Financeiro</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_ARRECADADO" select="sum($saldoexant[CD_CONTA=522130100]/VL_ARRECADADO)"/>
			</xsl:call-template>

			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">Reabertura de Creditos Adicionais</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_ARRECADADO" select="sum($saldoexant[CD_CONTA=522120202]/VL_ARRECADADO)"/>
			</xsl:call-template>

		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template match="ReceitaIntra">
	<!-- fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_2">2. RECEITAS INTRA-ORCAMENTARIAS</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block-->

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasB">
		<fo:table-column column-width="339pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />
		<fo:table-column column-width="111pt" />

		<xsl:call-template name="ReceitaHeaderRow">
			<xsl:with-param name="COL1_DESC" select="'RECEITAS INTRA-OR&#199;AMENT&#193;RIAS'"/>
		</xsl:call-template>
		<fo:table-body>
			<xsl:call-template name="ReceitaRow">
				<xsl:with-param name="DS_CONTA_REC">RECEITAS (INTRA-OR&#199;AMENT&#193;RIAS) (II)</xsl:with-param>
				<xsl:with-param name="NR_NIVEL">0</xsl:with-param>
				<xsl:with-param name="VL_ORCADO" select="sum(ReceitaIntraRow/VL_ORCADO [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_ORCADO_ATUAL" select="sum(ReceitaIntraRow/VL_ORCADO_ATUAL [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_ARRECADADO" select="sum(ReceitaIntraRow/VL_ARRECADADO [../NR_NIVEL=2])"/>
				<xsl:with-param name="VL_SALDO" select="sum(ReceitaIntraRow/VL_SALDO [../NR_NIVEL=2])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:apply-templates select="ReceitaIntraRow"/>
		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template name="ReceitaHeaderRow">
		<xsl:param name="COL1_DESC" />
		<fo:table-header>
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						<xsl:value-of select="$COL1_DESC"></xsl:value-of> <!-- RECEITAS OR&#199;AMENT&#193;RIAS <!- - Descricao Receitas Orcamentarias -->
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						PREVIS&#195;O INICIAL (a)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						PREVIS&#195;O ATUALIZADA (b)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						RECEITAS REALIZADAS (c)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						SALDO (d = c - b)
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-header>
</xsl:template>

<xsl:template name="ReceitaRow" match="ReceitaRow|ReceitaRefinanciamentoRow|ReceitaIntraRow|SaldosExerciciosAnterioresRow">
	<xsl:param name="NR_NIVEL" select="NR_NIVEL" />
	<xsl:param name="DS_CONTA_REC" select="DS_CONTA_REC" />
	<xsl:param name="VL_ORCADO" select="VL_ORCADO" />
	<xsl:param name="VL_ORCADO_ATUAL" select="VL_ORCADO_ATUAL" />
	<xsl:param name="VL_ARRECADADO" select="VL_ARRECADADO" />
	<xsl:param name="VL_SALDO" select="VL_SALDO" />
	<xsl:param name="_titulo" select="false" />

	<fo:table-row>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="padding-left"><xsl:value-of select="concat( (number($NR_NIVEL)) * 20,'pt')"/></xsl:attribute>
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="$DS_CONTA_REC" /> 
				<!-- <xsl:value-of select="IDENTIFICADOR" /> -->
				<!-- (<xsl:value-of select="$NR_NIVEL"/>) -->
				<!-- xsl:value-of select="(number(NR_NIVEL)-1)*10"/> //
				<xsl:value-of select="concat( (number(NR_NIVEL)-1) * 10,'pt')"/-->
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_ORCADO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_ORCADO_ATUAL"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_ARRECADADO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_SALDO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template match="Despesa">
	<xsl:param name="despesas" select="DespesaRow"/>
	<xsl:param name="amortizacao" select="../AmortizacaoDivida/AmortizacaoDividaRow"/>
	<xsl:param name="tot5arrecadado" select="sum(../Receita/ReceitaRow/VL_ARRECADADO [../NR_NIVEL=1]) + sum(../ReceitaRefinanciamento/ReceitaRefinanciamentoRow/VL_ARRECADADO [../NR_NIVEL=2])" />
	<xsl:param name="quadroSintetico" select="true()"/>

	<!-- fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_3">3. DESPESAS</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block-->

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasB">
		<fo:table-column column-width="280pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />

		<xsl:call-template name="DespesaHeaderRow">
			<xsl:with-param name="COL1_DESC" select="'DESPESAS OR&#199;AMENT&#193;RIAS'"/>
		</xsl:call-template>

		<fo:table-body>
			<!-- <xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">DESPESAS (VIII)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum(DespesaRow/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum(DespesaRow/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum(DespesaRow/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum(DespesaRow/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum(DespesaRow/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum(DespesaRow/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template> -->

			<xsl:variable name="grupoContas">3</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">DESPESAS CORRENTES (VIII)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
					<xsl:for-each select="$despesas [GRUPO_CONTAS=$grupoContas][count(.|key('DespesaRow-group', CD_ELEM)[1])=1]"> <!-- Iterar pelos grupos -->
						<xsl:variable name="DespesaRowX" select="key('DespesaRow-group', CD_ELEM)"/> <!-- Obter grupo -->
						<xsl:if test="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas]) + sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas]) != 0">
							<xsl:call-template name="DespesaRow">
								<xsl:with-param name="NR_NIVEL" select="$DespesaRowX[1]/NR_NIVEL"/>
								<xsl:with-param name="DS_RUBRICA" select="$DespesaRowX[1]/DS_RUBRICA"/>
								<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($DespesaRowX/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_EMPENHADO" select="sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_LIQUIDADO" select="sum($DespesaRowX/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_PAGO" select="sum($DespesaRowX/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_SALDO" select="sum($DespesaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$despesas [GRUPO_CONTAS=$grupoContas]"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:variable name="grupoContas">4</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">DESPESAS DE CAPITAL (IX)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
					<xsl:for-each select="$despesas [GRUPO_CONTAS=$grupoContas][count(.|key('DespesaRow-group', CD_ELEM)[1])=1]"> <!-- Iterar pelos grupos -->
						<xsl:variable name="DespesaRowX" select="key('DespesaRow-group', CD_ELEM)"/> <!-- Obter grupo -->
						<!-- <fo:table-row><fo:table-cell><fo:block>bbb:<xsl:value-of select="CD_ELEM"/>,</fo:block></fo:table-cell></fo:table-row> -->
						<xsl:if test="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas]) + sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas]) != 0">
							<xsl:call-template name="DespesaRow">
								<xsl:with-param name="NR_NIVEL" select="$DespesaRowX[1]/NR_NIVEL"/>
								<xsl:with-param name="DS_RUBRICA" select="$DespesaRowX[1]/DS_RUBRICA"/>
								<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($DespesaRowX/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_EMPENHADO" select="sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_LIQUIDADO" select="sum($DespesaRowX/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_PAGO" select="sum($DespesaRowX/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
								<xsl:with-param name="VL_SALDO" select="sum($DespesaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$despesas [GRUPO_CONTAS=$grupoContas]"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<!-- <xsl:variable name="grupoContas">9</xsl:variable>
			<xsl:apply-templates select="$despesas [GRUPO_CONTAS=$grupoContas][NR_NIVEL=1]">
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:apply-templates> -->
			<xsl:variable name="cdElem">99999</xsl:variable>
			<xsl:variable name="cdElemRpps">99997</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="DS_RUBRICA" select="'RESERVA DE CONTINGENCIA (X)'"/> <!-- $despesas [CD_ELEM=99999][NR_NIVEL=1][1] -->
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<!--
			<xsl:variable name="cdElem">99997</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="DS_RUBRICA" select="'RESERVA DO RPPS (XII)'"/>
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM=$cdElem][NR_NIVEL=1]/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			-->

			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">SUBTOTAL DAS DESPESAS (XI) = (VIII + IX + X)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<!--
			<xsl:apply-templates select="../DespesaIntraSum/DespesaIntraSumRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:apply-templates>
			-->
			
			<!--
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">SUBTOTAL DAS DESPESAS (X) = (VIII)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum(DespesaRow/VL_DOTACAO_INICIAL)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum(DespesaRow/VL_DOTACAO_AUTORIZADA)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum(DespesaRow/VL_EMPENHADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum(DespesaRow/VL_LIQUIDADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum(DespesaRow/VL_PAGO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum(DespesaRow/VL_SALDO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			-->
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">AMORTIZA&#199;&#195;O DA D&#205;V. / REFINANCIAMENTO (XII)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($amortizacao/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($amortizacao/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($amortizacao/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($amortizacao/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($amortizacao/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($amortizacao/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">2</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">Amortiza&#231;&#227;o da D&#237;vida Interna</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($amortizacao/VL_DOTACAO_INICIAL [../ORIGEM_DIVIDA='i'])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($amortizacao/VL_DOTACAO_AUTORIZADA [../ORIGEM_DIVIDA='i'])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($amortizacao/VL_EMPENHADO [../ORIGEM_DIVIDA='i'])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($amortizacao/VL_LIQUIDADO [../ORIGEM_DIVIDA='i'])"/>
				<xsl:with-param name="VL_PAGO" select="sum($amortizacao/VL_PAGO [../ORIGEM_DIVIDA='i'])"/>
				<xsl:with-param name="VL_SALDO" select="sum($amortizacao/VL_SALDO [../ORIGEM_DIVIDA='i'])"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
					<!-- <xsl:for-each select="$amortizacao [ORIGEM_DIVIDA='i']">
						<fo:table-row><fo:table-cell><fo:block>aaa:<xsl:value-of select="CD_ELEM"/>,,<xsl:value-of select="DS_RUBRICA"/></fo:block></fo:table-cell></fo:table-row>
					</xsl:for-each> -->
					<xsl:for-each select="$amortizacao [ORIGEM_DIVIDA='i'][count(.|key('AmortizacaoDividaRow-group', CD_ELEM)[1])=1]"> <!-- Iterar pelos grupos -->
						<!-- <fo:table-row><fo:table-cell><fo:block>bbb:<xsl:value-of select="CD_ELEM"/>,</fo:block></fo:table-cell></fo:table-row> -->
						<xsl:variable name="DespesaRowX" select="key('AmortizacaoDividaRow-group', CD_ELEM)"/> <!-- Obter grupo -->
						<xsl:call-template name="DespesaRow">
							<xsl:with-param name="NR_NIVEL" select="$DespesaRowX[1]/NR_NIVEL"/>
							<xsl:with-param name="DS_RUBRICA" select="$DespesaRowX[1]/DS_RUBRICA"/>
							<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($DespesaRowX/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_EMPENHADO" select="sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_LIQUIDADO" select="sum($DespesaRowX/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_PAGO" select="sum($DespesaRowX/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_SALDO" select="sum($DespesaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$amortizacao [ORIGEM_DIVIDA='i']"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">2</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">Amortiza&#231;&#227;o da D&#237;vida Externa</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($amortizacao/VL_DOTACAO_INICIAL [../ORIGEM_DIVIDA='e'])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($amortizacao/VL_DOTACAO_AUTORIZADA [../ORIGEM_DIVIDA='e'])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($amortizacao/VL_EMPENHADO [../ORIGEM_DIVIDA='e'])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($amortizacao/VL_LIQUIDADO [../ORIGEM_DIVIDA='e'])"/>
				<xsl:with-param name="VL_PAGO" select="sum($amortizacao/VL_PAGO [../ORIGEM_DIVIDA='e'])"/>
				<xsl:with-param name="VL_SALDO" select="sum($amortizacao/VL_SALDO [../ORIGEM_DIVIDA='e'])"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$quadroSintetico">
					<!-- <xsl:for-each select="$amortizacao [ORIGEM_DIVIDA='e']">
						<fo:table-row><fo:table-cell><fo:block>aaa:<xsl:value-of select="CD_ELEM"/>,<xsl:value-of select="DS_RUBRICA"/></fo:block></fo:table-cell></fo:table-row>
					</xsl:for-each> -->
					<xsl:for-each select="$amortizacao [ORIGEM_DIVIDA='e'][count(.|key('AmortizacaoDividaRow-group', CD_ELEM)[1])=1]"> <!-- Iterar pelos grupos -->
						<!-- <fo:table-row><fo:table-cell><fo:block>bbb:<xsl:value-of select="CD_ELEM"/>,</fo:block></fo:table-cell></fo:table-row> -->
						<xsl:variable name="DespesaRowX" select="key('AmortizacaoDividaRow-group', CD_ELEM)"/> <!-- Obter grupo -->
						<xsl:call-template name="DespesaRow">
							<xsl:with-param name="NR_NIVEL" select="$DespesaRowX[1]/NR_NIVEL"/>
							<xsl:with-param name="DS_RUBRICA" select="$DespesaRowX[1]/DS_RUBRICA"/>
							<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($DespesaRowX/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($DespesaRowX/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_EMPENHADO" select="sum($DespesaRowX/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_LIQUIDADO" select="sum($DespesaRowX/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_PAGO" select="sum($DespesaRowX/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
							<xsl:with-param name="VL_SALDO" select="sum($DespesaRowX/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="$amortizacao [ORIGEM_DIVIDA='e']"/>
				</xsl:otherwise>
			</xsl:choose>
			
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">SUBTOTAL C/ REFINANCIAMENTO (XIII) = (XI + XII)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_INICIAL)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_INICIAL)+sum($amortizacao/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_AUTORIZADA)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_AUTORIZADA)+sum($amortizacao/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_EMPENHADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO)+sum($amortizacao/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_LIQUIDADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_LIQUIDADO)+sum($amortizacao/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_PAGO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_PAGO)+sum($amortizacao/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_SALDO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_SALDO)+sum($amortizacao/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:variable name="despesaEmpenhado" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_EMPENHADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO)+sum($amortizacao/VL_EMPENHADO)" />
			<!-- <xsl:variable name="tot5arrecadado" select="sum(../Receita/ReceitaRow/VL_ARRECADADO [../NR_NIVEL=1]) + sum(../ReceitaRefinanciamento/ReceitaRefinanciamentoRow/VL_ARRECADADO [../NR_NIVEL=2])" /> -->
			<xsl:variable name="superavit">
				<xsl:choose>
					<xsl:when test="$tot5arrecadado > $despesaEmpenhado">
						<xsl:value-of select="$tot5arrecadado - $despesaEmpenhado"></xsl:value-of>
					</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">SUPER&#193;VIT (XIV)</xsl:with-param>
				<!-- xsl:with-param name="VL_DOTACAO_INICIAL" select=""/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select=""/-->
				<xsl:with-param name="VL_EMPENHADO" select="$superavit"/>
				<!-- xsl:with-param name="VL_LIQUIDADO" select=""/>
				<xsl:with-param name="VL_PAGO" select=""/>
				<xsl:with-param name="VL_SALDO" select=""/-->
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">TOTAL (XV) = (XIII + XIV)</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_INICIAL)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_INICIAL)+sum($amortizacao/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_DOTACAO_AUTORIZADA)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_DOTACAO_AUTORIZADA)+sum($amortizacao/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_EMPENHADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_EMPENHADO)+sum($amortizacao/VL_EMPENHADO) + $superavit"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_LIQUIDADO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_LIQUIDADO)+sum($amortizacao/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_PAGO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_PAGO)+sum($amortizacao/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM!=$cdElemRpps]/VL_SALDO)+sum(../DespesaIntraSum/DespesaIntraSumRow/VL_SALDO)+sum($amortizacao/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="DS_RUBRICA" select="'RESERVA DO RPPS (XVI)'"/>
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_DOTACAO_INICIAL)"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_DOTACAO_AUTORIZADA)"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_EMPENHADO)"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_LIQUIDADO)"/>
				<xsl:with-param name="VL_PAGO" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_PAGO)"/>
				<xsl:with-param name="VL_SALDO" select="sum($despesas[CD_ELEM=$cdElemRpps][NR_NIVEL=1]/VL_SALDO)"/>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>

		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template match="DespesaIntra">
	<!-- fo:block xsl:use-attribute-sets="titFCinza" id="BALORC_4">4. DESPESAS INTRA-ORCAMENTARIAS</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block-->

	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasB">
		<fo:table-column column-width="280pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />
		<fo:table-column column-width="84pt" />

		<xsl:call-template name="DespesaHeaderRow">
			<xsl:with-param name="COL1_DESC" select="'DESPESAS INTRA-OR&#199;AMENT&#193;RIAS'"/>
		</xsl:call-template>
		
		<fo:table-body>
			<xsl:apply-templates select="../DespesaIntraSum/DespesaIntraSumRow">
				<xsl:with-param name="NR_NIVEL">1</xsl:with-param>
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:apply-templates>
			
			<xsl:variable name="grupoContas">3</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">2</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">DESPESAS CORRENTES</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum(DespesaIntraRow/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum(DespesaIntraRow/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum(DespesaIntraRow/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum(DespesaIntraRow/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_PAGO" select="sum(DespesaIntraRow/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_SALDO" select="sum(DespesaIntraRow/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
			</xsl:call-template>
			<xsl:apply-templates select="DespesaIntraRow [GRUPO_CONTAS=$grupoContas]"/>
			
			<xsl:variable name="grupoContas">4</xsl:variable>
			<xsl:call-template name="DespesaRow">
				<xsl:with-param name="NR_NIVEL">2</xsl:with-param>
				<xsl:with-param name="DS_RUBRICA">DESPESAS DE CAPITAL</xsl:with-param>
				<xsl:with-param name="VL_DOTACAO_INICIAL" select="sum(DespesaIntraRow/VL_DOTACAO_INICIAL [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_DOTACAO_AUTORIZADA" select="sum(DespesaIntraRow/VL_DOTACAO_AUTORIZADA [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_EMPENHADO" select="sum(DespesaIntraRow/VL_EMPENHADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_LIQUIDADO" select="sum(DespesaIntraRow/VL_LIQUIDADO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_PAGO" select="sum(DespesaIntraRow/VL_PAGO [../GRUPO_CONTAS=$grupoContas])"/>
				<xsl:with-param name="VL_SALDO" select="sum(DespesaIntraRow/VL_SALDO [../GRUPO_CONTAS=$grupoContas])"/>
			</xsl:call-template>
			<xsl:apply-templates select="DespesaIntraRow [GRUPO_CONTAS=$grupoContas]"/>
			
		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template name="DespesaHeaderRow">
		<xsl:param name="COL1_DESC" />
		<fo:table-header>
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						<xsl:value-of select="$COL1_DESC"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						DOTA&#199;&#195;O INICIAL (e)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						DOTA&#199;&#195;O ATUALIZADA (f)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						DESPESAS EMPENHADAS (g)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						DESPESAS LIQUIDADAS (h)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						DESPESAS PAGAS (i)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block xsl:use-attribute-sets="titTabelaHeader">
						SALDO (j = f - g)
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-header>
</xsl:template>

<xsl:template name="DespesaRow" match="DespesaRow|DespesaIntraSumRow|DespesaIntraRow|AmortizacaoDividaRow">
	<xsl:param name="NR_NIVEL" select="NR_NIVEL" />
		<!-- xsl:choose>
			<xsl:when test="NR_NIVEL != ''"><xsl:value-of select="NR_NIVEL"/></xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:param-->
	<xsl:param name="DS_RUBRICA" select="DS_RUBRICA" />
	<xsl:param name="VL_DOTACAO_INICIAL" select="VL_DOTACAO_INICIAL" />
	<xsl:param name="VL_DOTACAO_AUTORIZADA" select="VL_DOTACAO_AUTORIZADA" />
	<xsl:param name="VL_EMPENHADO" select="VL_EMPENHADO" />
	<xsl:param name="VL_LIQUIDADO" select="VL_LIQUIDADO" />
	<xsl:param name="VL_PAGO" select="VL_PAGO" />
	<xsl:param name="VL_SALDO" select="VL_SALDO" />
	<xsl:param name="_titulo" select="false" />

	<fo:table-row>
	
		<fo:table-cell>
			<xsl:attribute name="padding-left"><xsl:value-of select="concat( (number($NR_NIVEL)-1) * 20,'pt')"/></xsl:attribute>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="$DS_RUBRICA" /> 
				<!-- <xsl:value-of select="IDENTIFICADOR" /> --> 
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_DOTACAO_INICIAL"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_DOTACAO_AUTORIZADA"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_EMPENHADO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_LIQUIDADO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_PAGO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_SALDO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>

	</fo:table-row>
</xsl:template>


<!-- #############################################  ############################################# -->


<xsl:template match="Restos">
	<fo:table margin-right="1pt" margin-left="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasB">
		<fo:table-column column-width="208pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />
		<fo:table-column column-width="72pt" />

		<xsl:call-template name="RestosHeaderRow">
			<!-- <xsl:with-param name="COL1_DESC" select="'RESTOS A PAGAR NAO PROCESSADOS'"/> -->
			<xsl:with-param name="COL1_DESC" select="''"/>
		</xsl:call-template>

		<fo:table-body>
			<!-- VL_LIQ	VL_PAG	VL_CANC	VL_SALDO -->
			<xsl:call-template name="RestosRow">
				<xsl:with-param name="DS_RUBRICA">DESPESAS CORRENTES</xsl:with-param>
				<xsl:with-param name="VL_RPNP_AA" select="sum(RestosRow/VL_RPNP_AA [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_RPNP_A" select="sum(RestosRow/VL_RPNP_A [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_RPP_AA" select="sum(RestosRow/VL_RPP_AA [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_RPP_A" select="sum(RestosRow/VL_RPP_A [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_LIQ" select="sum(RestosRow/VL_LIQ [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_PAG" select="sum(RestosRow/VL_PAG [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_CANC" select="sum(RestosRow/VL_CANC [../CD_GRUPO=3])" />
				<xsl:with-param name="VL_SALDO" select="sum(RestosRow/VL_SALDO [../CD_GRUPO=3])" />
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="RestosRow [CD_GRUPO=3]">
			</xsl:apply-templates>
			
			<xsl:call-template name="RestosRow">
				<xsl:with-param name="DS_RUBRICA">DESPESAS DE CAPITAL</xsl:with-param>
				<xsl:with-param name="VL_RPNP_AA" select="sum(RestosRow/VL_RPNP_AA [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_RPNP_A" select="sum(RestosRow/VL_RPNP_A [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_RPP_AA" select="sum(RestosRow/VL_RPP_AA [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_RPP_A" select="sum(RestosRow/VL_RPP_A [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_LIQ" select="sum(RestosRow/VL_LIQ [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_PAG" select="sum(RestosRow/VL_PAG [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_CANC" select="sum(RestosRow/VL_CANC [../CD_GRUPO=4])" />
				<xsl:with-param name="VL_SALDO" select="sum(RestosRow/VL_SALDO [../CD_GRUPO=4])" />
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			<xsl:apply-templates select="RestosRow [CD_GRUPO=4]">
			</xsl:apply-templates>

			<xsl:call-template name="RestosRow">
				<xsl:with-param name="DS_RUBRICA">TOTAL</xsl:with-param>
				<xsl:with-param name="VL_RPNP_AA" select="sum(RestosRow/VL_RPNP_AA)" />
				<xsl:with-param name="VL_RPNP_A" select="sum(RestosRow/VL_RPNP_A)" />
				<xsl:with-param name="VL_RPP_AA" select="sum(RestosRow/VL_RPP_AA)" />
				<xsl:with-param name="VL_RPP_A" select="sum(RestosRow/VL_RPP_A)" />
				<xsl:with-param name="VL_LIQ" select="sum(RestosRow/VL_LIQ)" />
				<xsl:with-param name="VL_PAG" select="sum(RestosRow/VL_PAG)" />
				<xsl:with-param name="VL_CANC" select="sum(RestosRow/VL_CANC)" />
				<xsl:with-param name="VL_SALDO" select="sum(RestosRow/VL_SALDO)" />
				<xsl:with-param name="_titulo">true</xsl:with-param>
			</xsl:call-template>
			
		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template name="RestosHeaderRow">
		<xsl:param name="COL1_DESC" />
		<fo:table-header>
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						<xsl:value-of select="$COL1_DESC"/>
					</fo:block>
				</fo:table-cell>
				
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						RPNP Exerc&#237;cios Anteriores (a)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						RPNP Exerc&#237;cio Anterior (b) 
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						RPP Exerc&#237;cios Anteriores (c)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						RPP Exerc&#237;cio Anterior (d) 
					</fo:block>
				</fo:table-cell>

				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						Liquidados (e)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						Pagos (f)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						Cancelados (g)
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordasUltColuna">
					<fo:block linefeed-treatment="preserve" xsl:use-attribute-sets="titTabelaHeader">
						Saldo (h = a + b + c + d - f - g)
					</fo:block>
				</fo:table-cell>
				
			</fo:table-row>
		</fo:table-header>
</xsl:template>

<xsl:template name="RestosRow" match="RestosRow">
	<xsl:param name="DS_RUBRICA" select="DS_RUBRICA" />
	<xsl:param name="VL_RPNP_AA" select="VL_RPNP_AA" />
	<xsl:param name="VL_RPNP_A" select="VL_RPNP_A" />
	<xsl:param name="VL_RPP_AA" select="VL_RPP_AA" />
	<xsl:param name="VL_RPP_A" select="VL_RPP_A" />
	<xsl:param name="VL_LIQ" select="VL_LIQ" />
	<xsl:param name="VL_PAG" select="VL_PAG" />
	<xsl:param name="VL_CANC" select="VL_CANC" />
	<xsl:param name="VL_SALDO" select="VL_SALDO" />
	<xsl:param name="_titulo" select="false" />
	
	<xsl:param name="_total" select="$DS_RUBRICA='TOTAL'" />

	<fo:table-row>

		<fo:table-cell>
			<xsl:if test="not($_titulo)">
				<xsl:attribute name="padding-left">20pt</xsl:attribute>
			</xsl:if>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="$DS_RUBRICA" /> 
			</fo:block>
		</fo:table-cell>

		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_RPNP_AA"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_RPNP_A"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_RPP_AA"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_RPP_A"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_LIQ"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_PAG"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_CANC"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_total">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			</xsl:if>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_SALDO"/>
					<!-- <xsl:with-param name="valor" select="number($RPNP_AA) + number($RPNP_A) - number($PAG) - number($EMP_CANC)"/> -->
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>

	</fo:table-row>
</xsl:template>


<!-- #############################################  ############################################# -->


<!-- xmlgraphics.apache.org/fop/fo.html#fo-preformat -->
<xsl:template match="NotasExplicativas">

	<xsl:choose>
	<xsl:when test="NotasExplicativasRow/TEXTO != ''">
	<fo:table width="784pt" margin-left="1pt" margin-right="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasAll">
		<fo:table-column column-number="1" />
		<fo:table-body>
			<xsl:for-each select="NotasExplicativasRow">
				<fo:table-row>
					<fo:table-cell border-width="0.5pt" padding-left="5pt">
						<fo:block xsl:use-attribute-sets="txtLeft" white-space-collapse="false">
							<xsl:value-of select="TEXTO" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
		</fo:table-body>
	</fo:table>
	</xsl:when>
	</xsl:choose>
</xsl:template>


<!-- #############################################  ############################################# -->


<xsl:template match="Assinaturas">
	<!-- ************* Variaveis locais ************** -->
	<xsl:variable name="administrador">
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
			Prefeito Municipal
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			Presidente da C&#226;mara Municipal
		</xsl:if>
		<xsl:if
			test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
			Respons&#225;vel
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="anoExercicio" select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO" />
	<!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
	<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
	<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
	<xsl:variable name="dia" select="substring($data, 9, 2)" />
	<xsl:variable name="mes" select="substring($data, 6, 2)" />
	<xsl:variable name="ano" select="substring($data, 1, 4)" />
	<xsl:variable name="mesNome">
		<xsl:if test="$mes='01'">
			Janeiro
		</xsl:if>
		<xsl:if test="$mes='02'">
			Fevereiro
		</xsl:if>
		<xsl:if test="$mes='03'">
			Mar&#231;o
		</xsl:if>
		<xsl:if test="$mes='04'">
			Abril
		</xsl:if>
		<xsl:if test="$mes='05'">
			Maio
		</xsl:if>
		<xsl:if test="$mes='06'">
			Junho
		</xsl:if>
		<xsl:if test="$mes='07'">
			Julho
		</xsl:if>
		<xsl:if test="$mes='08'">
			Agosto
		</xsl:if>
		<xsl:if test="$mes='09'">
			Setembro
		</xsl:if>
		<xsl:if test="$mes='10'">
			Outubro
		</xsl:if>
		<xsl:if test="$mes='11'">
			Novembro
		</xsl:if>
		<xsl:if test="$mes='12'">
			Dezembro
		</xsl:if>
	</xsl:variable>

	<fo:table width="784pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="375pt" />
		<fo:table-column column-number="2" column-width="16pt" />
		<fo:table-column column-number="3" column-width="0pt" />
		<fo:table-column column-number="4" column-width="16pt" />
		<fo:table-column column-number="5" column-width="375pt" />

		<fo:table-body>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO" />
						,
						<xsl:value-of select="$dia" />
						de
						<xsl:value-of select="$mesNome" />
						de
						<xsl:value-of select="$ano" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Gestor respons&#225;vel pelo per&#237;odo de 01/01/<xsl:value-of select="$anoExercicio"/> a 31/12/<xsl:value-of select="$anoExercicio"/> -
						<xsl:value-of select="AssinaturasRow/RESPONSAVEL_PERIODO" /> -
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Respons&#225;veis pela entrega dos documentos
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>

			<fo:table-row>
				<fo:table-cell border-width="0.5pt">txtCenter
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/CONTABILISTA" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">Contabilista</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<!-- fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						Respons&#225;vel pelo Controle Interno
					</fo:block-->
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/ADMINISTRADOR" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
		</fo:table-body>
	</fo:table>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template name="FormataNumero">
	<xsl:param name="valor" select="0" />
	<xsl:choose>
		<xsl:when test="string(number($valor))='NaN'">-</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="format-number($valor, '#.##0,00')" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
