/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.io.IOException;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPControl;

public class RTPPushDataSource
extends PushDataSource {
    PushSourceStream outputstream;
    OutputDataStream inputstream;
    String contentType = null;
    private boolean connected = false;
    private boolean started = false;
    DataSource childsrc = null;
    private RTPControl rtpcontrol = null;

    public RTPPushDataSource() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.media.rtp.RTPControlImpl");
            this.rtpcontrol = (RTPControl)clazz.newInstance();
        }
        catch (Exception exception) {
            this.rtpcontrol = null;
        }
    }

    public void connect() throws IOException {
        this.connected = true;
        if (this.childsrc != null) {
            this.childsrc.connect();
        }
    }

    public void disconnect() {
        this.connected = false;
        if (this.childsrc != null) {
            this.childsrc.disconnect();
        }
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return ContentDescriptor.mimeTypeToPackageName(this.contentType);
    }

    public Object getControl(String string) {
        if (string.equals("javax.media.rtp.RTPControl")) {
            return this.rtpcontrol;
        }
        return null;
    }

    public Object[] getControls() {
        Object[] objectArray = new RTPControl[]{this.rtpcontrol};
        return objectArray;
    }

    public Time getDuration() {
        return null;
    }

    public OutputDataStream getInputStream() {
        return this.inputstream;
    }

    public PushSourceStream getOutputStream() {
        return this.outputstream;
    }

    public PushSourceStream[] getStreams() {
        PushSourceStream[] pushSourceStreamArray = new PushSourceStream[]{this.outputstream};
        return pushSourceStreamArray;
    }

    protected void initCheck() {
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setChild(DataSource dataSource) {
        this.childsrc = dataSource;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setInputStream(OutputDataStream outputDataStream) {
        this.inputstream = outputDataStream;
    }

    public void setOutputStream(PushSourceStream pushSourceStream) {
        this.outputstream = pushSourceStream;
    }

    public void start() throws IOException {
        if (!this.connected) {
            return;
        }
        this.started = true;
        if (this.childsrc != null) {
            this.childsrc.start();
        }
    }

    public void stop() throws IOException {
        if (!this.connected && !this.started) {
            return;
        }
        this.started = false;
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
    }
}

