/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.ui.ButtonComp;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlComponent
extends Container
implements GainChangeListener {
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected GainControl gain = null;
    protected MuteButton muteButton = null;
    protected VolumeButton upButton = null;
    protected VolumeButton downButton = null;
    protected boolean fUseVolumeControl = true;
    protected static final float VolumeIncrement = 0.05f;
    protected static final int RepeatDelay = 100;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public GainControlComponent(GainControl gainControl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.gain = gainControl;
        gainControl.addGainChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        if (this.canChangeVolume()) {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridheight = 2;
            this.muteButton = new MuteButton();
            this.add(this.muteButton);
            gridBagLayout.setConstraints(this.muteButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridheight = 1;
            this.upButton = new VolumeButton("volumeUp.gif", "volumeUp-active.gif", "volumeUp-pressed.gif", "volumeUp-disabled.gif", "Increase volume", 0.05f);
            this.add(this.upButton);
            gridBagLayout.setConstraints(this.upButton, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.downButton = new VolumeButton("volumeDown.gif", "volumeDown-active.gif", "volumeDown-pressed.gif", "volumeDown-disabled.gif", "Decrease volume", -0.05f);
            this.add(this.downButton);
            gridBagLayout.setConstraints(this.downButton, gridBagConstraints);
        } else {
            this.fUseVolumeControl = false;
            this.muteButton = new MuteButton();
            this.add(this.muteButton);
        }
    }

    protected boolean canChangeVolume() {
        return this.gain != null && !(this.gain.getLevel() < 0.0f);
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
        if (this.fUseVolumeControl) {
            float f2 = gainChangeEvent.getLevel();
            this.upButton.setEnabled(f2 < 1.0f);
            this.downButton.setEnabled(f2 > 0.0f);
        }
        this.muteButton.setValue(gainChangeEvent.getMute());
    }

    class VolumeButton
    extends ButtonComp {
        protected float increment;
        Thread repeater = null;

        public VolumeButton(String string, String string2, String string3, String string4, String string5, float f2) {
            super(string5, string, string2, string3, string4, string, string2, string3, string4);
            this.increment = f2;
        }

        static /* synthetic */ GainControlComponent access$0(VolumeButton volumeButton) {
            return volumeButton.GainControlComponent.this;
        }

        public void action() {
            if (GainControlComponent.this.gain != null) {
                float f2 = GainControlComponent.this.gain.getLevel() + this.increment;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                GainControlComponent.this.gain.setLevel(f2);
                GainControlComponent.this.gain.setMute(false);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (this.repeater == null) {
                this.repeater = new Thread(this){
                    private final /* synthetic */ VolumeButton this$1;
                    {
                        this.this$1 = volumeButton;
                    }

                    public void run() {
                        if (VolumeButton.access$0((VolumeButton)this.this$1).gain != null) {
                            float f2 = VolumeButton.access$0((VolumeButton)this.this$1).gain.getLevel();
                            int n2 = 0;
                            while (this.this$1.mouseDown && n2 < 5) {
                                try {
                                    Thread.sleep(100L);
                                    try {
                                        this.this$1.action();
                                    }
                                    catch (Exception exception) {
                                        this.this$1.mouseDown = false;
                                    }
                                    float f3 = VolumeButton.access$0((VolumeButton)this.this$1).gain.getLevel();
                                    if (f2 == f3) {
                                        ++n2;
                                        continue;
                                    }
                                    f2 = f3;
                                    n2 = 0;
                                }
                                catch (InterruptedException interruptedException) {
                                    n2 = 10;
                                }
                            }
                        }
                    }
                };
                this.repeater.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (this.repeater != null) {
                Thread thread = this.repeater;
                this.repeater = null;
                boolean bl = true;
                if (securityPrivelege) {
                    if (jmfSecurity != null) {
                        try {
                            jmfSecurity.requestPermission(GainControlComponent.this.m, GainControlComponent.this.cl, GainControlComponent.this.args, 16);
                            GainControlComponent.this.m[0].invoke((Object)GainControlComponent.this.cl[0], GainControlComponent.this.args[0]);
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    thread.interrupt();
                }
            }
        }

        public void setEnabled(boolean bl) {
            if (bl != this.isEnabled()) {
                super.setEnabled(bl);
                this.mouseActivity();
            }
        }
    }

    class MuteButton
    extends ButtonComp {
        public MuteButton() {
            super("Mute audio", "audio.gif", "audio-active.gif", "audio-pressed.gif", "audio-disabled.gif", "mute.gif", "mute-active.gif", "mute-pressed.gif", "audio-disabled.gif");
        }

        public void action() {
            if (GainControlComponent.this.gain != null) {
                GainControlComponent.this.gain.setMute(GainControlComponent.this.gain.getMute() ^ true);
            }
        }
    }
}

