/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPPacketReceiver
implements PacketSource {
    private DatagramSocket sock;
    private int maxsize;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    byte[] dataBuf = new byte[1];

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public UDPPacketReceiver(int n2, String string, int n3, String string2, int n4, DatagramSocket datagramSocket) throws SocketException, UnknownHostException, IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        InetAddress inetAddress2 = InetAddress.getByName(string2);
        if (inetAddress2.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket(n3);
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    jmfSecurity.permissionFailureNotification(512);
                }
            }
            multicastSocket.joinGroup(inetAddress2);
            this.sock = multicastSocket;
            this.maxsize = n4;
        } else {
            this.sock = datagramSocket != null ? datagramSocket : new DatagramSocket(n2, inetAddress);
            this.maxsize = n4;
        }
        try {
            this.sock.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public UDPPacketReceiver(DatagramSocket datagramSocket, int n2) {
        this.sock = datagramSocket;
        this.maxsize = n2;
        try {
            datagramSocket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public void closeSource() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public Packet receiveFrom() throws IOException {
        DatagramPacket datagramPacket;
        int n2;
        do {
            if (this.dataBuf.length < this.maxsize) {
                this.dataBuf = new byte[this.maxsize];
            }
            datagramPacket = new DatagramPacket(this.dataBuf, this.maxsize);
            this.sock.receive(datagramPacket);
            n2 = datagramPacket.getLength();
            if (n2 <= this.maxsize >> 1) continue;
            this.maxsize = n2 << 1;
        } while (n2 >= datagramPacket.getData().length);
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.receiptTime = System.currentTimeMillis();
        uDPPacket.data = datagramPacket.getData();
        uDPPacket.offset = 0;
        uDPPacket.length = n2;
        uDPPacket.datagrampacket = datagramPacket;
        uDPPacket.localPort = this.sock.getLocalPort();
        uDPPacket.remotePort = datagramPacket.getPort();
        uDPPacket.remoteAddress = datagramPacket.getAddress();
        return uDPPacket;
    }

    public String sourceString() {
        String string = "UDP Datagram Packet Receiver on port " + this.sock.getLocalPort() + "on local address " + this.sock.getLocalAddress();
        return string;
    }
}

