/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.SSRCInfo;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.rtcp.SourceDescription;

public abstract class RTPSourceInfo
implements Participant {
    RTPSourceInfoCache sic;
    private SSRCInfo[] ssrc;
    private SourceDescription cname;

    RTPSourceInfo(String string, RTPSourceInfoCache rTPSourceInfoCache) {
        this.cname = new SourceDescription(1, string, 0, false);
        this.sic = rTPSourceInfoCache;
        this.ssrc = new SSRCInfo[0];
    }

    synchronized void addSSRC(SSRCInfo sSRCInfo) {
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            if (this.ssrc[n2] == sSRCInfo) {
                return;
            }
            ++n2;
        }
        this.ssrc = new SSRCInfo[this.ssrc.length + 1];
        System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length - 1);
        this.ssrc[this.ssrc.length - 1] = sSRCInfo;
    }

    public String getCNAME() {
        return this.cname.getDescription();
    }

    SourceDescription getCNAMESDES() {
        return this.cname;
    }

    public Vector getReports() {
        Vector<SSRCInfo> vector = new Vector<SSRCInfo>();
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            vector.addElement(this.ssrc[n2]);
            ++n2;
        }
        vector.trimToSize();
        return vector;
    }

    RTPStream getSSRCStream(long l2) {
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            if (this.ssrc[n2] instanceof RTPStream && this.ssrc[n2].ssrc == (int)l2) {
                return (RTPStream)((Object)this.ssrc[n2]);
            }
            ++n2;
        }
        return null;
    }

    public Vector getSourceDescription() {
        Vector vector = null;
        if (this.ssrc.length == 0) {
            vector = new Vector(0);
            return vector;
        }
        vector = this.ssrc[0].getSourceDescription();
        return vector;
    }

    int getStreamCount() {
        return this.ssrc.length;
    }

    public Vector getStreams() {
        Vector<SSRCInfo> vector = new Vector<SSRCInfo>();
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            if (this.ssrc[n2].isActive()) {
                vector.addElement(this.ssrc[n2]);
            }
            ++n2;
        }
        vector.trimToSize();
        return vector;
    }

    synchronized void removeSSRC(SSRCInfo sSRCInfo) {
        if (sSRCInfo.dsource != null) {
            this.sic.ssrccache.sm.removeDataSource(sSRCInfo.dsource);
        }
        int n2 = 0;
        while (n2 < this.ssrc.length) {
            if (this.ssrc[n2] == sSRCInfo) {
                this.ssrc[n2] = this.ssrc[this.ssrc.length - 1];
                this.ssrc = new SSRCInfo[this.ssrc.length - 1];
                System.arraycopy(this.ssrc, 0, this.ssrc, 0, this.ssrc.length);
                break;
            }
            ++n2;
        }
        if (this.ssrc.length == 0) {
            this.sic.remove(this.cname.getDescription());
        }
    }
}

