/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.util.RTPMediaThread;
import java.util.Vector;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.SessionEvent;

public class RTPEventHandler
extends RTPMediaThread {
    private RTPSessionMgr sm;
    private Vector eventQueue = new Vector();
    private boolean killed = false;

    public RTPEventHandler(RTPSessionMgr rTPSessionMgr) {
        super("RTPEventHandler");
        this.sm = rTPSessionMgr;
        this.useControlPriority();
        this.setDaemon(true);
        this.start();
    }

    public synchronized void close() {
        this.killed = true;
        this.notifyAll();
    }

    protected void dispatchEvents() {
        RTPEvent rTPEvent;
        RTPEventHandler rTPEventHandler = this;
        synchronized (rTPEventHandler) {
            try {
                while (this.eventQueue.size() == 0 && !this.killed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            if (this.killed) {
                Object var3_2 = null;
                return;
            }
            rTPEvent = (RTPEvent)this.eventQueue.elementAt(0);
            this.eventQueue.removeElementAt(0);
        }
        this.processEvent(rTPEvent);
    }

    public synchronized void postEvent(RTPEvent rTPEvent) {
        this.eventQueue.addElement(rTPEvent);
        this.notifyAll();
    }

    protected void processEvent(RTPEvent rTPEvent) {
        if (rTPEvent instanceof SessionEvent) {
            int n2 = 0;
            while (n2 < this.sm.sessionlistener.size()) {
                SessionListener sessionListener = (SessionListener)this.sm.sessionlistener.elementAt(n2);
                if (sessionListener != null) {
                    sessionListener.update((SessionEvent)rTPEvent);
                }
                ++n2;
            }
            return;
        }
        if (rTPEvent instanceof RemoteEvent) {
            int n3 = 0;
            while (n3 < this.sm.remotelistener.size()) {
                RemoteListener remoteListener = (RemoteListener)this.sm.remotelistener.elementAt(n3);
                if (remoteListener != null) {
                    remoteListener.update((RemoteEvent)rTPEvent);
                }
                ++n3;
            }
            return;
        }
        if (rTPEvent instanceof ReceiveStreamEvent) {
            int n4 = 0;
            while (n4 < this.sm.streamlistener.size()) {
                ReceiveStreamListener receiveStreamListener = (ReceiveStreamListener)this.sm.streamlistener.elementAt(n4);
                if (receiveStreamListener != null) {
                    receiveStreamListener.update((ReceiveStreamEvent)rTPEvent);
                }
                ++n4;
            }
            return;
        }
        if (rTPEvent instanceof SendStreamEvent) {
            int n5 = 0;
            while (n5 < this.sm.sendstreamlistener.size()) {
                SendStreamListener sendStreamListener = (SendStreamListener)this.sm.sendstreamlistener.elementAt(n5);
                if (sendStreamListener != null) {
                    sendStreamListener.update((SendStreamEvent)rTPEvent);
                }
                ++n5;
            }
        }
    }

    public void run() {
        while (!this.killed) {
            this.dispatchEvents();
        }
    }
}

