/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.audio.midi;

import com.sun.media.BasicController;
import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.IncompatibleSourceException;
import javax.media.StopByRequestEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

public class Handler
extends BasicPlayer {
    private MidiController controller = new MidiController();
    protected DataSource datasource = null;
    private boolean closed = false;
    private int META_EVENT_END_OF_MEDIA = 47;
    private Control[] controls = null;

    public Handler() {
        this.manageController(this.controller);
    }

    protected boolean audioEnabled() {
        return true;
    }

    protected TimeBase getMasterTimeBase() {
        return this.controller.getMasterTimeBase();
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        this.controller.setSource(dataSource);
    }

    public void updateStats() {
    }

    protected boolean videoEnabled() {
        return false;
    }

    class MidiController
    extends BasicController
    implements MetaEventListener {
        private MidiParser midiParser;
        private Track track = null;
        private Buffer buffer = new Buffer();
        private PullSourceStream stream;
        private Sequencer sequencer = null;
        private Synthesizer synthesizer = null;
        protected MidiChannel[] channels;
        private Sequence sequence = null;
        private byte[] mididata = null;
        private MidiFileInputStream is = null;
        private Time duration = Duration.DURATION_UNKNOWN;
        private GCA gc;

        MidiController() {
        }

        protected void abortPrefetch() {
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }

        protected void abortRealize() {
        }

        protected void doClose() {
            if (Handler.this.closed) {
                return;
            }
            this.doDeallocate();
            if (Handler.this.datasource != null) {
                Handler.this.datasource.disconnect();
            }
            Handler.this.datasource = null;
            this.sequencer.removeMetaEventListener(this);
            Handler.this.closed = true;
            super.doClose();
        }

        protected void doDeallocate() {
            if (this.sequencer == null) {
                return;
            }
            MidiController midiController = this;
            synchronized (midiController) {
                try {
                    this.sequencer.close();
                }
                catch (Exception exception) {
                    Log.error("Exception when deallocating: " + exception + "\n");
                }
            }
        }

        protected boolean doPrefetch() {
            if (this.track == null) {
                return false;
            }
            if (this.sequencer == null) {
                try {
                    this.sequencer = MidiSystem.getSequencer();
                    if (this.sequencer instanceof Synthesizer) {
                        this.synthesizer = (Synthesizer)((Object)this.sequencer);
                        this.channels = this.synthesizer.getChannels();
                    }
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    return false;
                }
                this.sequencer.addMetaEventListener(this);
            }
            if (this.buffer.getLength() == 0) {
                this.track.readFrame(this.buffer);
                if (this.buffer.isDiscard() || this.buffer.isEOM()) {
                    this.buffer.setLength(0);
                    return false;
                }
                this.mididata = (byte[])this.buffer.getData();
                this.is = new MidiFileInputStream(this.mididata, this.buffer.getLength());
            }
            MidiController midiController = this;
            synchronized (midiController) {
                if (this.is != null) {
                    try {
                        this.is.rewind();
                    }
                    catch (Exception exception) {}
                } else {
                    boolean bl = false;
                    Object var3_8 = null;
                    return bl;
                }
            }
            try {
                this.sequencer.open();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                Log.error("Cannot open sequencer " + midiUnavailableException + "\n");
                return false;
            }
            catch (Exception exception) {
                Log.error("Cannot open sequencer " + exception + "\n");
                return false;
            }
            try {
                this.sequencer.setSequence(new BufferedInputStream(this.is));
                long l2 = this.sequencer.getMicrosecondLength() * 1000L;
                this.duration = new Time(l2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                Log.error("Invalid Midi Data " + invalidMidiDataException + "\n");
                this.sequencer.close();
                return false;
            }
            catch (Exception exception) {
                Log.error("Error setting sequence " + exception + "\n");
                this.sequencer.close();
                return false;
            }
            return true;
        }

        protected boolean doRealize() {
            int n2;
            long l2;
            if (Handler.this.datasource == null) {
                return false;
            }
            try {
                Handler.this.datasource.start();
            }
            catch (IOException iOException) {
                return false;
            }
            this.stream = this.midiParser.getStream();
            long l3 = this.stream.getContentLength();
            long l4 = 0L;
            l4 = 0L;
            if (l3 != -1L) {
                l2 = l3;
                n2 = (int)l3;
            } else {
                l2 = Long.MAX_VALUE;
                n2 = (int)l2;
            }
            int n3 = 1;
            this.track = new BasicTrack(this.midiParser, null, true, Duration.DURATION_UNKNOWN, new Time(0L), n3, n2, this.stream, l4, l2);
            return true;
        }

        protected void doSetMediaTime(Time time) {
            if (time != null && this.sequencer != null) {
                this.sequencer.setMicrosecondPosition(time.getNanoseconds() / 1000L);
            }
        }

        protected float doSetRate(float f2) {
            if (this.sequencer != null) {
                this.sequencer.setTempoFactor(f2);
                return this.sequencer.getTempoFactor();
            }
            return 1.0f;
        }

        protected void doStart() {
            if (this.sequencer == null) {
                return;
            }
            if (!this.sequencer.isOpen()) {
                return;
            }
            this.sequencer.start();
        }

        protected void doStop() {
            if (this.sequencer == null) {
                return;
            }
            this.sequencer.stop();
            this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }

        public void gainChange(float f2) {
            if (this.channels == null || this.gc == null) {
                return;
            }
            float f3 = this.gc.getLevel();
            int n2 = 0;
            while (n2 < this.channels.length) {
                this.channels[n2].controlChange(7, (int)((double)f3 * 127.0));
                ++n2;
            }
        }

        public Control[] getControls() {
            if (Handler.this.controls == null) {
                Handler.this.controls = new Control[1];
                this.gc = new GCA();
                ((Handler)Handler.this).controls[0] = this.gc;
            }
            return Handler.this.controls;
        }

        public Time getDuration() {
            return this.duration;
        }

        protected TimeBase getMasterTimeBase() {
            return new SystemTimeBase();
        }

        protected boolean isConfigurable() {
            return false;
        }

        public void meta(MetaMessage metaMessage) {
            if (metaMessage.getType() != Handler.this.META_EVENT_END_OF_MEDIA) {
                return;
            }
            if (this.sequencer != null && this.sequencer.isOpen()) {
                this.stopControllerOnly();
                this.sequencer.stop();
                if (this.duration == Duration.DURATION_UNKNOWN) {
                    this.duration = this.getMediaTime();
                    this.sendEvent(new DurationUpdateEvent(this, this.duration));
                }
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
        }

        public void muteChange(boolean bl) {
            if (this.channels == null) {
                return;
            }
            int n2 = 0;
            while (n2 < this.channels.length) {
                this.channels[n2].setMute(bl);
                ++n2;
            }
        }

        public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
            this.midiParser = new MidiParser();
            this.midiParser.setSource(dataSource);
            Handler.this.datasource = dataSource;
        }

        class GCA
        extends GainControlAdapter {
            GCA() {
                super(1.0f);
            }

            public float setLevel(float f2) {
                float f3 = super.setLevel(f2);
                MidiController.this.gainChange(f2);
                return f3;
            }

            public void setMute(boolean bl) {
                super.setMute(bl);
                MidiController.this.muteChange(bl);
            }
        }
    }

    class MidiParser
    extends BasicPullParser {
        MidiParser() {
        }

        public Time getDuration() {
            return null;
        }

        public Time getMediaTime() {
            return null;
        }

        public String getName() {
            return "Parser for MIDI file format";
        }

        public PullSourceStream getStream() {
            PullSourceStream pullSourceStream = (PullSourceStream)this.streams[0];
            return pullSourceStream;
        }

        public ContentDescriptor[] getSupportedInputContentDescriptors() {
            return null;
        }

        public Track[] getTracks() throws IOException, BadHeaderException {
            return null;
        }

        public Time setPosition(Time time, int n2) {
            return null;
        }
    }

    class MidiFileInputStream
    extends InputStream {
        private int length;
        private int index = 0;
        private byte[] data;
        private int markpos = 0;

        MidiFileInputStream(byte[] byArray, int n2) {
            this.data = byArray;
            this.length = n2;
        }

        public int available() throws IOException {
            return this.length - this.index;
        }

        public int read() throws IOException {
            if (this.index >= this.length) {
                return -1;
            }
            return this.data[this.index++];
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 > this.available()) {
                n3 = this.available();
            }
            if (n3 == 0) {
                return -1;
            }
            System.arraycopy(this.data, this.index, byArray, n2, n3);
            this.index += n3;
            return n3;
        }

        public void rewind() {
            this.index = 0;
            this.markpos = 0;
        }
    }
}

