/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.msadpcm;

import com.sun.media.BasicPlugIn;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.msadpcm.MsAdpcm;
import com.sun.media.codec.audio.msadpcm.MsAdpcmState;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class JavaDecoder
extends AudioCodec {
    private static final boolean DEBUG = true;
    private MsAdpcmState[] state;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("msadpcm")};
    }

    public void close() {
        this.state[0] = null;
        this.state[1] = null;
        this.state = null;
    }

    private int decode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n3 - 7 * n4;
        int n6 = 4 * n4 + (n3 - 7 * n4) * 4;
        int n7 = 0;
        int n8 = 0;
        int n9 = n2 / n3;
        int n10 = 1;
        while (n10 <= n9) {
            MsAdpcm.decodeBlock(byArray, n7, byArray2, n8, n5, this.state, n4);
            ++n10;
            n8 += n6;
            n7 += n3;
        }
        return n8;
    }

    public String getName() {
        return "msadpcm decoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[0];
        }
        if (!(format instanceof AudioFormat)) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        int n2 = audioFormat.getFrameSizeInBits();
        if (n2 != 2048 && n2 != 4096 && n2 != 8192) {
            return new Format[0];
        }
        return new Format[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1)};
    }

    public void open() {
        this.state = new MsAdpcmState[2];
        this.state[0] = new MsAdpcmState();
        this.state[1] = new MsAdpcmState();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, byArray.length * 4);
        AudioFormat audioFormat = (AudioFormat)buffer.getFormat();
        int n2 = audioFormat.getFrameSizeInBits() >> 3;
        int n3 = audioFormat.getChannels();
        int n4 = this.decode(byArray, byArray2, buffer.getLength(), n2, n3);
        this.updateOutput(buffer2, this.outputFormat, n4, 0);
        return 0;
    }
}

