/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.BasicPlugIn;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MPAHeader;
import com.sun.media.codec.audio.mpa.MPAParse;
import com.sun.media.codec.audio.mpa.PacketSizeAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class Packetizer
extends AudioCodec {
    private static final int NEW_FRAME = 0;
    private static final int CONT_FRAME = 1;
    private static final int CONT_BUFFER = 2;
    private static final int FILL_BUFFER = 3;
    private int state = 0;
    public static final int MAX_MPA_FRAMESIZE = 1729;
    public static final int MAX_FRAMESIZE = 1456;
    public static final int MIN_FRAMESIZE = 110;
    public static final int DEFAULT_FRAMESIZE = 1456;
    private static final boolean debug = false;
    private byte[] pendingData = new byte[131072];
    private int pendingDataSize = 0;
    private int pendingDataOffset = 0;
    private boolean expectingSameInputBuffer = false;
    private boolean inputEOM = false;
    private boolean setMark = true;
    private boolean resetTime = true;
    private int frameSize = 0;
    private int frameOffset = 0;
    private long frameCount = 0L;
    private int packetSize = 1456;
    private long packetSeq = 0L;
    private long currentTime = 1L;
    private long deltaTime = 0L;
    private MPAHeader mpaHeader = null;
    private MPAParse mpaParse = new MPAParse();

    public Packetizer() {
        this.inputFormats = new AudioFormat[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
        this.outputFormats = new AudioFormat[]{new AudioFormat("mpegaudio/rtp", -1.0, -1, -1, -1, 1)};
    }

    protected void checkMPAHeader(byte[] byArray, int n2, int n3) {
        int n4 = n2 + this.frameSize - this.frameOffset;
        if (this.mpaHeader == null || this.mpaHeader.headerOffset == n4) {
            return;
        }
        int n5 = n3 - (this.frameSize - this.frameOffset);
        this.mpaHeader = this.getMPAHeader(byArray, n4, n5);
    }

    public void close() {
    }

    protected int continueFrameInBuffer(Buffer buffer) {
        this.checkMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        int n2 = Math.min(this.pendingDataSize, this.frameSize - this.frameOffset);
        if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
            this.state = 3;
            return this.newFrameInBuffer(buffer);
        }
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, n2 = Math.min(n2, this.packetSize - buffer.getLength()), buffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset += n2;
        buffer.setTimeStamp(this.currentTime);
        buffer.setFormat(this.outputFormat);
        if (n2 < this.pendingDataSize) {
            this.pendingDataOffset += n2;
            this.pendingDataSize -= n2;
            if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
                this.state = 3;
                return this.newFrameInBuffer(buffer);
            }
            this.state = 2;
            return 2;
        }
        this.pendingDataOffset += n2;
        this.pendingDataSize -= n2;
        this.shiftPendingData();
        if (!this.isOutputBufferFull(buffer)) {
            this.state = 1;
            return 4;
        }
        return 0;
    }

    protected int continueFrameNewBuffer(Buffer buffer) {
        int n2 = Math.min(this.pendingDataSize, this.frameSize - this.frameOffset);
        this.checkMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        if (this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
            this.state = 0;
            return this.newFrameNewBuffer(buffer);
        }
        n2 = Math.min(n2, this.packetSize - 4);
        this.setStartOfBuffer(buffer, this.frameOffset);
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, n2, buffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset += n2;
        buffer.setTimeStamp(this.currentTime);
        buffer.setFormat(this.outputFormat);
        if (n2 < this.pendingDataSize) {
            this.pendingDataOffset += n2;
            this.pendingDataSize -= n2;
            if (this.frameOffset >= this.frameSize || this.mpaHeader != null && this.mpaHeader.headerOffset == this.pendingDataOffset) {
                this.state = 0;
            }
            return 2;
        }
        this.pendingDataOffset += n2;
        this.pendingDataSize -= n2;
        this.shiftPendingData();
        if (!this.isOutputBufferFull(buffer)) {
            this.state = 1;
            return 4;
        }
        return 0;
    }

    private boolean copyBuffer(byte[] byArray, int n2, int n3, Buffer buffer) {
        byte[] byArray2 = (byte[])buffer.getData();
        int n4 = buffer.getLength();
        if (n4 + n3 > byArray2.length) {
            if (n4 + n3 > this.packetSize) {
                return false;
            }
            byte[] byArray3 = new byte[this.packetSize];
            if (n4 > 0) {
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
            }
            byArray2 = byArray3;
            buffer.setData(byArray2);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        buffer.setLength(n4 + n3);
        return true;
    }

    protected int doProcess(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        this.inputEOM = false;
        if (this.isEOM(buffer)) {
            if (this.pendingDataSize == 0) {
                this.propagateEOM(buffer2);
                this.mpaParse.reset();
                this.resetPendingData();
                this.state = 0;
                return 0;
            }
            this.inputEOM = true;
        }
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        if (!this.expectingSameInputBuffer) {
            if (n3 > 0 && byArray != null) {
                if (this.resetTime) {
                    this.currentTime = buffer.getTimeStamp();
                    if (this.currentTime == 0L) {
                        this.currentTime = 1L;
                    }
                    this.resetTime = false;
                }
                if (n3 > this.pendingData.length - this.pendingDataSize) {
                    this.mpaParse.reset();
                    this.resetPendingData();
                }
                System.arraycopy(byArray, n2, this.pendingData, this.pendingDataOffset + this.pendingDataSize, n3);
                this.pendingDataSize += n3;
            } else if (!this.inputEOM) {
                return 4;
            }
            this.expectingSameInputBuffer = true;
        }
        if (this.mpaHeader == null) {
            this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        }
        switch (this.state) {
            case 0: {
                return this.newFrameNewBuffer(buffer2);
            }
            case 1: {
                return this.continueFrameInBuffer(buffer2);
            }
            case 2: {
                return this.continueFrameNewBuffer(buffer2);
            }
            case 3: {
                return this.newFrameInBuffer(buffer2);
            }
        }
        return 1;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
        }
        return this.controls;
    }

    protected MPAHeader getMPAHeader(byte[] byArray, int n2, int n3) {
        MPAHeader mPAHeader = new MPAHeader();
        int n4 = this.mpaParse.getHeader(mPAHeader, byArray, n2, n3);
        if (n4 == MPAParse.MPA_OK) {
            return mPAHeader;
        }
        if (this.inputEOM && n4 == MPAParse.MPA_HDR_DOUBTED) {
            return mPAHeader;
        }
        return null;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.outputFormats = new AudioFormat[]{new AudioFormat("mpegaudio/rtp", audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getEndian(), 1, audioFormat.getFrameSizeInBits(), audioFormat.getFrameRate(), Format.byteArray)};
        return this.outputFormats;
    }

    public String getName() {
        return "MPEG Audio Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new Format[]{new AudioFormat("mpegaudio/rtp")};
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[1];
        }
        if (!(format instanceof AudioFormat)) {
            return new Format[]{new AudioFormat("mpegaudio/rtp")};
        }
        return this.getMatchingOutputFormats(format);
    }

    private boolean isOutputBufferFull(Buffer buffer) {
        return this.packetSize <= buffer.getLength() + 40;
    }

    protected int newFrameInBuffer(Buffer buffer) {
        int n2;
        if (this.mpaHeader == null) {
            this.state = 0;
            this.shiftPendingData();
            return 0;
        }
        if (this.pendingDataSize <= 1738 && !this.inputEOM) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        if (this.mpaHeader.headerOffset != this.pendingDataOffset) {
            this.pendingDataSize += this.pendingDataOffset - this.mpaHeader.headerOffset;
            this.pendingDataOffset = this.mpaHeader.headerOffset;
        }
        if ((n2 = this.mpaHeader.bitsInFrame >> 3) > this.pendingDataSize) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        if (n2 > this.packetSize - buffer.getLength()) {
            this.state = 0;
            return 2;
        }
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, n2, buffer)) {
            this.state = 0;
            return 2;
        }
        ++this.frameCount;
        this.deltaTime += (long)this.mpaHeader.nSamples * 1000L * 1000000L / (long)this.mpaHeader.samplingRate;
        this.pendingDataOffset += n2;
        this.pendingDataSize -= n2;
        if (this.pendingDataSize == 0) {
            this.state = 3;
            this.shiftPendingData();
            return 4;
        }
        this.state = 3;
        this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
        return this.newFrameInBuffer(buffer);
    }

    protected int newFrameNewBuffer(Buffer buffer) {
        int n2;
        if (this.mpaHeader == null) {
            this.shiftPendingData();
            return 4;
        }
        if (this.mpaHeader.headerOffset != this.pendingDataOffset) {
            this.pendingDataSize += this.pendingDataOffset - this.mpaHeader.headerOffset;
            this.pendingDataOffset = this.mpaHeader.headerOffset;
        }
        this.frameSize = this.mpaHeader.bitsInFrame >> 3;
        String string = "mpegaudio/rtp";
        AudioFormat audioFormat = (AudioFormat)this.outputFormat;
        if (audioFormat == null || audioFormat.getEncoding() != string || audioFormat.getSampleRate() != (double)this.mpaHeader.samplingRate || audioFormat.getChannels() != this.mpaHeader.nChannels) {
            n2 = 1;
            if (audioFormat != null) {
                n2 = audioFormat.getEndian();
            }
            this.outputFormat = new AudioFormat(string, this.mpaHeader.samplingRate, 16, this.mpaHeader.nChannels, n2, 1);
        }
        this.setStartOfBuffer(buffer, 0);
        n2 = Math.min(this.mpaHeader.bitsInFrame >> 3, this.pendingDataSize);
        n2 = Math.min(n2, this.packetSize - 4);
        if (!this.copyBuffer(this.pendingData, this.pendingDataOffset, n2, buffer)) {
            this.state = 0;
            return 1;
        }
        this.frameOffset = n2;
        ++this.frameCount;
        this.currentTime += this.deltaTime;
        this.deltaTime = (long)this.mpaHeader.nSamples * 1000L * 1000000L / (long)this.mpaHeader.samplingRate;
        buffer.setFormat(this.outputFormat);
        buffer.setTimeStamp(this.currentTime);
        if (n2 < this.pendingDataSize) {
            this.pendingDataOffset += n2;
            this.pendingDataSize -= n2;
            if (n2 == this.mpaHeader.bitsInFrame >> 3) {
                this.state = 3;
                this.mpaHeader = this.getMPAHeader(this.pendingData, this.pendingDataOffset, this.pendingDataSize);
                return this.newFrameInBuffer(buffer);
            }
            this.state = 2;
            this.mpaHeader = null;
            return 2;
        }
        this.pendingDataOffset += n2;
        this.pendingDataSize -= n2;
        if (n2 == this.mpaHeader.bitsInFrame >> 3) {
            this.shiftPendingData();
            if (this.isOutputBufferFull(buffer)) {
                this.state = 0;
                return 0;
            }
            this.state = 3;
            return 4;
        }
        if (!this.isOutputBufferFull(buffer)) {
            this.state = 1;
            this.shiftPendingData();
            return 4;
        }
        this.state = 2;
        this.shiftPendingData();
        return 0;
    }

    public void open() throws ResourceUnavailableException {
        this.setPacketSize(this.packetSize);
        this.reset();
        this.currentTime = 1L;
        this.packetSeq = 0L;
        this.resetTime = true;
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (buffer.isDiscard()) {
            this.updateOutput(buffer2, this.outputFormat, 0, 0);
            buffer2.setDiscard(true);
            return 0;
        }
        try {
            int n2 = this.doProcess(buffer, buffer2);
            if (n2 != 4) {
                buffer2.setSequenceNumber(this.packetSeq++);
                buffer2.setTimeStamp(this.currentTime);
            }
            if (this.inputEOM) {
                if (buffer2.getLength() == 0) {
                    this.propagateEOM(buffer2);
                    buffer2.setSequenceNumber(this.packetSeq++);
                    this.mpaParse.reset();
                    this.resetPendingData();
                    this.state = 0;
                    return 0;
                }
                if (n2 == 4) {
                    buffer2.setSequenceNumber(this.packetSeq++);
                    buffer2.setTimeStamp(this.currentTime);
                }
                n2 = 2;
                this.expectingSameInputBuffer = true;
            } else if (this.pendingDataSize <= 1738) {
                n2 &= 0xFFFFFFFD;
                this.shiftPendingData();
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public synchronized void reset() {
        super.reset();
        this.mpaParse.reset();
        this.resetPendingData();
        this.state = 0;
        this.setMark = true;
        this.expectingSameInputBuffer = false;
        this.frameSize = 0;
        this.frameOffset = 0;
        this.frameCount = 0L;
        this.resetTime = true;
        this.deltaTime = 0L;
    }

    protected void resetPendingData() {
        this.pendingDataSize = 0;
        this.pendingDataOffset = 0;
        this.expectingSameInputBuffer = false;
        this.mpaHeader = null;
    }

    public synchronized void setPacketSize(int n2) {
        this.packetSize = n2;
    }

    private void setStartOfBuffer(Buffer buffer, int n2) {
        byte[] byArray = (byte[])buffer.getData();
        if (byArray == null || this.packetSize > byArray.length) {
            byArray = new byte[this.packetSize];
            buffer.setData(byArray);
        }
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)n2;
        buffer.setOffset(0);
        buffer.setLength(4);
        if (this.setMark) {
            buffer.setFlags(2048);
            this.setMark = false;
        } else {
            buffer.setFlags(0);
        }
    }

    protected void shiftPendingData() {
        if (this.pendingDataOffset != 0 && this.pendingDataSize > 0) {
            System.arraycopy(this.pendingData, this.pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
        }
        this.pendingDataOffset = 0;
        this.expectingSameInputBuffer = false;
        this.mpaHeader = null;
    }
}

