/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.codec.audio.mpa.MPAHeader;

public class MPAParse {
    private static int MPA_MAX_BYTES_IN_FRAME = 2024;
    private static int MPA_MIN_BYTES_IN_FRAME = 21;
    private static int MPA_NSAMP = 1152;
    private static int MPA_LAYER1 = 3;
    private static int MPA_LAYER2 = 2;
    private static int MPA_LAYER3 = 1;
    private static int MPA_MPEG1 = 1;
    private static int MPA_MPEG2 = 0;
    private static int MPA_MONO = 3;
    public static int[][] SAMPLE_TABLE;
    public static int[][] BITRATE_TABLE1;
    public static int[][] BITRATE_TABLE2;
    private static int[] MAX_FREE_BITS;
    public static int[] SLOT_BITS_MASK;
    public static int[][] SAMPLES_PER_FRAME;
    public static int MPA_OK;
    public static int MPA_HDR_DOUBTED;
    public static int MPA_ERR_LOWBUFFER;
    public static int MPA_ERR_NULLPTR;
    public static int MPA_ERR_NOHDR;
    private boolean firstFound = false;
    private int firstId = 0;
    private int firstLayer = 0;
    private int firstSamplingRate = 0;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[4];
        nArray[0] = 22050;
        nArray[1] = 24000;
        nArray[2] = 16000;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 44100;
        nArray2[1] = 48000;
        nArray2[2] = 32000;
        nArrayArray[1] = nArray2;
        SAMPLE_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] nArray3 = new int[16];
        nArray3[1] = 32;
        nArray3[2] = 40;
        nArray3[3] = 48;
        nArray3[4] = 56;
        nArray3[5] = 64;
        nArray3[6] = 80;
        nArray3[7] = 96;
        nArray3[8] = 112;
        nArray3[9] = 128;
        nArray3[10] = 160;
        nArray3[11] = 192;
        nArray3[12] = 224;
        nArray3[13] = 256;
        nArray3[14] = 320;
        nArray3[15] = -1;
        nArrayArray2[1] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[1] = 32;
        nArray4[2] = 48;
        nArray4[3] = 56;
        nArray4[4] = 64;
        nArray4[5] = 80;
        nArray4[6] = 96;
        nArray4[7] = 112;
        nArray4[8] = 128;
        nArray4[9] = 160;
        nArray4[10] = 192;
        nArray4[11] = 224;
        nArray4[12] = 256;
        nArray4[13] = 320;
        nArray4[14] = 384;
        nArray4[15] = -1;
        nArrayArray2[2] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[1] = 32;
        nArray5[2] = 64;
        nArray5[3] = 96;
        nArray5[4] = 128;
        nArray5[5] = 160;
        nArray5[6] = 192;
        nArray5[7] = 224;
        nArray5[8] = 256;
        nArray5[9] = 288;
        nArray5[10] = 320;
        nArray5[11] = 352;
        nArray5[12] = 384;
        nArray5[13] = 416;
        nArray5[14] = 448;
        nArray5[15] = -1;
        nArrayArray2[3] = nArray5;
        BITRATE_TABLE1 = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] nArray6 = new int[16];
        nArray6[1] = 8;
        nArray6[2] = 16;
        nArray6[3] = 24;
        nArray6[4] = 32;
        nArray6[5] = 40;
        nArray6[6] = 48;
        nArray6[7] = 56;
        nArray6[8] = 64;
        nArray6[9] = 80;
        nArray6[10] = 96;
        nArray6[11] = 112;
        nArray6[12] = 128;
        nArray6[13] = 144;
        nArray6[14] = 160;
        nArray6[15] = -1;
        nArrayArray3[1] = nArray6;
        int[] nArray7 = new int[16];
        nArray7[1] = 8;
        nArray7[2] = 16;
        nArray7[3] = 24;
        nArray7[4] = 32;
        nArray7[5] = 40;
        nArray7[6] = 48;
        nArray7[7] = 56;
        nArray7[8] = 64;
        nArray7[9] = 80;
        nArray7[10] = 96;
        nArray7[11] = 112;
        nArray7[12] = 128;
        nArray7[13] = 144;
        nArray7[14] = 160;
        nArray7[15] = -1;
        nArrayArray3[2] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[1] = 32;
        nArray8[2] = 48;
        nArray8[3] = 56;
        nArray8[4] = 64;
        nArray8[5] = 80;
        nArray8[6] = 96;
        nArray8[7] = 112;
        nArray8[8] = 128;
        nArray8[9] = 144;
        nArray8[10] = 160;
        nArray8[11] = 176;
        nArray8[12] = 192;
        nArray8[13] = 224;
        nArray8[14] = 256;
        nArray8[15] = -1;
        nArrayArray3[3] = nArray8;
        BITRATE_TABLE2 = nArrayArray3;
        int[] nArray9 = new int[4];
        nArray9[1] = 11520;
        nArray9[2] = 13824;
        nArray9[3] = 5376;
        MAX_FREE_BITS = nArray9;
        int[] nArray10 = new int[4];
        nArray10[1] = 7;
        nArray10[2] = 7;
        nArray10[3] = 31;
        SLOT_BITS_MASK = nArray10;
        int[][] nArrayArray4 = new int[2][];
        int[] nArray11 = new int[4];
        nArray11[1] = 576;
        nArray11[2] = 1152;
        nArray11[3] = 384;
        nArrayArray4[0] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[1] = 1152;
        nArray12[2] = 1152;
        nArray12[3] = 384;
        nArrayArray4[1] = nArray12;
        SAMPLES_PER_FRAME = nArrayArray4;
        MPA_OK = 0;
        MPA_HDR_DOUBTED = 1;
        MPA_ERR_LOWBUFFER = -1;
        MPA_ERR_NULLPTR = -2;
        MPA_ERR_NOHDR = -3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHeader(MPAHeader mPAHeader, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        block28: {
            n15 = MPA_ERR_NOHDR;
            boolean bl = false;
            n14 = n2;
            n13 = 0;
            if (n3 < 4) {
                return n15;
            }
            n12 = n14 + n3;
            block2: while (true) {
                if ((byArray[n14] & 0xFF) != 255 || (byArray[n14 + 1] & 0xF6) <= 240 || (byArray[n14 + 2] & 0xF0) == 240 || (byArray[n14 + 2] & 0xC) == 12 || (byArray[n14 + 3] & 3) == 2) {
                    if (++n14 + 3 < n12) continue;
                    if (!bl) {
                        return n15;
                    }
                    break block28;
                }
                n11 = byArray[n14 + 1] >> 3 & 1;
                n10 = byArray[n14 + 1] >> 1 & 3;
                n9 = byArray[n14 + 1] & 1;
                n8 = byArray[n14 + 2] >> 4 & 0xF;
                n7 = byArray[n14 + 2] >> 2 & 3;
                n6 = byArray[n14 + 2] >> 1 & 1;
                n5 = byArray[n14 + 3] >> 6 & 3;
                int n16 = SAMPLES_PER_FRAME[n11][n10];
                int n17 = SAMPLE_TABLE[n11][n7];
                if (n8 != 0) {
                    n4 = (n11 == MPA_MPEG1 ? BITRATE_TABLE1[n10][n8] : BITRATE_TABLE2[n10][n8]) * 1000 * n16 / n17 & ~SLOT_BITS_MASK[n10];
                    if (n6 != 0) {
                        n4 += SLOT_BITS_MASK[n10] + 1;
                    }
                    if ((n13 = n14 + (n4 >> 3)) + 1 < n12) {
                        if ((byArray[n13] & 0xFF) == 255 && (byArray[n13 + 1] & 0xFE) == (byArray[n14 + 1] & 0xFE)) {
                            if (this.firstFound) {
                                if (n11 == this.firstId && n10 == this.firstLayer && n17 == this.firstSamplingRate) {
                                    mPAHeader.headerOffset = n14;
                                    bl = true;
                                    n15 = MPA_OK;
                                    break block28;
                                } else {
                                    ++n14;
                                    continue;
                                }
                            }
                            mPAHeader.headerOffset = n14;
                            bl = true;
                            n15 = MPA_OK;
                            break block28;
                        }
                        if (n14 == n2 && this.firstFound && n11 == this.firstId && n10 == this.firstLayer && n17 == this.firstSamplingRate) {
                            if (!bl) {
                                mPAHeader.headerOffset = n14;
                            }
                            bl = true;
                            n15 = MPA_HDR_DOUBTED;
                            break block28;
                        } else {
                            ++n14;
                            continue;
                        }
                    }
                    if (!bl) {
                        mPAHeader.headerOffset = n14;
                    }
                    bl = true;
                    n15 = MPA_HDR_DOUBTED;
                    ++n14;
                    continue;
                }
                n4 = MAX_FREE_BITS[n10] >> 3;
                n13 = 48;
                if (n14 + n13 + 3 >= n12) {
                    if (!bl) {
                        mPAHeader.headerOffset = n14;
                    }
                    bl = true;
                    n15 = MPA_HDR_DOUBTED;
                    ++n14;
                    continue;
                }
                try {
                    while ((byArray[n14 + n13] & 0xFF) != 255 || (byArray[n14 + n13 + 1] & 0xFE) != (byArray[n14 + 1] & 0xFE) || (byArray[n14 + n13 + 2] & 0xFC) != (byArray[n14 + 2] & 0xFC) || (byArray[n14 + n13 + 3] & 3) != 2) {
                        if (++n13 > n4) {
                            ++n14;
                            continue block2;
                        }
                        if (n14 + n13 + 3 < n12) continue;
                        if (!bl) {
                            mPAHeader.headerOffset = n14;
                        }
                        bl = true;
                        n15 = MPA_HDR_DOUBTED;
                        ++n14;
                        continue block2;
                    }
                    break;
                }
                catch (Exception exception) {
                    System.err.println("Exception: off " + n14 + " off2 " + n13 + " bufend " + n12);
                    exception.printStackTrace();
                    return MPA_ERR_NOHDR;
                }
            }
            mPAHeader.headerOffset = n14;
            bl = true;
            n15 = MPA_OK;
        }
        n14 = mPAHeader.headerOffset;
        n11 = byArray[n14 + 1] >> 3 & 1;
        n10 = byArray[n14 + 1] >> 1 & 3;
        n9 = byArray[n14 + 1] & 1;
        n8 = byArray[n14 + 2] >> 4 & 0xF;
        n7 = byArray[n14 + 2] >> 2 & 3;
        n6 = byArray[n14 + 2] >> 1 & 1;
        n5 = byArray[n14 + 3] >> 6 & 3;
        mPAHeader.layer = 4 - n10;
        mPAHeader.nSamples = SAMPLES_PER_FRAME[n11][n10];
        mPAHeader.samplingRate = SAMPLE_TABLE[n11][n7];
        mPAHeader.bitRate = n11 == MPA_MPEG1 ? BITRATE_TABLE1[n10][n8] : BITRATE_TABLE2[n10][n8];
        int n18 = mPAHeader.nChannels = n5 == MPA_MONO ? 1 : 2;
        if (mPAHeader.bitRate > 0) {
            mPAHeader.bitsInFrame = mPAHeader.bitRate * 1000 * mPAHeader.nSamples / mPAHeader.samplingRate & ~SLOT_BITS_MASK[n10];
            if (n6 != 0) {
                mPAHeader.bitsInFrame += SLOT_BITS_MASK[n10] + 1;
            }
        } else {
            mPAHeader.bitsInFrame = n15 == MPA_OK ? n13 << 3 : n12 - n14 << 3;
        }
        if (n10 == MPA_LAYER3) {
            int n19 = n4 = n9 == 1 ? 4 : 6;
            mPAHeader.negOffset = n11 == MPA_MPEG1 ? (byArray[n14 + n4] & 0xFF) << 1 | byArray[n14 + n4 + 1] >> 7 & 1 : byArray[n14 + n4] & 0xFF;
        } else {
            mPAHeader.negOffset = 0;
        }
        if (!this.firstFound && n15 == MPA_OK) {
            this.firstFound = true;
            this.firstId = n11;
            this.firstLayer = n10;
            this.firstSamplingRate = mPAHeader.samplingRate;
        }
        return n15;
    }

    public String getName() {
        return "MPEG Audio Parser";
    }

    public void reset() {
        this.firstFound = false;
        this.firstId = 0;
        this.firstLayer = 0;
        this.firstSamplingRate = 0;
    }
}

