/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.Renderer;

class GraphNode {
    Class clz;
    String cname;
    PlugIn plugin;
    int type = -1;
    Format input;
    Format output = null;
    Format[] supportedIns;
    Format[] supportedOuts;
    GraphNode prev;
    int level;
    boolean failed = false;
    boolean custom = false;
    static int ARRAY_INC = 30;
    int attemptedIdx = 0;
    Format[] attempted = null;

    GraphNode(GraphNode graphNode, Format format, GraphNode graphNode2, int n2) {
        this.cname = graphNode.cname;
        this.plugin = graphNode.plugin;
        this.type = graphNode.type;
        this.custom = graphNode.custom;
        this.input = format;
        this.prev = graphNode2;
        this.level = n2;
        this.supportedIns = graphNode.supportedIns;
        if (graphNode.input == format) {
            this.supportedOuts = graphNode.supportedOuts;
        }
    }

    GraphNode(String string, PlugIn plugIn, Format format, GraphNode graphNode, int n2) {
        this.cname = string;
        this.plugin = plugIn;
        this.input = format;
        this.prev = graphNode;
        this.level = n2;
    }

    GraphNode(PlugIn plugIn, Format format, GraphNode graphNode, int n2) {
        this(plugIn == null ? null : plugIn.getClass().getName(), plugIn, format, graphNode, n2);
    }

    boolean checkAttempted(Format format) {
        if (this.attempted == null) {
            this.attempted = new Format[ARRAY_INC];
            this.attempted[this.attemptedIdx++] = format;
            return false;
        }
        int n2 = 0;
        while (n2 < this.attemptedIdx) {
            if (format.equals(this.attempted[n2])) {
                return true;
            }
            ++n2;
        }
        if (this.attemptedIdx >= this.attempted.length) {
            Format[] formatArray = new Format[this.attempted.length + ARRAY_INC];
            System.arraycopy(this.attempted, 0, formatArray, 0, this.attempted.length);
            this.attempted = formatArray;
        }
        this.attempted[this.attemptedIdx++] = format;
        return false;
    }

    Format[] getSupportedInputs() {
        if (this.supportedIns != null) {
            return this.supportedIns;
        }
        if (this.plugin == null) {
            return null;
        }
        if ((this.type == -1 || this.type == 2) && this.plugin instanceof Codec) {
            this.supportedIns = ((Codec)this.plugin).getSupportedInputFormats();
        } else if ((this.type == -1 || this.type == 4) && this.plugin instanceof Renderer) {
            this.supportedIns = ((Renderer)this.plugin).getSupportedInputFormats();
        } else if (this.plugin instanceof Multiplexer) {
            this.supportedIns = ((Multiplexer)this.plugin).getSupportedInputFormats();
        }
        return this.supportedIns;
    }

    Format[] getSupportedOutputs(Format format) {
        if (format == this.input && this.supportedOuts != null) {
            return this.supportedOuts;
        }
        if (this.plugin == null) {
            return null;
        }
        if ((this.type == -1 || this.type == 4) && this.plugin instanceof Renderer) {
            return null;
        }
        if ((this.type == -1 || this.type == 2) && this.plugin instanceof Codec) {
            Format[] formatArray = ((Codec)this.plugin).getSupportedOutputFormats(format);
            if (this.input == format) {
                this.supportedOuts = formatArray;
            }
            return formatArray;
        }
        return null;
    }

    public void resetAttempted() {
        this.attemptedIdx = 0;
        this.attempted = null;
    }
}

