/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.ImageButton;
import com.ibm.media.bean.multiplayer.JMFUtil;
import com.ibm.media.bean.multiplayer.MediaGroup;
import com.ibm.media.bean.multiplayer.RelatedLink;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Time;
import javax.media.bean.playerbean.MediaPlayer;

public class MultiPlayerBean
extends Panel
implements ActionListener,
Serializable,
ControllerListener,
ComponentListener {
    transient Panel buttonPanel;
    transient Panel gifPanel;
    transient Panel scrollPanel;
    transient Panel utilPanel;
    transient Panel videoPanel;
    transient ImageButton up;
    transient ImageButton down;
    transient ImageButton left;
    transient ImageButton right;
    private MediaPlayer currentPlayer = null;
    transient Button infoButton;
    transient GridBagLayout gridbag = new GridBagLayout();
    transient GridBagConstraints constraint = new GridBagConstraints();
    private final String infoWindow = JMFUtil.getString("Info");
    private URL currentU = null;
    private boolean displayURL = false;
    private boolean panelVisible = true;
    private boolean fitVideo = true;
    private boolean looping = true;
    private boolean sequential = true;
    private URL mpCodeBase = null;
    private AppletContext mpAppletContext = null;
    private int currentNum;
    private int numOfClips = 0;
    protected int numOfMGroups = 0;
    private int preferredHeight = 400;
    private int preferredWidth = 300;
    private String linksString;
    private String[] mediaNames;
    private String[] links;
    public MediaGroup[] mGroups;
    private int maxMediaGroup = 10;
    private boolean loadOnInit = false;
    private boolean fixAspectRatio = true;
    private int startingButton = 1;
    private String buttonPosition = JMFUtil.getString("SOUTH");
    private int tabsize = 16;
    private boolean msVM = false;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public MultiPlayerBean() {
        this.setup();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("info") && this.mpAppletContext != null) {
            this.doDebug("Info: currentNum = " + this.currentNum);
            if (this.mGroups[this.currentNum - 1].getRelated() != null) {
                Vector vector = this.mGroups[this.currentNum - 1].getRelated();
                int n2 = vector.size();
                double d2 = this.currentPlayer.getMediaTime().getSeconds();
                int n3 = 0;
                while (n3 < n2) {
                    RelatedLink relatedLink = (RelatedLink)vector.elementAt(n3);
                    if ((double)relatedLink.startTime <= d2 && (relatedLink.stopTime == 0L || (double)relatedLink.stopTime >= d2)) {
                        this.mpAppletContext.showDocument(relatedLink.uLink, this.infoWindow);
                        n3 = n2;
                    }
                    ++n3;
                }
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("left") || actionEvent.getActionCommand().equalsIgnoreCase("up")) {
            this.shiftButtons(-1);
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("right") || actionEvent.getActionCommand().equalsIgnoreCase("down")) {
            this.shiftButtons(1);
        } else {
            int n4;
            try {
                n4 = Integer.parseInt(actionEvent.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            this.doDebug("Button " + n4 + " pressed.");
            if (this.currentNum != n4) {
                this.pauseCurrent();
                this.setPlayer(n4);
            }
        }
    }

    public void addControllerListener(ControllerListener controllerListener) {
        int n2 = 0;
        while (n2 < this.numOfClips) {
            this.mGroups[n2].getPlayer().addControllerListener(controllerListener);
            ++n2;
        }
    }

    public boolean addLink(int n2, String string, long l2, long l3) {
        String[] stringArray;
        this.doDebug("adding link: index = " + n2);
        this.doDebug("Link = " + string + " start=" + l2 + " stop=" + l3);
        try {
            stringArray = new RelatedLink(string, l2, l3, this);
            this.mGroups[n2 - 1].setRelated((RelatedLink)stringArray);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(JMFUtil.getString("InvalidURL"));
            return false;
        }
        if (!this.duplicate(Integer.toString(n2 + 1), string, Long.toString(l2), Long.toString(l3))) {
            int n3 = 0;
            if (this.links != null) {
                n3 = this.links.length;
            }
            stringArray = new String[n3 + 4];
            JMFUtil.copyStringArray(this.links, stringArray);
            stringArray[n3] = Integer.toString(n2 + 1);
            stringArray[n3 + 1] = string;
            stringArray[n3 + 2] = Long.toString(l2);
            stringArray[n3 + 3] = Long.toString(l3);
        }
        return true;
    }

    public void addMGroup(String string, String string2) {
        this.doDebug("adding media group - " + this.numOfMGroups);
        if (this.mGroups == null) {
            this.mGroups = new MediaGroup[this.maxMediaGroup];
        }
        if (this.numOfMGroups < this.maxMediaGroup) {
            this.mGroups[this.numOfMGroups] = new MediaGroup(string, string2, "", this);
        } else {
            System.out.println(JMFUtil.getString("MaxMGroup"));
        }
        this.doDebug("Number of next media group = " + this.numOfMGroups);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    private void changeCurrentPlayer(MediaPlayer mediaPlayer, int n2) {
        this.currentNum = n2;
        this.currentPlayer = mediaPlayer;
        this.doDebug("Switching current Player");
        this.currentPlayer.setVisible(true);
        this.videoPanel.add(this.currentPlayer);
        JMFUtil.center(this.videoPanel, this.currentPlayer, true, this.currentPlayer.getMediaLocationHeight() + this.currentPlayer.getControlPanelHeight());
        this.videoPanel.setVisible(true);
        try {
            if (this.currentPlayer.getState() != 600) {
                this.currentPlayer.start();
            } else {
                System.out.println("Player already in started state.");
            }
        }
        catch (ClockStartedError clockStartedError) {
            this.currentPlayer.close();
            this.currentPlayer.deallocate();
            this.currentPlayer.start();
        }
        this.currentPlayer.setVisible(true);
        this.currentPlayer.waitForState(600);
        this.currentPlayer.invalidate();
        this.videoPanel.validate();
        this.videoPanel.setVisible(true);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.doDebug("Something is being resized.");
        this.doDebug("videoPanel=" + this.videoPanel);
        if (this.currentPlayer != null) {
            this.doDebug("pb=" + this.currentPlayer);
        }
        if (componentEvent.getSource() == this.gifPanel) {
            this.doDebug("resize gifPanel: " + this.gifPanel);
            this.videoResize();
            if (!this.msVM) {
                this.updateGifPanel();
            }
        } else if (componentEvent.getSource() == this.currentPlayer) {
            this.doDebug("resize currentPlayer: " + this.currentPlayer.getSize());
            JMFUtil.center(this.videoPanel, this.currentPlayer, true, this.currentPlayer.getPreferredSize().height - this.currentPlayer.getVisualComponent().getSize().height);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private boolean containsButton(Component component) {
        Component[] componentArray = this.gifPanel.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] == component) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof EndOfMediaEvent) {
            if (!this.looping && this.currentPlayer != null) {
                this.currentPlayer.setMediaTime(new Time(0L));
            }
            if (this.sequential) {
                this.nextPlayer();
            }
        }
    }

    private void createLeftRight(int n2) {
        this.left = new ImageButton("<", true, this.tabsize, n2);
        this.right = new ImageButton(">", true, this.tabsize, n2);
        this.left.setActionCommand("left");
        this.right.setActionCommand("right");
        this.left.addActionListener(this);
        this.right.addActionListener(this);
        this.left.setBackground(Color.lightGray);
        this.right.setBackground(Color.lightGray);
    }

    protected void createTabs(int n2) {
        if (this.up != null) {
            this.scrollPanel.remove(this.up);
        }
        if (this.down != null) {
            this.scrollPanel.remove(this.down);
        }
        if (this.left != null) {
            this.scrollPanel.remove(this.left);
        }
        if (this.right != null) {
            this.scrollPanel.remove(this.right);
        }
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
            this.createLeftRight(n2);
            this.scrollPanel.add("West", this.left);
            this.scrollPanel.add("East", this.right);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.createUpDown(n2);
            this.scrollPanel.add("North", this.up);
            this.scrollPanel.add("South", this.down);
        }
    }

    private void createUpDown(int n2) {
        this.up = new ImageButton("UP", true, n2, this.tabsize);
        this.down = new ImageButton("DOWN", true, n2, this.tabsize);
        this.up.setActionCommand("up");
        this.down.setActionCommand("down");
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.up.setBackground(Color.lightGray);
        this.down.setBackground(Color.lightGray);
    }

    private boolean deleteLinks(String[] stringArray) {
        boolean bl = false;
        Vector vector = null;
        RelatedLink relatedLink = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (n2 < this.numOfMGroups) {
            vector = this.mGroups[n2].getRelated();
            if (vector != null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    relatedLink = (RelatedLink)vector.elementAt(n3);
                    bl3 = false;
                    if (stringArray != null) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            if (Integer.toString(n2).equals(stringArray[n4]) & relatedLink.link.equals(stringArray[n4 + 1]) & Long.toString(relatedLink.startTime).equals(stringArray[n4 + 2]) & Long.toString(relatedLink.stopTime).equals(stringArray[n4 + 3])) {
                                bl3 = true;
                                break;
                            }
                            n4 += 4;
                        }
                    }
                    if (!bl3) {
                        vector.removeElementAt(n3);
                        bl2 = true;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return bl2;
    }

    public void deleteMGroup(int n2) {
        boolean bl = false;
        String string = Integer.toString(n2 + 1);
        this.doDebug("i = " + n2);
        this.doDebug("index = " + string);
        this.doDebug("MGroups length = " + this.mGroups.length);
        String[] stringArray = null;
        MediaGroup mediaGroup = this.mGroups[n2];
        int n3 = 0;
        if (this.links != null) {
            n3 = this.links.length;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (string.equals(this.links[n4])) {
                bl = true;
                stringArray = new String[this.links.length - 4];
                JMFUtil.copyShortenStringArray(this.links, stringArray, n4, 4);
            }
            n4 += 4;
        }
        int n5 = n2;
        while (n5 < this.numOfMGroups - 1) {
            this.mGroups[n5] = this.mGroups[n5 + 1];
            if (this.links != null) {
                int n6;
                string = Integer.toString(n5 + 1);
                if (bl) {
                    n6 = 0;
                    while (n6 < stringArray.length) {
                        if (stringArray[n6].equals(string)) {
                            stringArray[n6] = Integer.toString(n5);
                        }
                        n6 += 4;
                    }
                } else {
                    stringArray = new String[n3];
                    JMFUtil.copyStringArray(this.links, stringArray);
                    n6 = 0;
                    while (n6 < stringArray.length) {
                        if (stringArray[n6].equals(string)) {
                            bl = true;
                            stringArray[n6] = Integer.toString(n5);
                        }
                        n6 += 4;
                    }
                }
            }
            ++n5;
        }
        if (bl) {
            this.setLinks(stringArray);
        }
        this.mGroups[this.numOfMGroups - 1] = null;
        --this.numOfMGroups;
        this.doDebug("Remove button " + mediaGroup.gifName);
        this.gifPanel.remove(mediaGroup.getButton());
        this.updateGifPanel();
        this.validate();
    }

    public void destroy() {
        this.doDebug("in destroy()");
        this.currentPlayer.stop();
        this.currentPlayer.close();
        this.numOfClips = 0;
        System.out.println("out destroy");
    }

    protected void doDebug(String string) {
        System.out.println(string);
    }

    private boolean duplicate(String string, String string2, String string3, String string4) {
        if (this.links != null) {
            int n2 = 0;
            while (n2 < this.links.length) {
                if (this.links[n2].equals(string) & this.links[n2 + 1].equals(string2) & this.links[n2 + 2].equals(string3) & this.links[n2 + 3].equals(string4)) {
                    return true;
                }
                n2 += 4;
            }
        }
        return false;
    }

    protected ImageButton formButton(int n2) {
        this.doDebug("Form Index button");
        ImageButton imageButton = new ImageButton(Integer.toString(n2), true, 80, 60);
        imageButton.setActionCommand(Integer.toString(n2));
        imageButton.addActionListener(this);
        imageButton.waitForImage(true);
        return imageButton;
    }

    protected ImageButton formButton(URL uRL, int n2) {
        this.doDebug("Form image button");
        ImageButton imageButton = new ImageButton(uRL);
        imageButton.setActionCommand(Integer.toString(n2));
        imageButton.addActionListener(this);
        imageButton.setEnabled(true);
        imageButton.waitForImage(true);
        return imageButton;
    }

    private MediaPlayer formPlayer(String string) {
        try {
            string = string.trim();
            if (string.length() != 0) {
                this.doDebug("Forming player: " + string + "| CodeBase = " + this.mpCodeBase);
                ClassLoader classLoader = this.getClass().getClassLoader();
                MediaPlayer mediaPlayer = (MediaPlayer)Beans.instantiate(classLoader, "javax.media.bean.playerbean.MediaPlayer");
                if (((string.startsWith("http") || string.startsWith("file")) ^ true) & this.mpCodeBase != null) {
                    string = String.valueOf(String.valueOf(this.mpCodeBase)) + string;
                }
                this.doDebug("loading: 111" + string);
                mediaPlayer.setMediaLocation(string);
                mediaPlayer.prefetch();
                mediaPlayer.waitForState(500);
                System.out.println("Wait for state done");
                mediaPlayer.addControllerListener(this);
                mediaPlayer.addComponentListener(this);
                mediaPlayer.setVisible(false);
                mediaPlayer.setBackground(this.getBackground());
                mediaPlayer.setMediaLocationVisible(this.displayURL);
                mediaPlayer.setPlaybackLoop(this.looping);
                mediaPlayer.setControlPanelVisible(this.panelVisible);
                ++this.numOfClips;
                System.out.println("num of Clips=" + this.numOfClips);
                Dimension dimension = this.getSize();
                int n2 = dimension.height;
                int n3 = dimension.width;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                Dimension dimension2 = this.buttonPanel.getSize();
                if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                    n5 = n2 - dimension2.height;
                    n6 = n3;
                } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                    n5 = n2;
                    n6 = n3 - dimension2.width;
                }
                if (this.fixAspectRatio) {
                    Component component = mediaPlayer.getVisualComponent();
                    float f2 = 1.0f;
                    if (component != null) {
                        int n7 = 0;
                        if (mediaPlayer.getControlPanelComponent() != null && this.panelVisible) {
                            n7 = mediaPlayer.getControlPanelComponent().getSize().height;
                        }
                        if (this.displayURL) {
                            n7 += 23;
                        }
                        Dimension dimension3 = component.getPreferredSize();
                        f2 = JMFUtil.aspectRatio(dimension3.width, dimension3.height, 0);
                        n5 = (int)((float)n3 / f2) + n7;
                        if (n5 > n2) {
                            n6 = (int)(f2 * (float)(n2 - n7));
                            n5 = n2 - n4;
                        } else {
                            n6 = n3;
                        }
                    }
                }
                mediaPlayer.setBounds(this.getBounds().x, this.getBounds().y, n6, n5);
                this.doDebug("Number of Clips: " + this.numOfClips);
                return mediaPlayer;
            }
            return null;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(JMFUtil.getString("PlayerBeanNotGood")) + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public String getButtonPosition() {
        return this.buttonPosition;
    }

    private void getContext(Object object) {
        if (object == null) {
            object = this.getParent();
        }
        if (this.mpCodeBase != null) {
            return;
        }
        if (object instanceof Applet) {
            this.mpCodeBase = ((Applet)object).getCodeBase();
            this.mpAppletContext = ((Applet)object).getAppletContext();
        }
    }

    public String[] getLinks() {
        return this.links;
    }

    public String getLinks(int n2) {
        return this.links[n2];
    }

    public boolean getLoadOnInit() {
        return this.loadOnInit;
    }

    public MediaGroup[] getMGroups() {
        return this.mGroups;
    }

    public MediaGroup getMGroups(int n2) {
        return this.mGroups[n2];
    }

    public String[] getMediaNames() {
        return this.mediaNames;
    }

    public String getMediaNames(int n2) {
        return this.mediaNames[n2];
    }

    public int getNumberOfMediaGroups() {
        return this.numOfMGroups;
    }

    public Dimension getPreferredSize() {
        if (Beans.isDesignTime()) {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
        return dimension;
    }

    protected URL getURL(String string) {
        URL uRL = null;
        this.doDebug(string);
        try {
            uRL = ((string.startsWith("http") || string.startsWith("file")) ^ true) & this.mpCodeBase != null ? new URL(this.mpCodeBase, string) : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(String.valueOf(JMFUtil.getString("InvalidURL:")) + string);
            return null;
        }
        return uRL;
    }

    public boolean isFitVideo() {
        return this.fitVideo;
    }

    public boolean isFixAspectRatio() {
        return this.fixAspectRatio;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public boolean isPanelVisible() {
        return this.panelVisible;
    }

    public boolean isSequentialPlay() {
        return this.sequential;
    }

    public boolean isURLVisible() {
        return this.displayURL;
    }

    public void moveDown(int n2) {
        MediaGroup mediaGroup = this.mGroups[n2];
        if (n2 < this.numOfMGroups - 1) {
            this.mGroups[n2] = this.mGroups[n2 + 1];
            this.mGroups[n2 + 1] = mediaGroup;
            this.mGroups[n2].setIndex(n2);
            this.mGroups[n2 + 1].setIndex(n2 + 1);
            this.mGroups[n2].getButton().setActionCommand(Integer.toString(n2 + 1));
            this.mGroups[n2 + 1].getButton().setActionCommand(Integer.toString(n2 + 2));
            if (this.switchLinkIndex(Integer.toString(n2 + 1), Integer.toString(n2 + 2))) {
                this.setLinks(this.links);
            }
            this.doDebug("moveDown(i):ActionCommand=" + (n2 + 1));
            this.doDebug("moveDown(i):ActionCommand=" + (n2 + 2));
        }
        int n3 = n2;
        while (n3 < this.numOfMGroups) {
            ImageButton imageButton = this.mGroups[n3].getButton();
            this.doDebug("Moving media " + this.mGroups[n3].mediaName);
            this.gifPanel.remove(imageButton);
            this.gifPanel.add(imageButton);
            ++n3;
        }
        this.validate();
    }

    public void moveUp(int n2) {
        MediaGroup mediaGroup = this.mGroups[n2];
        if (n2 > 0) {
            this.mGroups[n2] = this.mGroups[n2 - 1];
            this.mGroups[n2 - 1] = mediaGroup;
            this.mGroups[n2].setIndex(n2);
            this.mGroups[n2 - 1].setIndex(n2 - 1);
            this.mGroups[n2].getButton().setActionCommand(Integer.toString(n2 + 1));
            this.mGroups[n2 - 1].getButton().setActionCommand(Integer.toString(n2));
            if (this.switchLinkIndex(Integer.toString(n2), Integer.toString(n2 + 1))) {
                this.setLinks(this.links);
            }
            this.doDebug("ActionCommand = " + (n2 + 1));
            this.doDebug("ActionCommand = " + n2);
        }
        int n3 = n2 - 1;
        while (n3 < this.numOfMGroups) {
            ImageButton imageButton = this.mGroups[n3].getButton();
            this.gifPanel.remove(imageButton);
            this.gifPanel.add(imageButton);
            ++n3;
        }
        this.validate();
    }

    public void nextPlayer() {
        if (this.numOfMGroups <= 1) {
            return;
        }
        this.pauseCurrent();
        ++this.currentNum;
        if (this.currentNum > this.numOfMGroups) {
            this.currentNum = 1;
        }
        while (!this.containsButton(this.mGroups[this.currentNum - 1].getButton())) {
            this.shiftButtons(1);
        }
        this.doDebug("Next Player");
        this.setPlayer(this.currentNum);
    }

    public void pauseCurrent() {
        if (this.currentNum <= this.numOfMGroups && this.currentNum > 0) {
            ImageButton imageButton = this.mGroups[this.currentNum - 1].getButton();
            imageButton.setBorderColor(new Color(160, 160, 160));
            imageButton.drawBorder(true);
        }
        if (this.currentPlayer != null) {
            this.currentPlayer.stop();
            this.currentPlayer.close();
            this.currentPlayer.setVisible(false);
            this.videoPanel.remove(this.currentPlayer);
            this.doDebug("Exiting PauseCurrent.");
        }
    }

    private void position() {
        this.remove(this.videoPanel);
        this.remove(this.buttonPanel);
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST"))) {
            this.add("Center", this.videoPanel);
            this.add("West", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.add("Center", this.videoPanel);
            this.add("East", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
            this.add("Center", this.videoPanel);
            this.add("South", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
            this.add("Center", this.videoPanel);
            this.add("North", this.buttonPanel);
        } else {
            this.add("Center", this.videoPanel);
        }
        this.updateGifPanel();
    }

    public void previousPlayer() {
        if (this.numOfMGroups <= 1) {
            return;
        }
        this.pauseCurrent();
        --this.currentNum;
        if (this.currentNum < 1) {
            this.currentNum = this.numOfMGroups;
        }
        while (!this.containsButton(this.mGroups[this.currentNum - 1].getButton())) {
            this.shiftButtons(-1);
        }
        this.doDebug("Previous Player");
        this.setPlayer(this.currentNum);
    }

    private void refreshAllButtons() {
        this.gifPanel.removeAll();
        int n2 = 0;
        while (n2 < this.numOfMGroups) {
            this.gifPanel.add(this.mGroups[n2].getButton());
            ++n2;
        }
        this.validate();
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        int n2 = 0;
        while (n2 < this.numOfClips) {
            this.mGroups[n2].getPlayer().removeControllerListener(controllerListener);
            ++n2;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void replaceMGroup(int n2, String string, String string2) {
        if (n2 < this.numOfMGroups) {
            MediaGroup mediaGroup;
            if (n2 < this.numOfMGroups - 1) {
                mediaGroup = this.mGroups[n2 + 1];
                if (mediaGroup.mediaName.equals(string) & mediaGroup.gifName.equals(string2)) {
                    this.moveDown(n2);
                    return;
                }
            }
            if ((mediaGroup = this.mGroups[n2]).getPlayer() != null) {
                MediaPlayer mediaPlayer = mediaGroup.getPlayer();
                mediaPlayer.close();
                mediaPlayer.deallocate();
                mediaGroup.setPlayer(null);
            }
            this.doDebug("Media Name = " + string);
            this.doDebug("Gif Name = " + string2);
            mediaGroup.mediaName = string;
            mediaGroup.gifName = string2;
            if (string2 != null || string2.compareTo("") != 0) {
                mediaGroup.setButton(this.formButton(this.getURL(string2), n2 + 1));
            } else {
                mediaGroup.setButton(this.formButton(n2 + 1));
            }
            this.doDebug("Replacing " + n2);
            this.refreshAllButtons();
        }
    }

    public void setAppletContext(AppletContext appletContext) {
        this.mpAppletContext = appletContext;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        Dimension dimension = this.getSize();
        int n6 = dimension.height;
        int n7 = 10;
        Dimension dimension2 = this.buttonPanel.getSize();
        if (n7 < dimension2.height) {
            n7 = dimension2.height;
        }
        this.doDebug("Num of Clips = " + this.numOfClips);
        int n8 = 0;
        while (n8 < this.numOfClips) {
            this.mGroups[n8].getPlayer().setBounds(n2, n3, n4, n5 - n7);
            ++n8;
        }
        this.updateGifPanel();
    }

    public void setButtonPosition(String string) {
        String string2 = this.buttonPosition;
        if (!string2.equalsIgnoreCase(string)) {
            this.buttonPosition = string;
            this.position();
            this.changes.firePropertyChange("buttonPosition", new String(string2), new String(string));
        }
    }

    public void setCodeBase(URL uRL) {
        this.mpCodeBase = uRL;
    }

    public void setFitVideo(boolean bl) {
        boolean bl2 = this.fitVideo;
        if (bl2 != bl) {
            int n2 = 0;
            while (n2 < this.numOfClips) {
                ++n2;
            }
            this.fitVideo = bl;
        }
    }

    public void setFixAspectRatio(boolean bl) {
        boolean bl2 = this.fixAspectRatio;
        if (bl2 != bl) {
            int n2 = 0;
            while (n2 < this.numOfClips) {
                ++n2;
            }
        }
        this.fixAspectRatio = bl;
        this.changes.firePropertyChange("fixAspectRatio", new Boolean(bl2), new Boolean(bl));
    }

    public void setLinks(int n2, String string) {
        String[] stringArray = this.links;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        this.links[n2] = string;
        if (n2 % 4 == 0) {
            string2 = this.links[n2];
            string3 = this.links[n2 + 1];
            string4 = this.links[n2 + 2];
            string5 = this.links[n2 + 3];
        } else if (n2 % 4 == 1) {
            string2 = this.links[n2 - 1];
            string3 = this.links[n2];
            string4 = this.links[n2 + 1];
            string5 = this.links[n2 + 2];
        } else if (n2 % 3 == 2) {
            string2 = this.links[n2 - 2];
            string3 = this.links[n2 - 1];
            string4 = this.links[n2];
            string5 = this.links[n2 + 1];
        } else if (n2 % 3 == 4) {
            string2 = this.links[n2 - 3];
            string3 = this.links[n2 - 2];
            string4 = this.links[n2 - 1];
            string5 = this.links[n2];
        }
        if (this.updateLinks(string2, string3, string4, string5)) {
            this.changes.firePropertyChange("links", stringArray, this.links);
        }
    }

    public void setLinks(String[] stringArray) {
        String[] stringArray2 = this.links;
        boolean bl = false;
        this.links = stringArray;
        this.doDebug("Inside setLinks(String[])");
        bl = this.deleteLinks(this.links);
        this.doDebug("updating links...");
        if (this.updateLinks(this.links) | bl) {
            this.changes.firePropertyChange("links", stringArray2, stringArray);
        }
    }

    public void setLoadOnInit(boolean bl) {
        boolean bl2 = this.loadOnInit;
        if (bl2 != bl) {
            this.loadOnInit = bl;
            this.changes.firePropertyChange("loadOnInit", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setLooping(boolean bl) {
        boolean bl2 = this.looping;
        if (bl2 != bl) {
            int n2 = 0;
            while (n2 < this.numOfClips) {
                this.mGroups[n2].getPlayer().setPlaybackLoop(bl);
                ++n2;
            }
        }
        this.looping = bl;
        this.changes.firePropertyChange("looping", new Boolean(bl2), new Boolean(bl));
    }

    public void setMGroups(int n2, MediaGroup mediaGroup) {
        MediaGroup[] mediaGroupArray = this.mGroups;
        this.mGroups[n2] = mediaGroup;
        this.changes.firePropertyChange("mGroups", mediaGroupArray, this.mGroups);
    }

    public void setMGroups(MediaGroup[] mediaGroupArray) {
        MediaGroup[] mediaGroupArray2 = this.mGroups;
        this.mGroups = mediaGroupArray;
        this.changes.firePropertyChange("mGroups", mediaGroupArray2, mediaGroupArray);
    }

    public void setMediaNames(int n2, String string) {
        String string2;
        String string3;
        String[] stringArray = this.mediaNames;
        this.mediaNames[n2] = string;
        if (n2 % 2 == 0) {
            string3 = this.mediaNames[n2];
            string2 = this.mediaNames[n2 + 1];
        } else {
            string3 = this.mediaNames[n2 - 1];
            string2 = this.mediaNames[n2];
        }
        this.updateMGroups(n2 / 2, string3, string2);
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", stringArray, this.mediaNames);
    }

    public void setMediaNames(String[] stringArray) {
        String[] stringArray2 = this.mediaNames;
        this.mediaNames = stringArray;
        this.doDebug("setmediaNames " + this.mediaNames);
        this.updateMGroups(this.mediaNames);
        this.updateLinks(this.links);
        this.doDebug("updateMGroups done");
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", stringArray2, stringArray);
    }

    public void setMediaNames(String[] stringArray, Object object) {
        String[] stringArray2 = this.mediaNames;
        this.mediaNames = stringArray;
        this.doDebug("setmediaNames " + this.mediaNames);
        this.getContext(object);
        this.updateMGroups(this.mediaNames);
        this.updateLinks(this.links);
        this.doDebug("updateMGroups done");
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", stringArray2, stringArray);
    }

    public void setPanelVisible(boolean bl) {
        if (this.panelVisible != bl) {
            int n2 = 0;
            while (n2 < this.numOfClips) {
                this.mGroups[n2].getPlayer().setControlPanelVisible(bl);
                ++n2;
            }
            this.validate();
            this.panelVisible = bl;
            this.changes.firePropertyChange("panelVisible", new Boolean(bl ^ true), new Boolean(bl));
        }
    }

    public void setPlayer(int n2) {
        MediaGroup mediaGroup = null;
        ImageButton imageButton = null;
        if (n2 < 1 || n2 > this.numOfMGroups) {
            return;
        }
        mediaGroup = this.mGroups[n2 - 1];
        mediaGroup.setPlayer(this.formPlayer(mediaGroup.mediaName));
        if (!this.containsButton(mediaGroup.getButton())) {
            this.startingButton = this.currentNum;
            this.updateGifPanel();
        }
        if (mediaGroup.getRelated() != null && this.mpAppletContext != null) {
            if (mediaGroup.getRelated().size() > 0) {
                if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
                    this.buttonPanel.add("South", this.utilPanel);
                    this.validate();
                } else if (!this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NONE"))) {
                    this.videoPanel.add("South", this.utilPanel);
                    this.validate();
                }
            } else {
                this.buttonPanel.remove(this.utilPanel);
                this.videoPanel.remove(this.utilPanel);
                this.validate();
            }
        } else {
            this.buttonPanel.remove(this.utilPanel);
            this.videoPanel.remove(this.utilPanel);
        }
        imageButton = mediaGroup.getButton();
        imageButton.requestFocus();
        imageButton.setBorderColor(Color.darkGray);
        imageButton.drawBorder(false);
        this.currentPlayer = mediaGroup.getPlayer();
        this.changeCurrentPlayer(this.currentPlayer, n2);
    }

    public void setSequentialPlay(boolean bl) {
        boolean bl2 = this.sequential;
        if (bl2 != bl) {
            this.sequential = bl;
            this.changes.firePropertyChange("sequentialPlay", new Boolean(bl2), new Boolean(bl));
        }
    }

    public void setURLVisible(boolean bl) {
        if (this.displayURL != bl) {
            int n2 = 0;
            while (n2 < this.numOfClips) {
                this.mGroups[n2].getPlayer().setMediaLocationVisible(bl);
                ++n2;
            }
            this.validate();
            this.displayURL = bl;
            this.changes.firePropertyChange("URLVisible", new Boolean(bl ^ true), new Boolean(bl));
        }
    }

    private void setup() {
        this.getContext(null);
        if (!JMFUtil.msVersion()) {
            this.msVM = false;
            this.doDebug("Not Microsoft VM");
        } else {
            this.msVM = true;
            this.doDebug("Microsoft VM");
        }
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(this.getBackground());
        this.currentPlayer = null;
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new BorderLayout(0, 0));
        this.buttonPanel.setBackground(this.getBackground());
        this.buttonPanel.setVisible(false);
        this.gifPanel = new Panel();
        this.gifPanel.setBackground(this.getBackground());
        this.gifPanel.setVisible(false);
        this.gifPanel.addComponentListener(this);
        this.scrollPanel = new Panel();
        this.scrollPanel.setLayout(new BorderLayout(0, 0));
        this.scrollPanel.setBackground(this.getBackground());
        this.scrollPanel.add("Center", this.gifPanel);
        this.buttonPanel.add("Center", this.scrollPanel);
        this.infoButton = new Button(JMFUtil.getString("Link"));
        this.infoButton.setActionCommand("info");
        this.infoButton.addActionListener(this);
        this.infoButton.setEnabled(true);
        this.infoButton.setVisible(true);
        this.utilPanel = new Panel();
        this.utilPanel.setBackground(this.getBackground());
        this.utilPanel.setVisible(false);
        this.utilPanel.add("Center", this.infoButton);
        this.videoPanel = new Panel(){

            public Insets insets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.videoPanel.setBounds(this.getBounds().x, this.getBounds().y, this.getSize().width, this.getSize().height - this.buttonPanel.getSize().height);
        this.videoPanel.setLayout(new BorderLayout(0, 0));
        this.videoPanel.setBackground(this.getBackground());
        this.videoPanel.setVisible(true);
        this.utilPanel.setVisible(true);
        this.buttonPanel.setVisible(true);
        this.videoPanel.validate();
        this.setLayout(new BorderLayout());
        this.position();
    }

    private void shiftButtons(int n2) {
        this.startingButton += n2;
        if (this.startingButton > this.numOfMGroups) {
            this.startingButton -= this.numOfMGroups;
        }
        if (this.startingButton < 1) {
            this.startingButton = this.numOfMGroups + this.startingButton;
        }
        this.updateGifPanel();
    }

    public void start() {
        this.doDebug("in start()");
        if (this.loadOnInit) {
            int n2 = 0;
            while (n2 < this.numOfMGroups) {
                this.mGroups[n2].setPlayer(this.formPlayer(this.mGroups[n2].mediaName));
                ++n2;
            }
        }
        this.videoPanel.setBounds(this.getBounds().x, this.getBounds().y, this.getSize().width, this.getSize().height - this.buttonPanel.getSize().height);
        this.videoPanel.setVisible(true);
        this.pauseCurrent();
        this.setPlayer(1);
        this.validate();
        this.repaint();
    }

    public void stop() {
        this.doDebug("in stop()");
        if (this.currentPlayer != null) {
            this.currentPlayer.stop();
        }
    }

    private boolean switchLinkIndex(String string, String string2) {
        boolean bl = false;
        if (this.links != null) {
            int n2 = 0;
            while (n2 < this.links.length) {
                if (string.equals(this.links[n2])) {
                    this.doDebug("Switched " + this.links[n2] + " with " + string2);
                    bl = true;
                    this.links[n2] = string2;
                } else if (string2.equals(this.links[n2])) {
                    this.doDebug("Switched " + this.links[n2] + " with " + string);
                    bl = true;
                    this.links[n2] = string;
                }
                n2 += 4;
            }
        }
        return bl;
    }

    protected void updateGifPanel() {
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NONE"))) {
            this.validate();
            return;
        }
        if (this.numOfMGroups <= 0) {
            return;
        }
        int n2 = 0;
        int n3 = this.startingButton - 1;
        int n4 = n3 + 1;
        if (n4 == this.numOfMGroups) {
            n4 = 0;
        }
        int n5 = 0;
        ImageButton imageButton = this.mGroups[n3].getButton();
        int n6 = this.getSize().width;
        int n7 = 0;
        n5 = imageButton.height;
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            n6 = this.getSize().height;
            n7 = 0;
            n5 = imageButton.width;
        }
        n6 -= 2 * this.tabsize;
        boolean bl = true;
        this.scrollPanel.setVisible(false);
        this.scrollPanel.removeAll();
        this.gifPanel.setVisible(false);
        this.gifPanel.removeAll();
        if (++n3 >= this.numOfMGroups) {
            n3 = 0;
        }
        this.doDebug("ButtonsLength: " + n7);
        this.doDebug("Gif Length: " + n6);
        this.doDebug("i: " + n3);
        this.doDebug("stop: " + n4);
        imageButton = this.mGroups[n3].getButton();
        while (bl || n3 != n4) {
            bl = false;
            if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                if (imageButton.width + n7 > n6) break;
                ++n2;
                n7 += imageButton.width;
                if (imageButton.height > n5) {
                    n5 = imageButton.height;
                }
            } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                if (imageButton.height + n7 > n6) break;
                ++n2;
                n7 += imageButton.height;
                if (imageButton.width > n5) {
                    n5 = imageButton.width;
                }
            }
            if (++n3 < this.numOfMGroups) continue;
            n3 = 0;
        }
        int n8 = 0;
        if (n2 > 1) {
            n8 = (n6 - n7) / (n2 - 1);
        }
        System.out.println("gap=" + n8 + " gifLength=" + n6 + " buttonsLength=" + n7);
        if (n2 == 1) {
            this.gifPanel.setLayout(new FlowLayout());
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
            this.gifPanel.setLayout(new GridLayout(1, n2, n8, 0));
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.gifPanel.setLayout(new GridLayout(n2, 1, 0, n8));
        }
        imageButton = this.mGroups[this.startingButton - 1].getButton();
        n7 = imageButton.width;
        bl = true;
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            n7 = imageButton.height;
        }
        if ((n3 = this.startingButton) >= this.numOfMGroups) {
            n3 = 0;
        }
        while (n7 <= n6 && (bl || n3 != n4)) {
            bl = false;
            this.gifPanel.add(imageButton);
            imageButton = this.mGroups[n3].getButton();
            if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                n7 += imageButton.width;
            } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                n7 += imageButton.height;
            }
            if (++n3 < this.numOfMGroups) continue;
            n3 = 0;
        }
        if (n7 > n6 && n3 != n4) {
            this.createTabs(n5);
        }
        this.scrollPanel.add("Center", this.gifPanel);
        this.gifPanel.setVisible(true);
        this.scrollPanel.setVisible(true);
        this.validate();
    }

    private boolean updateLinks(String string, String string2, String string3, String string4) {
        this.doDebug("MediaNum=" + string + " related=" + string2);
        this.doDebug("Start=" + string3 + " Stop=" + string4);
        int n2 = Integer.parseInt(string) - 1;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        try {
            l2 = Long.parseLong(string3);
            l3 = Long.parseLong(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n2 < this.numOfMGroups & n2 >= 0) {
            MediaGroup mediaGroup = this.mGroups[n2];
            Vector vector = mediaGroup.getRelated();
            RelatedLink relatedLink = null;
            if (vector != null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    relatedLink = (RelatedLink)vector.elementAt(n3);
                    if (relatedLink.link.equals(string2) & relatedLink.startTime == l2 & relatedLink.stopTime == l3) {
                        bl = true;
                        n3 = vector.size();
                        return false;
                    }
                    ++n3;
                }
            }
            if (!bl) {
                try {
                    mediaGroup.setRelated(new RelatedLink(string2, l2, l3, this));
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println(String.valueOf(JMFUtil.getBIString("BadURL")) + string2);
                    return false;
                }
                return true;
            }
        }
        System.out.println(JMFUtil.getBIString("MEDIA_GROUP_BOUNDS"));
        return false;
    }

    private boolean updateLinks(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            this.doDebug("links length: " + stringArray.length);
            if (this.msVM) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = stringArray[n2];
                    ++n2;
                }
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (bl) {
                    this.updateLinks(stringArray[n3], stringArray[n3 + 1], stringArray[n3 + 2], stringArray[n3 + 3]);
                } else {
                    bl = this.updateLinks(stringArray[n3], stringArray[n3 + 1], stringArray[n3 + 2], stringArray[n3 + 3]);
                }
                n3 += 4;
            }
        }
        return bl;
    }

    private boolean updateMGroups(int n2, String string, String string2) {
        this.doDebug("Index=" + n2 + " Media=" + string + " Gif=" + string2);
        if (n2 < this.numOfMGroups) {
            MediaGroup mediaGroup = this.mGroups[n2];
            if (mediaGroup.mediaName.equals(string) ^ true | mediaGroup.gifName.equals(string2) ^ true) {
                this.replaceMGroup(n2, string, string2);
                return true;
            }
        } else {
            this.addMGroup(string, string2);
            return true;
        }
        return false;
    }

    private boolean updateMGroups(String[] stringArray) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        this.doDebug("Updating MGroups " + n2);
        int n4 = 0;
        while (n4 < n2) {
            n3 = n4 / 2;
            if (bl) {
                this.updateMGroups(n3, stringArray[n4], stringArray[n4 + 1]);
            } else {
                bl = this.updateMGroups(n3, stringArray[n4], stringArray[n4 + 1]);
            }
            n4 += 2;
        }
        if (n2 / 2 < this.numOfMGroups) {
            int n5 = this.numOfMGroups - 1;
            while (n5 >= n2 / 2) {
                this.doDebug("Deleting mGroup " + n5);
                this.mGroups[n5].delete();
                --n5;
            }
        }
        return bl;
    }

    private void videoResize() {
        this.doDebug("videoResize");
        MediaPlayer mediaPlayer = this.currentPlayer;
        if (mediaPlayer == null) {
            return;
        }
        Dimension dimension = this.getSize();
        int n2 = dimension.height;
        int n3 = dimension.width;
        int n4 = 10;
        this.buttonPanel.validate();
        Dimension dimension2 = this.buttonPanel.getSize();
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        mediaPlayer.setBounds(this.getBounds().x, this.getBounds().y, n3, n2 - n4);
        while (mediaPlayer.getState() != 500 && mediaPlayer.getState() != 600) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

