/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.CharData;
import oracle.xml.parser.v2.InfosetReader;
import oracle.xml.parser.v2.NodeReference;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLText
extends CharData
implements Text,
Serializable,
Externalizable,
CXMLConstants {
    static QxName CLASS_QNAME = QxNameHash.create("", "#text", "", "#text");
    static final int WHITESPACE_NODE = 65536;
    static final int CHAR_ARRAY_VALUE = 131072;
    private static final int TEXT_PARENT = 0;
    private static final int TEXT_VALUE = 1;
    private static final int TEXT_NEXTNODE = 2;
    private static final int TEXT_PREVNODE = 3;
    private static final int TEXT_OFFSET = 4;
    private static final int TEXT_DATASZ = 4;

    public XMLText() {
        this.setNodeFlag(131072);
    }

    public XMLText(String string) {
        this.setNodeValue(string);
    }

    protected XMLText(XMLDocument xMLDocument) {
        super(xMLDocument);
        this.setNodeFlag(131072);
    }

    XMLText(char[] cArray, int n, int n2) {
        this.addText(cArray, n, n2);
    }

    public short getNodeType() {
        return 3;
    }

    public QxName getQName() {
        return CLASS_QNAME;
    }

    public String getNodeName() {
        return "#text";
    }

    public boolean checkTypeNSName(int n, String string, String string2) {
        return n == 3;
    }

    public Text splitText(int n) throws DOMException {
        XMLText xMLText;
        this.checkReadOnly();
        String string = this.getNodeValue();
        try {
            this.setData(string.substring(0, n));
            XMLDocument xMLDocument = (XMLDocument)this.getOwnerDocument();
            xMLText = (XMLText)xMLDocument.createTextNode(string.substring(n, string.length()));
            Node node = this.getParentNode();
            if (node != null) {
                node.replaceChild(xMLText, this);
                xMLText.getParentNode().insertBefore(this, xMLText);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new XMLDOMException(1, 21001, this.getXMLError(), String.valueOf(n), String.valueOf(string.length()));
        }
        return xMLText;
    }

    private boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (XMLUtil.isWhiteSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitespace(char[] cArray) {
        if (cArray == null) {
            return false;
        }
        return this.isWhitespace(cArray, 0, cArray.length);
    }

    private boolean isWhitespace(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return false;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (XMLUtil.isWhiteSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    private boolean hasWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (!XMLUtil.isWhiteSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWhitespace(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return false;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (!XMLUtil.isWhiteSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    public boolean isElementContentWhitespace() {
        switch (this.flags & 3) {
            case 1: {
                boolean bl;
                if (this.getParentNode() == null) {
                    return false;
                }
                if (this.isNodeFlag(65536)) {
                    return true;
                }
                if (!this.isNodeFlag(131072)) {
                    String string = this.getNodeValue();
                    bl = this.hasWhitespace(string);
                } else {
                    char[] cArray = this.getTextChars();
                    bl = this.hasWhitespace(cArray, 0, cArray.length);
                }
                return bl;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    public String getWholeText() {
        switch (this.flags & 3) {
            case 1: {
                Node node = this;
                Node node2 = null;
                while ((node2 = this.getPreviousSibling()) != null && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    node = node2;
                }
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    stringBuffer.append(node.getNodeValue());
                } while ((node = node.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4));
                return stringBuffer.toString();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public Text replaceWholeText(String string) throws DOMException {
        if (string == null || string == "") {
            return null;
        }
        switch (this.flags & 3) {
            case 1: {
                Node node = null;
                Node node2 = this.getParentNode();
                while ((node = this.getPreviousSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                while ((node = this.getNextSibling()) != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
                    node2.removeChild(node);
                }
                this.xdkSetNodeValue(string);
                return this;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public boolean isWhiteSpaceNode() {
        boolean bl = false;
        switch (this.flags & 3) {
            case 1: {
                bl = this.isNodeFlag(65536);
                break;
            }
            case 2: {
                String string = this.getNodeValue();
                bl = this.isWhitespace(string);
            }
        }
        return bl;
    }

    public void addText(char[] cArray, int n, int n2) {
        switch (this.flags & 3) {
            case 1: {
                boolean bl;
                this.convertContentToCharArray();
                char[] cArray2 = this.getTextChars();
                if (this.isNodeFlag(65536) && !(bl = this.isWhitespace(cArray, n, n2))) {
                    this.resetNodeFlag(65536);
                }
                if (cArray2 != null) {
                    char[] cArray3 = cArray2;
                    cArray2 = new char[n2 + cArray2.length];
                    System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                    System.arraycopy(cArray, n, cArray2, cArray3.length, n2);
                } else {
                    cArray2 = new char[n2];
                    System.arraycopy(cArray, n, cArray2, 0, n2);
                }
                this.xdkSetTextArray(cArray2);
                return;
            }
            case 2: {
                this.appendData(new String(cArray, n, n2));
                return;
            }
        }
    }

    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    public void reportSAXEvents(ContentHandler contentHandler) throws SAXException {
        String string = this.getData();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    void reportSAXEvents(boolean bl, ContentHandler contentHandler) throws SAXException {
        String string = this.getData();
        this.getDOMLocator().setCurrentNode(this);
        contentHandler.characters(string.toCharArray(), 0, string.length());
    }

    public short isWhitespaceOnly() {
        switch (this.flags & 3) {
            case 1: {
                if (this.isWhiteSpaceNode()) {
                    return 5;
                }
                return 6;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canSetData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, string) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(string);
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canAppendData(String string) {
        switch (this.flags & 3) {
            case 1: {
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.getNodeValue());
                    stringBuffer.append(string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canReplaceData(int n, int n2, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canReplaceData(n, n2, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.replace(n, n + n2, string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canInsertData(int n, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canInsertData(n, string);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.insert(n, string);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string2 = xSDElement.getFixedVal();
                    if (string2 != null && xSDSimpleType.compareValues(string2, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public short canDeleteData(int n, int n2) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                super.canDeleteData(n, n2);
                XMLNSNode xMLNSNode = (XMLNSNode)this.getParentNode();
                if (xMLNSNode == null || xMLNSNode.getNodeType() != 1) {
                    return 7;
                }
                XSDElement xSDElement = ((XMLElement)xMLNSNode).getElementDeclaration();
                if (xSDElement == null || xSDElement.getType() instanceof XSDComplexType) {
                    return 5;
                }
                try {
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDElement.getType();
                    StringBuffer stringBuffer = new StringBuffer(this.xdkGetNodeValue());
                    stringBuffer.delete(n, n + n2);
                    XMLNode xMLNode = null;
                    for (xMLNode = (XMLNode)this.getPreviousSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getPreviousSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.insert(0, xMLNode.getNodeValue());
                    }
                    for (xMLNode = (XMLNode)this.getNextSibling(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                        if (xMLNode.getNodeType() != 3) continue;
                        stringBuffer.append(this.getNodeValue());
                    }
                    String string = xSDElement.getFixedVal();
                    if (string != null && xSDSimpleType.compareValues(string, stringBuffer.toString()) != 0) {
                        return 6;
                    }
                    xSDSimpleType.validateValue(stringBuffer.toString());
                }
                catch (Exception exception) {
                    return 6;
                }
                return 5;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return 7;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectOutput(objectOutput);
        this.writeExternal(cXMLStream, cXMLContext);
        cXMLStream.flush();
    }

    void writeExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException {
        cXMLStream.writeByte(23);
        cXMLStream.writeUTF(this.getNodeValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLContext cXMLContext = new CXMLContext();
        CXMLStream cXMLStream = new CXMLStream(cXMLContext);
        cXMLStream.setObjectInput(objectInput);
        this.readExternal(cXMLStream, cXMLContext);
    }

    public void readExternal(CXMLStream cXMLStream, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = cXMLStream.readByte();
        if (by != 23) {
            throw new IOException("Error in reading serialized stream corresponding to Text node.");
        }
        this.setNodeValue(cXMLStream.readUTF());
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        XMLNode xMLNode;
        char[] cArray = this.getTextChars();
        if (cArray == null) {
            return;
        }
        if (this.isNodeFlag(65536) && (xMLNode = (XMLNode)this.getParentNode()) != null && xMLNode.isNodeFlag(131072)) {
            return;
        }
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            String string = null;
            char c = cArray[i];
            if (c == '&') {
                string = "&amp;";
            } else if (c == '<') {
                string = "&lt;";
            } else if (i > 1 && c == '>') {
                string = bl || cArray[i - 1] == ']' && cArray[i - 2] == ']' ? "&gt;" : ">";
            }
            if (string == null) {
                xMLOutputStream.write(c);
                continue;
            }
            xMLOutputStream.writeChars(string);
        }
        xMLOutputStream.flush();
    }

    private char[] getTextChars() {
        char[] cArray = null;
        switch (this.flags & 3) {
            case 1: {
                cArray = this.xdkGetTextArray();
                break;
            }
            case 2: {
                String string = this.getNodeValue();
                if (this.isWhitespace(string)) {
                    this.setNodeFlag(65536);
                } else {
                    this.resetNodeFlag(65536);
                }
                if (string == null) break;
                cArray = string.toCharArray();
            }
        }
        return cArray;
    }

    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        return (XMLText)xMLDocument.createTextNode(this.xdkGetNodeValue());
    }

    XMLNode xdkGetParentNode() {
        int n = (int)this.nodeId + 0;
        return (XMLNode)this.data[n];
    }

    void xdkSetParentNode(XMLNode xMLNode) {
        int n = (int)this.nodeId + 0;
        this.data[n] = xMLNode;
    }

    String xdkGetNodeValue() {
        if (this.isNodeFlag(131072)) {
            this.convertContentToString();
        }
        int n = (int)this.nodeId + 1;
        return (String)this.data[n];
    }

    void xdkSetNodeValue(String string) {
        int n = (int)this.nodeId + 1;
        this.data[n] = string;
        if (this.isWhitespace(string)) {
            this.setNodeFlag(65536);
        } else {
            this.resetNodeFlag(65536);
        }
        this.resetNodeFlag(131072);
    }

    private synchronized char[] xdkGetTextArray() {
        char[] cArray = null;
        int n = (int)this.nodeId + 1;
        if (this.isNodeFlag(131072)) {
            cArray = (char[])this.data[n];
        } else {
            String string = (String)this.data[n];
            if (string != null) {
                cArray = string.toCharArray();
            }
        }
        return cArray;
    }

    private void xdkSetTextArray(char[] cArray) {
        this.setNodeFlag(131072);
        int n = (int)this.nodeId + 1;
        this.data[n] = cArray;
        if (this.isWhitespace(cArray)) {
            this.setNodeFlag(65536);
        } else {
            this.resetNodeFlag(65536);
        }
    }

    XMLNode xdkGetNextNode() {
        InfosetReader.Offset offset;
        NodeReference nodeReference;
        int n = (int)this.nodeId + 2;
        Object object = this.data[n];
        if (!this.isNodeFlag(2048)) {
            return (XMLNode)object;
        }
        if (object instanceof NodeReference) {
            nodeReference = (NodeReference)object;
            if ((object = nodeReference.get()) != null) {
                return (XMLNode)object;
            }
            offset = nodeReference.offset;
        } else if (object instanceof InfosetReader.Offset) {
            offset = (InfosetReader.Offset)object;
        } else {
            return null;
        }
        XMLNode xMLNode = this.getDocument().createNodeFromOffset(offset);
        nodeReference = new NodeReference(xMLNode, offset);
        this.xdkSetNextNode(nodeReference);
        XMLNode xMLNode2 = this.xdkGetParentNode();
        xMLNode.xdkSetParentNode(xMLNode2);
        xMLNode2.xdkSetLastChild(nodeReference);
        if (!this.getDocument().isNodeFlag(0x200000)) {
            xMLNode.xdkSetPrevNode(this);
        }
        return xMLNode;
    }

    void xdkSetNextNode(Object object) {
        int n = (int)this.nodeId + 2;
        this.data[n] = object;
    }

    XMLNode xdkGetPrevNode() {
        int n = (int)this.nodeId + 3;
        return (XMLNode)this.data[n];
    }

    void xdkSetPrevNode(XMLNode xMLNode) {
        int n = (int)this.nodeId + 3;
        this.data[n] = xMLNode;
    }

    int xdkGetNodeArraySize() {
        if (this.isNodeFlag(2048)) {
            return 5;
        }
        return 4;
    }

    InfosetReader.Offset getOffset() {
        int n = (int)this.nodeId + 4;
        return (InfosetReader.Offset)this.data[n];
    }

    void xdkSetOffset(InfosetReader.Offset offset) {
        int n = (int)this.nodeId + 4;
        this.data[n] = offset;
    }

    private synchronized void convertContentToString() {
        if (!this.isNodeFlag(131072)) {
            return;
        }
        int n = (int)this.nodeId + 1;
        char[] cArray = (char[])this.data[n];
        String string = cArray == null ? null : new String(cArray, 0, cArray.length);
        this.xdkSetNodeValue(string);
    }

    private void convertContentToCharArray() {
        if (this.isNodeFlag(131072)) {
            return;
        }
        this.setNodeFlag(131072);
        int n = (int)this.nodeId + 1;
        String string = (String)this.data[n];
        if (string == null) {
            return;
        }
        this.data[n] = string.toCharArray();
    }
}

