/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Constructor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import oracle.jbo.AttributeDef;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.StringManager;
import oracle.jbo.domain.Array;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.controls.JUArrayElementEditorInterface;
import oracle.jbo.uicli.jui.JUDefaultControlBinding;
import oracle.jbo.uicli.jui.JUDefaultControlInterface;
import oracle.jbo.uicli.jui.JUIUtil;

public class JUArrayComboBox
extends JComboBox
implements JUDefaultControlInterface,
FocusListener,
ActionListener {
    JUDefaultControlBinding mBinding;
    int mMaxCount;
    boolean mNullArray;
    FocusAdapter mFocusAdapter;
    Class mElemType;
    boolean modified;
    JUArrayElementEditorInterface mElemEditor;
    private static final String MSG_BUNDLE = "oracle.jbo.uicli.UIMessageBundle";

    private /* synthetic */ void $init$() {
        this.mMaxCount = -1;
        this.modified = false;
    }

    public JUArrayComboBox() {
        this.$init$();
        this.init();
    }

    void init() {
        this.getEditor().getEditorComponent().addFocusListener(this);
        this.setEditable(true);
    }

    public void setArrayElementEditor(JUArrayElementEditorInterface jUArrayElementEditorInterface) {
        this.mElemEditor = jUArrayElementEditorInterface;
    }

    public JUArrayElementEditorInterface getArrayElementEditor() {
        return this.mElemEditor;
    }

    public void setArrayBinding(JUDefaultControlBinding jUDefaultControlBinding) {
        this.mBinding = jUDefaultControlBinding;
    }

    public JUDefaultControlBinding getArrayBinding() {
        return this.mBinding;
    }

    public void dataChanged(Object object) {
        if (this.mMaxCount == -1 && this.mBinding != null) {
            AttributeDef attributeDef = this.mBinding.getAttributeDef(0);
            this.mMaxCount = attributeDef.getPrecision();
            this.mElemType = attributeDef.getElemType();
            if (this.mElemEditor != null) {
                this.getEditor().getEditorComponent().addKeyListener(new 1());
            }
        }
        this.removeAllItems();
        boolean bl = this.mNullArray = object == null;
        if (!this.mNullArray) {
            Array array = (Array)object;
            Object[] objectArray = array.getArray();
            int n = 0;
            while (n < objectArray.length) {
                this.addItem(objectArray[n]);
                ++n;
            }
        }
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        this.mFocusAdapter = focusAdapter;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && this.mFocusAdapter != null) {
            this.mFocusAdapter.focusGained(focusEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getSelectedIndex();
        String string = this.getEditor().getItem().toString();
        if (string.trim().length() == 0) {
            if (n >= 0) {
                this.modified = true;
                this.removeItemAt(n);
            }
        } else if (this.mElemEditor == null) {
            if (n >= 0) {
                if (!string.equals(this.getItemAt(n).toString())) {
                    try {
                        this.insertItemAt(TypeFactory.getInstance(this.mElemType, (Object)string), n);
                        this.modified = true;
                        this.removeItemAt(n + 1);
                        this.setSelectedIndex(n);
                    }
                    catch (Exception exception) {
                        this.mBinding.reportException(exception);
                        this.getEditor().setItem(this.getItemAt(n));
                        this.setSelectedIndex(n);
                    }
                }
            } else {
                try {
                    this.addItem(TypeFactory.getInstance(this.mElemType, (Object)string));
                    this.modified = true;
                    this.setSelectedIndex(this.getItemCount() - 1);
                }
                catch (Exception exception) {
                    this.mBinding.reportException(exception);
                    n = this.getItemCount() - 1;
                    this.getEditor().setItem(this.getItemAt(n));
                    this.setSelectedIndex(n);
                }
            }
        }
        if (this.modified) {
            this.updateArray();
        }
        super.actionPerformed(actionEvent);
    }

    void updateArray() {
        if (this.modified) {
            this.modified = false;
            int n = this.getItemCount();
            if (n > 0) {
                Object[] objectArray = new Object[n];
                ComboBoxModel comboBoxModel = this.getModel();
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = comboBoxModel.getElementAt(n2);
                    ++n2;
                }
                this.mBinding.setAttribute(0, (Object)new Array(objectArray));
            } else {
                this.mBinding.setAttribute(0, null);
            }
        }
    }

    public static ComboBoxModel createAttributeBinding(JUFormBinding jUFormBinding, JUArrayComboBox jUArrayComboBox, String string, String string2, String string3, String string4, JUArrayElementEditorInterface jUArrayElementEditorInterface) {
        if (!JUIUtil.inDesignTime()) {
            jUArrayComboBox.setArrayElementEditor(jUArrayElementEditorInterface);
            JUDefaultControlBinding jUDefaultControlBinding = new JUDefaultControlBinding((JUDefaultControlInterface)jUArrayComboBox, jUFormBinding.getRowIterBinding(string, string2, string3), string4);
            jUArrayComboBox.setArrayBinding(jUDefaultControlBinding);
            jUDefaultControlBinding.refreshControl();
            return jUArrayComboBox.getModel();
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJUArrayComboBoxBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 1) {
                    Object[] objectArray = new Object[]{string + "." + string4};
                    Object obj = constructor.newInstance(objectArray);
                    ComboBoxModel comboBoxModel = (ComboBoxModel)obj;
                    return comboBoxModel;
                }
                ++n;
            }
            ComboBoxModel comboBoxModel = null;
            return comboBoxModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ComboBoxModel comboBoxModel = null;
            return comboBoxModel;
        }
    }

    public final class 1
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = JUArrayComboBox.this.mElemEditor.hasCustomEditKey() ? JUArrayComboBox.this.mElemEditor.isEditKey(keyEvent) : (bl = keyEvent.getKeyCode() == 10 && keyEvent.isControlDown());
            if (bl) {
                Object object;
                int n = JUArrayComboBox.this.getSelectedIndex();
                Object object2 = JUArrayComboBox.this.getSelectedItem();
                if (object2 instanceof String) {
                    String string = (String)object2;
                    object2 = null;
                    if (string.trim().length() != 0 && Diagnostic.isOn()) {
                        Diagnostic.println(StringManager.getString(JUArrayComboBox.MSG_BUNDLE, "02674", "Found String instead of Struct", null));
                    }
                }
                if ((object = JUArrayComboBox.this.mElemEditor.edit(object2, (JUControlBinding)JUArrayComboBox.this.mBinding, keyEvent.getComponent())) == null) {
                    if (n >= 0) {
                        JUArrayComboBox.this.modified = true;
                        JUArrayComboBox.this.removeItemAt(n);
                    }
                } else if (n >= 0) {
                    if (object != object2) {
                        try {
                            JUArrayComboBox.this.insertItemAt(TypeFactory.getInstance(JUArrayComboBox.this.mElemType, object), n);
                            JUArrayComboBox.this.modified = true;
                            JUArrayComboBox.this.removeItemAt(n + 1);
                            JUArrayComboBox.this.grabFocus();
                            JUArrayComboBox.this.setSelectedIndex(n);
                        }
                        catch (Exception exception) {
                            JUArrayComboBox.this.mBinding.reportException(exception);
                            JUArrayComboBox.this.getEditor().setItem(JUArrayComboBox.this.getItemAt(n));
                            JUArrayComboBox.this.setSelectedIndex(n);
                        }
                    }
                } else {
                    JUArrayComboBox.this.modified = true;
                    try {
                        JUArrayComboBox.this.addItem(TypeFactory.getInstance(JUArrayComboBox.this.mElemType, object));
                        JUArrayComboBox.this.grabFocus();
                        JUArrayComboBox.this.setSelectedIndex(JUArrayComboBox.this.getItemCount() - 1);
                    }
                    catch (Exception exception) {
                        JUArrayComboBox.this.mBinding.reportException(exception);
                        n = JUArrayComboBox.this.getItemCount() - 1;
                        JUArrayComboBox.this.getEditor().setItem(JUArrayComboBox.this.getItemAt(n));
                        JUArrayComboBox.this.setSelectedIndex(n);
                    }
                }
                if (JUArrayComboBox.this.modified) {
                    JUArrayComboBox.this.updateArray();
                }
            }
        }
    }
}

