/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import oracle.adf.model.AttributesBinding;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.generic.RowImpl;
import oracle.binding.UpdateListener;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public class JUCtrlValueBindingRef
extends JboAbstractMap
implements AttributesBinding {
    public static final String RANGESET_INDEX = "index";
    public static final String RANGESET_ROW_KEY = "rowKey";
    public static final String RANGESET_ROW_KEY_STR = "rowKeyStr";
    public static final String RANGESET_ROW_KEY_VALUE = "keyValue";
    public static final String RANGESET_CURRENCY_STRING = "currencyString";
    public static final String RANGESET_LABEL_SET = "labelSet";
    public static final String RANGESET_ROW = "row";
    public static final String RANGESET_ROW_DATA_PROVIDER = "dataProvider";
    public static final String RANGESET_BASE_BINDING = "binding";
    public final String STR_NOT_CURRENT_ROW;
    public final String STR_CURRENT_ROW;
    JUCtrlValueBinding mBinding;
    int mIndex;
    Key mRowKey;
    WeakReference mRowRef;

    private /* synthetic */ void $init$() {
        this.STR_NOT_CURRENT_ROW = " ";
        this.STR_CURRENT_ROW = "*";
        this.mIndex = -1;
    }

    protected JUCtrlValueBindingRef(JUCtrlValueBinding jUCtrlValueBinding, int n, Row row) {
        this.$init$();
        this.mBinding = jUCtrlValueBinding;
        this.mIndex = n;
        if (row != null) {
            this.mRowKey = row.getKey();
        }
        this.mRowRef = new WeakReference<Row>(row);
    }

    public String getName() {
        return this.mBinding.getName() + new Integer(this.mIndex).toString();
    }

    public JUCtrlValueBinding getBinding() {
        return this.mBinding;
    }

    public Row getRow() {
        return (Row)this.mRowRef.get();
    }

    public String getCurrencyString() {
        Row row = this.mBinding.getCurrentRow();
        if (row != null && this.mRowKey != null) {
            return this.mRowKey.equals(row.getKey()) ? "*" : " ";
        }
        return " ";
    }

    public void makeCurrentRow() {
        Row row = this.getRow();
        this.mBinding.getDCIteratorBinding().setCurrentRowWithKey(row.getKey().toStringFormat(true));
    }

    public Object get(Object object) {
        if (object instanceof String) {
            Object object2;
            Row row;
            String string = ((String)object).intern();
            if (string == RANGESET_INDEX) {
                return new Integer(this.mIndex);
            }
            if (string == RANGESET_CURRENCY_STRING) {
                return this.getCurrencyString();
            }
            if (string == RANGESET_ROW_DATA_PROVIDER && (row = this.getRow()) instanceof RowImpl) {
                return ((RowImpl)row).getDataProvider();
            }
            if (string == RANGESET_ROW_KEY) {
                return this.mRowKey;
            }
            if (string == RANGESET_ROW_KEY_STR) {
                return this.mRowKey != null ? this.mRowKey.toStringFormat(true) : null;
            }
            if (string == RANGESET_ROW_KEY_VALUE) {
                return this.mRowKey != null && this.mRowKey.getAttributeCount() == 1 ? this.mRowKey.getAttribute(0) : null;
            }
            if (string == "attributeValues") {
                return this.getAttributeValues();
            }
            if (string == RANGESET_ROW) {
                return this.getRow();
            }
            if (string == RANGESET_BASE_BINDING) {
                return this.getBinding();
            }
            if (string == "error") {
                return this.getError();
            }
            if (string == "errors") {
                return this.getErrors();
            }
            Row row2 = this.resolveRow();
            AttributeDef attributeDef = this.mBinding.lookupAttributeDef(string);
            if (attributeDef != null && row2 != null && (object2 = this.mBinding.getInputValueInRow(this.mBinding, row2, attributeDef)) != null) {
                return this.resolveAttributeValue(string, object2);
            }
        }
        return null;
    }

    protected Object[] getAttributeValues() {
        Row row = this.resolveRow();
        AttributeDef[] attributeDefArray = this.mBinding.getAttributeDefs();
        Object[] objectArray = new Object[attributeDefArray.length];
        if (row != null) {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.mBinding.getAttributeFromRow(row, attributeDefArray[n]);
                ++n;
            }
        }
        return objectArray;
    }

    protected Object resolveAttributeValue(String string, Object object) {
        return object;
    }

    Row resolveRow() {
        Key key;
        Row row = (Row)this.mRowRef.get();
        if (row == null && (row = this.getIteratorBinding().getNavigatableRowIterator().getRowAtRangeIndex(this.mIndex)) != null && ((key = row.getKey()) == this.mRowKey || key != null && !row.getKey().equals(this.mRowKey))) {
            Row[] rowArray = this.mBinding.getRowIterator().findByKey(this.mRowKey, 1);
            if (rowArray.length == 0 || rowArray[0] == null) {
                throw new RowNotFoundException(false, this.getIteratorBinding().getDisplayName(), this.mRowKey);
            }
            row = rowArray[0];
        }
        return row;
    }

    protected final DCControlBinding getReferencedBinding() {
        return this.mBinding;
    }

    final JUIteratorBinding getIteratorBinding() {
        return this.mBinding.getIteratorBinding();
    }

    public Object put(Object object, Object object2) {
        String string;
        int n;
        if (object instanceof String && (n = this.mBinding.getAttributeIndexOf(string = (String)object)) > -1) {
            this.setInputValue(n, object2);
            return null;
        }
        return super.put(object, object2);
    }

    public String[] getLabelSet() {
        return this.mBinding.getLabelSet();
    }

    public Object getInputValue(int n) {
        return this.mBinding.getInputValueInRow(this.mBinding, this.resolveRow(), this.mBinding.getAttributeDef(n));
    }

    public void setInputValue(int n, Object object) {
        this.mBinding.getIteratorBinding().prepareForInput();
        this.mBinding.setInputValueInRow(this.mBinding, this.resolveRow(), this.mBinding.getAttributeDef(n), object, true);
    }

    public void setListener(oracle.adf.model.UpdateListener updateListener) {
        this.mBinding.setListener(updateListener);
    }

    public void setListener(UpdateListener updateListener) {
        this.mBinding.setListener(updateListener);
    }

    protected JboException getError() {
        List list = this.mBinding.getInputErrorsForRowKey(this.mRowKey);
        return list == null || list.size() == 0 ? null : (JboException)list.get(0);
    }

    public List getErrors() {
        return this.mBinding.getInputErrorsForRowKey(this.mRowKey);
    }

    public void release(int n) {
    }

    public boolean isUpdateable(int n) {
        return this.mBinding.isAttributeUpdateable(this.resolveRow(), n);
    }

    public String getPath() {
        return null;
    }

    public boolean resolvePath(Map map) {
        return false;
    }
}

