/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jbo.VariantException;
import oracle.jbo.common.Diagnostic;

public class Variant {
    private static final long serialVersionUID = 200L;
    public static final int UNASSIGNED_NULL = 0;
    public static final int ASSIGNED_NULL = 1;
    public static final int NULL_TYPES = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGDECIMAL = 10;
    public static final int BOOLEAN = 11;
    public static final int BINARY_STREAM = 12;
    public static final int INPUTSTREAM = 12;
    public static final int DATE = 13;
    public static final int TIME = 14;
    public static final int TIMESTAMP = 15;
    public static final int STRING = 16;
    public static final int OBJECT = 17;
    public static final int BYTE_ARRAY = 18;
    public static final String AssignedNull_S = "ASSIGNED_NULL";
    public static final String UnassignedNull_S = "UNASSIGNED_NULL";
    public static final String ByteType_S = "BYTE";
    public static final String ShortType_S = "SHORT";
    public static final String IntType_S = "INT";
    public static final String LongType_S = "LONG";
    public static final String FloatType_S = "FLOAT";
    public static final String DoubleType_S = "DOUBLE";
    public static final String BigDecimalType_S = "BIGDECIMAL";
    public static final String BooleanType_S = "BOOLEAN";
    public static final String InputStreamType_S = "INPUTSTREAM";
    public static final String BinaryStreamType_S = "BINARY_STREAM";
    public static final String DateType_S = "DATE";
    public static final String TimeType_S = "TIME";
    public static final String TimestampType_S = "TIMESTAMP";
    public static final String ByteArrayType_S = "BYTE_ARRAY";
    public static final String StringType_S = "STRING";
    public static final String ObjectType_S = "OBJECT";
    public static final String UnknownType_S = "UNKNOWN";
    public static final Variant nullVariant = new Variant(0);
    public static final int MaxTypes = 18;
    private int setType;
    private int type;
    private boolean booleanVal;
    private int intVal;
    private long longVal;
    private float floatVal;
    private double doubleVal;
    private String stringVal;
    private byte[] byteArrayVal;
    private BigDecimal bigDecimalVal;
    private Date dateVal;
    private Time timeVal;
    private Timestamp timestampVal;
    private transient Object objectVal;
    private static String zeroString;
    private static char[] zeroCharArray;
    private static BigDecimal zeroBIGDECIMAL;
    private static ByteArrayInputStream zeroBinary;
    private static byte[] zeroByteArray;
    private static boolean offsetsKnown;
    private static long timeZoneOffset;

    public Variant(int n) {
        this.setType = n;
    }

    public Variant() {
    }

    public static String typeName(int n) {
        switch (n) {
            case 1: {
                return AssignedNull_S;
            }
            case 0: {
                return UnassignedNull_S;
            }
            case 2: {
                return ByteType_S;
            }
            case 3: {
                return ShortType_S;
            }
            case 4: {
                return IntType_S;
            }
            case 5: {
                return LongType_S;
            }
            case 6: {
                return FloatType_S;
            }
            case 7: {
                return DoubleType_S;
            }
            case 10: {
                return BigDecimalType_S;
            }
            case 11: {
                return BooleanType_S;
            }
            case 12: {
                return InputStreamType_S;
            }
            case 13: {
                return DateType_S;
            }
            case 14: {
                return TimeType_S;
            }
            case 15: {
                return TimestampType_S;
            }
            case 16: {
                return StringType_S;
            }
            case 18: {
                return ByteArrayType_S;
            }
            case 17: {
                return ObjectType_S;
            }
        }
        return UnknownType_S;
    }

    public static int typeOf(String string) {
        if (string.equals(StringType_S)) {
            return 16;
        }
        if (string.equals(DateType_S)) {
            return 13;
        }
        if (string.equals(TimeType_S)) {
            return 14;
        }
        if (string.equals(TimestampType_S)) {
            return 15;
        }
        if (string.equals(IntType_S)) {
            return 4;
        }
        if (string.equals(BigDecimalType_S)) {
            return 10;
        }
        if (string.equals(AssignedNull_S)) {
            return 1;
        }
        if (string.equals(UnassignedNull_S)) {
            return 0;
        }
        if (string.equals(ByteType_S)) {
            return 2;
        }
        if (string.equals(ShortType_S)) {
            return 3;
        }
        if (string.equals(LongType_S)) {
            return 5;
        }
        if (string.equals(DoubleType_S)) {
            return 7;
        }
        if (string.equals(FloatType_S)) {
            return 6;
        }
        if (string.equals(BooleanType_S)) {
            return 11;
        }
        if (string.equals(BinaryStreamType_S)) {
            return 12;
        }
        if (string.equals(InputStreamType_S)) {
            return 12;
        }
        if (string.equals(ByteArrayType_S)) {
            return 18;
        }
        if (string.equals(ObjectType_S)) {
            return 17;
        }
        throw new VariantException("55003", new String[]{string});
    }

    public static int typeId(String string) {
        int n = 2;
        while (n <= 18) {
            if (string.equals(Variant.typeName(n))) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static long getTimeZoneOffset() {
        if (!offsetsKnown) {
            Date date = new Date(0L);
            timeZoneOffset = date.getTime();
            offsetsKnown = true;
        }
        return timeZoneOffset;
    }

    public final Object getDisplayValue() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 12: 
            case 17: {
                return this.objectVal;
            }
        }
        return this.toString();
    }

    private boolean setZeroValue(int n, int n2) {
        if (zeroString == null) {
            zeroString = "";
            zeroCharArray = new char[0];
            zeroBIGDECIMAL = new BigDecimal(0.0);
            zeroByteArray = new byte[0];
            zeroBinary = new ByteArrayInputStream(zeroByteArray);
        }
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                this.intVal = 0;
                break;
            }
            case 15: {
                this.setTimestamp(0L, 0);
                break;
            }
            case 14: {
                this.setTime(0L);
                break;
            }
            case 13: {
                this.setDate(0L);
                break;
            }
            case 5: {
                this.longVal = 0L;
                break;
            }
            case 11: {
                this.booleanVal = false;
                break;
            }
            case 6: {
                this.floatVal = 0.0f;
                break;
            }
            case 7: {
                this.doubleVal = 0.0;
                break;
            }
            case 16: {
                this.stringVal = zeroString;
                break;
            }
            case 10: {
                this.bigDecimalVal = zeroBIGDECIMAL;
                this.booleanVal = false;
                break;
            }
            case 12: 
            case 17: {
                this.objectVal = zeroBinary;
                break;
            }
            case 18: {
                this.byteArrayVal = zeroByteArray;
                break;
            }
            default: {
                return false;
            }
        }
        Diagnostic.ASSERT(n <= 1);
        this.type = n;
        return true;
    }

    private void typeProblem(int n, int n2) {
        if (n <= 1 && this.setZeroValue(n, n2)) {
            return;
        }
        throw new VariantException("55001", new String[]{Variant.typeName(n), Variant.typeName(n2)});
    }

    public final int getInt() {
        if (this.type != 4) {
            this.typeProblem(this.type, 4);
        }
        return this.intVal;
    }

    public final short getShort() {
        if (this.type != 3) {
            this.typeProblem(this.type, 3);
        }
        return (short)this.intVal;
    }

    public final byte getByte() {
        if (this.type != 2) {
            this.typeProblem(this.type, 2);
        }
        return (byte)this.intVal;
    }

    public final long getLong() {
        if (this.type != 5) {
            this.typeProblem(this.type, 5);
        }
        return this.longVal;
    }

    public final boolean getBoolean() {
        if (this.type != 11) {
            this.typeProblem(this.type, 11);
        }
        return this.booleanVal;
    }

    public final double getDouble() {
        if (this.type != 7) {
            this.typeProblem(this.type, 7);
        }
        return this.doubleVal;
    }

    public final float getFloat() {
        if (this.type != 6) {
            this.typeProblem(this.type, 6);
        }
        return this.floatVal;
    }

    public final String getString() {
        if (this.type != 16) {
            this.typeProblem(this.type, 16);
        }
        return this.stringVal;
    }

    public final BigDecimal getBigDecimal() {
        if (this.type != 10) {
            this.typeProblem(this.type, 10);
        }
        if (this.booleanVal) {
            this.bigDecimalVal = new BigDecimal(this.stringVal);
            this.booleanVal = false;
        }
        return this.bigDecimalVal;
    }

    public final Date getDate() {
        if (this.type != 13) {
            this.typeProblem(this.type, 13);
        }
        return this.dateVal;
    }

    public final Time getTime() {
        if (this.type != 14) {
            this.typeProblem(this.type, 14);
        }
        return this.timeVal;
    }

    public final Timestamp getTimestamp() {
        if (this.type != 15) {
            this.typeProblem(this.type, 15);
        }
        return this.timestampVal;
    }

    public final byte[] getByteArray() {
        if (this.type != 18) {
            this.typeProblem(this.type, 18);
        }
        return this.byteArrayVal;
    }

    public final int getArrayLength() {
        return this.intVal;
    }

    public final InputStream getBinaryStream() {
        return this.getInputStream();
    }

    public final InputStream getInputStream() {
        if (this.type != 12) {
            this.typeProblem(this.type, 12);
        }
        return (InputStream)this.objectVal;
    }

    public final void setInt(int n) {
        Diagnostic.ASSERT(this != nullVariant);
        if (this.setType != 0 && this.setType != 4) {
            this.typeProblem(this.setType, 4);
        }
        this.type = 4;
        this.intVal = n;
    }

    public final void setShort(short s) {
        if (this.setType != 0 && this.setType != 3) {
            this.typeProblem(this.setType, 3);
        }
        this.type = 3;
        this.intVal = s;
    }

    public final void setByte(byte by) {
        if (this.setType != 0 && this.setType != 2) {
            this.typeProblem(this.setType, 2);
        }
        this.type = 2;
        this.intVal = by;
    }

    public final void setLong(long l) {
        if (this.setType != 0 && (this.setType < 2 || this.setType > 5)) {
            this.typeProblem(this.setType, 5);
        }
        this.type = 5;
        this.longVal = l;
    }

    public final void setBoolean(boolean bl) {
        if (this.setType != 0 && this.setType != 11) {
            this.typeProblem(this.setType, 11);
        }
        this.type = 11;
        this.booleanVal = bl;
    }

    public final void setDouble(double d) {
        if (this.setType != 0 && this.setType != 7) {
            this.typeProblem(this.setType, 7);
        }
        this.type = 7;
        this.doubleVal = d;
    }

    public final void setFloat(float f) {
        if (this.setType != 0 && this.setType != 6) {
            this.typeProblem(this.setType, 6);
        }
        this.type = 6;
        this.floatVal = f;
    }

    public final void setString(String string) {
        if (this.setType != 16 && this.setType != 0) {
            this.typeProblem(this.setType, 16);
        }
        this.type = string == null ? 1 : 16;
        this.stringVal = string;
    }

    public final void setBigDecimal(BigDecimal bigDecimal) {
        if (this.setType != 10 && this.setType != 0) {
            this.typeProblem(this.setType, 10);
        }
        this.type = bigDecimal == null ? 1 : 10;
        this.bigDecimalVal = bigDecimal;
        this.booleanVal = false;
    }

    public final void setDate(Date date) {
        if (this.setType != 13 && this.setType != 0) {
            this.typeProblem(this.setType, 13);
        }
        if (date == null) {
            this.type = 1;
            this.dateVal = null;
        } else {
            this.type = 13;
            if (this.dateVal == null) {
                this.dateVal = new Date(date.getTime());
            } else {
                this.dateVal.setTime(date.getTime());
            }
        }
    }

    public final void setTime(Time time) {
        if (this.setType != 14 && this.setType != 0) {
            this.typeProblem(this.setType, 14);
        }
        if (time == null) {
            this.type = 1;
            this.timeVal = null;
        } else {
            this.type = 14;
            if (this.timeVal == null) {
                this.timeVal = new Time(time.getTime());
            } else {
                this.timeVal.setTime(time.getTime());
            }
        }
    }

    public final void setTimestamp(Timestamp timestamp) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        if (timestamp == null) {
            this.type = 1;
            this.timestampVal = null;
        } else {
            this.type = 15;
            if (this.timestampVal == null) {
                this.timestampVal = new Timestamp(timestamp.getTime());
            } else {
                this.timestampVal.setTime(timestamp.getTime());
            }
            this.timestampVal.setNanos(timestamp.getNanos());
        }
    }

    public final void setDate(long l) {
        if (this.setType != 13 && this.setType != 0) {
            this.typeProblem(this.setType, 13);
        }
        this.type = 13;
        if (this.dateVal == null) {
            this.dateVal = new Date(System.currentTimeMillis());
        }
        this.dateVal.setTime(l);
    }

    public final void setTime(long l) {
        if (this.setType != 14 && this.setType != 0) {
            this.typeProblem(this.setType, 14);
        }
        this.type = 14;
        if (this.timeVal == null) {
            this.timeVal = new Time(System.currentTimeMillis());
        }
        this.timeVal.setTime(l);
    }

    public final void setTimestamp(long l, int n) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        this.timestampVal.setTime(l);
        this.timestampVal.setNanos(n);
    }

    public final void setTimestamp(long l) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        this.timestampVal.setTime(l / 1000L * 1000L);
        int n = (int)(l % 1000L * 1000000L);
        if (n < 0) {
            n = 1000000000 + n;
            this.timestampVal.setTime((l / 1000L - 1L) * 1000L);
        }
        this.timestampVal.setNanos(n);
    }

    public final void setByteArray(byte[] byArray, int n) {
        if (this.setType != 18 && this.setType != 0) {
            this.typeProblem(this.setType, 18);
        }
        this.type = byArray == null ? 1 : 18;
        this.byteArrayVal = byArray;
        this.intVal = n;
    }

    public final void setArrayLength(int n) {
        this.intVal = n;
    }

    public final void setBinaryStream(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public final void setInputStream(InputStream inputStream) {
        if (this.setType != 12 && this.setType != 0) {
            this.typeProblem(this.setType, 12);
        }
        this.type = inputStream == null ? 1 : 12;
        this.objectVal = inputStream;
    }

    public final void setVariant(Variant variant) {
        switch (variant.type) {
            case 16: {
                this.setString(variant.stringVal);
                break;
            }
            case 2: {
                this.setByte((byte)variant.intVal);
                break;
            }
            case 3: {
                this.setShort((short)variant.intVal);
                break;
            }
            case 4: {
                this.setInt(variant.intVal);
                break;
            }
            case 11: {
                this.setBoolean(variant.booleanVal);
                break;
            }
            case 15: {
                this.setTimestamp(variant.getTimestamp());
                break;
            }
            case 13: {
                this.setDate(variant.getDate());
                break;
            }
            case 14: {
                this.setTime(variant.getTime());
                break;
            }
            case 5: {
                this.setLong(variant.longVal);
                break;
            }
            case 6: {
                this.setFloat(variant.floatVal);
                break;
            }
            case 7: {
                this.setDouble(variant.doubleVal);
                break;
            }
            case 10: {
                this.setBigDecimal(variant.bigDecimalVal);
                break;
            }
            case 12: {
                this.setInputStream((InputStream)variant.objectVal);
                break;
            }
            case 18: {
                this.setByteArray(variant.byteArrayVal, variant.intVal);
                break;
            }
            case 17: {
                this.setObject(variant.objectVal);
                break;
            }
            case 0: 
            case 1: {
                if (this.setType != variant.type && this.setType != 0) {
                    this.typeProblem(variant.type, this.setType);
                }
                this.type = variant.type;
                break;
            }
            default: {
                this.invalidVariantType(variant.type);
            }
        }
    }

    public final void setAsVariant(Variant variant) {
        switch (this.setType) {
            case 16: {
                this.setString(variant.stringVal);
                break;
            }
            case 2: {
                this.setByte((byte)variant.getAsInt());
                break;
            }
            case 3: {
                this.setShort((short)variant.getAsInt());
                break;
            }
            case 4: {
                this.setInt(variant.getAsInt());
                break;
            }
            case 11: {
                this.setBoolean(variant.getAsBoolean());
                break;
            }
            case 15: {
                this.setAsTimestamp(variant);
                break;
            }
            case 13: {
                this.setAsDate(variant);
                break;
            }
            case 14: {
                this.setAsTime(variant);
                break;
            }
            case 5: {
                this.setLong(variant.getAsLong());
                break;
            }
            case 6: {
                this.setFloat(variant.getAsFloat());
                break;
            }
            case 7: {
                this.setDouble(variant.getAsDouble());
                break;
            }
            case 10: {
                this.setBigDecimal(variant.getAsBigDecimal());
                break;
            }
            case 0: {
                this.setUnassignedNull();
                break;
            }
            case 1: {
                this.setAssignedNull();
                break;
            }
            default: {
                if (this.setType == 0 || this.setType == variant.type) {
                    this.setVariant(variant);
                    break;
                }
                this.invalidVariantType(variant.type);
            }
        }
    }

    private final void invalidVariantType(int n) {
        throw new VariantException("55002", new String[]{Variant.typeName(n)});
    }

    public final void setObject(Object object) {
        if (this.setType != 17 && this.setType != 0) {
            this.typeProblem(this.setType, 17);
        }
        this.type = 17;
        this.objectVal = object;
    }

    public final Object getObject() {
        if (this.type != 17) {
            this.typeProblem(this.type, 17);
        }
        return this.objectVal;
    }

    public final short getAsShort() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return (short)this.intVal;
            }
            case 11: {
                return (short)(this.booleanVal ? 1 : 0);
            }
            case 13: 
            case 14: 
            case 15: {
                return (short)this.getAsLong();
            }
            case 5: {
                return (short)this.longVal;
            }
            case 6: {
                return (short)this.floatVal;
            }
            case 7: {
                return (short)this.doubleVal;
            }
            case 10: {
                return (short)this.getBigDecimal().intValue();
            }
            case 0: 
            case 1: {
                return 0;
            }
        }
        this.typeProblem(this.type, 3);
        return 0;
    }

    public final int getAsInt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 11: {
                return this.booleanVal ? 1 : 0;
            }
            case 13: 
            case 14: 
            case 15: {
                return (int)this.getAsLong();
            }
            case 5: {
                return (int)this.longVal;
            }
            case 6: {
                return (int)this.floatVal;
            }
            case 7: {
                return (int)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().intValue();
            }
            case 0: 
            case 1: {
                return 0;
            }
        }
        this.typeProblem(this.type, 4);
        return 0;
    }

    public final long getAsLong() {
        switch (this.type) {
            case 11: {
                return this.booleanVal ? 1 : 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return (long)this.floatVal;
            }
            case 7: {
                return (long)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().longValue();
            }
            case 15: {
                return this.timestampVal.getTime();
            }
            case 14: {
                return this.timeVal.getTime();
            }
            case 13: {
                return this.dateVal.getTime();
            }
            case 0: 
            case 1: {
                return 0L;
            }
        }
        this.typeProblem(this.type, 5);
        return 0L;
    }

    public final double getAsDouble() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return this.floatVal;
            }
            case 7: {
                return this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().doubleValue();
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong();
            }
            case 0: 
            case 1: {
                return 0.0;
            }
        }
        this.typeProblem(this.type, 7);
        return 0.0;
    }

    public final float getAsFloat() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: {
                return this.floatVal;
            }
            case 7: {
                return (float)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().floatValue();
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong();
            }
            case 0: 
            case 1: {
                return 0.0f;
            }
        }
        this.typeProblem(this.type, 6);
        return 0.0f;
    }

    public final BigDecimal getAsBigDecimal() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return new BigDecimal((double)this.intVal);
            }
            case 5: {
                return new BigDecimal((double)this.longVal);
            }
            case 6: {
                return new BigDecimal(this.floatVal);
            }
            case 7: {
                return new BigDecimal(this.doubleVal);
            }
            case 10: {
                return this.getBigDecimal();
            }
            case 13: 
            case 14: 
            case 15: {
                return new BigDecimal((double)this.getAsLong());
            }
            case 0: 
            case 1: {
                return new BigDecimal(0.0);
            }
        }
        this.typeProblem(this.type, 10);
        return null;
    }

    public final boolean getAsBoolean() {
        switch (this.type) {
            case 11: {
                return this.booleanVal;
            }
            case 16: {
                return Boolean.valueOf(this.stringVal);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal != 0;
            }
            case 5: {
                return this.longVal != 0L;
            }
            case 6: {
                return this.floatVal != 0.0f;
            }
            case 7: {
                return this.doubleVal != 0.0;
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getAsLong() != 0L;
            }
        }
        return false;
    }

    public final void setAsTime(Variant variant) {
        switch (variant.type) {
            case 14: {
                this.setTime(variant.getTime());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                this.setTime(variant.getAsLong());
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.typeProblem(this.type, 14);
    }

    public final void setAsTimestamp(Variant variant) {
        switch (variant.type) {
            case 15: {
                this.setTimestamp(variant.getTimestamp());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                this.setTimestamp(variant.getAsLong(), 0);
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.typeProblem(this.type, 15);
    }

    public final void setAsDate(Variant variant) {
        switch (variant.type) {
            case 13: {
                this.setDate(variant.getDate());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                this.setDate(variant.getAsLong());
                return;
            }
            case 0: {
                this.setUnassignedNull();
                return;
            }
            case 1: {
                this.setAssignedNull();
                return;
            }
        }
        this.typeProblem(this.type, 13);
    }

    public final void setNull(int n) {
        if (n == 0) {
            this.type = 0;
        } else {
            Diagnostic.ASSERT(n == 1);
            this.type = 1;
        }
    }

    public final void setAssignedNull() {
        this.type = 1;
    }

    public final void setUnassignedNull() {
        this.type = 0;
    }

    public final boolean isAssignedNull() {
        return this.type == 1;
    }

    public final boolean isUnassignedNull() {
        return this.type == 0;
    }

    public final boolean isNull() {
        return this.type <= 1;
    }

    public final int getType() {
        return this.type;
    }

    public final int getSetType() {
        return this.setType;
    }

    public final String toString() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: 
            case 3: 
            case 4: {
                return Integer.toString(this.intVal, 10);
            }
            case 6: {
                return Float.toString(this.floatVal);
            }
            case 7: {
                return Double.toString(this.doubleVal);
            }
            case 5: {
                return Long.toString(this.longVal, 10);
            }
            case 10: {
                if (this.booleanVal) {
                    return this.stringVal;
                }
                if (this.bigDecimalVal == null) {
                    return "";
                }
                return this.bigDecimalVal.toString();
            }
            case 11: {
                return this.booleanVal ? "true" : "false";
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return this.dateVal.toString();
            }
            case 14: {
                return this.timeVal.toString();
            }
            case 15: {
                return this.timestampVal.toString();
            }
            case 18: {
                if (this.byteArrayVal == null) {
                    return "";
                }
                return new String(this.byteArrayVal, 0, this.intVal);
            }
            case 12: 
            case 17: {
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
        }
        Diagnostic.ASSERT(false);
        return "";
    }

    public boolean equalsInstance(Variant variant) {
        switch (this.type) {
            case 12: 
            case 17: {
                return this.type == variant.type && this.objectVal == variant.objectVal;
            }
        }
        return this.equals(variant);
    }

    public final boolean equals(Variant variant) {
        if (this.type != variant.type) {
            if (this.type <= 1 || variant.type <= 1) {
                return false;
            }
            this.typeProblem(variant.type, this.type);
        }
        switch (this.type) {
            case 0: 
            case 1: {
                return variant.type == this.type;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal == variant.intVal;
            }
            case 11: {
                return this.booleanVal == variant.booleanVal;
            }
            case 6: {
                return this.floatVal == variant.floatVal;
            }
            case 7: {
                return this.doubleVal == variant.doubleVal;
            }
            case 15: {
                if (this.timestampVal.getNanos() != variant.getTimestamp().getNanos()) {
                    return false;
                }
                return this.timestampVal.getTime() == variant.getTimestamp().getTime();
            }
            case 13: 
            case 14: {
                return this.getAsLong() == variant.getAsLong();
            }
            case 5: {
                return this.longVal == variant.longVal;
            }
            case 10: {
                if (this.getBigDecimal() == variant.getBigDecimal()) {
                    return true;
                }
                return this.bigDecimalVal.compareTo(variant.bigDecimalVal) == 0;
            }
            case 16: {
                if (this.stringVal == variant.stringVal) {
                    return true;
                }
                return this.stringVal.equals(variant.stringVal);
            }
            case 18: {
                if (this.intVal != variant.intVal) {
                    return false;
                }
                if (this.byteArrayVal == variant.byteArrayVal) {
                    return true;
                }
                int n = 0;
                while (this.byteArrayVal[n] == variant.byteArrayVal[n] && n < this.intVal) {
                    ++n;
                }
                return n == this.intVal;
            }
            case 12: {
                return this.equals((InputStream)this.objectVal, (InputStream)variant.objectVal);
            }
            case 17: {
                if (this.objectVal == variant.objectVal) {
                    return true;
                }
                return this.objectVal.equals(variant.objectVal);
            }
        }
        Diagnostic.ASSERT(false);
        return false;
    }

    private boolean equals(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        if (n != cArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] != cArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean equals(InputStream inputStream, InputStream inputStream2) {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        if (!inputStream.markSupported() || !inputStream2.markSupported()) {
            return false;
        }
        try {
            inputStream.reset();
            inputStream2.reset();
            int n = 0;
            int n2 = 0;
            while (n2 != -1) {
                n2 = inputStream.read();
                int n3 = inputStream2.read();
                ++n;
                if (n2 == n3) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            Diagnostic.println("IOException hit:");
            Diagnostic.printStackTrace(iOException);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final int compareLong(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    private final int compareDouble(double d, double d2) {
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    private final int compareFloat(float f, float f2) {
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        return 0;
    }

    private final int compareTimestamp(Timestamp timestamp, Timestamp timestamp2) {
        int n = this.compareLong(timestamp.getTime(), timestamp2.getTime());
        if (n == 0) {
            return timestamp.getNanos() - timestamp2.getNanos();
        }
        return n;
    }

    private final int compareBoolean(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Variant variant) {
        if (this.isNull()) {
            return variant.isNull() ? 0 : -1;
        }
        if (variant.isNull()) {
            return 1;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal - variant.getAsInt();
            }
            case 5: {
                return this.compareLong(this.longVal, variant.getAsLong());
            }
            case 6: {
                return this.compareFloat(this.floatVal, variant.getAsFloat());
            }
            case 7: {
                return this.compareDouble(this.doubleVal, variant.getAsDouble());
            }
            case 10: {
                return this.getBigDecimal().compareTo(variant.getAsBigDecimal());
            }
            case 13: {
                return this.compareLong(this.dateVal.getTime(), variant.getDate().getTime());
            }
            case 14: {
                return this.compareLong(this.timeVal.getTime(), variant.getTime().getTime());
            }
            case 15: {
                return this.compareTimestamp(this.timestampVal, variant.getTimestamp());
            }
            case 11: {
                return this.compareBoolean(this.booleanVal, variant.getBoolean());
            }
            case 16: {
                return this.stringVal.compareTo(variant.getString());
            }
        }
        Diagnostic.ASSERT(false);
        return 0;
    }
}

