/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jbo.AttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.rules.JboAbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.Variant;

public class JboRangeValidator
extends JboAbstractValidator
implements JboValidatorInterface {
    Object m_min;
    Object m_max;

    protected void initialize(JboValidatorContext jboValidatorContext) {
        super.initialize(jboValidatorContext);
        this.m_min = this.convertToJava(this.mValidatingAttr, this.m_min);
        this.m_max = this.convertToJava(this.mValidatingAttr, this.m_max);
    }

    public JboRangeValidator() {
        this.mbInverse = false;
        this.setDefaultDescription("01303");
    }

    public JboRangeValidator(boolean bl, Object object, Object object2) {
        this.mbInverse = bl;
        this.setMin(object);
        this.setMax(object2);
        this.setDefaultDescription("01303");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNewValue(Object object) throws Exception {
        super.setNewValue(object);
        if (object != null && this.m_max.getClass() != object.getClass()) {
            JboRangeValidator jboRangeValidator = this;
            synchronized (jboRangeValidator) {
                this.m_max = TypeFactory.getInstance(object.getClass(), this.m_max);
                this.m_min = TypeFactory.getInstance(object.getClass(), this.m_min);
            }
        }
    }

    public boolean validateValue(Object object) {
        if (object == null || object.toString().length() == 0) {
            return true;
        }
        Variant variant = this.getVariant(object);
        return variant.compareTo(this.getVariant(this.m_max)) <= 0 && variant.compareTo(this.getVariant(this.m_min)) >= 0;
    }

    public void setMin(Object object) {
        this.m_min = object;
    }

    public void setMax(Object object) {
        this.m_max = object;
    }

    public Object getMin() {
        return this.m_min;
    }

    public Object getMax() {
        return this.m_max;
    }

    Variant getVariant(Object object) {
        Variant variant = new Variant();
        Object object2 = null;
        if (object instanceof AttributeDef) {
            AttributeDef attributeDef = (AttributeDef)object;
            variant.setInt(0);
        } else {
            object2 = object instanceof DomainInterface ? ((DomainInterface)object).getData() : object;
        }
        if (object2 instanceof Number) {
            if (object2 instanceof Integer) {
                variant.setInt((Integer)object2);
            } else if (object2 instanceof Short) {
                variant.setShort((Short)object2);
            } else if (object2 instanceof Long) {
                variant.setLong((Long)object2);
            } else if (object2 instanceof Float) {
                variant.setFloat(((Float)object2).floatValue());
            } else if (object2 instanceof Double) {
                variant.setDouble((Double)object2);
            } else if (object2 instanceof BigDecimal) {
                variant.setBigDecimal((BigDecimal)object2);
            } else if (object2 instanceof BigInteger) {
                variant.setLong(((Number)object2).longValue());
            } else if (object2 instanceof Byte) {
                variant.setByte((Byte)object2);
            } else {
                variant.setDouble(((Number)object2).doubleValue());
            }
        } else if (object2 instanceof String) {
            variant.setString((String)object2);
        } else if (object2 instanceof Time) {
            variant.setTime((Time)object2);
        } else if (object2 instanceof Timestamp) {
            variant.setTimestamp((Timestamp)object2);
        } else if (object2 instanceof Date) {
            variant.setDate((Date)object2);
        } else {
            variant.setObject(object2);
        }
        return variant;
    }

    public String toString() {
        return new String("Range(" + this.m_min.toString() + this.m_max.toString() + ")");
    }
}

