/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import java.math.BigDecimal;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.common.StringManager;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;

public class JboPrecisionScaleValidator
extends AbstractValidator
implements JboValidatorInterface {
    public static final int DEFAULT_SCALE = -127;
    int mPrec;
    int mScale;
    static String DOTCHAR;
    static int DOTCHARLENGTH;
    private static JboPrecisionScaleValidator mSingleton;
    private static /* synthetic */ Class class$java$math$BigDecimal;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mPrec = 0;
        this.mScale = -127;
    }

    public JboPrecisionScaleValidator() {
        this.$init$();
        DOTCHAR = StringManager.getString("oracle.jbo.CSMessageBundle", "01308", null, null);
        DOTCHARLENGTH = DOTCHAR.length();
    }

    public static JboPrecisionScaleValidator getSingleton() {
        if (mSingleton == null) {
            mSingleton = new JboPrecisionScaleValidator();
        }
        return mSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(JboValidatorContext jboValidatorContext) {
        boolean bl = false;
        Object object = null;
        try {
            object = jboValidatorContext.getSource();
            AttributeDef attributeDef = jboValidatorContext.getAttributeDef();
            if (attributeDef != null) {
                bl = JboPrecisionScaleValidator.validateValue(jboValidatorContext.getNewValue(), attributeDef.getPrecision(), attributeDef.getScale());
            } else {
                JboPrecisionScaleValidator jboPrecisionScaleValidator = this;
                synchronized (jboPrecisionScaleValidator) {
                    bl = JboPrecisionScaleValidator.validateValue(jboValidatorContext.getNewValue(), this.mPrec, this.mScale);
                }
            }
            if (!bl) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JboPrecisionScaleValidator.class$("oracle.jbo.CSMessageBundle");
                }
                RulesBeanUtils.raiseException(clazz, "27010", object, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), jboValidatorContext.getNewValue(), null, null);
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JboPrecisionScaleValidator.class$("oracle.jbo.CSMessageBundle");
            }
            RulesBeanUtils.raiseException(clazz, "27010", object, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), jboValidatorContext.getNewValue(), null, exception);
        }
    }

    public static boolean validateValue(Object object, int n, int n2) {
        boolean bl = true;
        if (object != null) {
            if (n2 == -127) {
                bl = !(object instanceof LobInterface) ? (n > 0 ? object.toString().length() <= n : bl) : (n > 0 ? ((LobInterface)object).getSize() <= (long)n : bl);
            } else {
                Class clazz;
                String string = object.toString().trim();
                if (string.length() == 0) {
                    return bl;
                }
                char c = string.charAt(0);
                if (c == '+' || c == '-') {
                    string = string.substring(1);
                }
                if ((clazz = class$java$math$BigDecimal) == null) {
                    clazz = class$java$math$BigDecimal = JboPrecisionScaleValidator.class$("java.math.BigDecimal");
                }
                BigDecimal bigDecimal = (BigDecimal)TypeFactory.getInstance(clazz, (Object)string);
                if (n2 < 0) {
                    BigDecimal bigDecimal2 = new BigDecimal(Math.pow(10.0, -1 * n2));
                    bl = bigDecimal.compareTo(bigDecimal2) < 0 && string.length() <= n + DOTCHARLENGTH;
                } else if (n2 > 0) {
                    BigDecimal bigDecimal3 = new BigDecimal(Math.pow(10.0, (double)n - (double)n2));
                    bl = string.indexOf(DOTCHAR) > -1 ? bigDecimal.compareTo(bigDecimal3) < 0 && string.length() - string.indexOf(DOTCHAR) - 1 <= n2 : bigDecimal.compareTo(bigDecimal3) < 0;
                } else {
                    bl = String.valueOf(bigDecimal.longValue()).length() <= n && bigDecimal.scale() == 0;
                }
            }
        }
        return bl;
    }

    public int getPrecision() {
        return this.mPrec;
    }

    public int getScale() {
        return this.mScale;
    }

    public void setPrecision(int n) {
        this.mPrec = n;
    }

    public void setScale(int n) {
        this.mScale = n;
    }

    public String toString() {
        return new String("Precision-" + this.mPrec + "; Scale-" + this.mScale);
    }

    public String getDescription() {
        return "";
    }

    public void setDescription(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

