/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.common.AttributeDefHelper;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboBeanUtils;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.common.StringManager;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.NullValue;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.format.Formatter;
import oracle.jbo.format.FormatterFactory;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.JboPrecisionScaleValidator;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.ValidationManager;

public class VariableImpl
extends NamedObjectImpl
implements Serializable,
AttributeHints,
ValidationManager,
Variable {
    static final long serialVersionUID = -9072335479779259293L;
    protected boolean mMandatory;
    protected boolean mNotNull;
    protected int mPrecision;
    protected int mScale;
    protected byte mUpdateable;
    protected Object mDefaultValue;
    protected transient Class mJavaType;
    protected transient String mJavaTypeName;
    private String mKind;
    private Object mExtendedData;
    private transient java.util.ArrayList mValidators;
    private transient VariableManager mManager;
    private final byte FORMAT_INFO_UNINITIALIZED;
    private final byte FORMAT_INFO_NOT_AVAILABLE;
    private final byte FORMAT_INFO_AVAILABLE;
    private byte mHasFormatInfo;
    private boolean mPassivationNeeded;
    private boolean mIsDefinedDefaultValue;
    private static /* synthetic */ Class class$java$lang$Object;

    private /* synthetic */ void $init$() {
        this.mMandatory = false;
        this.mNotNull = false;
        this.mPrecision = 0;
        this.mScale = -127;
        this.mUpdateable = (byte)2;
        this.mJavaType = null;
        this.mJavaTypeName = null;
        this.mValidators = new java.util.ArrayList(3);
        this.FORMAT_INFO_UNINITIALIZED = (byte)-1;
        this.FORMAT_INFO_NOT_AVAILABLE = 0;
        this.FORMAT_INFO_AVAILABLE = 1;
        this.mHasFormatInfo = (byte)-1;
        this.mPassivationNeeded = true;
        this.mIsDefinedDefaultValue = false;
    }

    public VariableImpl() {
        this.$init$();
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = VariableImpl.class$("java.lang.Object");
        }
        this.initVariable(null, (byte)2, false, clazz);
    }

    public VariableImpl(String string) {
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = VariableImpl.class$("java.lang.Object");
        }
        this(string, null, 2, false, clazz);
    }

    public VariableImpl(String string, Class clazz) {
        this(string, null, 2, false, clazz);
    }

    public VariableImpl(String string, Object object, byte by, boolean bl, Class clazz) {
        this.$init$();
        this.setName(string);
        this.initVariable(object, by, bl, clazz);
    }

    protected VariableImpl createClone() {
        return new VariableImpl();
    }

    public Object clone() {
        VariableImpl variableImpl = this.createClone();
        variableImpl.setName(this.getName());
        variableImpl.initVariable(this.getDefaultValue(), this.getUpdateableFlag(), this.isMandatory(), this.getJavaType());
        variableImpl.setPrecisionScale(this.getPrecision(), this.getScale());
        variableImpl.setVariableKind(this.getVariableKind());
        variableImpl.setExtendedData(this.getExtendedData());
        variableImpl.setPropertiesMap(this.getPropertiesMap());
        variableImpl.mValidators = this.mValidators != null ? (java.util.ArrayList)this.mValidators.clone() : null;
        return variableImpl;
    }

    void initVariable(Object object, byte by, boolean bl, Class clazz) {
        this.mUpdateable = by;
        this.mNotNull = bl;
        this.mJavaType = clazz;
        this.mDefaultValue = object instanceof String && JboBeanUtils.isElExpr((String)object) ? object : this.convertToJava(object);
    }

    void notifyManager() {
        this.mPassivationNeeded = true;
        if (this.mManager != null) {
            this.mManager.variableChanged(this);
        }
    }

    void validateName() {
        String string = this.getName();
        if (!JboNameUtil.isNameValid(string)) {
            throw new InvalidObjNameException(132, string);
        }
        if ("where".equals(this.getVariableKind()) && string.charAt(0) == '_') {
            throw new InvalidObjNameException(133, string);
        }
    }

    public void setName(String string) {
        if (string == null) {
            this.getName();
        } else if (this.mObjName != null && string.equals(this.mObjName)) {
            return;
        }
        this.validateName();
        super.setName(string);
        this.notifyManager();
    }

    public VariableManager getVariableManager() {
        return this.mManager;
    }

    public void setVariableManager(VariableManager variableManager) {
        this.mManager = variableManager;
    }

    public String getVariableKind() {
        return this.mKind;
    }

    public void setVariableKind(String string) {
        if (string == null ? this.mKind == null : string.equals(this.mKind)) {
            return;
        }
        this.mKind = string;
        this.validateName();
        this.notifyManager();
    }

    public Object getExtendedData() {
        return this.mExtendedData;
    }

    public void setExtendedData(Object object) {
        this.mExtendedData = object;
        this.notifyManager();
    }

    public byte getUpdateableFlag() {
        return this.mUpdateable;
    }

    public void setUpdateableFlag(byte by) {
        if (this.mUpdateable != by) {
            this.mUpdateable = by;
            this.notifyManager();
        }
    }

    public boolean isMandatory() {
        return this.mNotNull;
    }

    public void setMandatory(boolean bl) {
        if (this.mNotNull != bl) {
            this.mNotNull = bl;
            this.notifyManager();
        }
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public int getScale() {
        return this.mScale;
    }

    public void setPrecisionScale(int n, int n2) {
        if (this.mPrecision != n || this.mScale != n2) {
            this.mPrecision = n;
            this.mScale = n2;
            if (this.mPrecision > 0) {
                JboPrecisionScaleValidator jboPrecisionScaleValidator = new JboPrecisionScaleValidator();
                jboPrecisionScaleValidator.setPrecision(this.mPrecision);
                jboPrecisionScaleValidator.setScale(this.mScale);
                if (jboPrecisionScaleValidator != null) {
                    this.addValidator(jboPrecisionScaleValidator);
                }
            }
            this.notifyManager();
        }
    }

    public Class getJavaType() {
        return this.mJavaType;
    }

    public void setJavaType(Class clazz) {
        if (this.mJavaType != clazz) {
            this.mJavaType = clazz;
            this.notifyManager();
        }
    }

    public String getJavaTypeName() {
        if (this.mJavaType != null) {
            return this.mJavaType.getName();
        }
        return this.mJavaTypeName;
    }

    public void setJavaTypeName(String string) {
        String string2 = this.getJavaTypeName();
        if (string2 == null || !string.equals(string2)) {
            this.mJavaTypeName = string;
            this.mJavaType = null;
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    this.setJavaType(clazz);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.notifyManager();
        }
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(Object object) {
        if (object == null ? this.mDefaultValue == null : object.equals(this.mDefaultValue)) {
            return;
        }
        this.mDefaultValue = object;
        this.mIsDefinedDefaultValue = false;
        this.notifyManager();
    }

    public Object convertToJava(Object object) {
        if (this.mJavaType != null && !(object instanceof NullValue)) {
            return TypeFactory.getInstance(this.mJavaType, object);
        }
        return object;
    }

    public void addValidator(JboValidatorInterface jboValidatorInterface) {
        this.mValidators.add(jboValidatorInterface);
    }

    public java.util.ArrayList getValidators() {
        return this.mValidators != null ? (java.util.ArrayList)this.mValidators.clone() : null;
    }

    public void removeValidator(JboValidatorInterface jboValidatorInterface) {
        this.mValidators.remove(jboValidatorInterface);
    }

    private void loadPrecisionValidator(DefElement defElement) {
        this.mPrecision = defElement.readInt("Precision");
        if (this.mPrecision > 0) {
            if (JboTypeMap.isNumericType(JboTypeMap.javaTypeToSQLTypeId(this.getJavaTypeName()))) {
                this.mScale = defElement.readInt("Scale");
            }
            if (defElement.readBoolean("PrecisionRule")) {
                this.setPrecisionScale(this.mPrecision, this.mScale);
            }
        }
    }

    static byte convertUpdateableStringToFlag(String string) {
        return AttributeDefHelper.convertUpdateableStringToFlag(string);
    }

    public void initFromXML(DefElement defElement) {
        this.initFromXML(defElement, false);
    }

    public void initFromXML(DefElement defElement, boolean bl) {
        String string = defElement.readString("Name");
        if (string == null) {
            string = defElement.readString("id");
        }
        string = string.intern();
        String string2 = defElement.readString("DefaultValue");
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        byte by = VariableImpl.convertUpdateableStringToFlag(defElement.readString("IsUpdateable"));
        boolean bl2 = defElement.readBoolean("IsNotNull");
        this.mJavaTypeName = defElement.readString("Type");
        Class clazz = null;
        try {
            clazz = JBOClass.findDataClass(this.mJavaTypeName);
        }
        catch (DataCreationException dataCreationException) {
            if (!bl) {
                // empty if block
            }
        }
        this.setName(string);
        this.initVariable(string2, by, bl2, clazz);
        this.loadPrecisionValidator(defElement);
        this.loadExtendedData(defElement);
        this.loadProperties(defElement);
        String string3 = defElement.readString("Kind");
        if (string3 != null) {
            string3 = string3.intern();
            this.setVariableKind(string3);
        }
        defElement = null;
        this.mPassivationNeeded = false;
        this.mIsDefinedDefaultValue = true;
    }

    public boolean isPassivationNeeded() {
        return this.mPassivationNeeded;
    }

    public boolean isDefinedDefaultValue() {
        return this.mIsDefinedDefaultValue;
    }

    void loadExtendedData(DefElement defElement) {
        ArrayList arrayList = defElement.readStringArrayList("ExtendedDataInts");
        if (arrayList != null) {
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = Integer.valueOf((String)arrayList.get(n));
                ++n;
            }
            this.setExtendedData(nArray);
        }
    }

    void loadProperties(DefElement defElement) {
        HashMap hashMap = defElement.loadPropertiesMap();
        if (hashMap != null) {
            this.getPropertiesMap();
            this.mProperties.putAll((Map)hashMap);
        }
    }

    public AttributeHints getUIHelper() {
        return this;
    }

    public String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName(localeContext, string);
    }

    protected String resolveResourceProperty(String string, LocaleContext localeContext) {
        String string2;
        String string3 = null;
        HashMap hashMap = this.getPropertiesMap();
        string3 = (String)hashMap.get((Object)(string2 = this.getLocaleName(localeContext, string)));
        if (string3 == null && !hashMap.containsKey((Object)string2)) {
            string3 = (String)hashMap.get((Object)string);
            if (string3 == null) {
                string3 = this.getStringFromMessageBundle(string, localeContext);
            }
            this.setProperty(string2, string3);
        }
        return string3;
    }

    public final String getLabel(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("LABEL", localeContext);
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public final String getTooltip(LocaleContext localeContext) {
        return this.resolveResourceProperty("TOOLTIP", localeContext);
    }

    public final String getDisplayHint(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHINT", localeContext);
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public final int getControlType(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("CONTROLTYPE", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public final int getDisplayWidth(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYWIDTH", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public final int getDisplayHeight(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHEIGHT", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        if (string.equals("DISPLAYHEIGHT")) {
            return Integer.toString(this.getDisplayHeight(localeContext));
        }
        if (string.equals("CONTROLTYPE")) {
            return Integer.toString(this.getControlType(localeContext));
        }
        if (string.equals("DISPLAYHINT")) {
            return this.getDisplayHint(localeContext);
        }
        return this.resolveResourceProperty(string, localeContext);
    }

    public String getHintValue(LocaleContext localeContext, String string) {
        return this.resolveResourceProperty(string, localeContext);
    }

    public final String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.resolveResourceProperty("FMT_FORMAT", localeContext);
        if (string == null) {
            string = this.getFormatter(localeContext).getDefaultFormatString();
        }
        return string;
    }

    public final Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return FormatterFactory.getFormatter(this.getFormatterClassName(localeContext), localeContext);
    }

    public final boolean hasFormatInformation(LocaleContext localeContext) {
        if (this.mHasFormatInfo == -1) {
            String string = this.getFormatterClassName(localeContext);
            this.mHasFormatInfo = string == null || string.equals("") ? (byte)0 : 1;
        }
        return this.mHasFormatInfo == 1;
    }

    public final String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getName());
        if (object == null) {
            return null;
        }
        if ("".equals(object)) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public final Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = object;
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public final boolean displayInShortForm(LocaleContext localeContext) {
        return "Summary".equals(this.resolveResourceProperty("FORMTYPE", localeContext));
    }

    public final String getFormatterClassName(LocaleContext localeContext) {
        return this.resolveResourceProperty("FMT_FORMATTER", localeContext);
    }

    String getStringFromMessageBundle(String string, LocaleContext localeContext) {
        Class clazz = this.getVariableManager().getVarMgrOwner().getMessageBundleClass();
        String string2 = null;
        if (clazz != null) {
            String string3 = this.getName() + "_" + string;
            string2 = StringManager.getLocalizedString(clazz.getName(), string3, null, localeContext != null ? localeContext.getLocale() : null, false);
        }
        return string2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this.getName());
        objectOutputStream.writeUTF(this.getJavaType().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setName(objectInputStream.readUTF());
        this.mJavaType = JBOClass.findDataClass(objectInputStream.readUTF());
    }

    public byte getAttributeKind() {
        return -1;
    }

    public String getColumnName() {
        return null;
    }

    public String getColumnNameForQuery() {
        return null;
    }

    public int getSQLType() {
        return -1;
    }

    public boolean isPrimaryKey() {
        return false;
    }

    public int getElemSQLType() {
        return -1;
    }

    public int getIndex() {
        return -1;
    }

    public Class getElemType() {
        return null;
    }

    public boolean isSelected() {
        return false;
    }

    public boolean isQueriable() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

