/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.jbo.ApplicationModule;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackInput;
import oracle.jbo.common.PiggybackOutput;
import oracle.jbo.common.SvcMethodResponse;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.svcmsg.ServiceMessage;

public class JboServiceMessage
extends ServiceMessage
implements Serializable {
    static final long serialVersionUID = -6193967590429663228L;
    private ArrayList mRefs;
    private byte[] mSerRequests;
    private byte[] mSerResponses;
    private byte[] mSerRefs;
    private int mSyncMode;
    private SvcMsgRequestParams mSyncROTReq;
    private SvcMsgResponseValues mOutOfBandResponse;
    private transient boolean mForceMarshal;

    private /* synthetic */ void $init$() {
        this.mRefs = new ArrayList(2);
        this.mSerRequests = null;
        this.mSerResponses = null;
        this.mSerRefs = null;
        this.mSyncROTReq = null;
        this.mOutOfBandResponse = null;
        this.mForceMarshal = false;
    }

    public JboServiceMessage() {
        this(null, 0);
    }

    public JboServiceMessage(String string, int n) {
        super(string);
        this.$init$();
        this.mSyncMode = n;
    }

    public int getSyncMode() {
        return this.mSyncMode;
    }

    public List getRefs() {
        return this.mRefs;
    }

    public boolean isForceMarshal() {
        return this.mForceMarshal;
    }

    public void setOutOfBandResponse(SvcMsgResponseValues svcMsgResponseValues) {
        this.mOutOfBandResponse = svcMsgResponseValues;
    }

    public SvcMsgResponseValues getOutOfBandResponse() {
        return this.mOutOfBandResponse;
    }

    protected void setRefs(List list) {
        this.mRefs = list instanceof ArrayList ? (ArrayList)list : new ArrayList(list);
    }

    public void addRef(Serializable serializable) {
        this.mRefs.add(serializable);
    }

    public byte[] getSerRequests() {
        return this.mSerRequests;
    }

    public byte[] getSerResponses() {
        return this.mSerResponses;
    }

    public byte[] getSerRefs() {
        return this.mSerRefs;
    }

    public ServiceMessage copyTo(ServiceMessage serviceMessage) {
        JboServiceMessage jboServiceMessage = (JboServiceMessage)serviceMessage;
        super.copyTo(serviceMessage);
        jboServiceMessage.mRefs = (ArrayList)this.mRefs.clone();
        jboServiceMessage.mSerRequests = this.mSerRequests;
        jboServiceMessage.mSerResponses = this.mSerResponses;
        jboServiceMessage.mSerRefs = this.mSerRefs;
        jboServiceMessage.mSyncMode = this.mSyncMode;
        jboServiceMessage.mOutOfBandResponse = this.mOutOfBandResponse;
        return serviceMessage;
    }

    public void clear() {
        super.clear();
        this.mRefs.clear();
    }

    public void clearAll() {
        this.clear();
        this.mSerRequests = null;
        this.mSerResponses = null;
        this.mSerRefs = null;
        this.mForceMarshal = false;
    }

    public void addMethodResponse(String string, Object object) {
        SvcMethodResponse svcMethodResponse = new SvcMethodResponse(string, object);
        this.mForceMarshal = true;
        this.addResponse(svcMethodResponse);
    }

    public Object getMethodResponse(String string) {
        Object object = null;
        Iterator iterator = this.getResponses().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SvcMethodResponse) || !((SvcMethodResponse)e).getMethodName().equals(string)) continue;
            object = ((SvcMethodResponse)e).getResponse();
            if (object != null || ((SvcMethodResponse)e).isNull()) break;
            return e;
        }
        return object;
    }

    public void marshal(Locale locale, ApplicationModule applicationModule) {
        this.marshal(locale, applicationModule, null);
    }

    public void marshal(Locale locale, ApplicationModule applicationModule, ObjectMarshaller objectMarshaller) {
        PiggybackOutput piggybackOutput;
        List list = this.getRequests();
        if (list.size() == 0) {
            this.mSerRequests = new byte[0];
        } else {
            piggybackOutput = new PiggybackOutput(list, locale, applicationModule, objectMarshaller);
            this.mSerRequests = piggybackOutput.getPiggybackStream();
        }
        List list2 = this.getResponses();
        if (list2.size() == 0) {
            this.mSerResponses = new byte[0];
        } else {
            piggybackOutput = new PiggybackOutput(list2, locale, applicationModule, objectMarshaller);
            this.mSerResponses = piggybackOutput.getPiggybackStream();
        }
        this.clearEntries();
    }

    public void marshalRefs(Locale locale, ApplicationModule applicationModule, ObjectMarshaller objectMarshaller) {
        List list = this.getRefs();
        if (list.size() == 0) {
            this.mSerRefs = new byte[0];
        } else {
            PiggybackOutput piggybackOutput = new PiggybackOutput(list, locale, applicationModule, objectMarshaller);
            this.mSerRefs = piggybackOutput.getPiggybackStream();
        }
        this.mRefs.clear();
    }

    public void unmarshal(ObjectMarshaller objectMarshaller) {
        PiggybackInput piggybackInput;
        if (this.mSerRequests == null) {
            return;
        }
        if (this.mSerRequests.length < 4) {
            this.getRequests().clear();
        } else {
            piggybackInput = new PiggybackInput(objectMarshaller, this.mSerRequests);
            this.setRequests(Arrays.asList(piggybackInput.getPiggybackEntries()));
        }
        if (this.mSerResponses.length < 4) {
            this.getResponses().clear();
        } else {
            piggybackInput = new PiggybackInput(objectMarshaller, this.mSerResponses);
            this.setResponses(Arrays.asList(piggybackInput.getPiggybackEntries()));
        }
        if (this.mSerRefs == null || this.mSerRefs.length < 4) {
            this.getRefs().clear();
        } else {
            piggybackInput = new PiggybackInput(objectMarshaller, this.mSerRefs);
            this.setRefs(Arrays.asList(piggybackInput.getPiggybackEntries()));
        }
        this.mSerRequests = null;
        this.mSerResponses = null;
        this.mSerRefs = null;
    }

    public void setSyncROTReq(SvcMsgRequestParams svcMsgRequestParams) {
        this.mSyncROTReq = svcMsgRequestParams;
    }

    public SvcMsgRequestParams getSyncROTReq() {
        return this.mSyncROTReq;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.mSerRequests == null) {
            this.marshal(null, null);
        }
        objectOutputStream.writeObject(this.mSerRequests);
        objectOutputStream.writeObject(this.mSerResponses);
        objectOutputStream.writeObject(this.mSerRefs);
        objectOutputStream.writeInt(this.mSyncMode);
        objectOutputStream.writeObject(this.mSyncROTReq);
        objectOutputStream.writeObject(this.mOutOfBandResponse);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mRefs = new ArrayList(2);
        this.mSerRequests = (byte[])objectInputStream.readObject();
        this.mSerResponses = (byte[])objectInputStream.readObject();
        this.mSerRefs = (byte[])objectInputStream.readObject();
        this.mSyncMode = objectInputStream.readInt();
        this.mSyncROTReq = (SvcMsgRequestParams)objectInputStream.readObject();
        this.mOutOfBandResponse = (SvcMsgResponseValues)objectInputStream.readObject();
    }
}

