/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.ObjectMarshaller;

public class JboObjectInputStream
extends ObjectInputStream {
    private ObjectMarshaller mMarshaller;

    public JboObjectInputStream(InputStream inputStream, ObjectMarshaller objectMarshaller) throws IOException {
        super(inputStream);
        if (objectMarshaller != null) {
            this.enableResolveObject(true);
        }
        this.mMarshaller = objectMarshaller;
    }

    protected Object resolveObject(Object object) throws IOException {
        Object object2 = object;
        if (this.mMarshaller != null) {
            object2 = this.mMarshaller.unMarshal(object);
        }
        return object2;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class clazz = null;
        try {
            clazz = super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = JBOClass.forName(objectStreamClass.getName());
        }
        return clazz;
    }

    public Object readHandle() throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])this.readObject();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }
}

