/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;

public class JboBeanUtils {
    protected static final String EL_start = "${";
    protected static final String EL_end = "}";
    protected static final String JSF_EL_start = "#{";

    static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            PropertyDescriptor propertyDescriptor = null;
            return propertyDescriptor;
        }
        catch (IntrospectionException introspectionException) {
            PropertyDescriptor propertyDescriptor = null;
            return propertyDescriptor;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null) {
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (string.equals(propertyDescriptorArray[n].getName())) {
                    return propertyDescriptorArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static Object getProperty(Object object, String string) {
        try {
            String string2;
            PropertyDescriptor propertyDescriptor = JboBeanUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor == null) {
                Object var6_3 = null;
                return var6_3;
            }
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) {
                Object var7_5 = null;
                return var7_5;
            }
            if (Diagnostic.isOn() && ((string2 = object.getClass().getName()).startsWith("oracle.jbo") || string2.startsWith("oracle.adf"))) {
                Diagnostic.println("*** Using bean introspection to lookup value :" + string);
            }
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (Exception exception) {
            throw JboBeanUtils._adapt(exception);
        }
    }

    public static void setProperty(Object object, String string, Object object2) {
        try {
            PropertyDescriptor propertyDescriptor = JboBeanUtils.getPropertyDescriptor(object, string);
            if (propertyDescriptor == null) {
                throw new JboException("Unknown property '" + string + "'");
            }
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                throw new JboException("Property '" + string + "' has no getter method");
            }
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw JboBeanUtils._adapt(exception);
        }
    }

    private static JboException _adapt(Throwable throwable) {
        while (throwable instanceof InvocationTargetException) {
            Throwable throwable2;
            throwable = throwable2 = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof JboException) {
            return (JboException)throwable;
        }
        return new JboException(throwable);
    }

    public static boolean isElExpr(String string) {
        return string != null && (string.startsWith(EL_start) || string.startsWith(JSF_EL_start)) && string.endsWith(EL_end);
    }
}

