/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.DriverManager;
import oracle.jbo.common.CallAnalyzer;
import oracle.jbo.common.DiagnosticFactory;
import oracle.jbo.common.DiagnosticStream;
import oracle.jbo.common.IDiagnostic;
import oracle.jbo.common.IDiagnostic2;
import oracle.jbo.common.JboAssert;
import oracle.jbo.common.SilentDiagnosticImpl;

public final class Diagnostic {
    private static final int BASEOFFSET = 5;
    private static IDiagnostic s_diag = null;
    static int s_depthOffset = 5;
    static boolean s_firstPrintOnLine = true;
    private static boolean s_stopOnAssert = false;
    private static boolean s_quiet = false;
    private static boolean s_showTiming = false;
    private static boolean s_showFunction = false;
    private static boolean s_showLinecount = false;
    private static boolean s_showLevel = false;
    private static boolean s_SilentDiagnostic = false;
    private static int s_traceThreshold = 0;
    private static long s_linecount = 0L;
    private static long s_thisCallTime;
    private static long s_lastCallTime;

    static {
        s_lastCallTime = System.currentTimeMillis();
        Diagnostic.init("BC4J Bootstrap");
    }

    public static IDiagnostic getInstance() {
        return s_diag;
    }

    public static void init(String string) {
        s_diag = DiagnosticFactory.createDiagnostic();
        if (s_diag instanceof SilentDiagnosticImpl) {
            s_SilentDiagnostic = true;
        }
        if (s_diag instanceof IDiagnostic2) {
            ((IDiagnostic2)((Object)s_diag)).initialized(string);
        } else if (!s_SilentDiagnostic) {
            System.out.println("Diagnostics: (" + string + ") " + s_diag.toString());
        }
        if (!s_SilentDiagnostic) {
            if (DiagnosticFactory.getProperty("jbo.logging.show.timing").equalsIgnoreCase("true")) {
                s_showTiming = true;
            }
            if (DiagnosticFactory.getProperty("jbo.logging.show.function").equalsIgnoreCase("true")) {
                s_showFunction = true;
            }
            if (DiagnosticFactory.getProperty("jbo.logging.show.level").equalsIgnoreCase("true")) {
                s_showLevel = true;
            }
            if (DiagnosticFactory.getProperty("jbo.logging.show.linecount").equalsIgnoreCase("true")) {
                s_showLinecount = true;
            }
        }
        try {
            s_traceThreshold = Integer.parseInt(DiagnosticFactory.getProperty("jbo.logging.trace.threshold"));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: couldn't parse jbo.logging.show.linecount=" + DiagnosticFactory.getProperty("jbo.logging.trace.threshold"));
            s_traceThreshold = 3;
        }
        Diagnostic.println("Diagnostic Properties: Timing:" + s_showTiming + " Functions:" + s_showFunction + " Linecount:" + s_showLinecount + " Threshold:" + s_traceThreshold, 0);
        try {
            String string2 = DiagnosticFactory.getProperty("jbo.jdbc.driver.verbose");
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                DiagnosticStream diagnosticStream = new DiagnosticStream();
                DriverManager.setLogWriter(diagnosticStream);
            }
        }
        catch (Exception exception) {
            Diagnostic.println("WARNING: could not set the JDBC driver output (" + exception.getMessage() + ")");
        }
    }

    private Diagnostic() {
    }

    public static void print(String string, int n) {
        block3: {
            if (s_SilentDiagnostic) {
                return;
            }
            if (s_quiet || n > s_traceThreshold) break block3;
            if (s_firstPrintOnLine) {
                s_diag.print(Diagnostic.getPreamble(s_depthOffset, n) + string);
                s_firstPrintOnLine = false;
            } else {
                s_diag.print(string);
            }
        }
    }

    public static void print(String string) {
        if (s_SilentDiagnostic) {
            return;
        }
        ++s_depthOffset;
        Diagnostic.print(string, 3);
        --s_depthOffset;
    }

    private static void nl(int n) {
        block1: {
            if (s_SilentDiagnostic) {
                return;
            }
            if (s_quiet || n > s_traceThreshold) break block1;
            ++s_depthOffset;
            s_diag.println("");
            --s_depthOffset;
            s_firstPrintOnLine = true;
            ++s_linecount;
        }
    }

    public static void println(String string, int n) {
        if (s_SilentDiagnostic) {
            return;
        }
        ++s_depthOffset;
        Diagnostic.print(string, n);
        --s_depthOffset;
        Diagnostic.nl(n);
    }

    public static void println(String string) {
        if (s_SilentDiagnostic) {
            return;
        }
        ++s_depthOffset;
        Diagnostic.println(string, 3);
        --s_depthOffset;
    }

    public static void println(StringBuffer stringBuffer) {
        if (s_SilentDiagnostic) {
            return;
        }
        ++s_depthOffset;
        Diagnostic.println(stringBuffer.toString(), 3);
        --s_depthOffset;
    }

    public static void ASSERT(boolean bl, String string, Object[] objectArray) {
        if (!bl) {
            JboAssert jboAssert = new JboAssert("(Assertion Failed) " + string, objectArray);
            Diagnostic.printStackTrace(jboAssert);
            if (s_stopOnAssert) {
                Diagnostic.println("Throwing JboAssert");
                throw jboAssert;
            }
        }
    }

    public static void ASSERT(boolean bl, String string) {
        Diagnostic.ASSERT(bl, string, null);
    }

    public static void ASSERT(boolean bl) {
        Diagnostic.ASSERT(bl, "", null);
    }

    public static boolean isOn() {
        return !s_SilentDiagnostic && !s_quiet;
    }

    public static boolean isOn(int n) {
        return !s_SilentDiagnostic && !s_quiet && n <= s_traceThreshold;
    }

    public static void setQuiet(boolean bl) {
        s_quiet = bl;
    }

    public static void setStopOnAssert(boolean bl) {
        s_stopOnAssert = bl;
    }

    public static boolean isStopOnAssert() {
        return s_stopOnAssert;
    }

    public static void printStackTrace() {
        Diagnostic.printStackTrace(new Exception("Diagnostic Stack Trace"));
    }

    public static void printStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Diagnostic.println(stringWriter.toString());
    }

    private static String getPreamble(int n, int n2) {
        if (s_SilentDiagnostic) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (s_showLevel) {
            stringBuffer.append('<').append(n2).append('>');
        }
        if (s_showLinecount) {
            stringBuffer.append('[');
            if (s_linecount < (long)10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(s_linecount).append(']');
        }
        if (s_showTiming) {
            s_thisCallTime = System.currentTimeMillis();
            stringBuffer.append(" (").append(s_thisCallTime - s_lastCallTime).append(")");
            s_lastCallTime = s_thisCallTime;
        }
        if (s_showFunction) {
            stringBuffer.append(' ').append(CallAnalyzer.whoCalledMe(n));
        }
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }
}

