/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import com.sun.java.util.collections.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.jbo.AttributeList;
import oracle.jbo.CriteriaClauses;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.Key;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.StructureDef;
import oracle.jbo.ViewCriteriaManager;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewObject;

public class ViewCriteria
extends Vector
implements NavigatableRowIterator {
    static final long serialVersionUID = -1936719611032545661L;
    private transient StructureDef mStructureDef;
    private transient int mCurrentIndex;
    private transient int mCriteriaMode;
    private transient CriteriaClauses mClauses;
    private boolean mUseFormatters;
    private ViewCriteriaManager mManager;
    public static int CRITERIA_MODE_QUERY = 1;
    public static int CRITERIA_MODE_CACHE = 2;
    protected ArrayList listeners;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mCurrentIndex = -1;
        this.mCriteriaMode = CRITERIA_MODE_QUERY;
        this.mUseFormatters = true;
        this.listeners = null;
    }

    public ViewCriteria(ViewObject viewObject) {
        this.$init$();
        this.mStructureDef = viewObject;
    }

    public ViewCriteria(StructureDef structureDef) {
        this.$init$();
        this.mStructureDef = structureDef;
    }

    public void setViewCriteriaManager(ViewCriteriaManager viewCriteriaManager) {
        this.mManager = viewCriteriaManager;
    }

    public CriteriaClauses getClauses() {
        return this.mClauses;
    }

    public void setClauses(CriteriaClauses criteriaClauses) {
        this.mClauses = criteriaClauses;
    }

    public void criteriaChanged() {
        this.setClauses(null);
        if (this.mManager != null) {
            this.mManager.criteriaChanged(this);
        }
    }

    public boolean isCriteriaForQuery() {
        return (this.mCriteriaMode & CRITERIA_MODE_QUERY) != 0;
    }

    public boolean isCriteriaForRowMatch() {
        return (this.mCriteriaMode & CRITERIA_MODE_CACHE) != 0;
    }

    public void setCriteriaForQuery(boolean bl) {
        if (bl) {
            if (this.mCriteriaMode != CRITERIA_MODE_QUERY) {
                this.mCriteriaMode = CRITERIA_MODE_QUERY;
                this.criteriaChanged();
            }
        } else if (this.mCriteriaMode != CRITERIA_MODE_CACHE) {
            this.mCriteriaMode = CRITERIA_MODE_CACHE;
            this.criteriaChanged();
        }
    }

    public int getCriteriaMode() {
        return this.mCriteriaMode;
    }

    public void setCriteriaMode(int n) {
        if (this.mCriteriaMode != n) {
            this.mCriteriaMode = n;
            this.criteriaChanged();
        }
    }

    public void setViewObject(ViewObject viewObject) {
        this.mStructureDef = viewObject;
    }

    public ViewObject getViewObject() {
        return this.mStructureDef instanceof ViewObject ? (ViewObject)this.mStructureDef : null;
    }

    public StructureDef getStructureDef() {
        return this.mStructureDef;
    }

    public int getAttributeIndexOf(String string) {
        return this.mStructureDef.findAttributeDef(string).getIndex();
    }

    public ViewCriteriaRow createViewCriteriaRow() {
        return new ViewCriteriaRow(this, null);
    }

    public Row next() {
        Row row = this.getCurrentRow();
        Row row2 = this.hasNext() ? this.elementAt(++this.mCurrentIndex) : null;
        this.fireNavigationEvent(new NavigationEvent(this, row, row2));
        return row2;
    }

    public Row previous() {
        Row row = this.getCurrentRow();
        Row row2 = this.hasPrevious() ? this.elementAt(--this.mCurrentIndex) : null;
        this.fireNavigationEvent(new NavigationEvent(this, row, row2));
        return row2;
    }

    public Row first() {
        Row row = this.getCurrentRow();
        this.mCurrentIndex = this.size() > 0 ? 0 : -1;
        int n = this.mCurrentIndex;
        Row row2 = n >= 0 ? this.elementAt(n) : null;
        this.fireNavigationEvent(new NavigationEvent(this, row, row2));
        return row2;
    }

    public Row last() {
        Row row = this.getCurrentRow();
        int n = this.size();
        n = n > 0 ? --n : 0;
        this.mCurrentIndex = n;
        Row row2 = n >= 0 ? this.elementAt(n) : null;
        this.fireNavigationEvent(new NavigationEvent(this, row, row2));
        return row2;
    }

    public void reset() {
        Row row = this.getCurrentRow();
        this.mCurrentIndex = -1;
        this.fireNavigationEvent(new NavigationEvent(this, row, null));
    }

    public boolean hasNext() {
        int n = this.mCurrentIndex;
        n = n < 0 ? (this.size() > 0 ? 0 : n) : (n <= this.size() - 2 ? ++n : -1);
        return n > 0;
    }

    public boolean hasPrevious() {
        return this.mCurrentIndex > 0 && this.mCurrentIndex <= this.size() - 1;
    }

    public int getFetchedRowCount() {
        return this.size();
    }

    public int getRowCount() {
        return this.size();
    }

    public Row getRowAtRangeIndex(int n) {
        if (n >= this.size()) {
            return null;
        }
        return (Row)this.elementAt(n);
    }

    public Row getCurrentRow() {
        return this.mCurrentIndex >= 0 ? this.elementAt(this.mCurrentIndex) : null;
    }

    public int getCurrentRowIndex() {
        return this.mCurrentIndex;
    }

    public int getCurrentRowSlot() {
        return this.mCurrentIndex >= 0 ? 0 : 2;
    }

    public boolean setCurrentRow(Row row) {
        int n = this.indexOf(row);
        if (n > -1) {
            this.setCurrentRowAt(n, row);
            return true;
        }
        return false;
    }

    void setCurrentRowAt(int n, Row row) {
        Row row2 = this.getCurrentRow();
        this.mCurrentIndex = n;
        this.fireNavigationEvent(new NavigationEvent(this, row2, row));
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.createViewCriteriaRow();
    }

    public Row createRow() {
        return this.createViewCriteriaRow();
    }

    public void insertRow(Row row) {
        int n;
        if (this.mCurrentIndex < 0) {
            this.addElement(row);
            n = 0;
        } else {
            this.insertElementAt(row, this.mCurrentIndex);
            n = this.mCurrentIndex++;
        }
        Row row2 = this.getCurrentRow();
        int n2 = this.size();
        this.fireRowInserted(new InsertEvent(this, row, n, n2, n2 - 1));
        this.setCurrentRowAt(n, row);
        this.fireNavigationEvent(new NavigationEvent(this, row2, row));
    }

    public void removeCurrentRow() {
        if (this.mCurrentIndex > -1 && this.mCurrentIndex < this.size()) {
            Row row = this.getCurrentRow();
            this.removeElementAt(this.mCurrentIndex);
            int n = this.size();
            int n2 = this.mCurrentIndex--;
            if (n2 == n) {
                // empty if block
            }
            this.fireRowDeleted(new DeleteEvent(this, row, n2, n, n + 1, false));
            this.fireNavigationEvent(new NavigationEvent(this, row, this.getCurrentRow()));
        }
    }

    public void removeCurrentRowFromCollection() {
        this.removeCurrentRow();
    }

    public Row removeCurrentRowAndRetain() {
        Row row = this.getCurrentRow();
        this.removeCurrentRow();
        return row;
    }

    public int setRangeSize(int n) {
        return -1;
    }

    public int getRangeSize() {
        return -1;
    }

    public int getRangeStart() {
        return 0;
    }

    public int setRangeStart(int n) {
        return 0;
    }

    public int scrollRange(int n) {
        return 0;
    }

    public int scrollToRangePage(int n) {
        return 0;
    }

    public int scrollRangeTo(Row row, int n) {
        return 0;
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        if (n < this.size() && n > -1) {
            this.setCurrentRowAt(n, (Row)this.elementAt(n));
            return true;
        }
        return false;
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        this.insertElementAt(row, n);
    }

    public int getRangeIndexOf(Row row) {
        return this.indexOf(row);
    }

    public int getRowCountInRange() {
        return this.size();
    }

    public boolean isRangeAtBottom() {
        return true;
    }

    public boolean isRangeAtTop() {
        return true;
    }

    public Enumeration enumerateRowsInRange() {
        return this.elements();
    }

    public Row[] getAllRowsInRange() {
        Object[] objectArray = new Row[this.size()];
        this.copyInto(objectArray);
        return objectArray;
    }

    public Row getRow(Key key) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"getRow"});
    }

    public Row[] findByKey(Key key, int n) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"findByKey"});
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"findByViewCriteria"});
    }

    public Key createKey(AttributeList attributeList) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"createKey"});
    }

    public Row[] findByEntity(int n, int n2) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"findByEntity"});
    }

    public void setRowValidation(boolean bl) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ViewCriteria.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "26032", new Object[]{"setRowValidation"});
    }

    public boolean isRowValidation() {
        return false;
    }

    public int getIterMode() {
        return 1;
    }

    public void setIterMode(int n) {
    }

    protected ArrayList getListenersList() {
        return this.listeners;
    }

    public synchronized void addListener(Object object) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(object)) {
            this.listeners.add(object);
        }
    }

    public synchronized void removeListener(Object object) {
        if (this.listeners != null && this.listeners.contains(object)) {
            this.listeners.remove(object);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    void fireRowInserted(InsertEvent insertEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rowInserted(insertEvent);
            ++n;
        }
    }

    void fireRowDeleted(DeleteEvent deleteEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.rowDeleted(deleteEvent);
            ++n;
        }
    }

    void fireNavigationEvent(NavigationEvent navigationEvent) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.listeners.clone();
        int n = 0;
        while (n < arrayList.size()) {
            RowSetListener rowSetListener = (RowSetListener)arrayList.get(n);
            rowSetListener.navigated(navigationEvent);
            ++n;
        }
    }

    public void trimNoDataRows() {
        this.mCurrentIndex = -1;
        int n = this.size() - 1;
        while (n >= 0) {
            ViewCriteriaRow viewCriteriaRow = (ViewCriteriaRow)this.elementAt(n);
            if (!viewCriteriaRow.hasData()) {
                this.removeElementAt(n);
            }
            --n;
        }
    }

    public void setUseAttributeFormatHint(boolean bl) {
        if (bl != this.mUseFormatters) {
            this.mUseFormatters = bl;
            this.criteriaChanged();
        }
    }

    public boolean isUseAttributeFormatHint() {
        return this.mUseFormatters;
    }

    public void add(int n, Object object) {
        super.add(n, object);
        this.criteriaChanged();
    }

    public boolean add(Object object) {
        boolean bl = super.add(object);
        this.criteriaChanged();
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        this.criteriaChanged();
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = super.addAll(n, collection);
        this.criteriaChanged();
        return bl;
    }

    public void addElement(Object object) {
        super.addElement(object);
        this.criteriaChanged();
    }

    public void clear() {
        super.clear();
        this.criteriaChanged();
    }

    public void insertElementAt(Object object, int n) {
        super.insertElementAt(object, n);
        this.criteriaChanged();
    }

    public Object remove(int n) {
        Object e = super.remove(n);
        this.criteriaChanged();
        return e;
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.criteriaChanged();
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = super.removeAll(collection);
        this.criteriaChanged();
        return bl;
    }

    public void removeAllElements() {
        super.removeAllElements();
        this.criteriaChanged();
    }

    public boolean removeElement(Object object) {
        boolean bl = super.removeElement(object);
        this.criteriaChanged();
        return bl;
    }

    public void removeElementAt(int n) {
        super.removeElementAt(n);
        this.criteriaChanged();
    }

    protected void removeRange(int n, int n2) {
        super.removeRange(n, n2);
        this.criteriaChanged();
    }

    public boolean retainAll(Collection collection) {
        boolean bl = super.retainAll(collection);
        this.criteriaChanged();
        return bl;
    }

    public Object set(int n, Object object) {
        Object object2 = super.set(n, object);
        this.criteriaChanged();
        return object2;
    }

    public void setElementAt(Object object, int n) {
        super.setElementAt(object, n);
        this.criteriaChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

