/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeHelper;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.http.HttpUtil;

public class ServletContextScopeAdapter
implements ADFScope {
    private ServletContext mAdaptee;
    private final ADFScopeHelper mHelper;
    private final String mScopeName;

    public ServletContextScopeAdapter(String string, ServletContext servletContext) {
        this.mScopeName = string;
        this.mAdaptee = servletContext;
        this.mHelper = new ADFScopeHelper();
    }

    public int size() {
        int n = 0;
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            ++n;
        }
        return n;
    }

    public void clear() {
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            this.mAdaptee.removeAttribute((String)enumeration.nextElement());
        }
    }

    public boolean isEmpty() {
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        return !enumeration.hasMoreElements();
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            if (!object.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            if (!object.equals(this.mAdaptee.getAttribute((String)enumeration.nextElement()))) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(this.mAdaptee.getAttribute((String)enumeration.nextElement()));
        }
        return arrayList;
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            HttpUtil.getInstance().setAttribute(this.mAdaptee, k.toString(), map.get(k));
        }
    }

    public Set entrySet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            hashSet.add(this.mAdaptee.getAttribute((String)enumeration.nextElement()));
        }
        return hashSet;
    }

    public Set keySet() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.mAdaptee.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        return HttpUtil.getInstance().getAttribute(this.mAdaptee, object.toString());
    }

    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = this.get(object);
        this.mAdaptee.removeAttribute(object.toString());
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Object object3 = this.get(object);
        HttpUtil.getInstance().setAttribute(this.mAdaptee, object.toString(), object2);
        return object3;
    }

    public void invalidate() {
        this.mHelper.fireScopeInvalidated(this.mScopeName);
        this.mAdaptee = null;
    }

    public void addScopeListener(ADFScopeListener aDFScopeListener) {
        this.mHelper.addScopeListener(aDFScopeListener);
    }

    public void removeScopeListener(ADFScopeListener aDFScopeListener) {
        this.mHelper.removeScopeListener(aDFScopeListener);
    }
}

