/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.ADFScopeHelper;
import oracle.adf.share.ADFScopeListener;
import oracle.adf.share.Environment;
import oracle.adf.share.http.HttpUtil;
import oracle.adf.share.http.StateHolder;
import oracle.adf.share.logging.ADFLogger;

public final class HttpSessionScopeAdapter
implements Serializable,
HttpSessionBindingListener,
ADFScope {
    private static final String HTTP_SESSION_SCOPE_KEY;
    private static final ADFLogger mLogger;
    private static Hashtable mSessionAdapters;
    private static final String HOLDER = "adf.sessionscopeadapter.transient_holder";
    public static final String VALID = "__valid__";
    private final String mScopeName;
    private transient ADFScopeHelper mHelper;
    static final long serialVersionUID = -414166398739154544L;
    private static /* synthetic */ Class class$oracle$adf$share$http$HttpSessionScopeAdapter;

    private /* synthetic */ void $init$() {
        this.mHelper = new ADFScopeHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ADFScope getScope(HttpSession httpSession) {
        HttpUtil httpUtil = HttpUtil.getInstance();
        ADFScope aDFScope = (ADFScope)httpUtil.getAttribute(httpSession, HTTP_SESSION_SCOPE_KEY);
        if (aDFScope == null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                aDFScope = (ADFScope)httpUtil.getAttribute(httpSession, HTTP_SESSION_SCOPE_KEY);
                if (aDFScope == null) {
                    aDFScope = new HttpSessionScopeAdapter(ADFContext.SESSION_SCOPE);
                    httpUtil.setAttribute(httpSession, HTTP_SESSION_SCOPE_KEY, (Object)aDFScope);
                }
            }
        }
        return aDFScope;
    }

    private HttpSessionScopeAdapter(String string) {
        this.$init$();
        this.mScopeName = string;
    }

    public int size() {
        int n = 0;
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                n += stateHolder.size();
            }
        }
        return n;
    }

    public void clear() {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                httpSession.removeAttribute((String)enumeration.nextElement());
            }
        }
    }

    public boolean isEmpty() {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            return httpSession.getAttributeNames().hasMoreElements() ^ true;
        }
        return true;
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            if (httpSession.getAttribute(object.toString()) != null) {
                return true;
            }
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                return stateHolder.containsKey(object.toString());
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            if (object instanceof Serializable) {
                Enumeration enumeration = httpSession.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    if (!object.equals(HttpUtil.getInstance().getAttribute(httpSession, (String)enumeration.nextElement()))) continue;
                    return true;
                }
            } else {
                StateHolder stateHolder = this.getStateHolder(false);
                if (stateHolder != null) {
                    return stateHolder.containsValue(object);
                }
            }
        }
        return false;
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                arrayList.add(httpSession.getAttribute((String)enumeration.nextElement()));
            }
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                arrayList.add(stateHolder.values());
            }
        }
        return arrayList;
    }

    public void putAll(Map map) {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this.put(httpSession, k.toString(), map.get(k));
            }
        }
    }

    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = httpSession.getAttribute(string);
                hashSet.add(new Entry(string, object));
            }
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                Iterator iterator = stateHolder.keySet().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    hashSet.add(new Entry(e.toString(), stateHolder.get(e)));
                }
            }
        }
        return hashSet;
    }

    private HttpSession getSession() {
        HttpServletRequest httpServletRequest;
        Environment environment = ADFContext.getCurrent().getEnvironment();
        HttpSession httpSession = null;
        if (environment != null && (httpServletRequest = (HttpServletRequest)environment.getRequest()) != null && (httpSession = httpServletRequest.getSession(true)) == null && mLogger.isLoggable(ADFLogger.ERROR)) {
            mLogger.log(ADFLogger.ERROR, "HttpSessionScopeAdapter:  Request is in an invalid state.  Could not access the request session.");
        }
        return httpSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateHolder getStateHolder(boolean bl) {
        StateHolder stateHolder = null;
        HttpSession httpSession = this.getSession();
        if (httpSession != null && (stateHolder = (StateHolder)HttpUtil.getInstance().getAttribute(httpSession, HOLDER)) == null && bl) {
            HttpSessionScopeAdapter httpSessionScopeAdapter = this;
            synchronized (httpSessionScopeAdapter) {
                stateHolder = (StateHolder)HttpUtil.getInstance().getAttribute(httpSession, HOLDER);
                if (stateHolder == null) {
                    stateHolder = new StateHolder();
                    HttpUtil.getInstance().setAttribute(httpSession, HOLDER, (Object)stateHolder);
                }
            }
        }
        return stateHolder;
    }

    public Set keySet() {
        HashSet hashSet = new HashSet();
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(enumeration.nextElement());
            }
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                hashSet.add(stateHolder.keySet());
            }
        }
        return hashSet;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        HttpSession httpSession = this.getSession();
        Object object2 = null;
        if (httpSession != null) {
            object2 = this.get(httpSession, object.toString());
        }
        return object2;
    }

    private Object get(HttpSession httpSession, String string) {
        StateHolder stateHolder;
        Object object = HttpUtil.getInstance().getAttribute(httpSession, string);
        if (object == null && (stateHolder = this.getStateHolder(false)) != null) {
            object = stateHolder.get(string);
        }
        return object;
    }

    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            object2 = this.get(httpSession, object.toString());
            httpSession.removeAttribute(object.toString());
            StateHolder stateHolder = this.getStateHolder(false);
            if (stateHolder != null) {
                stateHolder.remove(object.toString());
            }
        }
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Object object3 = null;
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            object3 = this.put(httpSession, object.toString(), object2);
        }
        return object3;
    }

    public Object putTransient(Object object, Object object2) {
        return this.getStateHolder(true).putTransient(object.toString(), object2);
    }

    private Object put(HttpSession httpSession, String string, Object object) {
        Object object2 = this.get(httpSession, string);
        if (object instanceof Serializable) {
            HttpUtil.getInstance().setAttribute(httpSession, string, object);
        } else {
            this.getStateHolder(true).putTransient(string, object);
        }
        return object2;
    }

    public void invalidate() {
        if (this.mHelper == null) {
            return;
        }
        this.mHelper.fireScopeInvalidated(this.mScopeName);
        this.mHelper = null;
        ADFContext.getCurrent().removeScope(this.mScopeName);
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            httpSession.removeAttribute(HTTP_SESSION_SCOPE_KEY);
        }
    }

    public void addScopeListener(ADFScopeListener aDFScopeListener) {
        this.mHelper.addScopeListener(aDFScopeListener);
    }

    public void removeScopeListener(ADFScopeListener aDFScopeListener) {
        this.mHelper.removeScopeListener(aDFScopeListener);
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSessionScopeAdapter httpSessionScopeAdapter = (HttpSessionScopeAdapter)mSessionAdapters.remove(httpSessionEvent.getSession());
        if (httpSessionScopeAdapter != null) {
            httpSessionScopeAdapter.invalidate();
        }
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        this.invalidate();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mHelper = new ADFScopeHelper();
    }

    static {
        Class clazz = class$oracle$adf$share$http$HttpSessionScopeAdapter;
        if (clazz == null) {
            clazz = class$oracle$adf$share$http$HttpSessionScopeAdapter = HttpSessionScopeAdapter.class$("oracle.adf.share.http.HttpSessionScopeAdapter");
        }
        HTTP_SESSION_SCOPE_KEY = clazz.getName();
        Class clazz2 = class$oracle$adf$share$http$HttpSessionScopeAdapter;
        if (clazz2 == null) {
            clazz2 = class$oracle$adf$share$http$HttpSessionScopeAdapter = HttpSessionScopeAdapter.class$("oracle.adf.share.http.HttpSessionScopeAdapter");
        }
        mLogger = ADFLogger.createADFLogger((String)clazz2.getName());
        mSessionAdapters = new Hashtable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Entry
    implements Map.Entry {
        private final String key;
        private Object value;

        Entry(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

