/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.DefaultContext;
import oracle.adf.share.Environment;
import oracle.adf.share.HashMapScopeAdapter;
import oracle.adf.share.MDSSessionCustomizer;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.el.ADFContextVariableResolverImpl;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.adf.share.el.OracleExpressionEvaluatorImpl;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.statemanager.StateManagerScopeAdapter;
import oracle.mds.config.CustClassListMapping;
import oracle.mds.config.CustConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.core.MDSSession;

public abstract class ADFContext {
    public static final int TYPE_GENERIC = 1;
    public static final int TYPE_HTTP = 2;
    public static final int TYPE_PORTLET = 3;
    private static final String MDS_SESSION_CUSTOMIZER = "oracle.adf.share.MdsSessionCustomizer";
    public static String SESSION_SCOPE = "sessionScope";
    public static String REQUEST_SCOPE = "requestScope";
    public static String APPLICATION_SCOPE = "applicationScope";
    private SecurityContext securityContext;
    private Object mdsSession;
    private transient Map scopeMap;
    private transient ADFExpressionEvaluator mExpressionEvaluator;
    private transient VariableResolver mVariableResolver;
    private static ThreadLocal contextStore = new InheritableThreadLocal();

    private /* synthetic */ void $init$() {
        this.mdsSession = null;
        this.scopeMap = new HashMap(3);
        this.mExpressionEvaluator = new OracleExpressionEvaluatorImpl();
        this.mVariableResolver = null;
    }

    protected abstract Environment loadEnvironment();

    public void putScope(String string, Map map) {
        this.scopeMap.put(string, map);
    }

    public Map getScope(String string) {
        Map map = (Map)this.scopeMap.get(string);
        if (map == null) {
            map = this.createScope(string);
            this.scopeMap.put(string, map);
        }
        return map;
    }

    public Map createScope(String string) {
        return new HashMapScopeAdapter(string, new HashMap(4));
    }

    public Map removeScope(String string) {
        return (Map)this.scopeMap.remove(string);
    }

    public Set getScopeNames() {
        return this.scopeMap.keySet();
    }

    public Map getApplicationScope() {
        return this.getScope(APPLICATION_SCOPE);
    }

    public Map getSessionScope() {
        return this.getScope(SESSION_SCOPE);
    }

    public Map getRequestScope() {
        return this.getScope(REQUEST_SCOPE);
    }

    public ADFConfig getApplication() {
        return this.getADFConfig();
    }

    public ADFConfig getADFConfig() {
        return ADFConfigFactory.findOrCreateADFConfig();
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            try {
                this.securityContext = (SecurityContext)this.getADFConfig().getSecurityContext();
                this.setSecurityContext(this.securityContext);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
        }
        return this.securityContext;
    }

    public Context getConnectionsContext() throws NamingException {
        return this.getADFConfig().getConnectionsContext();
    }

    public static boolean hasCurrent() {
        ADFContext aDFContext = (ADFContext)ADFContext.getContextStore().get();
        return aDFContext != null;
    }

    public static ADFContext getCurrent() {
        ADFContext aDFContext = (ADFContext)ADFContext.getContextStore().get();
        if (aDFContext == null) {
            aDFContext = new DefaultContext();
            aDFContext.setAsCurrent();
        }
        return aDFContext;
    }

    public String getApplicationName() {
        return null;
    }

    public void setAsCurrent() {
        ADFContext.getContextStore().set(this);
    }

    public void removeAsCurrent() {
        ADFContext.getContextStore().set(null);
    }

    protected void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    protected SecurityContext loadSecurityContext() {
        JAASInitialContextFactory jAASInitialContextFactory = new JAASInitialContextFactory();
        SecurityContext securityContext = null;
        try {
            securityContext = (SecurityContext)jAASInitialContextFactory.getInitialContext(null);
            this.setSecurityContext(securityContext);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        return securityContext;
    }

    public Context getConfigSecurityContext() throws NamingException {
        return this.getADFConfig().getSecurityContext();
    }

    public final Environment getEnvironment() {
        return this.loadEnvironment();
    }

    public boolean hasEnvironment() {
        return false;
    }

    public VariableResolver getVariableResolver() {
        if (this.mVariableResolver == null) {
            this.mVariableResolver = new ADFContextVariableResolverImpl();
        }
        return this.mVariableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        if (variableResolver != null) {
            this.mVariableResolver = variableResolver;
        }
    }

    public ADFExpressionEvaluator getExpressionEvaluator() {
        return this.mExpressionEvaluator;
    }

    public void setExpressionEvaluator(ADFExpressionEvaluator aDFExpressionEvaluator) {
        if (aDFExpressionEvaluator != null) {
            this.mExpressionEvaluator = aDFExpressionEvaluator;
        }
    }

    public Map getStateManager(String string, Hashtable hashtable) {
        return new StateManagerScopeAdapter(string, hashtable);
    }

    public abstract int getContextType();

    public boolean isHttpContext() {
        return false;
    }

    public boolean hasSession() {
        return false;
    }

    public Object getMDSInstanceAsObject() {
        return this.getADFConfig().getMDSInstance();
    }

    public Object getMDSSessionAsObject() {
        if (this.mdsSession == null) {
            this.mdsSession = this.createMDSSession();
        }
        return this.mdsSession;
    }

    public boolean hasMDSSession() {
        return this.mdsSession != null;
    }

    public void setMDSSessionCustomizer(MDSSessionCustomizer mDSSessionCustomizer) {
        if (mDSSessionCustomizer != null) {
            this.getSessionScope().put(MDS_SESSION_CUSTOMIZER, mDSSessionCustomizer);
        } else {
            this.getSessionScope().remove(MDS_SESSION_CUSTOMIZER);
        }
    }

    public MDSSessionCustomizer getMDSSessionCustomizer(MDSSessionCustomizer mDSSessionCustomizer) {
        return (MDSSessionCustomizer)this.getSessionScope().get(MDS_SESSION_CUSTOMIZER);
    }

    protected Object createMDSSession() {
        CustConfig custConfig = null;
        try {
            List list;
            MDSSessionCustomizer mDSSessionCustomizer = (MDSSessionCustomizer)this.getSessionScope().get(MDS_SESSION_CUSTOMIZER);
            if (mDSSessionCustomizer != null && (list = mDSSessionCustomizer.getCustomizationMappings()) != null) {
                CustClassListMapping[] custClassListMappingArray = list.toArray(new CustClassListMapping[0]);
                custConfig = new CustConfig(custClassListMappingArray);
            }
            MDSSession mDSSession = ((MDSInstance)this.getMDSInstanceAsObject()).createSession(null, null, custConfig, null);
            return mDSSession;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static ThreadLocal getContextStore() {
        return contextStore;
    }

    public ADFContext() {
        this.$init$();
    }
}

