/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import oracle.adf.model.binding.PermissionMap;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;

public class PermissionHelper {
    public static final int ATTRIBUTE_PERMISSION = 0;
    public static final int ROWSET_PERMISSION = 1;
    public static final int REGION_PERMISSION = 2;
    public static final int METHOD_PERMISSION = 3;
    public static final String UPDATE_ACTION = "Update";
    public static final String READ_ACTION = "Read";
    public static final String WRITE_ACTION = "Write";
    public static final String CREATE_ACTION = "Create";
    public static final String DELETE_ACTION = "Delete";
    public static final String EDIT_ACTION = "Edit";
    public static final String VIEW_ACTION = "View";
    public static final String INVOKE_ACTION = "Invoke";
    private static final String ADF_PERMISSION_CLASS = "oracle.adf.share.security.authorization.ADFPermission";
    public static final int NOT_CHECKED = -1;
    public static final int NO_PERMISSION = 0;
    public static final int HAS_PERMISSION = 1;
    private static final int AUTHORIZATION_NOT_INITIALIZED = -1;
    private static final int AUTHORIZATION_NOT_ENABLED = 0;
    private static final int AUTHORIZATION_ENABLED = 1;
    private static int mAuthorizationFlag = -1;
    public static final String PERMISSION_CACHE = "_permission_cache_";
    public static final String PERMISSION_TIMESTAMP = "_permission_timestamp_";
    static final PermissionMap[] mPermissionMap = new PermissionMap[]{new PermissionMap(0, "oracle.adf.share.security.authorization.AttributePermission"), new PermissionMap(1, "oracle.adf.share.security.authorization.RowSetPermission"), new PermissionMap(2, "oracle.adf.share.security.authorization.RegionPermission"), new PermissionMap(3, "oracle.adf.share.security.authorization.MethodPermission")};

    public static Object createPermissionInstance(String string, String string2, String string3) {
        Permission permission = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName("java.lang.String");
            Class[] classArray = new Class[]{clazz2, clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            permission = (Permission)constructor.newInstance(string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new IllegalStateException(exception.getMessage());
        }
        return permission;
    }

    public static boolean hasPermission(SecurityContext securityContext, String string, String string2) {
        if (!securityContext.isAuthorizationEnabled()) {
            return true;
        }
        Permission permission = (Permission)PermissionHelper.createPermissionInstance(ADF_PERMISSION_CLASS, string, string2);
        return PermissionHelper.hasPermission(securityContext, permission);
    }

    public static boolean hasPermission(SecurityContext securityContext, Permission permission) {
        if (!PermissionHelper.isAuthorizationEnabled()) {
            return true;
        }
        HashMap<Permission, Boolean> hashMap = null;
        Long l = null;
        Map map = ADFContext.getCurrent().getSessionScope();
        if (map != null) {
            hashMap = (HashMap<Permission, Boolean>)map.get(PERMISSION_CACHE);
            l = (Long)map.get(PERMISSION_TIMESTAMP);
        }
        if (l != null && !securityContext.isReAuthenticated(l.longValue())) {
            Object var5_5;
            Object v0 = var5_5 = hashMap != null ? hashMap.get(permission) : null;
            if (var5_5 != null) {
                return var5_5;
            }
        } else {
            map.put(PERMISSION_TIMESTAMP, new Long(System.currentTimeMillis()));
            if (hashMap != null) {
                hashMap.clear();
            }
        }
        boolean bl = securityContext.hasPermission(permission);
        if (hashMap == null) {
            hashMap = new HashMap<Permission, Boolean>();
            if (map != null) {
                map.put(PERMISSION_CACHE, hashMap);
                map.put(PERMISSION_TIMESTAMP, new Long(System.currentTimeMillis()));
            }
        }
        hashMap.put(permission, bl);
        return bl;
    }

    public static String getPermissionClassName(int n) {
        if (n < mPermissionMap.length) {
            return PermissionHelper.mPermissionMap[n].mPermissionClass;
        }
        return null;
    }

    public static String getReadAction(String string) {
        int n = 0;
        while (n < mPermissionMap.length) {
            if (PermissionHelper.mPermissionMap[n].mPermissionClass.equals(string) && n == 2) {
                return VIEW_ACTION;
            }
            ++n;
        }
        return READ_ACTION;
    }

    public static final boolean isAuthorizationEnabled() {
        SecurityContext securityContext;
        if (mAuthorizationFlag == -1 && (securityContext = ADFContext.getCurrent().getSecurityContext()) != null) {
            mAuthorizationFlag = securityContext.isAuthorizationEnabled() ? 1 : 0;
        }
        return mAuthorizationFlag == 1;
    }
}

