/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.awt.Component;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.adf.model.BindingContext;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCExecutableBinding;
import oracle.adf.model.binding.DCIExecutableDef;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.binding.PermissionBinding;
import oracle.adf.model.generic.DCGenericDataControl;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboEvent;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoObjException;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowNotAvailableException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.SortCriteria;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ValidationException;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.ws.WSProxy;
import oracle.jbo.common.ws.WSRowSet;
import oracle.jbo.common.ws.WSViewObjectImpl;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;

public abstract class DCIteratorBinding
extends DCExecutableBinding
implements RowSetManagementListener,
RowSetListener {
    protected ApplicationModule mAM;
    private String mSourceName;
    private String mRSIName;
    private ViewObject mVO;
    private ViewCriteria mVC;
    private SortCriteria[] mSC;
    private String mViewDefName;
    private NavigatableRowIterator mRSI;
    private NavigatableRowIterator mOldRSI;
    private ArrayList mValueBindingList;
    private ArrayList mActionBindingList;
    private boolean mIsBound;
    private boolean mIsAlive;
    private boolean mFindMode;
    private boolean mAllowFindMode;
    private boolean mRowSetEventsEnabled;
    protected int mRangeSize;
    private boolean mInitVisible;
    private boolean mNeedsEstimatedRC;
    protected DCDataControl mDC;
    private boolean mDCNotInitialized;
    protected boolean inExecute;
    private DCIteratorBindingDef mDef;
    private JboException mErrExc;
    private boolean mRowNotPrepared;
    private boolean mSuspendRowSetEvents;
    private Row mReservedRow;
    protected Row mCreatedRowRef;
    private boolean mTokenDisabled;
    public static int RANGESIZE_DO_NOT_OVERRIDE = 0;
    public static int RANGESIZE_UNLIMITED = -1;
    private static String ROOTAM = "Root";
    private boolean mCallInitSourceRSI;
    static final String FIND_MODE_INDICATOR_DATA = "-D-";
    static final String FIND_MODE_INDICATOR_NA = "-N-";
    static final String FIND_MODE_INDICATOR_FIND = "-F-";
    static final int FIND_MODE_INDICATOR_LENGTH = "-D-".length();
    static final String CREATED_ROW_INDICATOR = "%C%";
    static final int CREATED_ROW_INDICATOR_LENGTH = "%C%".length();
    static final String GET_Def = "Def";
    static final String GET_Name = "Name";
    static final String GET_AllRowsInRange = "allRowsInRange";
    static final String GET_CurrentRow = "currentRow";
    static final String GET_CurrentRowKeyString = "currentRowKeyString";
    static final String GET_EstimatedRowCount = "estimatedRowCount";
    static final String GET_NavigatableRowIterator = "navigatableRowIterator";
    static final String GET_RowSetIterator = "rowSetIterator";
    static final String GET_RangeSize = "rangeSize";
    static final String GET_RangeStart = "rangeStart";
    static final String GET_BindingContainer = "bindingContainer";
    static final String GET_FindMode = "findMode";
    static final String GET_ViewObject = "viewObject";
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

    private /* synthetic */ void $init$() {
        this.mIsBound = true;
        this.mIsAlive = true;
        this.mFindMode = false;
        this.mAllowFindMode = true;
        this.mRowSetEventsEnabled = true;
        this.mRangeSize = RANGESIZE_DO_NOT_OVERRIDE;
        this.mInitVisible = false;
        this.mNeedsEstimatedRC = false;
        this.mDCNotInitialized = true;
        this.inExecute = false;
        this.mRowNotPrepared = true;
        this.mSuspendRowSetEvents = false;
        this.mCallInitSourceRSI = true;
    }

    protected DCIteratorBinding() {
        this.$init$();
        this.mName = "";
    }

    protected DCIteratorBinding(DCIteratorBinding dCIteratorBinding) {
        this.$init$();
        this.mAM = dCIteratorBinding.mAM;
        this.mSourceName = dCIteratorBinding.mSourceName;
        this.mRSIName = dCIteratorBinding.mRSIName;
        this.mRangeSize = dCIteratorBinding.mRangeSize;
    }

    protected DCIteratorBinding(BindingContext bindingContext, String string, String string2, String string3, int n) {
        this.$init$();
        this.mDC = (DCDataControl)DCUtil.findContextObject(bindingContext, string);
        if (this.mDC != null) {
            this.mAM = this.mDC.getApplicationModule();
        }
        this.mSourceName = string2;
        this.mRSIName = string3;
        this.mRangeSize = n;
    }

    protected DCIteratorBinding(ApplicationModule applicationModule, String string, String string2, int n) {
        this.$init$();
        this.mAM = applicationModule;
        this.mSourceName = string;
        this.mRSIName = string2;
        this.mRangeSize = n;
    }

    protected DCIteratorBinding(ApplicationModule applicationModule, String string, String string2) {
        this(applicationModule, string, string2, 1);
    }

    protected DCIteratorBinding(DCDataControl dCDataControl, RowSetIterator rowSetIterator) {
        this.$init$();
        this.mDC = dCDataControl;
        if (this.mDC != null) {
            this.mAM = this.mDC.getApplicationModule();
        }
        if (rowSetIterator != null) {
            this.bindRowSetIterator(rowSetIterator, false);
            ViewObject viewObject = this.getViewObject();
            if (viewObject != null) {
                this.mAM = viewObject.getApplicationModule();
            }
            this.mRangeSize = rowSetIterator.getRangeSize();
        }
    }

    protected void setDef(DCIteratorBindingDef dCIteratorBindingDef) {
        this.mDef = dCIteratorBindingDef;
        this.setExecutableDef(dCIteratorBindingDef);
    }

    public DCIteratorBindingDef getDef() {
        return this.mDef;
    }

    public void prepareForInput() {
        if (this.mRowNotPrepared) {
            this.mRowNotPrepared = false;
            this.getBindingContainer().prepareForInput();
        }
    }

    public boolean isAccessorIterator() {
        return this.getDef() != null && this.getDef().isAccessorType();
    }

    boolean doneInput() {
        boolean bl = this.insertCreatedRow();
        this.mRowNotPrepared = true;
        return bl;
    }

    public final String getDisplayName() {
        if (this.isIteratorMadeVisible() && this.getViewObject() != null) {
            return this.getViewObject().getName();
        }
        return this.getName();
    }

    public String getVOName() {
        return this.mSourceName;
    }

    public String getSourceName() {
        return this.mSourceName;
    }

    public final String getViewDefName() {
        return this.mViewDefName;
    }

    void setViewDefName(String string) {
        this.mViewDefName = string;
    }

    public void reportException(boolean bl, Exception exception) {
        JboException jboException = exception instanceof JboException ? (JboException)exception : new JboException(exception);
        if (jboException.getSource() == null) {
            jboException.setSource(this.getRowSetIterator());
        }
        if (bl) {
            this.mIsAlive = false;
        }
        if (this.getBindingContainer() == null) {
            throw jboException;
        }
        this.getBindingContainer().reportException(jboException);
    }

    public void bindRowSetIterator(NavigatableRowIterator navigatableRowIterator, boolean bl) {
        DCDataControl dCDataControl;
        NavigatableRowIterator navigatableRowIterator2 = this.mRSI;
        if (this.mRSI != null) {
            if (this.mRSI instanceof RowSetIterator) {
                ((RowSetIterator)this.mRSI).removeManagementListener(this);
            }
            this.mRSI.removeListener(this);
            this.removeDependentListeners();
        }
        this.mRSI = navigatableRowIterator;
        this.mIsBound = navigatableRowIterator != null;
        if (this.mIsBound) {
            if (!this.mFindMode) {
                RowSetIterator rowSetIterator = (RowSetIterator)navigatableRowIterator;
                if (rowSetIterator instanceof Proxy) {
                    RowSetIterator rowSetIterator2 = null;
                    WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(rowSetIterator);
                    rowSetIterator = rowSetIterator2 = wSProxy.getInternalRowSetIter();
                    this.mRSI = rowSetIterator;
                }
                if (rowSetIterator.getRowSet() != null) {
                    this.mVO = rowSetIterator.getRowSet().getViewObject();
                    this.mSourceName = this.createAbsoluteVOName(this.mVO.getFullName());
                }
                this.mRSIName = rowSetIterator.getName();
                rowSetIterator.addManagementListener(this);
            }
            this.mRSI.addListener(this);
            if (bl && this.mRangeSize != RANGESIZE_DO_NOT_OVERRIDE) {
                this.mRSI.setRangeSize(this.mRangeSize);
            }
            this.addDependentListeners();
            this.setAlive(true);
        }
        if (navigatableRowIterator != navigatableRowIterator2 && (this.isIteratorMadeVisible() || this.allowsRefreshControl()) && (dCDataControl = this.getDataControl()) != null && dCDataControl.isJClientApp()) {
            this.rangeRefreshed(null);
        }
    }

    public final boolean isBoundRowIteratorEvent(JboEvent jboEvent) {
        return this.hasRSI() && this.getDataControl().isBoundRowIteratorEvent(this, jboEvent);
    }

    public final boolean isIteratorMadeVisible() {
        return this.mInitVisible;
    }

    protected void setIteratorMadeVisible(boolean bl) {
        this.mInitVisible = bl;
    }

    public final boolean isRowSetEventsEnabled() {
        return this.mRowSetEventsEnabled;
    }

    public final void setRowSetEventsEnabled(boolean bl) {
        this.mRowSetEventsEnabled = bl;
    }

    public void suspendRowSetEventsHandling(boolean bl) {
        this.mSuspendRowSetEvents = bl;
    }

    public boolean isSuspendRowSetEventsHandling() {
        return this.mSuspendRowSetEvents;
    }

    void resetInputState() {
        ArrayList arrayList;
        this.mErrExc = null;
        this.mRowNotPrepared = true;
        if (this.mCreatedRowRef != null) {
            this.releaseCachedRow();
        }
        if (this.getDataControl() != null) {
            this.getDataControl().removeBindingWithExc(this.getFullName());
        }
        if ((arrayList = this.mValueBindingList) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                ((DCControlBinding)arrayList.get(n)).resetInputState();
                ++n;
            }
        }
        if ((arrayList = this.mActionBindingList) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                ((DCControlBinding)arrayList.get(n)).resetInputState();
                ++n;
            }
        }
    }

    public boolean allowsRefreshControl() {
        return true;
    }

    protected Row prepareCurrentRow() {
        return this.getCurrentRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void refreshControl() {
        if (!this.allowsRefreshControl()) {
            return;
        }
        this.setRefreshed(true);
        var1_1 = this.getBindingContainer();
        var16_2 = this.getSyncLock();
        synchronized (var16_2) {
            var2_3 = this.getDataControl();
            var3_4 = this.getNavigatableRowIterator();
            if (var3_4 != null) {
                var4_5 = false;
                this.mCreatedRowRef = null;
                if (!this.mFindMode && this.getViewObject() != null && var2_3 != null && (var5_6 = var2_3.getTransientCreatedRowObjects()) != null && (var6_7 = var5_6.get(this.getCachedRSIName((RowSetIterator)var3_4))) != null) {
                    if (var6_7 instanceof Row) {
                        this.mCreatedRowRef = (Row)var6_7;
                        var7_8 = this.mCreatedRowRef.getKey();
                        if ((Integer)var7_8.getRowHandle() > 0) {
                            this.getDataControl().setTransientCreatedRowObject(this.getCachedRSIName(this.getRowSetIterator()), var7_8);
                        }
                    } else if (var6_7 instanceof Key && (var8_9 = var3_4.findByKey((Key)var6_7, 1)) != null && var8_9.length == 1) {
                        this.mCreatedRowRef = var8_9[0];
                    }
                }
                if (this.mCreatedRowRef == null) {
                    var9_10 = -1;
                    try {
                        var9_10 = var3_4.getCurrentRowSlot();
                    }
                    catch (RowNotAvailableException var10_11) {
                        if (!var2_3.syncNeeded()) {
                            this.reportException(false, var10_11);
                        }
                        return;
                    }
                    if (var9_10 != 0) {
                        var4_5 = this.mInitVisible;
                        if (var1_1 != null && var2_3.isJClientApp()) {
                            var11_12 = (Component)var1_1.getViewComponent();
                            var4_5 = var4_5 != false || var11_12 != null && var11_12.isVisible() != false;
                        }
                    }
                }
                var12_13 = null;
                if (!this.inExecute) {
                    if (var4_5) {
                        try {
                            var12_13 = var3_4.first();
                        }
                        catch (RowNotAvailableException var13_14) {
                            if (!var2_3.syncNeeded()) {
                                this.reportException(false, var13_14);
                            }
                            var14_15 = true;
                            try {
                                if (!var3_4.hasNext()) {
                                    var12_13 = null;
                                    var14_15 = false;
                                }
                            }
                            catch (Exception var15_16) {
                                // empty catch block
                            }
                            if (!var14_15) ** GOTO lbl56
                            return;
                        }
                    } else {
                        var12_13 = this.prepareCurrentRow();
                    }
                }
lbl56:
                // 5 sources

                this.setIteratorMadeVisible(true);
                if (!var4_5 || this.mRangeSize != 1) {
                    this.updateValuesFromRows(this.getAllRowsInRange(), var12_13, true);
                } else if (var4_5 && this.mRangeSize == 1 && var12_13 == null) {
                    this.navigated(new NavigationEvent(var3_4, null, null));
                }
            }
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        DCBindingContainer dCBindingContainer;
        if (this.mSuspendRowSetEvents) {
            return;
        }
        this.refreshControl();
        if (this.mRowSetEventsEnabled && (dCBindingContainer = this.getBindingContainer()) != null) {
            dCBindingContainer.rangeRefreshed(this, rangeRefreshEvent);
        }
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        DCBindingContainer dCBindingContainer;
        if (this.mRowSetEventsEnabled && (dCBindingContainer = this.getBindingContainer()) != null) {
            dCBindingContainer.rangeScrolled(this, scrollEvent);
        }
    }

    public void rowInserted(InsertEvent insertEvent) {
        if (!this.isFindMode() && this.getDataControl() != null) {
            this.mDC.transactionStateChanged(true);
        }
        if (this.mSuspendRowSetEvents) {
            return;
        }
        if (this.mRowSetEventsEnabled) {
            DCBindingContainer dCBindingContainer;
            if (this.mCreatedRowRef != null) {
                this.releaseCachedRow();
            }
            if ((dCBindingContainer = this.getBindingContainer()) != null) {
                dCBindingContainer.rowInserted(this, insertEvent);
            }
        }
    }

    public void internalGetNextRangeSet() {
        int n;
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        int n2 = rowSetIterator.getRangeStart();
        try {
            this.suspendRowSetEventsHandling(true);
            rowSetIterator.getNextRangeSet();
            Object var5_3 = null;
            this.suspendRowSetEventsHandling(false);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.suspendRowSetEventsHandling(false);
            throw throwable;
        }
        if (this.getDataControl().isJClientApp()) {
            this.rangeRefreshed(null);
        }
        if ((n = rowSetIterator.getRowCountInRange()) > 0 && this.getRangeStart() != n2) {
            if (rowSetIterator.getRowAtRangeIndex(0) != null) {
                rowSetIterator.setCurrentRowAtRangeIndex(0);
                this.rangeScrolled(new ScrollEvent(rowSetIterator, n2));
            } else {
                rowSetIterator.setRangeStart(rowSetIterator.getRangeStart());
                this.getDataControl().sync("DCIteratorBinding.internalGetNextRangeSet");
            }
        }
    }

    public void internalGetPreviousRangeSet() {
        NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
        int n = navigatableRowIterator.getRangeStart();
        int n2 = navigatableRowIterator.getCurrentRowIndex() - 1;
        try {
            this.suspendRowSetEventsHandling(true);
            ((RowSetIterator)navigatableRowIterator).getPreviousRangeSet();
            Object var6_4 = null;
            this.suspendRowSetEventsHandling(false);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.suspendRowSetEventsHandling(false);
            throw throwable;
        }
        if (this.getDataControl().isJClientApp()) {
            this.rangeRefreshed(null);
        }
        int n3 = navigatableRowIterator.getRangeSize();
        if (navigatableRowIterator.getRangeStart() == n - n3) {
            navigatableRowIterator.setCurrentRowAtRangeIndex(n3 - 1);
        } else {
            n = navigatableRowIterator.getRangeStart();
            if (n2 > n && n2 < n + n3) {
                navigatableRowIterator.setCurrentRowAtRangeIndex(n2 - n);
            } else {
                navigatableRowIterator.setCurrentRowAtRangeIndex(0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rowDeleted(DeleteEvent deleteEvent) {
        DCBindingContainer dCBindingContainer;
        block15: {
            DCBindingContainer dCBindingContainer2;
            NavigatableRowIterator navigatableRowIterator;
            block17: {
                block16: {
                    if (!this.isFindMode() && this.getDataControl() != null) {
                        this.mDC.transactionStateChanged(true);
                    }
                    if (this.mSuspendRowSetEvents) {
                        return;
                    }
                    navigatableRowIterator = this.getNavigatableRowIterator();
                    if (navigatableRowIterator.getCurrentRowSlot() != 1) break block15;
                    if (!navigatableRowIterator.hasNext()) break block16;
                    if (!this.getDataControl().syncNeeded()) {
                        navigatableRowIterator.next();
                        break block15;
                    } else {
                        try {
                            navigatableRowIterator.next();
                        }
                        catch (RowNotAvailableException rowNotAvailableException) {
                            int n = navigatableRowIterator.getCurrentRowIndex();
                            int n2 = navigatableRowIterator.getRangeStart();
                            if (n >= n2 && n < n2 + navigatableRowIterator.getRangeSize()) {
                                this.getDataControl().sync("DCIteratorBinding.rowDeleted().next, on RowNotAvailableException");
                                if (navigatableRowIterator.hasNext()) {
                                    navigatableRowIterator.next();
                                }
                                break block15;
                            }
                            navigatableRowIterator.setCurrentRowAtRangeIndex(0);
                        }
                    }
                    break block15;
                }
                if (!navigatableRowIterator.hasPrevious()) break block17;
                if (!this.getDataControl().syncNeeded()) {
                    navigatableRowIterator.previous();
                    break block15;
                } else {
                    try {
                        navigatableRowIterator.previous();
                    }
                    catch (RowNotAvailableException rowNotAvailableException) {
                        this.getDataControl().sync("DCIteratorBinding.rowDeleted().previous, on RowNotAvailableException");
                        if (navigatableRowIterator.hasPrevious()) {
                            navigatableRowIterator.previous();
                        }
                        break block15;
                    }
                }
            }
            if (this.mRowSetEventsEnabled && (dCBindingContainer2 = this.getBindingContainer()) != null) {
                dCBindingContainer2.rowDeleted(this, deleteEvent);
            }
            this.navigated(new NavigationEvent(navigatableRowIterator, null, null));
            navigatableRowIterator.reset();
            return;
        }
        if (this.mRowSetEventsEnabled && (dCBindingContainer = this.getBindingContainer()) != null) {
            dCBindingContainer.rowDeleted(this, deleteEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowUpdated(UpdateEvent updateEvent) {
        DCBindingContainer dCBindingContainer;
        if (!this.isFindMode()) {
            // empty if block
        }
        if (this.mSuspendRowSetEvents) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.notifyUpdateEvent(updateEvent);
        }
        if (this.mRowSetEventsEnabled && (dCBindingContainer = this.getBindingContainer()) != null) {
            dCBindingContainer.rowUpdated(this, updateEvent);
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        ArrayList arrayList;
        if (this.mSuspendRowSetEvents) {
            return;
        }
        if (this.mRowSetEventsEnabled) {
            DCBindingContainer dCBindingContainer;
            if (this.mCreatedRowRef != null) {
                this.releaseCachedRow();
            }
            if ((dCBindingContainer = this.getBindingContainer()) != null) {
                dCBindingContainer.navigated(this, navigationEvent);
            }
        }
        if ((arrayList = this.getActionBindingList()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                DCControlBinding dCControlBinding = (DCControlBinding)arrayList.get(n);
                if (dCControlBinding.mAttributeListener != null) {
                    dCControlBinding.mAttributeListener.updateRenderer();
                }
                ++n;
            }
        }
    }

    protected abstract void notifyUpdateEvent(UpdateEvent var1);

    protected abstract void updateValuesFromRows(Row[] var1, Row var2, boolean var3);

    protected abstract void updateValuesFromRow(Row var1);

    public final Object getSyncLock() {
        if (this.mAM != null) {
            return this.mAM.getSyncLock();
        }
        if (this.mDC != null) {
            return this.mDC.getRootDataControl();
        }
        return this;
    }

    public void iteratorReset(RowSetManagementEvent rowSetManagementEvent) {
        if (this.mSuspendRowSetEvents) {
            return;
        }
        if (this.mCreatedRowRef != null) {
            this.releaseCachedRow();
        }
        this.rangeRefreshed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iteratorClosed(RowSetManagementEvent rowSetManagementEvent) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.releaseDataInternal();
        }
    }

    public ViewCriteria getViewCriteria() {
        if (this.mVC == null) {
            if (this.mRSI == null && this.mOldRSI == null) {
                this.getRowSetIterator();
            }
            this.mVC = this.getDataControl().getViewCriteria(this);
        }
        return this.mVC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewObject getViewObject() {
        if (this.mVO == null) {
            RowSetIterator rowSetIterator = (RowSetIterator)(this.mFindMode ? this.mOldRSI : this.mRSI);
            if (rowSetIterator != null && rowSetIterator.getRowSet() != null) {
                this.mVO = rowSetIterator.getRowSet().getViewObject();
            }
            if (this.mVO == null && this.getApplicationModule() != null) {
                Object object = this.getSyncLock();
                synchronized (object) {
                    if (!(this.mIsAlive && this.mIsBound || !this.mIsAlive && !this.mIsBound)) {
                        ViewObject viewObject = null;
                        return viewObject;
                    }
                    if (this.mVO == null) {
                        try {
                            block23: {
                                String string = this.getVOName();
                                try {
                                    Object object2;
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("Resolving VO:" + string + " for iterator binding:" + this.getName());
                                    }
                                    if ((object2 = this.getBindingContainer().evaluateParameter(string, false, true)) instanceof ViewObject) {
                                        this.mVO = (ViewObject)object2;
                                    } else if (object2 instanceof String) {
                                        string = (String)object2;
                                    }
                                    if (this.mVO == null) {
                                        this.mVO = this.mAM.findViewObject(string);
                                    }
                                }
                                catch (NoObjException noObjException) {
                                    block22: {
                                        String string2;
                                        if (this.mDC != null && (string2 = string).startsWith(this.mDC.getName())) {
                                            string2 = string2.substring(this.mDC.getName().length() + 1);
                                            try {
                                                this.mVO = this.mAM.findViewObject(string2);
                                            }
                                            catch (Exception exception) {
                                                if (!Diagnostic.isOn()) break block22;
                                                Diagnostic.printStackTrace(exception);
                                            }
                                        }
                                    }
                                    if (this.mVO != null) break block23;
                                    throw noObjException;
                                }
                            }
                            if (this.mVO == null) {
                                if (this.mViewDefName == null) {
                                    throw new NoObjException(111, this.mSourceName);
                                }
                                this.mVO = this.mAM.createViewObject(this.mSourceName, this.mViewDefName);
                            }
                        }
                        catch (Exception exception) {
                            this.reportException(true, exception);
                        }
                    }
                }
            }
        }
        return this.mVO;
    }

    public void resolveRangeSize(int n) {
        int n2 = this.mRangeSize;
        if (n2 > RANGESIZE_DO_NOT_OVERRIDE && n2 != n) {
            RowSetIterator rowSetIterator;
            if (n == RANGESIZE_UNLIMITED) {
                n2 = RANGESIZE_UNLIMITED;
            } else if (n > n2) {
                n2 = n;
            }
            if (n2 != this.mRangeSize && (rowSetIterator = this.getRowSetIterator()) != null) {
                this.mRangeSize = n2;
                this.setRangeSizeForRSI(rowSetIterator, n2);
            }
        }
    }

    public boolean hasRSI() {
        return (RowSetIterator)(this.mFindMode ? this.mOldRSI : this.mRSI) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSetIterator getRowSetIterator() {
        RowSetIterator rowSetIterator = (RowSetIterator)(this.mFindMode ? this.mOldRSI : this.mRSI);
        if (rowSetIterator != null) {
            return rowSetIterator;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!(this.mIsAlive && this.mIsBound || !this.mIsAlive && !this.mIsBound)) {
                RowSetIterator rowSetIterator2 = null;
                return rowSetIterator2;
            }
            this.setAlive(true);
            if (this.mCallInitSourceRSI) {
                this.mIsBound = true;
                rowSetIterator = this.callInitSourceRSI();
                this.mIsBound = rowSetIterator != null;
            }
            RowSetIterator rowSetIterator3 = rowSetIterator;
            return rowSetIterator3;
        }
    }

    private RowSetIterator callInitSourceRSI() {
        DCIteratorBindingDef dCIteratorBindingDef = this.getDef();
        RowSetIterator rowSetIterator = null;
        try {
            block4: {
                try {
                    this.mCallInitSourceRSI = false;
                    rowSetIterator = this.initSourceRSI();
                    if (this.mSC != null || dCIteratorBindingDef == null || dCIteratorBindingDef.getSortCriteria() == null) break block4;
                    this.applySortCriteria(dCIteratorBindingDef.getSortCriteria());
                }
                catch (Exception exception) {
                    this.mIsBound = rowSetIterator != null;
                    this.reportException(true, exception);
                    Object var5_4 = null;
                    this.mCallInitSourceRSI = true;
                }
            }
            Object var5_3 = null;
            this.mCallInitSourceRSI = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mCallInitSourceRSI = true;
            throw throwable;
        }
        return rowSetIterator;
    }

    protected RowSetIterator initSourceRSI() {
        RowSetIterator rowSetIterator = null;
        if (this.getApplicationModule() != null) {
            ViewObject viewObject = this.getViewObject();
            if (viewObject == null) {
                return null;
            }
            if (this.mRSIName == null) {
                rowSetIterator = viewObject;
            } else if (!this.getDataControl().syncNeeded()) {
                rowSetIterator = viewObject.findRowSetIterator(this.mRSIName);
                if (rowSetIterator == null) {
                    rowSetIterator = viewObject.createRowSetIterator(this.mRSIName);
                }
            } else {
                rowSetIterator = ((WSRowSet)viewObject).findOrCreateRowSetIterator(this.mRSIName);
            }
        } else {
            String string = this.mSourceName;
            if (string != null) {
                Object object;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Resolving collection source:" + string + " for iterator binding:" + this.getName());
                }
                if ((object = this.getBindingContainer().evaluateParameter(string, false, true)) instanceof RowSetIterator) {
                    rowSetIterator = (RowSetIterator)object;
                } else if (object instanceof String) {
                    string = (String)object;
                }
                if (rowSetIterator == null) {
                    DCDataControl dCDataControl = this.getDataControl();
                    if (string != null && string.startsWith(dCDataControl.getName())) {
                        if (string.length() > dCDataControl.getName().length()) {
                            string = string.substring(dCDataControl.getName().length() + 1);
                        } else if (string.equals(dCDataControl.getName())) {
                            string = DCGenericDataControl.DC_ROOT_ACC_NAME;
                        }
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Looking for RSI with name :" + string + " for iterator binding:" + this.getName());
                    }
                    rowSetIterator = this.getDataControl().getRowSetIterator(string);
                }
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("Warning! DCIteratorBinding.initSourceRSI - <null> sourceName not expected");
            }
        }
        if (rowSetIterator != null) {
            if (this.mFindMode) {
                this.mOldRSI = rowSetIterator;
            } else {
                if (rowSetIterator instanceof Proxy) {
                    RowSetIterator rowSetIterator2 = null;
                    WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(rowSetIterator);
                    rowSetIterator = rowSetIterator2 = wSProxy.getInternalRowSetIter();
                }
                this.mRSI = rowSetIterator;
                rowSetIterator.addListener(this);
                rowSetIterator.addManagementListener(this);
                this.addDependentListeners();
                int n = rowSetIterator.getRangeSize();
                if (this.getDataControl().isJClientApp() && n > this.mRangeSize) {
                    this.resolveRangeSize(n);
                }
                if (n != this.mRangeSize && this.mRangeSize != RANGESIZE_DO_NOT_OVERRIDE) {
                    this.setRangeSizeForRSI(rowSetIterator, this.mRangeSize);
                }
            }
        }
        this.mIsBound = rowSetIterator != null;
        return rowSetIterator;
    }

    public NavigatableRowIterator getNavigatableRowIterator() {
        if (this.mFindMode) {
            return this.getViewCriteria();
        }
        return this.getRowSetIterator();
    }

    void removeDependentListeners() {
        List list = this.getDependents();
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                RowSetListener rowSetListener;
                Object e = list.get(n);
                if (e instanceof DCIteratorBinding && (rowSetListener = ((DCIteratorBinding)e).getMasterListener()) != null) {
                    this.mRSI.removeListener(rowSetListener);
                }
                ++n;
            }
        }
    }

    void addDependentListeners() {
        List list = this.getDependents();
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                RowSetListener rowSetListener;
                Object e = list.get(n);
                if (e instanceof DCIteratorBinding && (rowSetListener = ((DCIteratorBinding)e).getMasterListener()) != null) {
                    this.mRSI.addListener(rowSetListener);
                }
                ++n;
            }
        }
    }

    protected RowSetListener getMasterListener() {
        return null;
    }

    public final void setAllowFindMode(boolean bl) {
        this.mAllowFindMode = bl;
    }

    public final boolean isFindModeAllowed() {
        return this.mAllowFindMode;
    }

    public final void setFindMode(boolean bl) {
        this.setFindMode(bl, true);
    }

    public final void setFindMode(boolean bl, boolean bl2) {
        if (this.mAllowFindMode && bl != this.mFindMode) {
            NavigatableRowIterator navigatableRowIterator;
            if (bl && !this.getDataControl().isOperationSupported(this, (byte)3)) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Warning! Find mode not supported by DataControl associated with iterator binding:" + this.getName());
                }
                this.mAllowFindMode = false;
                return;
            }
            ViewObject viewObject = this.getViewObject();
            this.mFindMode = bl;
            if (bl) {
                this.mOldRSI = this.mRSI;
                navigatableRowIterator = this.getNavigatableRowIterator();
                this.setupFindMode();
            } else {
                navigatableRowIterator = this.mOldRSI;
                if (navigatableRowIterator == null && this.mCallInitSourceRSI) {
                    navigatableRowIterator = this.callInitSourceRSI();
                }
                if (bl2 && this.mVC != null) {
                    this.mVC.trimNoDataRows();
                    if (this.mVC.getRowCount() > 0) {
                        this.getDataControl().applyViewCriteria(this.mVC, this, viewObject != null ? viewObject : (RowSetIterator)navigatableRowIterator);
                    } else {
                        this.getDataControl().applyViewCriteria(null, this, viewObject != null ? viewObject : (RowSetIterator)navigatableRowIterator);
                    }
                } else if (viewObject != null && (navigatableRowIterator != null || !bl2 && this.getDataControl().syncNeeded())) {
                    this.getDataControl().applyViewCriteria(null, this, viewObject != null ? viewObject : (RowSetIterator)navigatableRowIterator);
                }
                this.mVC = null;
            }
            this.bindRowSetIterator(navigatableRowIterator, false);
        }
    }

    public final boolean isFindMode() {
        return this.mFindMode;
    }

    public final boolean needsEstimatedRowCount() {
        return this.mNeedsEstimatedRC;
    }

    void initForRefresh() {
        this.mIsBound = true;
        this.mIsAlive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mIsAlive && this.mIsBound) {
                try {
                    if (this.mCreatedRowRef != null) {
                        this.releaseCachedRow();
                    }
                    this.doExecuteQuery();
                }
                catch (Exception exception) {
                    this.reportException(false, exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueryIfNeeded() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mIsAlive && this.mIsBound) {
                this.getDataControl().executeIteratorBindingIfNeeded(this);
                if (!this.mInitVisible) {
                    this.setIteratorMadeVisible(true);
                }
                this.setRefreshed(true);
            }
        }
    }

    protected void doExecuteQuery() {
        this.getDataControl().executeIteratorBinding(this);
        if (!this.mInitVisible) {
            this.setIteratorMadeVisible(true);
        }
        this.setRefreshed(true);
    }

    public Row getCurrentRow() {
        if (this.mReservedRow != null) {
            return this.mReservedRow;
        }
        return this.internalGetCurrentRowInBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Row internalGetCurrentRowInBinding() {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if (!this.isFindMode() && this.mCreatedRowRef != null) {
            return this.mCreatedRowRef;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            NavigatableRowIterator navigatableRowIterator;
            NavigatableRowIterator navigatableRowIterator2 = navigatableRowIterator = this.mFindMode || this.hasRSI() ? this.getNavigatableRowIterator() : null;
            if (this.mIsAlive && this.mIsBound && navigatableRowIterator != null) {
                DCDataControl dCDataControl = this.getDataControl();
                try {
                    if (navigatableRowIterator.getCurrentRowSlot() == 2 && dCDataControl != null && !dCDataControl.isJClientApp()) {
                        try {
                            if (!this.inExecute) {
                                this.setIteratorMadeVisible(true);
                                this.inExecute = true;
                                if (navigatableRowIterator.getCurrentRowSlot() == 2 && this.refreshIfNeeded()) {
                                    navigatableRowIterator.first();
                                }
                            }
                            Object var7_4 = null;
                            this.inExecute = false;
                        }
                        catch (Throwable throwable) {
                            Object var7_5 = null;
                            this.inExecute = false;
                            throw throwable;
                        }
                    }
                    Row row = navigatableRowIterator.getCurrentRow();
                    return row;
                }
                catch (RowNotAvailableException rowNotAvailableException) {
                    if (!dCDataControl.syncNeeded()) {
                        this.reportException(false, rowNotAvailableException);
                    }
                }
                catch (Exception exception) {
                    this.reportException(false, exception);
                }
            }
            Row row = null;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mIsAlive && this.mIsBound && this.refreshIfNeeded()) {
                try {
                    Row row = this.getNavigatableRowIterator().getRowAtRangeIndex(n);
                    return row;
                }
                catch (Exception exception) {
                    this.reportException(false, exception);
                }
            }
            Row row = null;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] getAllRowsInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.refreshIfNeeded() && this.mIsAlive && this.mIsBound) {
                try {
                    NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
                    Row[] rowArray = navigatableRowIterator != null ? navigatableRowIterator.getAllRowsInRange() : null;
                    return rowArray;
                }
                catch (Exception exception) {
                    this.reportException(false, exception);
                }
            }
            Row[] rowArray = null;
            return rowArray;
        }
    }

    public void setBindingContainer(DCBindingContainer dCBindingContainer) {
        if (dCBindingContainer != null && this.mDC != null) {
            this.mDC.addBindingContainer(dCBindingContainer);
        }
        super.setBindingContainer(dCBindingContainer);
    }

    public final DCDataControl getDataControl() {
        if (this.mDC == null && this.mDCNotInitialized) {
            this.mDCNotInitialized = false;
            this.internalSetDataControl(this.initDataControl());
        }
        return this.mDC;
    }

    protected DCDataControl initDataControl() {
        String string;
        if (this.getDef() != null && (string = this.getDef().getDataControlName()) != null) {
            return this.getBindingContainer().findDataControl(string);
        }
        return this.getBindingContainer() != null ? this.getBindingContainer().getDataControl() : null;
    }

    void internalSetDataControl(DCDataControl dCDataControl) {
        this.mDC = dCDataControl;
        if (this.mDC != null && this.getBindingContainer().getRegionContainer() == null) {
            this.mDC.addBindingContainer(this.getBindingContainer());
        }
    }

    private String resolveViewObjectName() {
        String string = this.getVOName();
        if (DCUtil.isElExpr(string)) {
            ViewObject viewObject = this.getViewObject();
            return viewObject != null ? this.createAbsoluteVOName(viewObject.getFullName()) : this.getVOName();
        }
        return string;
    }

    private String createAbsoluteVOName(String string) {
        return string;
    }

    protected void fetchAttributeProperties() {
        ApplicationModule applicationModule;
        DCDataControl dCDataControl = this.getDataControl();
        if (dCDataControl != null && (dCDataControl.isClientTier() || dCDataControl.syncNeeded()) && (applicationModule = dCDataControl.getApplicationModule()) != null && this.mValueBindingList != null) {
            String[][] stringArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.mValueBindingList.size()) {
                String[] stringArray2 = ((JUCtrlValueBinding)this.mValueBindingList.get(n)).getAttributeNames();
                if (stringArray2 != null) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (!arrayList.contains(stringArray2[n2])) {
                            arrayList.add(stringArray2[n2]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                String[][] stringArray3 = new String[1][];
                stringArray = stringArray3;
                stringArray3[0] = arrayList.toArray(new String[arrayList.size()]);
            } else {
                stringArray = null;
            }
            String[][] stringArray4 = stringArray;
            String string = this.resolveViewObjectName();
            if (string != null) {
                DCBindingContainer dCBindingContainer = this.getBindingContainer();
                if (dCBindingContainer != null) {
                    applicationModule.fetchAttributeProperties(new String[]{string}, stringArray4, dCBindingContainer.getLocaleContext());
                } else if (this.mDC != null) {
                    applicationModule.fetchAttributeProperties(new String[]{string}, stringArray4, this.mDC.getLocaleContext());
                } else {
                    applicationModule.fetchAttributeProperties(new String[]{string}, stringArray4, applicationModule.getSession().getLocaleContext());
                }
            }
        }
    }

    public ArrayList getValueBindingList() {
        return (ArrayList)(this.mValueBindingList != null ? this.mValueBindingList.clone() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueBinding(DCControlBinding dCControlBinding) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mValueBindingList == null) {
                this.mValueBindingList = new ArrayList(4);
            }
            if (dCControlBinding.needsEstimatedRowCount()) {
                this.mNeedsEstimatedRC = true;
            }
            this.mValueBindingList.add(dCControlBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValueBinding(DCControlBinding dCControlBinding) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mValueBindingList == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mValueBindingList.remove(dCControlBinding);
            return bl;
        }
    }

    public ArrayList getActionBindingList() {
        return (ArrayList)(this.mActionBindingList != null ? this.mActionBindingList.clone() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionBinding(DCControlBinding dCControlBinding) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DCIteratorBinding dCIteratorBinding;
            if (this.mActionBindingList == null) {
                this.mActionBindingList = new ArrayList(4);
            }
            if ((dCIteratorBinding = dCControlBinding.getDCIteratorBinding()) != this) {
                if (dCIteratorBinding != null) {
                    dCIteratorBinding.removeActionBinding(dCControlBinding);
                }
                dCControlBinding.setDCIteratorBinding(this);
            }
            this.mActionBindingList.add(dCControlBinding);
        }
    }

    public void removeCurrentRow() {
        NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
        if (navigatableRowIterator != null) {
            DCDataControl dCDataControl;
            boolean bl = this.isFindMode();
            if (!bl && this.mCreatedRowRef != null) {
                if (this.mCreatedRowRef != null) {
                    this.releaseCachedRow();
                }
                this.rowDeleted(new DeleteEvent(navigatableRowIterator, this.mCreatedRowRef, -1, -1, -1));
                return;
            }
            if (!this.isRefreshed()) {
                this.refreshIfNeeded();
            }
            navigatableRowIterator.removeCurrentRow();
            if (bl && (dCDataControl = this.getDataControl()).syncNeeded()) {
                dCDataControl.getViewCriteria(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActionBinding(DCControlBinding dCControlBinding) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mActionBindingList == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mActionBindingList.remove(dCControlBinding);
            return bl;
        }
    }

    public RowSetIterator getLovRowSetIterator() {
        if (this.mRSIName == null) {
            this.mRSIName = this.getName();
        }
        return this.getRowSetIterator();
    }

    public void release() {
        this.release(DCDataControl.REL_ALL_REFS);
    }

    public void releaseData() {
        this.getDataControl().releaseData(this);
    }

    protected void releaseDataInternal() {
        List list;
        if (this.mCreatedRowRef != null) {
            this.releaseCachedRow();
        }
        if ((list = this.getDependents()) != null) {
            list = (List)((ArrayList)list).clone();
            int n = 0;
            while (n < list.size()) {
                Object e = list.get(n);
                if (e instanceof DCExecutableBinding) {
                    if (e instanceof DCIteratorBinding) {
                        ((DCIteratorBinding)e).releaseDataInternal();
                    }
                    this.removeDependentExecutable((DCExecutableBinding)e);
                }
                ++n;
            }
        }
        this.bindRowSetIterator(null, false);
        this.mAM = null;
        this.mVO = null;
        this.mRSI = null;
        this.mOldRSI = null;
        this.mVC = null;
        this.mErrExc = null;
        this.mRowNotPrepared = true;
        this.mIsAlive = false;
        this.mFindMode = false;
        this.mAllowFindMode = true;
    }

    public void invalidateCache() {
        NavigatableRowIterator navigatableRowIterator = this.mRSI;
        ViewObject viewObject = this.getViewObject();
        this.release(DCDataControl.REL_DATA_REFS);
        if (viewObject != null) {
            viewObject.clearCache();
        } else if (navigatableRowIterator != null && navigatableRowIterator instanceof RowSetIterator) {
            ((RowSetIterator)navigatableRowIterator).closeRowSetIterator();
        }
    }

    public void release(int n) {
        ArrayList arrayList;
        if (this.mValueBindingList != null) {
            arrayList = (ArrayList)this.mValueBindingList.clone();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                DCControlBinding dCControlBinding = (DCControlBinding)arrayList.get(n2);
                dCControlBinding.release(n);
                ++n2;
            }
        }
        if (this.mActionBindingList != null) {
            arrayList = (ArrayList)this.mActionBindingList.clone();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                DCControlBinding dCControlBinding = (DCControlBinding)arrayList.get(n3);
                dCControlBinding.release(n);
                ++n3;
            }
        }
        if ((n & DCDataControl.REL_DATA_REFS) > 0) {
            this.bindRowSetIterator(null, false);
            this.releaseDataInternal();
        } else if ((n & DCDataControl.REL_WEAK_DATA_REFS) > 0) {
            this.suspendRowSetEventsHandling(true);
            if (this.mCreatedRowRef != null) {
                this.mCreatedRowRef = null;
            }
        }
        if (n == DCDataControl.REL_ALL_REFS) {
            this.mValueBindingList = null;
            this.mActionBindingList = null;
        }
        super.release(n);
    }

    void validateCurrentRow() {
        if (this.getNavigatableRowIterator().getCurrentRowSlot() == 0) {
            if (!this.isRefreshed()) {
                this.refreshIfNeeded();
            }
            try {
                this.getNavigatableRowIterator().getCurrentRow().validate();
            }
            catch (JboException jboException) {
                this.mErrExc = jboException;
                this.reportException(false, this.mErrExc);
            }
            catch (Exception exception) {
                this.mErrExc = new JboException(exception);
                this.reportException(false, this.mErrExc);
            }
        }
    }

    public void processInputException() {
        this.processInputException(this.mErrExc);
    }

    public void processInputException(JboException jboException) {
        Object object = jboException.getSource();
        if (object instanceof RowSetIterator) {
            RowSetIterator rowSetIterator = (RowSetIterator)object;
            if (this.getRowSetIterator() != null && !rowSetIterator.getName().equals(this.getRowSetIterator().getName())) {
                return;
            }
        }
        if (jboException instanceof ValidationException && this.mValueBindingList != null) {
            ValidationException validationException = (ValidationException)jboException;
            ArrayList arrayList = this.mValueBindingList;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCControlBinding)arrayList.get(n)).processInputException(validationException);
                ++n;
            }
        } else {
            this.mErrExc = jboException;
        }
        if (this.getDataControl() != null) {
            this.getDataControl().addBindingWithExc(this.getFullName());
        }
    }

    public JboException getError() {
        return this.mErrExc;
    }

    final String getFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("data").append('.').append(this.getBindingContainer().getName()).append('.').append(this.getName());
        return stringBuffer.toString();
    }

    public AttributeDef[] getAttributeDefs() {
        if (this.mDC != null && this.mDC.getApplicationModule() != null) {
            this.refreshIfNeeded();
            if (this.getViewObject() != null) {
                return this.getViewObject().getAttributeDefs();
            }
        }
        if (this.mDC instanceof DCGenericDataControl) {
            return ((DCGenericDataControl)this.mDC).getAttributeDefs(this, null);
        }
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator instanceof DCRowSetIteratorImpl) {
            return ((DCRowSetIteratorImpl)this.getRowSetIterator()).getStructureDef().getAttributeDefs();
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("No ViewObject or Generic RowSetIterator found for this binding");
        }
        return null;
    }

    public String getIteratorDefName() {
        if (this.mDC != null && this.mDC.getApplicationModule() != null && this.getViewObject() != null) {
            return this.getViewObject().getDefFullName();
        }
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator instanceof DCRowSetIteratorImpl) {
            return ((StructureDefImpl)((DCRowSetIteratorImpl)this.getRowSetIterator()).getStructureDef()).getBeanClassName();
        }
        return null;
    }

    public AttributeDef[] getAttributeDefs(String[] stringArray) {
        LocaleContext localeContext;
        ViewObject viewObject = this.getViewObject();
        if (viewObject instanceof Proxy) {
            WSViewObjectImpl wSViewObjectImpl = null;
            WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(viewObject);
            wSViewObjectImpl = wSProxy.getWSViewObject();
            viewObject = wSViewObjectImpl;
        }
        AttributeDef[] attributeDefArray = null;
        DCBindingContainer dCBindingContainer = this.getBindingContainer();
        LocaleContext localeContext2 = localeContext = dCBindingContainer != null ? dCBindingContainer.getLocaleContext() : null;
        if (viewObject == null) {
            attributeDefArray = this.getDataControl().getAttributeDefs(this, stringArray);
            if (stringArray == null && attributeDefArray != null) {
                ArrayList<AttributeDef> arrayList = new ArrayList<AttributeDef>(attributeDefArray.length);
                int n = 0;
                while (n < attributeDefArray.length) {
                    if (!"Hide".equals(attributeDefArray[n].getUIHelper().getDisplayHint(localeContext))) {
                        arrayList.add(attributeDefArray[n]);
                    }
                    ++n;
                }
                attributeDefArray = arrayList.toArray(new AttributeDef[arrayList.size()]);
            }
        } else {
            this.refreshIfNeeded();
            if (stringArray == null) {
                AttributeDef[] attributeDefArray2 = viewObject.getAttributeDefs();
                ArrayList<AttributeDef> arrayList = new ArrayList<AttributeDef>(attributeDefArray2.length);
                byte by = 0;
                int n = 0;
                while (n < attributeDefArray2.length) {
                    by = attributeDefArray2[n].getAttributeKind();
                    if (by != 2 && by != 6 && !"Hide".equals(attributeDefArray2[n].getUIHelper().getDisplayHint(localeContext))) {
                        arrayList.add(attributeDefArray2[n]);
                    }
                    ++n;
                }
                attributeDefArray = arrayList.toArray(new AttributeDef[arrayList.size()]);
            } else {
                attributeDefArray = new AttributeDef[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    attributeDefArray[n] = viewObject.findAttributeDef(stringArray[n]);
                    ++n;
                }
            }
        }
        return attributeDefArray;
    }

    public int getRangeSize() {
        return this.hasRSI() ? this.getRowSetIterator().getRangeSize() : this.mRangeSize;
    }

    public void setRangeSize(int n) {
        this.mRangeSize = n;
        if (n != RANGESIZE_DO_NOT_OVERRIDE) {
            this.setRangeSizeForRSI(this.getRowSetIterator(), n);
        }
    }

    void setRangeSizeForRSI(RowSetIterator rowSetIterator, int n) {
        if (rowSetIterator == null) {
            return;
        }
        DCDataControl dCDataControl = this.getDataControl();
        if (dCDataControl != null && dCDataControl.syncNeeded() && this.needsEstimatedRowCount()) {
            WSRowSet wSRowSet;
            if (rowSetIterator instanceof Proxy) {
                RowSetIterator rowSetIterator2 = null;
                WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(rowSetIterator);
                rowSetIterator = rowSetIterator2 = wSProxy.getInternalRowSetIter();
            }
            if ((wSRowSet = (WSRowSet)rowSetIterator.getRowSet()) != null) {
                wSRowSet.requestEstimatedRowCount();
            }
        }
        if (rowSetIterator.getRangeSize() != n) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Changing iterator range size from :" + rowSetIterator.getRangeSize() + " to :" + n);
            }
            rowSetIterator.setRangeSize(n);
        }
    }

    public int getRangeStart() {
        return this.hasRSI() ? this.getRowSetIterator().getRangeStart() : 0;
    }

    public void setRangeStart(int n) {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        this.getRowSetIterator().setRangeStart(n);
    }

    public int getCurrentRowIndexInRange() {
        NavigatableRowIterator navigatableRowIterator;
        int n;
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if ((n = (navigatableRowIterator = this.getNavigatableRowIterator()).getCurrentRowIndex()) > -1) {
            return n - this.getRangeStart();
        }
        return -1;
    }

    public void setCurrentRowIndexInRange(int n) {
        this.getNavigatableRowIterator().setCurrentRowAtRangeIndex(n);
    }

    public void setCurrentRowWithKeyValue(String string) {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if (string != null) {
            this.getDataControl().setCurrentRowWithKeyValue(this, string);
        } else {
            Diagnostic.println("** Warning! NoOp in setCurrentRowWithKeyValue as the string key is null!");
        }
    }

    public String getCurrentRowWithKeyValue() {
        return this.getCurrentRowKeyString();
    }

    public String getCurrentRowKeyString() {
        Row row;
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if ((row = this.getCurrentRow()) != null) {
            return row.getKey().toStringFormat(true);
        }
        return null;
    }

    public Key createKey(String string) {
        block5: {
            RowSetIterator rowSetIterator;
            if (string != null && (rowSetIterator = (RowSetIterator)(this.mFindMode ? this.mOldRSI : this.mRSI)) != null) {
                if (rowSetIterator instanceof DCRowSetIteratorImpl) {
                    return ((DCRowSetIteratorImpl)rowSetIterator).createKey(string);
                }
                RowSet rowSet = rowSetIterator.getRowSet();
                if (rowSet != null) {
                    try {
                        Key key = new Key(string, rowSet.getViewObject().getKeyAttributeDefs());
                        return key;
                    }
                    catch (Exception exception) {
                        if (!Diagnostic.isOn()) break block5;
                        Diagnostic.printStackTrace(exception);
                    }
                }
            }
        }
        return null;
    }

    public void setCurrentRowWithKey(String string) {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if (string != null) {
            this.getDataControl().setCurrentRowWithKey(this, string);
        } else {
            Diagnostic.println("** Warning! NoOp in setCurrentRowWithKey as the string key is null!");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeRowWithKey(String string) {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if (string == null) {
            Diagnostic.println("** Warning! NoOp in removeCurrentRowWithKeyValue as the string key is null!");
            return;
        }
        NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
        Row[] rowArray = navigatableRowIterator.findByKey(this.createKey(string), -1);
        if (rowArray == null) return;
        if (rowArray.length <= 0) return;
        if (rowArray.length == 1) {
            rowArray[0].remove();
            return;
        }
        Class clazz = class$oracle$adf$model$ADFmMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$adf$model$ADFmMessageBundle = DCIteratorBinding.class$("oracle.adf.model.ADFmMessageBundle");
        }
        throw new InvalidOperException(clazz, "35006", new Object[]{string, this.getName()});
    }

    protected void setAlive(boolean bl) {
        this.mIsAlive = bl;
    }

    public boolean isAlive() {
        return this.mIsAlive;
    }

    public final boolean isBound() {
        return this.mIsBound;
    }

    public long getEstimatedRowCount() {
        if (!this.isRefreshed()) {
            this.refreshIfNeeded();
        }
        if (this.isFindMode()) {
            NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
            return navigatableRowIterator != null ? navigatableRowIterator.getRowCount() : 0;
        }
        if (!this.hasRSI() && this.getDef() != null && !this.getDef().isRefreshable(this.getBindingContainer(), this, -1)) {
            return 0L;
        }
        return this.getDataControl().getEstimatedRowCount(this);
    }

    public void applySortCriteria(SortCriteria[] sortCriteriaArray) {
        if (this.isSortable()) {
            this.mSC = sortCriteriaArray;
            if (this.mSC != null) {
                this.getDataControl().applySortCriteria(this, sortCriteriaArray);
            }
        } else if (Diagnostic.isOn()) {
            Diagnostic.println("Warning! Sorting is disabled for IteratorBinding :" + this.getName());
        }
    }

    public SortCriteria[] getSortCriteria() {
        if (this.mSC == null) {
            this.mSC = this.getDataControl().getSortCriteria(this);
        }
        if (this.mSC == null) {
            this.mSC = new SortCriteria[0];
        }
        return this.mSC;
    }

    public boolean isSortable() {
        return (this.getDef() == null || this.getDef().isSortable()) && this.isOperationSupported((byte)6);
    }

    public boolean isAttributeSortable(AttributeDef attributeDef) {
        DCDataControl dCDataControl = this.getDataControl();
        return this.isSortable() && dCDataControl != null && dCDataControl.isAttributeSortable(this, attributeDef);
    }

    public boolean isOperationSupported(byte by) {
        return this.getDataControl() != null ? this.getDataControl().isOperationSupported(this, by) : false;
    }

    private ApplicationModule getApplicationModule() {
        if (this.mAM == null) {
            this.mAM = this.getDataControl().getApplicationModule();
        }
        return this.mAM;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setupFindMode() {
        this.mFindMode = true;
        NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
        if (navigatableRowIterator != this.mRSI && !(this.mRSI instanceof ViewCriteria)) {
            this.mOldRSI = this.mRSI;
        }
        if (navigatableRowIterator == null) return;
        if (navigatableRowIterator.getRowCount() == 0) {
            try {
                Row row = navigatableRowIterator.createRow();
                if (row == null) return;
                navigatableRowIterator.insertRow(row);
                return;
            }
            catch (InvalidOperException invalidOperException) {
                if (!this.getDataControl().syncNeeded()) throw invalidOperException;
                Diagnostic.println("Warning! Setting find mode in the startup. You will need to create a new findmode row");
                return;
            }
        } else {
            if (navigatableRowIterator.getCurrentRow() != null) return;
            navigatableRowIterator.first();
        }
    }

    public void internalReserveCurrentRow() {
        if (this.mReservedRow == null) {
            this.mReservedRow = this.getCurrentRow();
        }
    }

    void releaseCurrentRow() {
        this.mReservedRow = null;
    }

    String getPathToRootContainer() {
        StringBuffer stringBuffer = new StringBuffer();
        DCBindingContainer dCBindingContainer = this.getBindingContainer();
        while (dCBindingContainer.getRegionContainer() != null) {
            stringBuffer.insert(0, (Object)new StringBuffer(dCBindingContainer.getName()).append('.'));
            dCBindingContainer = dCBindingContainer.getRegionContainer();
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    void buildFormToken(StringBuffer stringBuffer, boolean bl) {
        if (this.mTokenDisabled || !this.mIsAlive || !this.isBound()) {
            return;
        }
        if (this.isFindMode()) {
            stringBuffer.append(this.getName()).append('=').append(FIND_MODE_INDICATOR_FIND).append(",");
        } else {
            stringBuffer.append(this.getName()).append('=');
            if (this.isFindModeAllowed()) {
                stringBuffer.append(FIND_MODE_INDICATOR_DATA);
            } else {
                stringBuffer.append(FIND_MODE_INDICATOR_NA);
            }
            boolean bl2 = bl = bl && this.getDef() != null && this.getDef().isStateValidationEnabled();
            if ((bl || this.mCreatedRowRef != null) && this.hasRSI()) {
                Row row = null;
                NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
                if (this.mCreatedRowRef != null || navigatableRowIterator != null && navigatableRowIterator.getCurrentRowIndex() > -1) {
                    row = this.getCurrentRow();
                }
                if (row != null && row.getKey() != null) {
                    String string;
                    String string2 = string = this.mCreatedRowRef == null ? row.getKey().toStringFormat(false) : this.mCreatedRowRef.getKey().toStringFormat(true);
                    if (this.mCreatedRowRef != null) {
                        stringBuffer.append(CREATED_ROW_INDICATOR);
                    }
                    stringBuffer.append(string);
                }
            }
            stringBuffer.append(",");
        }
    }

    String parseKeyValue(String string) {
        if (string.length() > FIND_MODE_INDICATOR_LENGTH && (string = string.substring(FIND_MODE_INDICATOR_LENGTH)).length() != 0 && string.indexOf(CREATED_ROW_INDICATOR) == 0) {
            string = string.substring(CREATED_ROW_INDICATOR_LENGTH);
        }
        return string;
    }

    boolean processFormToken(String string, Map map) {
        if (string.indexOf(FIND_MODE_INDICATOR_FIND) == 0) {
            RowSetIterator rowSetIterator = this.getRowSetIterator();
            if (rowSetIterator != null) {
                this.setupFindMode();
            }
        } else {
            RowSetIterator rowSetIterator;
            RowSetIterator rowSetIterator2 = rowSetIterator = this.hasRSI() ? this.getRowSetIterator() : null;
            if (string.indexOf(FIND_MODE_INDICATOR_NA) == 0) {
                this.setAllowFindMode(false);
            }
            if ((string = string.substring(FIND_MODE_INDICATOR_LENGTH)).length() == 0) {
                return true;
            }
            if (string.indexOf(CREATED_ROW_INDICATOR) == 0) {
                Key key;
                if (rowSetIterator == null) {
                    this.refreshIfNeeded();
                    rowSetIterator = this.getRowSetIterator();
                }
                string = string.substring(CREATED_ROW_INDICATOR_LENGTH);
                try {
                    key = new Key(string, rowSetIterator.getRowSet().getViewObject().getKeyAttributeDefs());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    boolean bl = false;
                    return bl;
                }
                Row[] rowArray = rowSetIterator.findByKey(key, 1);
                if (rowArray.length != 1) {
                    return false;
                }
                map.put(this, rowArray[0]);
            } else {
                Row row;
                if (Diagnostic.isOn() && this.mCreatedRowRef != null) {
                    Diagnostic.println("Warning! New/Created row on this iterator will now be lost!");
                }
                if (this.mCreatedRowRef != null) {
                    this.releaseCachedRow();
                }
                if (!this.hasRSI()) {
                    this.getNavigatableRowIterator();
                }
                if ((row = this.getCurrentRow()) == null) {
                    return false;
                }
                Key key = row.getKey();
                if (key == null) {
                    return false;
                }
                if (!key.toStringFormat(false).equals(string)) {
                    return false;
                }
            }
        }
        return true;
    }

    void findAndInsertNewRow(Row row) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        rowSetIterator.insertRow(row);
        row.setNewRowState((byte)0);
        this.releaseCachedRow();
    }

    boolean insertCreatedRow() {
        if (this.mCreatedRowRef != null) {
            Row row = this.mCreatedRowRef;
            this.releaseCachedRow();
            RowSetIterator rowSetIterator = this.getRowSetIterator();
            rowSetIterator.insertRow(row);
            row.setNewRowState((byte)0);
            return true;
        }
        return false;
    }

    protected void cacheCreatedRow(RowSetIterator rowSetIterator, Row row) {
        this.mCreatedRowRef = row;
        this.getDataControl().setTransientCreatedRowObject(this.getCachedRSIName(rowSetIterator), row);
        this.resetDependentsRefresh();
    }

    private final String getCachedRSIName(RowSetIterator rowSetIterator) {
        RowSet rowSet = rowSetIterator.getRowSet();
        return rowSet.getViewObject().getFullName() + '_' + rowSet.getName() + '_' + rowSetIterator.getName();
    }

    private void releaseCachedRow() {
        this.mCreatedRowRef = null;
        DCDataControl dCDataControl = this.getDataControl();
        if (dCDataControl != null && this.hasRSI() && dCDataControl.getTransientCreatedRowObjects() != null) {
            dCDataControl.releaseTransientCreatedRowObject(this.getCachedRSIName(this.getRowSetIterator()));
        }
    }

    public int getExecutableType() {
        return 1;
    }

    public void refresh(int n) {
        if (n == 32768) {
            if (this.getBindingContainer().getTransientRefreshFlag() != n) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Executing and syncing on IteratorBinding.refresh from :" + this.getName());
                }
                boolean bl = this.getDataControl().syncNeeded();
                try {
                    this.releaseCurrentRow();
                    if (bl) {
                        this.suspendRowSetEventsHandling(true);
                    }
                    if (!this.isFindMode()) {
                        if (this.mRangeSize != RANGESIZE_DO_NOT_OVERRIDE) {
                            this.setRangeSize(this.mRangeSize);
                        }
                        this.getRowSetIterator();
                        this.executeQueryIfNeeded();
                    } else {
                        this.getViewCriteria();
                    }
                    if (bl) {
                        this.fetchAttributeProperties();
                        this.getDataControl().syncIfNeeded("DCIteratorBinding.refresh(DEFER)");
                    }
                    Object var4_3 = null;
                    if (bl) {
                        this.suspendRowSetEventsHandling(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (bl) {
                        this.suspendRowSetEventsHandling(false);
                    }
                    throw throwable;
                }
                if (this.isRefreshed()) {
                    return;
                }
            }
        } else if (n == -1 && !this.hasRSI()) {
            this.getNavigatableRowIterator();
        }
        this.refreshControl();
    }

    public boolean hasRefreshParametersChanged() {
        return true;
    }

    public DCIExecutableDef getExecutableDef() {
        return this.getDef();
    }

    protected Object internalGet(String string) {
        string = string.intern();
        Object var2_2 = null;
        if (string == GET_Name) {
            this.mInternalGet_KeyResolved = true;
            return this.getName();
        }
        if (string == GET_Def) {
            this.mInternalGet_KeyResolved = true;
            return this.getExecutableDef();
        }
        if (string == GET_AllRowsInRange) {
            this.mInternalGet_KeyResolved = true;
            return this.getAllRowsInRange();
        }
        if (string == GET_CurrentRow) {
            this.mInternalGet_KeyResolved = true;
            return this.getCurrentRow();
        }
        if (string == GET_CurrentRowKeyString) {
            this.mInternalGet_KeyResolved = true;
            return this.getCurrentRowKeyString();
        }
        if (string == GET_EstimatedRowCount) {
            this.mInternalGet_KeyResolved = true;
            return new Long(this.getEstimatedRowCount());
        }
        if (string == GET_NavigatableRowIterator) {
            this.mInternalGet_KeyResolved = true;
            return this.getNavigatableRowIterator();
        }
        if (string == GET_RowSetIterator) {
            this.mInternalGet_KeyResolved = true;
            return this.getRowSetIterator();
        }
        if (string == GET_RangeSize) {
            this.mInternalGet_KeyResolved = true;
            return new Integer(this.getRangeSize());
        }
        if (string == GET_RangeStart) {
            this.mInternalGet_KeyResolved = true;
            return new Integer(this.getRangeStart());
        }
        if (string == GET_BindingContainer) {
            this.mInternalGet_KeyResolved = true;
            return this.getBindingContainer();
        }
        if (string == "hasCriteriaData") {
            this.mInternalGet_KeyResolved = true;
            if (this.getViewCriteria() != null && this.getViewCriteria().getRowCount() > 0) {
                return new Boolean(((ViewCriteriaRow)this.getViewCriteria().first()).hasData());
            }
            return Boolean.FALSE;
        }
        if (string == GET_FindMode) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isFindMode());
        }
        if (string == GET_ViewObject) {
            this.mInternalGet_KeyResolved = true;
            return this.getViewObject();
        }
        return super.internalGet(string);
    }

    public String getPermissionTargetName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mDC != null && this.mDC.getApplicationModule() != null && this.isAlive() && this.getViewObject() != null) {
            stringBuffer.append(this.mDC.getName()).append('.');
            if (this.mSourceName != null) {
                stringBuffer.append(this.mSourceName);
            }
            return stringBuffer.toString();
        }
        if (this.mSourceName == null && this.mName.equals("variables") && this.getBindingContainer() != null) {
            return this.getBindingContainer().getDef().getFullName();
        }
        if (this.mDC != null) {
            stringBuffer.append(this.mDC.getName());
            if (this.mSourceName != null && this.mSourceName.endsWith(".result")) {
                stringBuffer.append('.').append(this.mSourceName.substring(0, this.mSourceName.lastIndexOf(46)));
            } else if (this.mSourceName != null && !this.mSourceName.equals("root")) {
                stringBuffer.append('.').append(this.mSourceName);
            }
            return stringBuffer.toString();
        }
        return this.mSourceName;
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            this.mPermissionInfo = new PermissionBinding(this.getPermissionTargetName(), 1);
        }
        return this.mPermissionInfo;
    }

    protected void disableTokenValidation() {
        this.mTokenDisabled = true;
    }

    public void setRefreshed(boolean bl) {
        DCIteratorBindingDef dCIteratorBindingDef;
        boolean bl2 = this.isRefreshed();
        super.setRefreshed(bl);
        if (!bl2 && bl && (dCIteratorBindingDef = this.getDef()) != null && !dCIteratorBindingDef.isCacheResults()) {
            this.releaseData();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

