/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.security.Permission;
import java.util.HashMap;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCDefBase;
import oracle.adf.model.binding.DCIExecutable;
import oracle.adf.model.binding.DCIExecutableDef;
import oracle.adf.model.binding.PermissionHelper;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.jbo.mom.xml.DefElement;

public abstract class DCExecutableBindingDef
extends DCDefBase
implements DCIExecutableDef {
    public static final String PNAME_option = "Refresh";
    public static final String PNAME_optionExpr = "RefreshCondition";
    public static final String PNAME_option_DEFAULT = "ifNeeded";
    public static final String PNAME_option_PREPARE = "prepareModel";
    public static final String PNAME_option_RENDER = "renderModel";
    public static final String PNAME_option_PREPARE_OPT = "prepareModelIfNeeded";
    public static final String PNAME_option_RENDER_OPT = "renderModelIfNeeded";
    public static final String PNAME_option_ALWAYS = "always";
    public static final String PNAME_option_DEFER = "deferred";
    public static final String PNAME_option_NEVER = "never";
    public static final String PNAME_option_REFRESH_OPT = "renderModelIfNeeded";
    public static final String PNAME_option_REFRESH = "renderModel";
    public static final int RC_DEFAULT = -1;
    public static final int RC_PREPARE = 1;
    public static final int RC_PREPARE_OPT = 2;
    public static final int RC_RENDER = 16;
    public static final int RC_RENDER_OPT = 32;
    public static final int RC_ALWAYS = 17;
    public static final int RC_NEVER = 0;
    public static final int RC_DEFER = 32768;
    public static final int RC_REFRESH = 16;
    public static final int RC_REFRESH_OPT = 32;
    private int mRefreshOption;
    private String mRefreshExpression;

    private /* synthetic */ void $init$() {
        this.mRefreshOption = -1;
        this.mRefreshExpression = null;
    }

    public DCExecutableBindingDef() {
        this.$init$();
        this.setSubType("DCIterator");
    }

    public DCExecutableBindingDef(String string) {
        super(string);
        this.$init$();
        this.setSubType("DCIterator");
    }

    public void init(HashMap hashMap) {
        super.init(hashMap);
        Object v = hashMap.get(PNAME_option);
        if (v != null) {
            this.mRefreshOption = DCExecutableBindingDef.internalGetRefreshOptionFromString((String)v);
        }
        if ((v = hashMap.get(PNAME_optionExpr)) != null) {
            this.mRefreshExpression = (String)v;
        }
    }

    public final int getRefreshOption() {
        return this.mRefreshOption;
    }

    public final String getRefreshExpression() {
        return this.mRefreshExpression;
    }

    public static int internalGetRefreshOptionFromString(String string) {
        if (string != null) {
            if ((string = string.intern()) == PNAME_option_DEFAULT) {
                return -1;
            }
            if (string == PNAME_option_DEFER) {
                return 32768;
            }
            if (string == PNAME_option_PREPARE) {
                return 1;
            }
            if (string == "renderModel") {
                return 16;
            }
            if (string == PNAME_option_PREPARE_OPT) {
                return 2;
            }
            if (string == "renderModelIfNeeded") {
                return 32;
            }
            if (string == PNAME_option_ALWAYS) {
                return 17;
            }
            if (string == PNAME_option_NEVER) {
                return 0;
            }
        }
        return -1;
    }

    public String getXMLElementTag() {
        return PNAME_option;
    }

    protected void retrieveFromXML(DefElement defElement, HashMap hashMap) {
        super.retrieveFromXML(defElement, hashMap);
        DCExecutableBindingDef.readXMLString(defElement, PNAME_option, hashMap);
        DCExecutableBindingDef.readXMLString(defElement, PNAME_optionExpr, hashMap);
    }

    public abstract int getExecutableType();

    public abstract Object createExecutableBinding(BindingContext var1, DCBindingContainer var2);

    public boolean isRefreshable(DCBindingContainer dCBindingContainer, DCIExecutable dCIExecutable, int n) {
        if (!this.internalHasPermission(dCBindingContainer)) {
            return false;
        }
        int n2 = dCIExecutable.getRefreshOption();
        boolean bl = false;
        switch (n2) {
            case 32768: {
                bl = n == -1;
                break;
            }
            case 1: {
                bl = n == 1;
                break;
            }
            case 2: {
                if (n != 1) break;
                bl = dCIExecutable.hasRefreshParametersChanged();
                break;
            }
            case 16: {
                bl = n == 2;
                break;
            }
            case 32: {
                if (n != 2) break;
                bl = dCIExecutable.hasRefreshParametersChanged();
                break;
            }
            case 17: {
                bl = true;
                break;
            }
            case 0: {
                bl = false;
            }
        }
        if (bl || n2 == -1) {
            String string = dCIExecutable.getRefreshExpression();
            boolean bl2 = true;
            if (string != null && string.length() > 0) {
                Object object = dCBindingContainer.evaluateParameter(dCIExecutable.getRefreshExpression(), true);
                if (object != null) {
                    bl2 = false;
                    bl = !(object instanceof Boolean) ? Boolean.valueOf(object.toString()).booleanValue() : ((Boolean)object).booleanValue();
                } else {
                    bl = false;
                }
            }
            if (bl2 && n2 == -1) {
                bl = dCIExecutable.hasRefreshParametersChanged() || dCIExecutable.getExecutableType() == 1 && !dCIExecutable.isRefreshed() || n == 0;
            }
        }
        return bl;
    }

    protected boolean internalHasPermission(DCBindingContainer dCBindingContainer) {
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        if (!securityContext.isAuthorizationEnabled()) {
            return true;
        }
        DCDataControl dCDataControl = dCBindingContainer.getDataControl();
        String string = this.getPermissionClassName();
        if (string == null) {
            return true;
        }
        String string2 = this.getPermissionTargetName();
        if (string2 != null) {
            Permission permission = (Permission)PermissionHelper.createPermissionInstance(string, string2, PermissionHelper.getReadAction(string));
            if (dCDataControl != null && !dCDataControl.hasPermission(permission)) {
                return false;
            }
        }
        return true;
    }

    protected String getPermissionTargetName() {
        return this.getFullName();
    }

    protected String getPermissionClassName() {
        return PermissionHelper.getPermissionClassName(2);
    }
}

