/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.adf.model.BindingContext;
import oracle.adf.model.DataControl;
import oracle.adf.model.OperationBinding;
import oracle.adf.model.OperationParameter;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCBindingContainerDef;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControlDef;
import oracle.adf.model.binding.DCDataControlManagement;
import oracle.adf.model.binding.DCDataControlReference;
import oracle.adf.model.binding.DCErrorHandler;
import oracle.adf.model.binding.DCErrorHandlerThrow;
import oracle.adf.model.binding.DCInvokeMethod;
import oracle.adf.model.binding.DCInvokeMethodDef;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.adf.model.binding.DCStatusBarInterface;
import oracle.adf.model.binding.DCTransactionStateListener;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.binding.PermissionHelper;
import oracle.adf.model.generic.BeanUtils;
import oracle.adf.model.generic.DCGenericRowSetIteratorImpl;
import oracle.adf.model.generic.DCRowContext;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.adf.model.generic.RowImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.binding.OperationInfo;
import oracle.binding.meta.Definition;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboEvent;
import oracle.jbo.JboException;
import oracle.jbo.JboExceptionHandler;
import oracle.jbo.JboWarning;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.NameClashException;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.SessionContext;
import oracle.jbo.SessionContextManager;
import oracle.jbo.SortCriteria;
import oracle.jbo.StructureDef;
import oracle.jbo.TransactionStateEvent;
import oracle.jbo.Variable;
import oracle.jbo.ViewCriteria;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.common.SessionContextManagerImpl;
import oracle.jbo.uicli.binding.JUCtrlActionBinding;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public abstract class DCDataControl
extends JboAbstractMap
implements DCDataControlManagement,
DataControl {
    private DCDataControlDef mDCDef;
    protected boolean mIsRoot;
    protected DCDataControl mParent;
    protected DCDataControl mRootApplication;
    protected Object mUserData;
    protected String mName;
    protected ArrayList mBindingContainerList;
    protected DCErrorHandler mErrorHandler;
    protected DCErrorHandler mErrorHandlerThrow;
    protected boolean mErrorHandlerActive;
    protected LocaleContext mLocaleCtx;
    public static byte ABSTRACT = BindingContext.CLIENT_TYPE_ABSTRACT;
    public static byte JCLIENT = BindingContext.CLIENT_TYPE_JCLIENT;
    public static final byte OPER_DATA_ROW_UPDATE = 0;
    public static final byte OPER_DATA_ROW_CREATE = 1;
    public static final byte OPER_DATA_ROW_REMOVE = 2;
    public static final byte OPER_FIND_MODE = 3;
    public static final byte OPER_CTRL_BINDING_VALIDATION = 4;
    public static final byte OPER_EXECUTE = 5;
    public static final byte OPER_SORT_COLLECTION = 6;
    boolean mTxnModified;
    private BindingContext mBindingContext;
    private boolean mResetStateDeferred;
    private int mUseCount;
    protected Object mDataProvider;
    private Map mTransientDataMap;
    private Map mUserParams;
    private HashMap mReleasedIterators;
    public static final String GET_MethodResults = "MethodResults";
    public static final String GET_ApplicationModule = "ApplicationModule";
    public static final String GET_DataProvider = "DataProvider";
    public static final String GET_dataProvider = "dataProvider";
    public static final String GET_Name = "Name";
    MethodResultsMap mMethodResults;
    public static int REL_ALL_REFS = -1;
    public static int REL_DATA_REFS = 1;
    public static int REL_VIEW_REFS = 2;
    public static int REL_WEAK_DATA_REFS = 4;
    private HashMap mBindingsWithExc;
    public static final String PNAME_Type = "Session";
    protected ArrayList mStatusBarList;
    protected ArrayList mTxnListeners;
    private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;
    private static /* synthetic */ Class class$oracle$adf$model$binding$DCBindingContainer;

    private /* synthetic */ void $init$() {
        this.mBindingContainerList = new ArrayList(4);
        this.mErrorHandlerActive = true;
        this.mTxnModified = false;
        this.mBindingContext = null;
        this.mResetStateDeferred = false;
        this.mUseCount = 0;
        this.mUserParams = null;
        this.mReleasedIterators = null;
        this.mBindingsWithExc = null;
    }

    protected DCDataControl() {
        this(false, null);
    }

    protected DCDataControl(boolean bl, Object object) {
        this.$init$();
        this.mIsRoot = bl;
        this.mParent = null;
        this.mRootApplication = bl ? this : null;
        this.mErrorHandlerThrow = new DCErrorHandlerThrow();
        this.mUserData = object;
    }

    public final String getName() {
        return this.mName;
    }

    public final void setName(String string) {
        this.mName = string;
    }

    public final DCDataControlDef getDef() {
        return this.mDCDef;
    }

    public final void setDef(DCDataControlDef dCDataControlDef) {
        this.mDCDef = dCDataControlDef;
    }

    public void initializeFromMetadata(Map map) {
    }

    public void initialize() {
        if (this.mIsRoot) {
            this.connect();
        }
    }

    public Object getDataProvider() {
        return this.mDataProvider;
    }

    protected void setDataProvider(Object object) {
        this.mDataProvider = object;
    }

    public final void reportException(DCBindingContainer dCBindingContainer, Exception exception) {
        if (!this.mIsRoot) {
            this.getRootDataControl().reportException(dCBindingContainer, exception);
        } else {
            JboException jboException;
            if (this.getApplicationModule() != null && exception instanceof JboException && (jboException = (JboException)exception).needsEntityToVOMapping()) {
                jboException.doEntityToVOMapping(this.getApplicationModule(), dCBindingContainer.getOrderedVOUsageList(this));
            }
            if (this.mErrorHandlerActive) {
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.reportException(dCBindingContainer, exception);
                } else if (this.getBindingContext().getErrorHandler() != null) {
                    this.getBindingContext().getErrorHandler().reportException(dCBindingContainer, exception);
                } else {
                    JUMetaObjectManager.reportException(dCBindingContainer, exception);
                }
            } else {
                this.mErrorHandlerThrow.reportException(dCBindingContainer, exception);
            }
        }
    }

    public final DCErrorHandler getCurrentErrorHandler() {
        return this.getRootDataControl().mErrorHandler;
    }

    public void setErrorHandler(Object object) {
        if (object instanceof DCErrorHandler) {
            DCErrorHandler dCErrorHandler;
            this.getRootDataControl().mErrorHandler = dCErrorHandler = (DCErrorHandler)object;
            ApplicationModule applicationModule = this.getRootDataControl().getApplicationModule();
            if (applicationModule != null) {
                if (dCErrorHandler instanceof JboExceptionHandler) {
                    applicationModule.setExceptionHandler((JboExceptionHandler)((Object)dCErrorHandler));
                } else {
                    applicationModule.setExceptionHandler(new 1());
                }
            }
        }
    }

    public final boolean getErrorHandlerActive() {
        return this.getRootDataControl().mErrorHandlerActive;
    }

    public final void setErrorHandlerActive(boolean bl) {
        this.getRootDataControl().mErrorHandlerActive = bl;
    }

    protected void connect() {
    }

    public LocaleContext getLocaleContext() {
        BindingContext bindingContext;
        if (this.mLocaleCtx == null && (bindingContext = this.getBindingContext()) != null) {
            this.mLocaleCtx = bindingContext.getLocaleContext();
        }
        return this.mLocaleCtx;
    }

    public void setLocaleContext(LocaleContext localeContext) {
        this.mLocaleCtx = localeContext;
    }

    public ApplicationModule getApplicationModule() {
        return null;
    }

    protected abstract RowSetIterator getRowSetIterator(String var1);

    protected abstract Object getAccessorValue(RowSetIterator var1, Row var2, DCIteratorBinding var3, String var4);

    public RowSetIterator createAccessorRowSetIterator(RowSetIterator rowSetIterator, DCIteratorBinding dCIteratorBinding, String string, String string2) {
        Row row = rowSetIterator.getCurrentRow();
        if (row == null) {
            row = rowSetIterator.first();
        }
        return this.createAccessorRowSetIterator(rowSetIterator, row, dCIteratorBinding, string, string2, true);
    }

    public RowSetIterator createAccessorRowSetIterator(RowSetIterator rowSetIterator, Row row, DCIteratorBinding dCIteratorBinding, String string, String string2) {
        return this.createAccessorRowSetIterator(rowSetIterator, row, dCIteratorBinding, string, string2, false);
    }

    protected RowSetIterator createAccessorRowSetIterator(RowSetIterator rowSetIterator, Row row, DCIteratorBinding dCIteratorBinding, String string, String string2, boolean bl) {
        Object object;
        Object object2 = row != null ? this.getAccessorValue(rowSetIterator, row, dCIteratorBinding, string) : null;
        RowSetIterator rowSetIterator2 = null;
        if (object2 instanceof RowSetIterator) {
            rowSetIterator2 = (RowSetIterator)object2;
        } else if (row instanceof RowImpl) {
            if (string2 == null) {
                string2 = ((StructureDefImpl)((RowImpl)row).getStructureDef()).getAccessorDef(string).getBeanClassName();
            } else if (BeanUtils.skipMetaData(string2)) {
                string2 = null;
            }
            rowSetIterator2 = this.createRowSetIteratorImpl(dCIteratorBinding, string2, object2, rowSetIterator);
            if (rowSetIterator2 instanceof DCRowSetIteratorImpl) {
                DCRowSetIteratorImpl dCRowSetIteratorImpl = (DCRowSetIteratorImpl)rowSetIterator2;
                dCRowSetIteratorImpl.setAccessorName(string);
                if (dCRowSetIteratorImpl instanceof DCGenericRowSetIteratorImpl) {
                    rowSetIterator2 = ((DCGenericRowSetIteratorImpl)dCRowSetIteratorImpl).setMasterInfo((DCGenericRowSetIteratorImpl)rowSetIterator, (RowImpl)row, string, bl);
                }
                dCRowSetIteratorImpl.setName(string);
            }
        } else if (object2 instanceof Row && (object = DCUtil.findSpelObject(object2, "rowSet")) instanceof RowSetIterator) {
            rowSetIterator2 = (RowSetIterator)object;
        }
        dCIteratorBinding.bindRowSetIterator(rowSetIterator2, false);
        return rowSetIterator2;
    }

    public RowSetIterator findOrCreateMethodRowSetIterator(DCIteratorBinding dCIteratorBinding, String string, Object object) {
        return this.createRowSetIteratorImpl(dCIteratorBinding, string, object, null);
    }

    public RowSetIterator findOrCreateAccessorRowSetIterator(RowSetIterator rowSetIterator, DCIteratorBinding dCIteratorBinding, String string, String string2) {
        return this.createAccessorRowSetIterator(rowSetIterator, dCIteratorBinding, string, string2);
    }

    protected Row internalGetCurrentRow(DCIteratorBinding dCIteratorBinding) {
        Row row;
        block2: {
            RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
            row = null;
            try {
                row = dCIteratorBinding.isFindMode() ? rowSetIterator.getCurrentRow() : dCIteratorBinding.internalGetCurrentRowInBinding();
            }
            catch (InvalidOperException invalidOperException) {
                if (!dCIteratorBinding.isAccessorIterator()) break block2;
                throw invalidOperException;
            }
        }
        return row;
    }

    public RowSetIterator findOrCreateAccessorRowSetIterator(DCIteratorBinding dCIteratorBinding, DCIteratorBinding dCIteratorBinding2, String string, String string2) {
        Row row = this.internalGetCurrentRow(dCIteratorBinding);
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        if (row == null) {
            return this.createAccessorRowSetIterator(rowSetIterator, dCIteratorBinding2, string, string2);
        }
        return this.createAccessorRowSetIterator(rowSetIterator, row, dCIteratorBinding2, string, string2, true);
    }

    protected abstract RowSetIterator createRowSetIteratorImpl(String var1, Object var2, RowSetIterator var3);

    protected RowSetIterator findOrCreateRowSetIteratorImpl(DCIteratorBinding dCIteratorBinding, String string, Object object, RowSetIterator rowSetIterator) {
        return this.createRowSetIteratorImpl(string, object, rowSetIterator);
    }

    public final RowSetIterator createRowSetIteratorImpl(DCIteratorBinding dCIteratorBinding, String string, Object object, RowSetIterator rowSetIterator) {
        if (dCIteratorBinding != null) {
            RowSetIterator rowSetIterator2 = this.findOrCreateRowSetIteratorImpl(dCIteratorBinding, string, object, rowSetIterator);
            DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
            if (dCIteratorBindingDef != null && "DCMethodIterator".equals(dCIteratorBindingDef.getSubType()) && rowSetIterator2 instanceof DCRowSetIteratorImpl) {
                DCRowSetIteratorImpl dCRowSetIteratorImpl = (DCRowSetIteratorImpl)rowSetIterator2;
                dCRowSetIteratorImpl.setProviderMethodResultName(JboNameUtil.getLastPartOfName(dCIteratorBinding.getSourceName()));
            }
            return rowSetIterator2;
        }
        return this.createRowSetIteratorImpl(string, object, rowSetIterator);
    }

    public final boolean isRoot() {
        return this.mIsRoot;
    }

    public final DCDataControl getParent() {
        return this.mParent;
    }

    public final DCDataControl getRootDataControl() {
        if (this.mRootApplication == null) {
            if (this.getParent() == null) {
                this.mIsRoot = true;
                this.mRootApplication = this;
            } else {
                this.mRootApplication = this.getParent().getRootDataControl();
            }
        }
        return this.mRootApplication;
    }

    public final Object getUserData() {
        return this.mUserData;
    }

    protected final void removeBindingContainer(DCBindingContainer dCBindingContainer) {
        this.mBindingContainerList.remove(dCBindingContainer);
    }

    public final void addBindingContainer(DCBindingContainer dCBindingContainer) {
        this.addBindingContainer(dCBindingContainer.getName(), dCBindingContainer);
    }

    public final void addBindingContainerRef(NamedObjectImpl namedObjectImpl) {
        BindingContext bindingContext = this.getBindingContext();
        if (bindingContext.get(namedObjectImpl.getName()) != null) {
            Object object = bindingContext.get(namedObjectImpl.getName());
            if (object instanceof DCBindingContainer) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Replacing Binding Container :" + ((DCBindingContainer)object).getName() + "with a reference.");
                }
            } else if (object instanceof NamedObjectImpl && Diagnostic.isOn()) {
                Diagnostic.println("Replacing Binding Container Reference :" + ((NamedObjectImpl)object).getName() + "with another.");
            }
            bindingContext.remove(object);
        }
        bindingContext.put(namedObjectImpl.getName(), namedObjectImpl);
    }

    public final void addBindingContainer(String string, DCBindingContainer dCBindingContainer, DCBindingContainerDef dCBindingContainerDef) {
        this.addOrCreateBindingContainer(string, dCBindingContainer, dCBindingContainerDef, false, false);
    }

    public final void addBindingContainer(String string, DCBindingContainer dCBindingContainer) {
        this.addOrCreateBindingContainer(string, dCBindingContainer, dCBindingContainer.getDef(), false, false);
    }

    protected void initializeBindingContainer(DCBindingContainerDef dCBindingContainerDef, DCBindingContainer dCBindingContainer, boolean bl) {
        if (this.getApplicationModule() != null) {
            if (bl) {
                dCBindingContainer.initializeFromDef(this.getBindingContext(), this.getApplicationModule());
            } else {
                dCBindingContainerDef.createIterBindings(dCBindingContainer, this.getBindingContext(), this.getApplicationModule());
            }
        } else {
            Diagnostic.println("Generic Application - needs to override");
        }
    }

    protected DCBindingContainer addOrCreateBindingContainer(String string, DCBindingContainer dCBindingContainer, DCBindingContainerDef dCBindingContainerDef, boolean bl, boolean bl2) {
        Object object = null;
        if (dCBindingContainer != null && dCBindingContainer.getRegionContainer() != null) {
            if (this.mBindingContainerList.contains(dCBindingContainer)) {
                object = dCBindingContainer;
            }
        } else {
            boolean bl3;
            BindingContext bindingContext = this.getBindingContext();
            boolean bl4 = bl3 = string == null;
            while (true) {
                if (bl3) {
                    string = DCUtil.generateContainerName(dCBindingContainer);
                } else if (!JboNameUtil.isNameValid(string)) {
                    throw new InvalidObjNameException(611, string);
                }
                if (bl2 || (object = bindingContext.get(string)) == dCBindingContainer || object == null) break;
                if (!bl3) {
                    throw new NameClashException(611, string);
                }
                bl3 = true;
            }
            if (dCBindingContainer == null) {
                dCBindingContainer = dCBindingContainerDef.createBindingContainer(this, bl);
                dCBindingContainer.setName(string);
                dCBindingContainer.setDataControl(this);
                dCBindingContainer.setDef(dCBindingContainerDef);
                this.initializeBindingContainer(dCBindingContainerDef, dCBindingContainer, bl);
            } else {
                dCBindingContainer.setName(string);
                if (dCBindingContainer.internalGetDataControl() == null) {
                    dCBindingContainer.setDataControl(this);
                }
                if (dCBindingContainer.getDef() != dCBindingContainerDef) {
                    dCBindingContainer.setDef(dCBindingContainerDef);
                }
            }
            object = bindingContext.get(dCBindingContainer.getName());
            if (object != null && object != dCBindingContainer) {
                if (object instanceof DCBindingContainer) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Replacing Binding Container :" + ((DCBindingContainer)object).getName() + "with another.");
                    }
                } else if (object instanceof NamedObjectImpl && Diagnostic.isOn()) {
                    Diagnostic.println("Replacing Binding Container Reference :" + ((NamedObjectImpl)object).getName() + "with a reference.");
                }
                bindingContext.remove(object);
            }
            bindingContext.put(dCBindingContainer.getName(), dCBindingContainer);
            dCBindingContainer.setRefreshed(true);
        }
        int n = -1;
        if (object != null && (n = this.mBindingContainerList.indexOf(object)) > -1) {
            this.mBindingContainerList.set(n, dCBindingContainer);
        } else {
            this.mBindingContainerList.add(dCBindingContainer);
        }
        return dCBindingContainer;
    }

    public final DCBindingContainer findBindingContainer(String string) {
        Object object = this.getBindingContext().get(string);
        if (object instanceof NamedObjectImpl) {
            NamedObjectImpl namedObjectImpl = (NamedObjectImpl)object;
            return this.addOrCreateBindingContainer(namedObjectImpl.getName(), null, DCBindingContainerDef.findDefObject(namedObjectImpl.getFullName()), true, true);
        }
        return (DCBindingContainer)object;
    }

    public final DCBindingContainer createBindingContainer(String string, String string2, boolean bl) {
        return this.addOrCreateBindingContainer(string, null, DCBindingContainerDef.findDefObject(string2), bl, false);
    }

    public boolean isJClientApp() {
        return this.getBindingContext() != null ? this.getBindingContext().isJClientApp() : false;
    }

    public void setClientApp(byte by) {
        if (this.getBindingContext() != null) {
            this.getBindingContext().setClientAppType(by);
        }
    }

    public DCBindingContainer createBindingContainerInstance(String string) {
        if (this.isJClientApp()) {
            Class clazz = class$oracle$adf$model$binding$DCBindingContainer;
            if (clazz == null) {
                clazz = class$oracle$adf$model$binding$DCBindingContainer = DCDataControl.class$("oracle.adf.model.binding.DCBindingContainer");
            }
            if (clazz.getName().equals(string)) {
                return (DCBindingContainer)DCUtil.createNewInstance("oracle.jbo.uicli.jui.JUPanelBinding");
            }
        }
        return (DCBindingContainer)DCUtil.createNewInstance(string);
    }

    public void initializeContainerFromDef(String string) {
        DCBindingContainer dCBindingContainer = this.findBindingContainer(string);
        if (dCBindingContainer != null) {
            if (this.getApplicationModule() != null) {
                dCBindingContainer.initializeFromDef(this.getBindingContext(), this.getApplicationModule());
            } else {
                this.initializeBindingContainer(dCBindingContainer.getDef(), dCBindingContainer, true);
            }
        }
    }

    public final void addStatusBarInterface(DCStatusBarInterface dCStatusBarInterface) {
        if (this.mStatusBarList == null) {
            this.mStatusBarList = new ArrayList(5);
        }
        this.mStatusBarList.add(dCStatusBarInterface);
    }

    public final void removeStatusBarInterface(DCStatusBarInterface dCStatusBarInterface) {
        if (this.mStatusBarList != null) {
            this.mStatusBarList.remove(dCStatusBarInterface);
        }
    }

    public final void displayStatus(DCIteratorBinding dCIteratorBinding, String string, Object[] objectArray) {
        if (this.mStatusBarList != null) {
            ArrayList arrayList = this.mStatusBarList;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCStatusBarInterface)arrayList.get(n)).displayStatus(dCIteratorBinding, string, objectArray);
                ++n;
            }
        }
    }

    public final void displayStatus(String string) {
        if (this.mStatusBarList != null) {
            ArrayList arrayList = this.mStatusBarList;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCStatusBarInterface)arrayList.get(n)).displayStatus(string);
                ++n;
            }
        }
    }

    public final void focusGained(DCIteratorBinding dCIteratorBinding, DCControlBinding dCControlBinding, int n) {
        if (this.mStatusBarList != null) {
            ArrayList arrayList = this.mStatusBarList;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ((DCStatusBarInterface)arrayList.get(n2)).focusGained(dCIteratorBinding, dCControlBinding, n);
                ++n2;
            }
        }
    }

    public final boolean hasBindingsWithExc() {
        return this.mBindingsWithExc != null && this.mBindingsWithExc.size() > 0;
    }

    public void validate() {
        Diagnostic.println("Default validate Transaction is a no-op");
    }

    public void commitTransaction() {
        Diagnostic.println("Default Commit Transaction : resetting transaction state!");
        this.transactionStateChanged(false);
    }

    public final void callCommitTransaction() {
        if (this.hasBindingsWithExc()) {
            Iterator iterator = this.mBindingsWithExc.keySet().iterator();
            ArrayList<JboException> arrayList = new ArrayList<JboException>(this.mBindingsWithExc.size());
            boolean bl = false;
            while (iterator.hasNext()) {
                JboException jboException;
                Object object = this.mBindingContext.get(iterator.next());
                if (object == null || (jboException = object instanceof DCControlBinding ? ((DCControlBinding)object).getError() : ((DCIteratorBinding)object).getError()) == null) continue;
                arrayList.add(jboException);
                bl = true;
            }
            if (bl) {
                if (arrayList.size() > 1) {
                    Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$uicli$UIMessageBundle = DCDataControl.class$("oracle.jbo.uicli.UIMessageBundle");
                    }
                    JboException jboException = new JboException(clazz, "34005", new Object[0]);
                    jboException.setExceptions(arrayList.toArray(new JboException[arrayList.size()]));
                } else {
                    throw (JboException)arrayList.get(0);
                }
            }
        }
        int n = 0;
        while (n < this.mBindingContainerList.size()) {
            DCBindingContainer dCBindingContainer = (DCBindingContainer)this.mBindingContainerList.get(n);
            dCBindingContainer.callBeforeSaveTransaction(this);
            if (!dCBindingContainer.isEditingStopped()) {
                return;
            }
            ++n;
        }
        this.commitTransaction();
    }

    public void rollbackTransaction() {
        Diagnostic.println("Default rollback Transaction : resetting transaction state!");
        this.transactionStateChanged(false);
    }

    public final boolean isTransactionModified() {
        return this.mTxnModified;
    }

    public void setTransactionModified() {
        if (!this.mTxnModified) {
            this.mTxnModified = true;
            if (this.mTxnListeners != null) {
                ArrayList arrayList = this.mTxnListeners;
                int n = 0;
                while (n < arrayList.size()) {
                    ((DCTransactionStateListener)arrayList.get(n)).transactionStateChanged(true);
                    ++n;
                }
            }
        }
    }

    protected void internalSetTransactionStateChanged(boolean bl) {
        this.mTxnModified = bl;
        if (this.mTxnListeners != null) {
            ArrayList arrayList = this.mTxnListeners;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCTransactionStateListener)arrayList.get(n)).transactionStateChanged(bl);
                ++n;
            }
        }
    }

    public final void transactionStateChanged(boolean bl) {
        if (bl != this.mTxnModified) {
            this.internalSetTransactionStateChanged(bl);
        }
    }

    public final void addTransactionStateListener(DCTransactionStateListener dCTransactionStateListener) {
        if (this.mTxnListeners == null) {
            this.mTxnListeners = new ArrayList(5);
        }
        this.mTxnListeners.add(dCTransactionStateListener);
    }

    public final void removeTransactionStateListener(DCTransactionStateListener dCTransactionStateListener) {
        if (this.mTxnListeners != null) {
            this.mTxnListeners.remove(dCTransactionStateListener);
        }
    }

    public final void doneCommit(TransactionStateEvent transactionStateEvent) {
        this.transactionStateChanged(false);
    }

    public final void doneRollback(TransactionStateEvent transactionStateEvent) {
        this.transactionStateChanged(false);
    }

    public void beginRequest(HashMap hashMap) {
        ++this.mUseCount;
    }

    public void endRequest(HashMap hashMap) {
        if (this.mUseCount == 0) {
            return;
        }
        --this.mUseCount;
        if (this.mReleasedIterators != null) {
            Iterator iterator = this.mReleasedIterators.values().iterator();
            while (iterator.hasNext()) {
                this.releaseData((DCIteratorBinding)iterator.next());
            }
            this.mReleasedIterators = null;
        }
        if (this.mResetStateDeferred) {
            this.resetState();
        }
        this.mTransientDataMap = null;
    }

    public void release() {
        this.release(REL_ALL_REFS);
    }

    public Definition getDefinition(String string, Class clazz) {
        return null;
    }

    public void release(int n) {
        boolean bl;
        ArrayList arrayList;
        if ((n & REL_VIEW_REFS) > 0) {
            if (this.mStatusBarList != null) {
                arrayList = (ArrayList)this.mStatusBarList.clone();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    DCStatusBarInterface dCStatusBarInterface = (DCStatusBarInterface)arrayList.get(n2);
                    dCStatusBarInterface.release();
                    ++n2;
                }
                this.mStatusBarList = null;
            }
            if (this.mTxnListeners != null) {
                arrayList = (ArrayList)this.mTxnListeners.clone();
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    DCTransactionStateListener dCTransactionStateListener = (DCTransactionStateListener)arrayList.get(n3);
                    dCTransactionStateListener.release();
                    ++n3;
                }
                this.mTxnListeners = null;
            }
        }
        boolean bl2 = bl = (n & REL_DATA_REFS) > 0;
        if (bl || (n & REL_WEAK_DATA_REFS) > 0) {
            if (bl) {
                this.mMethodResults = null;
            }
            arrayList = (ArrayList)this.mBindingContainerList.clone();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                DCBindingContainer dCBindingContainer = (DCBindingContainer)arrayList.get(n4);
                dCBindingContainer.release(n);
                ++n4;
            }
        }
        if (n == REL_ALL_REFS) {
            this.mBindingContainerList = new ArrayList(2);
            BindingContext bindingContext = this.getBindingContext();
            if (bindingContext != null) {
                String string = this.getName();
                bindingContext.remove(string);
                if (this.mDCDef != null) {
                    DCDataControlReference dCDataControlReference = new DCDataControlReference(this.mDCDef);
                    dCDataControlReference.setUserParams((Map)this.get(DCDataControlReference.USER_PARAMS_KEY));
                    bindingContext.put(string, dCDataControlReference);
                }
            }
            this.setName(null);
        }
    }

    public boolean releaseData(DCIteratorBinding dCIteratorBinding) {
        if (this.mUseCount > 0) {
            if (this.mReleasedIterators == null) {
                this.mReleasedIterators = new HashMap(4);
            }
            this.mReleasedIterators.put(dCIteratorBinding.getFullName(), dCIteratorBinding);
            return false;
        }
        this.releaseIterator(dCIteratorBinding);
        return true;
    }

    private void releaseIterator(DCIteratorBinding dCIteratorBinding) {
        dCIteratorBinding.invalidateCache();
    }

    public Object get(Object object) {
        String string;
        Object object2;
        if (object instanceof String && (object2 = this.internalGet(string = JboNameUtil.toUpperCaseFirstChar((String)object).intern())) != null) {
            return object2;
        }
        return super.get(object);
    }

    protected Object internalGet(String string) {
        DCBindingContainer dCBindingContainer = this.findBindingContainer(string);
        if (dCBindingContainer != null) {
            return dCBindingContainer;
        }
        if (GET_MethodResults == string) {
            return this.getMethodResults();
        }
        if (GET_dataProvider == string || GET_DataProvider == string) {
            return this.getDataProvider();
        }
        if (GET_ApplicationModule == string) {
            return this.getApplicationModule();
        }
        if (GET_Name == string) {
            return this.getName();
        }
        if (DCDataControlReference.USER_PARAMS_KEY.equals(string)) {
            return this.mUserParams;
        }
        return null;
    }

    protected void internalPut(String string, Object object) {
        if (DCDataControlReference.USER_PARAMS_KEY.equals(string)) {
            this.mUserParams = (Map)object;
        } else {
            super.internalPut(string, object);
        }
    }

    public void cleanup() {
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    protected void rebuildIteratorIfNeeded(DCIteratorBinding dCIteratorBinding) {
        DCRowSetIteratorImpl dCRowSetIteratorImpl;
        int n;
        if (dCIteratorBinding.allowsRefreshControl() && dCIteratorBinding.getViewObject() == null && (n = this.getMethodResultUseCount((dCRowSetIteratorImpl = (DCRowSetIteratorImpl)dCIteratorBinding.getRowSetIterator()).getProviderMethodResultName())) != dCRowSetIteratorImpl.getProviderMethodResultUseCount()) {
            dCRowSetIteratorImpl.setProviderMethodResultUseCount(n);
            dCRowSetIteratorImpl.rebuildIteratorUpto(0);
        }
    }

    protected abstract void executeIteratorBinding(DCIteratorBinding var1);

    protected abstract void executeIteratorBindingIfNeeded(DCIteratorBinding var1);

    public AttributeDef[] getAttributeDefs(DCIteratorBinding dCIteratorBinding, String[] stringArray) {
        return new AttributeDef[0];
    }

    public boolean isAttributeSortable(DCIteratorBinding dCIteratorBinding, AttributeDef attributeDef) {
        boolean bl = false;
        if (this.isOperationSupported(dCIteratorBinding, (byte)6)) {
            return attributeDef.isQueriable();
        }
        return bl;
    }

    public boolean isOperationSupported(DCIteratorBinding dCIteratorBinding, byte by) {
        DCDataControlDef dCDataControlDef = this.getDef();
        switch (by) {
            case 4: {
                return true;
            }
            case 6: {
                return dCDataControlDef != null && "true".equals(dCDataControlDef.get("SupportsSortCollection"));
            }
            case 0: {
                return dCDataControlDef != null && dCDataControlDef.supportsTransactions();
            }
        }
        return false;
    }

    public final void setBindingContext(BindingContext bindingContext) {
        this.mBindingContext = bindingContext;
        if (bindingContext.get(this.getName()) != this) {
            bindingContext.put(this.getName(), this);
        }
    }

    public final BindingContext getBindingContext() {
        return this.mBindingContext != null ? this.mBindingContext : JUMetaObjectManager.getJUMom().getBindingContext();
    }

    public Object invokeMethod(DCInvokeMethodDef dCInvokeMethodDef, ArrayList arrayList) {
        return dCInvokeMethodDef.invokeMethod(this, arrayList);
    }

    protected Object invokeMethod(DCInvokeMethod dCInvokeMethod, OperationBinding operationBinding, Map map) {
        return dCInvokeMethod.invokeMethod(this, map);
    }

    public boolean invokeOperation(Map map, oracle.binding.OperationBinding operationBinding) {
        if (operationBinding instanceof JUCtrlActionBinding) {
            ((JUCtrlActionBinding)operationBinding).doIt();
            return true;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Warning! invokeAction ignored. DataControl subclass should handle this action");
        }
        return false;
    }

    public void addBindingWithExc(String string) {
        if (this.mBindingsWithExc == null) {
            this.mBindingsWithExc = new HashMap(10);
        }
        this.mBindingsWithExc.put(string, string);
    }

    public void removeBindingWithExc(String string) {
        if (this.mBindingsWithExc != null) {
            this.mBindingsWithExc.remove(string);
        }
    }

    public abstract boolean isTransactionDirty();

    public boolean isClientTier() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean syncNeeded() {
        return false;
    }

    public void syncIfNeeded(String string) {
    }

    public void sync(String string) {
    }

    protected abstract long getEstimatedRowCount(DCIteratorBinding var1);

    public void setSessionContext(SessionContext sessionContext) {
        SessionContextManager sessionContextManager = this.getSessionContextManager();
        sessionContextManager.setCurrentSession(sessionContext);
    }

    public SessionContext getSessionContext() {
        SessionContextManager sessionContextManager = this.getSessionContextManager();
        return sessionContextManager.getCurrentSession();
    }

    protected SessionContextManager getSessionContextManager() {
        return SessionContextManagerImpl.getInstance();
    }

    public abstract void setCurrentRowWithKeyValue(DCIteratorBinding var1, String var2);

    public abstract void setCurrentRowWithKey(DCIteratorBinding var1, String var2);

    public abstract void setCurrentRowWithKey(DCIteratorBinding var1, Key var2);

    public Object registerDataProvider(DCRowContext dCRowContext) {
        return dCRowContext.getRowDataProvider();
    }

    public void setAttributeInRow(DCIteratorBinding dCIteratorBinding, Row row, AttributeDef attributeDef, Object object) {
        row.setAttribute(attributeDef.getIndex(), object);
        if (dCIteratorBinding.isFindMode() || this.isTransactionModified() || attributeDef instanceof Variable) {
            return;
        }
        this.setTransactionModified();
    }

    public Object createRowData(DCRowContext dCRowContext) {
        throw new UnsupportedOperationException("DataControl:createRowData");
    }

    public boolean removeRowData(DCRowContext dCRowContext) {
        throw new UnsupportedOperationException("DataControl:removeRowData");
    }

    public boolean removeRowDataFromCollection(DCRowContext dCRowContext) {
        return true;
    }

    protected AttributeDef[] resolveAttributeDefs(StructureDef structureDef, String[] stringArray) {
        if (structureDef == null) {
            return null;
        }
        if (stringArray == null) {
            return structureDef.getAttributeDefs();
        }
        int n = stringArray.length;
        AttributeDef[] attributeDefArray = new AttributeDef[n];
        while (--n >= 0) {
            attributeDefArray[n] = structureDef.findAttributeDef(stringArray[n]);
        }
        return attributeDefArray;
    }

    protected abstract void applySortCriteria(DCIteratorBinding var1, SortCriteria[] var2);

    protected abstract SortCriteria[] getSortCriteria(DCIteratorBinding var1);

    public Map getMethodResults() {
        if (this.mMethodResults == null) {
            this.mMethodResults = new MethodResultsMap(10);
        }
        return this.mMethodResults;
    }

    public int getMethodResultUseCount(Object object) {
        return this.mMethodResults != null ? this.mMethodResults.getUseCount(object) : 0;
    }

    public boolean resetState() {
        if (this.mUseCount > 0) {
            this.mResetStateDeferred = true;
            return false;
        }
        this.mResetStateDeferred = false;
        return true;
    }

    public abstract void applyViewCriteria(ViewCriteria var1, DCIteratorBinding var2, RowSetIterator var3);

    public ViewCriteria getViewCriteria(DCIteratorBinding dCIteratorBinding) {
        return null;
    }

    public ViewCriteria createViewCriteria(DCIteratorBinding dCIteratorBinding) {
        return null;
    }

    Map getTransientCreatedRowObjects() {
        return this.mTransientDataMap;
    }

    void setTransientCreatedRowObject(String string, Object object) {
        if (this.mTransientDataMap == null) {
            this.mTransientDataMap = new HashMap(4);
        }
        this.mTransientDataMap.put(string, object);
    }

    void releaseTransientCreatedRowObject(String string) {
        if (this.mTransientDataMap != null) {
            this.mTransientDataMap.remove(string);
            if (this.mTransientDataMap.size() == 0) {
                this.mTransientDataMap = null;
            }
        }
    }

    protected void resetAttributeExceptionInRow(DCIteratorBinding dCIteratorBinding, Row row, AttributeDef attributeDef, AttrValException attrValException) {
    }

    public boolean hasPermission(DCControlBinding dCControlBinding, String string, String string2) {
        return !PermissionHelper.isAuthorizationEnabled() ? true : dCControlBinding.internalHasPermission(string, string2);
    }

    public boolean hasPermission(DCControlBinding dCControlBinding, String string) {
        return !PermissionHelper.isAuthorizationEnabled() ? true : dCControlBinding.internalHasPermission(string);
    }

    public boolean hasPermission(Permission permission) {
        return PermissionHelper.hasPermission(this.getSecurityContext(), permission);
    }

    public SecurityContext getSecurityContext() {
        return ADFContext.getCurrent().getSecurityContext();
    }

    public boolean hasOperationParamsChanged(OperationInfo operationInfo) {
        if (operationInfo instanceof DCInvokeMethod) {
            DCInvokeMethod dCInvokeMethod = (DCInvokeMethod)operationInfo;
            return dCInvokeMethod.hasParameterValuesChanged();
        }
        return true;
    }

    protected void cacheMethodResult(DCInvokeMethod dCInvokeMethod, Object object, Object object2) {
        DCInvokeMethodDef dCInvokeMethodDef = dCInvokeMethod.getDef();
        BindingContext bindingContext = this.getBindingContext();
        String string = dCInvokeMethodDef.getReturnName();
        if (string != null && bindingContext != null) {
            DCUtil.putValueInPath(bindingContext, string, object);
            String string2 = dCInvokeMethodDef.getCachedParamsName();
            if (string2 != null) {
                DCUtil.putValueInPath(bindingContext, string2, object2);
            }
        }
    }

    protected Object invalidateMethodResult(DCInvokeMethod dCInvokeMethod) {
        DCInvokeMethodDef dCInvokeMethodDef = dCInvokeMethod.getDef();
        BindingContext bindingContext = this.getBindingContext();
        String string = dCInvokeMethodDef.getReturnName();
        Object object = null;
        if (string != null && bindingContext != null) {
            object = DCUtil.removeValueFromPath(bindingContext, string);
            String string2 = dCInvokeMethodDef.getCachedParamsName();
            if (string2 != null) {
                DCUtil.removeValueFromPath(bindingContext, string2);
            }
        }
        return object;
    }

    protected boolean isBoundRowIteratorEvent(DCIteratorBinding dCIteratorBinding, JboEvent jboEvent) {
        return dCIteratorBinding.getNavigatableRowIterator() == jboEvent.getSource();
    }

    protected Variable findVariable(String string) {
        return (Variable)DCUtil.findSpelObject((Object)this, string, DCUtil.isElExpr(string));
    }

    public void executeIteratorBindingWithParams(DCIteratorBinding dCIteratorBinding, OperationParameter[] operationParameterArray, Object[] objectArray) {
        this.executeIteratorBinding(dCIteratorBinding);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MethodResultsMap
    extends HashMap {
        Map mUseCountMap;

        private /* synthetic */ void $init$() {
            this.mUseCountMap = new HashMap(10);
        }

        MethodResultsMap(int n) {
            super(n);
            this.$init$();
        }

        public Object put(Object object, Object object2) {
            Object v = super.get(object);
            if (v != null && v != object2) {
                Integer n = (Integer)this.mUseCountMap.get(object);
                n = n != null ? new Integer(n + 1) : new Integer(1);
                this.mUseCountMap.put(object, n);
            }
            return super.put(object, object2);
        }

        int getUseCount(Object object) {
            Integer n = (Integer)this.mUseCountMap.get(object);
            return n != null ? n : 0;
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("DCDataControl.MethodResultsMap.putAll()");
        }

        public Object remove(Object object) {
            this.mUseCountMap.remove(object);
            return super.remove(object);
        }

        public void clear() {
            this.mUseCountMap.clear();
            super.clear();
        }

        public Object clone() {
            throw new UnsupportedOperationException("DCDataControl.MethodResultsMap.clone()");
        }
    }

    public final class 1
    implements JboExceptionHandler {
        ArrayList al;
        private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;

        private /* synthetic */ void $init$() {
            this.al = null;
        }

        public void handleException(Exception exception, boolean bl) {
            if (this.al == null) {
                this.al = new ArrayList(5);
            }
            this.al.add(exception);
        }

        public void handleWarning(JboWarning jboWarning) {
            if (Diagnostic.isOn()) {
                Diagnostic.println(jboWarning.getMessage());
            }
        }

        public void finishedProcessingPiggyback(Exception[] exceptionArray) {
            if (this.al != null && this.al.size() > 0) {
                Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$uicli$UIMessageBundle = 1.class$("oracle.jbo.uicli.UIMessageBundle");
                }
                JboException jboException = new JboException(clazz, "34005", null, this.al.toArray(new Exception[this.al.size()]));
                this.al = null;
                throw jboException;
            }
        }

        public /* synthetic */ 1() {
            this.$init$();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

