/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.adf.model.AttributeBinding;
import oracle.adf.model.BindingContext;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.RegionBinding;
import oracle.adf.model.RegionContext;
import oracle.adf.model.RegionController;
import oracle.adf.model.RegionListener;
import oracle.adf.model.binding.DCBindingContainerDef;
import oracle.adf.model.binding.DCBindingContainerReference;
import oracle.adf.model.binding.DCBindingContainerState;
import oracle.adf.model.binding.DCBindingContainerValidationEvent;
import oracle.adf.model.binding.DCBindingContainerValidationListener;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCExecutableBinding;
import oracle.adf.model.binding.DCIExecutable;
import oracle.adf.model.binding.DCIExecutableAdapter;
import oracle.adf.model.binding.DCIExecutableDef;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.adf.model.binding.DCParameter;
import oracle.adf.model.binding.DCStatusBarInterface;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.binding.PermissionBinding;
import oracle.adf.model.binding.PermissionHelper;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.binding.ControlBinding;
import oracle.binding.OperationBinding;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.JboExceptionHandler;
import oracle.jbo.JboWarning;
import oracle.jbo.LocaleContext;
import oracle.jbo.NameClashException;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ValidationException;
import oracle.jbo.Variable;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.domain.NullValue;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public class DCBindingContainer
extends DCExecutableBinding
implements VariableManagerOwner,
JboExceptionHandler,
RegionBinding {
    protected DCDataControl mDataControl;
    private DCBindingContainerDef mBindingContainerDef;
    private Object mViewComponent;
    private ArrayList mExcs;
    private HashMap mParams;
    protected ArrayList mParamsList;
    private HashMap mIterBindings;
    protected ArrayList mIterBindingList;
    private HashMap mControls;
    protected ArrayList mControlList;
    private DCBindingContainer mParent;
    private ArrayList mRegionsList;
    private HashMap mExecutables;
    private ArrayList mExecutablesList;
    boolean mFindMode;
    private LocaleContext mLocaleContext;
    boolean mExecuteOnRollback;
    protected ApplicationModule mDataProvider;
    ArrayList mValidationListeners;
    private BindingContext mBindingContext;
    boolean mInited;
    int mTrackInputs;
    boolean mEnableTokenValidation;
    private Map mAliases;
    private Map mParamValues;
    private boolean mParentBeingValidated;
    transient Object mActionProcessor;
    transient RegionController mRegionController;
    transient ArrayList mRegionListeners;
    transient int mTransientRefreshType;
    private PermissionInfo mPermissionInfo;
    static final String GET_EditingMode = "editingMode";
    static final String GET_ExceptionsList = "exceptionsList";
    static final String GET_StateToken = "statetoken";
    static final String GET_StateTokenId = "statetokenid";
    static final String GET_VariableManager = "variableManager";
    static final String GET_Viewable = "viewable";
    static final String GET_Parameters = "parametersMap";
    static final String GET_Executables = "executableBindings";
    static final String GET_This = "bindings";
    private static final String NO_VARIABLE_INDICATOR = "%V%=N";
    private static final String VARIABLE_DELIMITER = ";#;";
    private static final String VARIABLES_END_DELIMITER = ":#:";
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;

    private /* synthetic */ void $init$() {
        this.mIterBindings = new HashMap(5);
        this.mIterBindingList = new ArrayList(5);
        this.mControls = new HashMap(10);
        this.mControlList = new ArrayList(10);
        this.mFindMode = false;
        this.mExecuteOnRollback = true;
        this.mInited = false;
        this.mTrackInputs = 0;
        this.mEnableTokenValidation = true;
        this.mParentBeingValidated = false;
        this.mTransientRefreshType = -1;
        this.mPermissionInfo = null;
    }

    public DCBindingContainer() {
        this.$init$();
    }

    public boolean isTokenValidationEnabled() {
        return this.mEnableTokenValidation;
    }

    public void setEnableTokenValidation(boolean bl) {
        this.mEnableTokenValidation = bl;
    }

    protected DCBindingContainer(Object object) {
        this.$init$();
        if (object != null) {
            this.setViewComponentInternal(object);
        }
    }

    void reportException(DCDataControl dCDataControl, Throwable throwable) {
        JboException jboException;
        if (Diagnostic.isOn()) {
            Diagnostic.println("DCBindingContainer.reportException :" + (throwable != null ? throwable.getClass().getName() : "null exception"));
            if (throwable != null) {
                Diagnostic.printStackTrace(throwable);
            }
        }
        JboException jboException2 = jboException = throwable instanceof JboException ? (JboException)throwable : new JboException(throwable);
        if (dCDataControl != null) {
            dCDataControl.reportException(this, jboException);
        } else {
            BindingContext bindingContext = this.getBindingContext();
            if (bindingContext != null && bindingContext.getErrorHandler() != null) {
                bindingContext.getErrorHandler().reportException(this, jboException);
            } else {
                JUMetaObjectManager.reportException(this, (Exception)jboException);
            }
        }
    }

    public void reportException(Throwable throwable) {
        DCDataControl dCDataControl = null;
        try {
            dCDataControl = this.getDataControl();
        }
        catch (JboException jboException) {
            Diagnostic.println("Ignoring during reportException :" + jboException);
        }
        this.reportException(dCDataControl, throwable);
    }

    protected void setBindingContext(BindingContext bindingContext) {
        this.mBindingContext = bindingContext;
    }

    public BindingContext getBindingContext() {
        return this.mBindingContext;
    }

    public void setDataControl(DCDataControl dCDataControl) {
        if (this.mDataControl != null && dCDataControl != this.mDataControl) {
            Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$uicli$UIMessageBundle = DCBindingContainer.class$("oracle.jbo.uicli.UIMessageBundle");
            }
            throw new InvalidOperException(clazz, "34002", new Object[]{this.getName()});
        }
        if (dCDataControl != this.mDataControl) {
            this.mDataControl = dCDataControl;
            if (dCDataControl != null && this.mParent == null) {
                dCDataControl.addBindingContainer(this);
                if (this.mDataProvider != dCDataControl.getApplicationModule()) {
                    this.mDataProvider = dCDataControl.getApplicationModule();
                }
            }
        }
    }

    public final DCBindingContainerDef getDef() {
        return this.mBindingContainerDef;
    }

    protected void setDef(DCBindingContainerDef dCBindingContainerDef) {
        this.mBindingContainerDef = dCBindingContainerDef;
        if (dCBindingContainerDef != null) {
            this.mValidationListeners = dCBindingContainerDef.mValidators;
        }
        super.setExecutableDef(dCBindingContainerDef);
    }

    public void initializeFromDef(BindingContext bindingContext, ApplicationModule applicationModule) {
        this.setBindingContext(bindingContext);
        this.mBindingContainerDef.initializeBindingContainer(this, applicationModule);
    }

    public final Object getViewComponent() {
        return this.mViewComponent;
    }

    protected void setViewComponentInternal(Object object) {
        this.mViewComponent = object;
    }

    public final ApplicationModule getApplicationModule() {
        if (this.mDataProvider == null) {
            this.mDataProvider = this.getDataControl().getApplicationModule();
        }
        return this.mDataProvider;
    }

    public void setApplicationModule(ApplicationModule applicationModule) {
        this.mDataProvider = applicationModule;
    }

    void setRegionContainer(DCBindingContainer dCBindingContainer) {
        this.mParent = dCBindingContainer;
    }

    public final DCBindingContainer getRegionContainer() {
        return this.mParent;
    }

    public final List getRegionBindings() {
        return (List)(this.mRegionsList != null ? this.mRegionsList.clone() : null);
    }

    public final List getExecutableBindings() {
        return (List)(this.mExecutablesList != null ? this.mExecutablesList.clone() : null);
    }

    public final RegionBinding findRegionBinding(String string) {
        return (RegionBinding)this.findExecutableBinding(string);
    }

    public final boolean usesDef(DCBindingContainerDef dCBindingContainerDef) {
        if (this.getExecutableDef() == dCBindingContainerDef) {
            return true;
        }
        if (this.mRegionsList != null) {
            int n = 0;
            while (n < this.mRegionsList.size()) {
                DCExecutableBinding dCExecutableBinding = (DCExecutableBinding)this.mRegionsList.get(n);
                DCIExecutableDef dCIExecutableDef = dCExecutableBinding.getExecutableDef();
                if (dCIExecutableDef == dCBindingContainerDef) {
                    return true;
                }
                if (dCExecutableBinding instanceof DCBindingContainer && ((DCBindingContainer)dCExecutableBinding).usesDef(dCBindingContainerDef)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public final Object findExecutableBinding(String string) {
        return this.mExecutables != null ? this.mExecutables.get(string) : null;
    }

    public final void addExecutableBinding(Object object) {
        if (object instanceof DCIExecutable) {
            this.addExecutableBinding(((DCIExecutable)object).getName(), object);
        } else {
            this.addExecutableBinding(this.getDef().adaptExecutableBinding(null, object));
        }
    }

    public final void addExecutableBinding(String string, Object object) {
        boolean bl;
        int n;
        DCIExecutable dCIExecutable;
        block12: {
            dCIExecutable = (DCIExecutable)object;
            n = dCIExecutable.getExecutableType();
            boolean bl2 = bl = (string == null || string.length() == 0) && dCIExecutable != null;
            if (this.mExecutables == null) {
                this.mExecutables = new HashMap(10);
                this.mExecutablesList = new ArrayList();
            }
            do {
                if (bl) {
                    string = DCUtil.generateIteratorName(dCIExecutable);
                } else if (!JboNameUtil.isNameValid(string)) {
                    throw new InvalidObjNameException(611, string);
                }
                if (this.mExecutables.get(string) == null) break block12;
            } while (bl);
            throw new NameClashException(611, string);
        }
        if (string != null && string.length() != 0) {
            if (dCIExecutable != null && bl) {
                dCIExecutable.setName(string);
            }
            this.mExecutablesList.add(dCIExecutable);
            this.mExecutables.put(string, dCIExecutable);
            dCIExecutable.setBindingContainer(this);
            if (n == 0) {
                if (dCIExecutable instanceof DCBindingContainer) {
                    DCBindingContainer dCBindingContainer = (DCBindingContainer)dCIExecutable;
                    dCBindingContainer.setRegionContainer(this);
                    dCBindingContainer.setBindingContext(this.getBindingContext());
                }
                if (this.mRegionsList == null) {
                    this.mRegionsList = new ArrayList(5);
                }
                this.mRegionsList.add(dCIExecutable);
            } else if (n == 1) {
                this.mIterBindingList.add(dCIExecutable);
                this.mIterBindings.put(string, dCIExecutable);
            }
        }
    }

    public final boolean removeExecutableBinding(String string) {
        DCIExecutable dCIExecutable;
        boolean bl = false;
        if (this.mExecutables != null && (dCIExecutable = (DCIExecutable)this.mExecutables.get(string)) != null) {
            if (dCIExecutable instanceof DCBindingContainer) {
                ((DCBindingContainer)dCIExecutable).release(DCDataControl.REL_VIEW_REFS);
                if (this.mRegionsList != null) {
                    this.mRegionsList.remove(dCIExecutable);
                }
            } else if (dCIExecutable instanceof DCIteratorBinding) {
                this.mIterBindingList.remove(dCIExecutable);
                this.mIterBindings.remove(string);
            }
            this.mExecutables.remove(string);
            this.mExecutablesList.remove(dCIExecutable);
            bl = true;
        }
        return bl;
    }

    protected final void clearExecutableBindings() {
        if (this.mExecutablesList != null) {
            int n = 0;
            while (n < this.mExecutablesList.size()) {
                this.mExecutablesList.remove(this.mExecutablesList.get(n));
                ++n;
            }
            this.mExecutablesList.clear();
            this.mExecutables.clear();
        }
    }

    public final HashMap getIterBindings() {
        return (HashMap)this.mIterBindings.clone();
    }

    public final ArrayList getIterBindingList() {
        return (ArrayList)this.mIterBindingList.clone();
    }

    public final ArrayList getAllIterBindingList() {
        ArrayList arrayList = (ArrayList)this.mIterBindingList.clone();
        if (this.mRegionsList != null) {
            int n = 0;
            while (n < this.mRegionsList.size()) {
                RegionBinding regionBinding = (RegionBinding)this.mRegionsList.get(n);
                if (regionBinding instanceof DCBindingContainer) {
                    arrayList.addAll(((DCBindingContainer)regionBinding).getIterBindingList());
                }
                ++n;
            }
        }
        return arrayList;
    }

    public final DCIteratorBinding findIteratorBinding(String string) {
        if (string != null && string.indexOf(46) > 0) {
            return (DCIteratorBinding)DCUtil.findSpelObject((Object)this, string, false);
        }
        return (DCIteratorBinding)this.mIterBindings.get(string);
    }

    public final void addIteratorBinding(DCIteratorBinding dCIteratorBinding) {
        this.addIteratorBinding(null, dCIteratorBinding);
    }

    public final void addIteratorBinding(String string, DCIteratorBinding dCIteratorBinding) {
        block4: {
            boolean bl;
            boolean bl2 = bl = string == null || string.length() == 0;
            do {
                if (bl) {
                    string = DCUtil.generateIteratorName(dCIteratorBinding);
                } else if (!JboNameUtil.isNameValid(string)) {
                    throw new InvalidObjNameException(612, string);
                }
                if (this.getChildByName(string) == null) break block4;
            } while (bl);
            throw new NameClashException(612, string);
        }
        dCIteratorBinding.setName(string);
        this.addExecutableBinding(string, dCIteratorBinding);
    }

    public final boolean removeIteratorBinding(String string) {
        return this.removeExecutableBinding(string);
    }

    protected final void clearIteratorBindings() {
        int n = 0;
        while (n < this.mIterBindingList.size()) {
            DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n);
            this.mExecutablesList.remove(dCIteratorBinding);
            this.mExecutables.remove(dCIteratorBinding.getName());
            ++n;
        }
        this.mIterBindingList.clear();
        this.mIterBindings.clear();
    }

    final void addParameter(DCParameter dCParameter, String string) {
        if (string == null) {
            throw new InvalidObjNameException(613, string);
        }
        if (dCParameter.getBindingContainer() != this) {
            DCBindingContainer dCBindingContainer = dCParameter.getBindingContainer();
            if (dCBindingContainer != null) {
                dCBindingContainer.removeParameter(dCParameter);
                dCParameter.setBindingContainer(null);
            }
            dCParameter.setName(string);
            dCParameter.setBindingContainer(this);
            return;
        }
        if (string != null && !string.equals(dCParameter.getName())) {
            dCParameter.setName(string);
        } else {
            this.addBinding(dCParameter, false);
        }
    }

    public final void addControlBinding(DCControlBinding dCControlBinding) {
        this.addBinding(dCControlBinding, true);
    }

    private void addBinding(DCControlBinding dCControlBinding, boolean bl) {
        String string;
        block8: {
            boolean bl2;
            string = dCControlBinding.getName();
            boolean bl3 = bl2 = string == null || string.length() == 0;
            do {
                if (bl2) {
                    string = DCUtil.generateControlName(dCControlBinding);
                } else if (!JboNameUtil.isNameValid(string)) {
                    throw new InvalidObjNameException(613, string);
                }
                if (this.getChildByName(string) == null) break block8;
            } while (bl2);
            throw new NameClashException(613, string);
        }
        dCControlBinding.internalSetName(string);
        if (string != null) {
            if (bl) {
                this.mControls.put(string, dCControlBinding);
                this.mControlList.add(dCControlBinding);
            } else {
                if (this.mParams == null) {
                    this.mParams = new HashMap(4);
                    this.mParamsList = new ArrayList(4);
                }
                this.mParams.put(string, dCControlBinding);
                this.mParamsList.add(dCControlBinding);
            }
        }
    }

    public final void addControlBinding(String string, DCControlBinding dCControlBinding) {
        if (dCControlBinding.getBindingContainer() != this) {
            if (dCControlBinding.getBindingContainer() == null && string != null && !string.equals(dCControlBinding.getName())) {
                dCControlBinding.setName(string);
            }
            dCControlBinding.setBindingContainer(this);
        }
        if (string != null && !string.equals(dCControlBinding.getName())) {
            dCControlBinding.setName(string);
        } else if (string == null) {
            this.addControlBinding(dCControlBinding);
        }
    }

    public final List getControlBindings() {
        return this.getCtrlBindingList();
    }

    public final ArrayList getCtrlBindingList() {
        return (ArrayList)this.mControlList.clone();
    }

    public List getAttributeBindings() {
        int n = this.mControlList.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = this.mControlList.get(n2);
            if (e instanceof oracle.binding.AttributeBinding) {
                arrayList.add(e);
            }
            ++n2;
        }
        return arrayList;
    }

    public List getOperationBindings() {
        int n = this.mControlList.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = this.mControlList.get(n2);
            if (e instanceof OperationBinding) {
                arrayList.add(e);
            }
            ++n2;
        }
        return arrayList;
    }

    public final List getParametersList() {
        return (List)(this.mParamsList != null ? this.mParamsList.clone() : null);
    }

    public final Map getParametersMap() {
        return (Map)(this.mParams != null ? this.mParams.clone() : null);
    }

    public final DCParameter findParameter(String string) {
        if (this.mParams == null) {
            return null;
        }
        if (string != null && string.indexOf(46) > 0) {
            return (DCParameter)DCUtil.findSpelObject((Object)this, string, false);
        }
        return (DCParameter)this.mParams.get(string);
    }

    public final DCControlBinding getCtrlBinding(int n) {
        return (DCControlBinding)this.mControlList.get(n);
    }

    public final DCControlBinding findCtrlBinding(String string) {
        if (string != null && string.indexOf(46) > 0) {
            return (DCControlBinding)DCUtil.findSpelObject((Object)this, string, false);
        }
        return (DCControlBinding)this.mControls.get(string);
    }

    public final ControlBinding getControlBinding(String string) {
        return (ControlBinding)this.findCtrlBinding(string);
    }

    public final OperationBinding getOperationBinding(String string) {
        return (OperationBinding)this.findCtrlBinding(string);
    }

    final Object evaluateParameter(String string, boolean bl, boolean bl2) {
        Object object = null;
        boolean bl3 = DCUtil.isElExpr(string);
        object = bl3 ? DCUtil.elEvaluate(this.getBindingContext(), this, string) : DCUtil.findSpelObject((Object)this, new StringBuffer(string), false);
        if (object instanceof DCParameter) {
            DCParameter dCParameter = (DCParameter)object;
            object = null;
            if (dCParameter.getBindingContainer() == this && this.mParamValues != null && this.mParamValues.containsKey(dCParameter.getName()) && !dCParameter.isFinal()) {
                object = this.mParamValues.get(dCParameter.getName());
            }
            if (object == null && (object = dCParameter.getValue()) == null && bl2) {
                object = dCParameter.getExpression();
            }
        }
        if (object == null && bl && !bl3) {
            object = DCUtil.findSpelObject((Object)this.getBindingContext(), new StringBuffer(string), false);
        }
        return object;
    }

    public final Object evaluateParameter(String string, boolean bl) {
        return this.evaluateParameter(string, bl, false);
    }

    public final void setParameterExpression(String string, String string2) {
        if (this.mAliases == null) {
            this.mAliases = new HashMap(5);
        }
        if (Diagnostic.isOn() && this.mAliases.get(string) != null) {
            Diagnostic.println("Overriding existing parameter of name:" + string + " with value expression:" + string2);
        }
        this.mAliases.put(string, string2);
    }

    public final void setParameterValues(Map map) {
        if (map != null) {
            HashMap hashMap = new HashMap();
            hashMap.putAll(map);
            this.mParamValues = hashMap;
        } else {
            this.mParamValues = null;
        }
    }

    public final DCDataControl findDataControl(String string) {
        return (DCDataControl)this.evaluateParameter(string, true, true);
    }

    void setAliasesMap(Map map) {
        this.mAliases = map;
    }

    public String getParameterAlias(String string) {
        return this.mAliases != null ? this.mAliases.get(string) : null;
    }

    public boolean aliasExists(String string) {
        return this.mAliases != null ? this.mAliases.containsKey(string) : false;
    }

    public DCBindingContainer getRootBindingContainer() {
        if (this.getRegionContainer() == null) {
            return this;
        }
        return this.getRegionContainer().getRootBindingContainer();
    }

    public final DCControlBinding getCtrlBinding(Object object) {
        int n = this.mControlList.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.mControlList.get(n2);
            if (e instanceof DCControlBinding && ((DCControlBinding)e).getControl() == object) {
                return (DCControlBinding)e;
            }
            ++n2;
        }
        return null;
    }

    public final boolean removeParameter(DCParameter dCParameter) {
        if (this.mParams != null) {
            String string = dCParameter.getName();
            this.mParams.remove(string);
            return this.mParamsList.remove(dCParameter);
        }
        return false;
    }

    public final boolean removeControlBinding(DCControlBinding dCControlBinding) {
        String string = dCControlBinding.getName();
        this.mControls.remove(string);
        return this.mControlList.remove(dCControlBinding);
    }

    public final boolean removeControlBinding(String string) {
        boolean bl = false;
        DCControlBinding dCControlBinding = (DCControlBinding)this.mControls.get(string);
        if (dCControlBinding != null) {
            this.mControls.remove(string);
            bl = this.mControlList.remove(dCControlBinding);
        }
        return bl;
    }

    public final boolean removeParameter(String string) {
        DCControlBinding dCControlBinding;
        boolean bl = false;
        if (this.mParams != null && (dCControlBinding = (DCControlBinding)this.mParams.get(string)) != null) {
            this.mParams.remove(string);
            bl = this.mParamsList.remove(dCControlBinding);
        }
        return bl;
    }

    public void execute() {
        this.internalRefreshControl(0, false);
    }

    /*
     * Unable to fully structure code
     */
    private void oldExecute() {
        block20: {
            var2_1 = this.mIterBindingList.size();
            var5_2 = new ArrayList<DCDataControl>(4);
            var6_3 = false;
            try {
                var4_4 = 0;
                while (var4_4 < var2_1) {
                    var1_5 = (DCIteratorBinding)this.mIterBindingList.get(var4_4);
                    var1_5.suspendRowSetEventsHandling(true);
                    var3_7 = var1_5.getDataControl();
                    if (var3_7 != null && (var3_7.getApplicationModule() != null || var3_7.syncNeeded()) && !var5_2.contains(var3_7)) {
                        var6_3 = var6_3 != false ? true : var3_7.syncNeeded();
                        var5_2.add(var3_7);
                        var3_7.getRootDataControl().getApplicationModule().setExceptionHandler(this);
                    }
                    ++var4_4;
                }
                var8_8 = 0;
                while (var8_8 < this.mIterBindingList.size()) {
                    var1_5 = (DCIteratorBinding)this.mIterBindingList.get(var8_8);
                    var7_9 = var1_5.getRowSetIterator();
                    if (var7_9 != null) {
                        if (var6_3) {
                            if (var1_5.mRangeSize != DCIteratorBinding.RANGESIZE_DO_NOT_OVERRIDE) {
                                var7_9.setRangeSize(var1_5.mRangeSize);
                            }
                        } else if (var1_5.getDataControl().isJClientApp() && var1_5.mRangeSize != DCIteratorBinding.RANGESIZE_DO_NOT_OVERRIDE) {
                            var7_9.setRangeSize(var1_5.mRangeSize);
                        }
                    }
                    var1_5.executeQuery();
                    ++var8_8;
                }
                var9_10 = null;
                var4_4 = 0;
                while (var4_4 < var5_2.size()) {
                    try {
                        ((DCDataControl)var5_2.get(var4_4)).sync("DCBindingContainer.execute");
                    }
                    catch (JboException var10_11) {
                        var9_10 = var10_11;
                    }
                    ++var4_4;
                }
                var2_1 = this.mIterBindingList.size();
                var11_12 = 0;
                while (var11_12 < var2_1) {
                    var1_5 = (DCIteratorBinding)this.mIterBindingList.get(var11_12);
                    var7_9 = var1_5.getRowSetIterator();
                    if (var7_9 != null) {
                        var7_9.reset();
                    }
                    ++var11_12;
                }
                if (var9_10 != null) {
                    throw var9_10;
                }
                var15_13 = null;
                var12_15 = 0;
                ** while (var12_15 < this.mIterBindingList.size())
            }
            catch (Throwable var14_19) {
                var15_14 = null;
                var12_16 = 0;
                ** while (var12_16 < this.mIterBindingList.size())
            }
lbl-1000:
            // 1 sources

            {
                var1_5 = (DCIteratorBinding)this.mIterBindingList.get(var12_15);
                var1_5.suspendRowSetEventsHandling(false);
                ++var12_15;
                continue;
            }
lbl61:
            // 1 sources

            var13_17 = 0;
            while (var13_17 < this.mIterBindingList.size()) {
                var1_5 = (DCIteratorBinding)this.mIterBindingList.get(var13_17);
                var1_5.rangeRefreshed(null);
                ++var13_17;
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                var1_6 = (DCIteratorBinding)this.mIterBindingList.get(var12_16);
                var1_6.suspendRowSetEventsHandling(false);
                ++var12_16;
                continue;
            }
lbl77:
            // 1 sources

            var13_18 = 0;
            while (var13_18 < this.mIterBindingList.size()) {
                var1_6 = (DCIteratorBinding)this.mIterBindingList.get(var13_18);
                var1_6.rangeRefreshed(null);
                ++var13_18;
            }
            throw var14_19;
        }
    }

    public void executeIfNeeded() {
        DCIteratorBinding dCIteratorBinding;
        DCDataControl dCDataControl = this.getDataControl();
        boolean bl = dCDataControl != null ? dCDataControl.syncNeeded() : false;
        int n = this.mIterBindingList.size();
        int n2 = 0;
        while (n2 < n) {
            dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n2);
            RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
            if (bl) {
                dCIteratorBinding.suspendRowSetEventsHandling(true);
                if (dCIteratorBinding.mRangeSize != DCIteratorBinding.RANGESIZE_DO_NOT_OVERRIDE) {
                    dCIteratorBinding.setRangeSizeForRSI(rowSetIterator, dCIteratorBinding.mRangeSize);
                }
            } else if (dCDataControl.isJClientApp() && dCIteratorBinding.mRangeSize != DCIteratorBinding.RANGESIZE_DO_NOT_OVERRIDE) {
                dCIteratorBinding.setRangeSizeForRSI(rowSetIterator, dCIteratorBinding.mRangeSize);
            }
            dCIteratorBinding.executeQueryIfNeeded();
            ++n2;
        }
        if (bl) {
            dCDataControl.syncIfNeeded("DCBindingContainer.executeIfNeeded");
            int n3 = 0;
            while (n3 < n) {
                dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n3);
                RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
                if (rowSetIterator != null) {
                    rowSetIterator.reset();
                }
                dCIteratorBinding.suspendRowSetEventsHandling(false);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n4);
                dCIteratorBinding.rangeRefreshed(null);
                ++n4;
            }
        }
    }

    public DCIteratorBinding getIteratorBinding(String string, String string2, String string3) {
        return this.getIteratorBinding(string, string2, string3, 1);
    }

    public DCIteratorBinding getIteratorBinding(String string, String string2, String string3, int n) {
        DCIteratorBinding dCIteratorBinding = this.findIteratorBinding(string3);
        if (dCIteratorBinding == null) {
            dCIteratorBinding = this.createIteratorBinding(string, string2, string3, n);
            this.addIteratorBinding(string3, dCIteratorBinding);
            if (this.mDataControl != null) {
                dCIteratorBinding.internalSetDataControl(this.mDataControl);
            }
        } else {
            dCIteratorBinding.resolveRangeSize(n);
        }
        return dCIteratorBinding;
    }

    protected DCIteratorBinding createIteratorBinding(String string, String string2, String string3, int n) {
        return null;
    }

    public void setFindMode(boolean bl) {
        this.setFindMode(bl, true);
    }

    public void setFindMode(boolean bl, boolean bl2) {
        if (bl != this.mFindMode) {
            this.mFindMode = bl;
            if (this.mExecutablesList != null) {
                int n = 0;
                while (n < this.mExecutablesList.size()) {
                    DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n);
                    int n2 = dCIExecutable.getExecutableType();
                    if (n2 == 0) {
                        if (dCIExecutable instanceof DCBindingContainer) {
                            ((DCBindingContainer)dCIExecutable).setFindMode(bl, bl2);
                        }
                    } else if (n2 == 1) {
                        DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)dCIExecutable;
                        if (dCIteratorBinding.isFindModeAllowed()) {
                            dCIteratorBinding.setFindMode(bl, bl2);
                            this.notifyIteratorChanged(dCIteratorBinding, false);
                        } else if (dCIteratorBinding.getDataControl().isJClientApp()) {
                            dCIteratorBinding.refreshControl();
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public boolean isFindMode() {
        return this.mFindMode;
    }

    public String getEditingMode() {
        if (this.isFindMode()) {
            return "*Find Mode";
        }
        return "";
    }

    public void addStatusBarInterface(DCStatusBarInterface dCStatusBarInterface) {
        if (this.getDataControl() != null) {
            this.mDataControl.addStatusBarInterface(dCStatusBarInterface);
        }
    }

    public void removeStatusBarInterface(DCStatusBarInterface dCStatusBarInterface) {
        if (this.mDataControl != null) {
            this.mDataControl.removeStatusBarInterface(dCStatusBarInterface);
        }
    }

    public void displayStatus(DCIteratorBinding dCIteratorBinding, String string, Object[] objectArray) {
        if (this.mDataControl != null) {
            this.mDataControl.displayStatus(dCIteratorBinding, string, objectArray);
        }
    }

    public void displayStatus(String string) {
        if (this.mDataControl != null) {
            this.mDataControl.displayStatus(string);
        }
    }

    public LocaleContext getLocaleContext() {
        if (this.getBindingContext() != null) {
            return this.getBindingContext().getLocaleContext();
        }
        if (this.mLocaleContext == null) {
            this.mLocaleContext = this.getDataControl() != null ? this.getDataControl().getLocaleContext() : null;
        }
        return this.mLocaleContext;
    }

    public boolean isExecuteOnRollback() {
        return this.mExecuteOnRollback;
    }

    public void setExecuteOnRollback(boolean bl) {
        this.mExecuteOnRollback = bl;
    }

    public void release() {
        this.release(DCDataControl.REL_ALL_REFS);
    }

    public void release(int n) {
        BindingContext bindingContext = this.getBindingContext();
        if (bindingContext == null) {
            return;
        }
        this.mRegionController = null;
        this.mActionProcessor = null;
        this.mExcs = null;
        ArrayList arrayList = (ArrayList)this.mControlList.clone();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            ((DCControlBinding)arrayList.get(n2)).release(n);
            ++n2;
        }
        if (this.mExecutables != null) {
            arrayList = (ArrayList)this.mExecutablesList.clone();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                ((DCIExecutable)arrayList.get(n3)).release(n);
                ++n3;
            }
        }
        if (this.mIterBindingList.size() > 0) {
            arrayList = (ArrayList)this.mIterBindingList.clone();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                ((DCIteratorBinding)arrayList.get(n4)).release(n);
                ++n4;
            }
        }
        if (this.mParamsList != null && this.mParamsList.size() > 0) {
            arrayList = (ArrayList)this.mParamsList.clone();
            int n5 = 0;
            while (n5 < arrayList.size()) {
                ((DCParameter)arrayList.get(n5)).release(n);
                ++n5;
            }
        }
        if (n == DCDataControl.REL_ALL_REFS) {
            this.mControls = new HashMap(10);
            this.mControlList = new ArrayList(10);
            this.mParams = null;
            this.mParamsList = null;
            this.mIterBindings = new HashMap(5);
            this.mIterBindingList = new ArrayList(5);
            this.mExecutables = null;
            this.mExecutablesList = null;
            this.mRegionsList = null;
            this.mValidationListeners = null;
            this.mRegionListeners = null;
            this.mDataProvider = null;
            if (this.mDataControl != null) {
                this.mDataControl.removeBindingContainer(this);
                this.mDataControl = null;
            }
        }
        if ((n & DCDataControl.REL_DATA_REFS) > 0 || (n & DCDataControl.REL_WEAK_DATA_REFS) > 0) {
            this.mDataProvider = null;
            this.mFindMode = false;
        }
        if ((n & DCDataControl.REL_VIEW_REFS) > 0) {
            this.setViewComponentInternal(null);
        }
        if (n == DCDataControl.REL_ALL_REFS) {
            if (this == bindingContext.get(this.getName())) {
                bindingContext.remove(this.getName());
                bindingContext.put(this.getName(), new DCBindingContainerReference(bindingContext, this.getName(), this.mBindingContainerDef.getFullName()));
            }
            this.setBindingContext(null);
        }
        super.release(n);
    }

    protected void initializeViewComponent(ArrayList arrayList) {
    }

    protected void initializeApplicationModule() {
    }

    protected void focusGained(DCIteratorBinding dCIteratorBinding, DCControlBinding dCControlBinding, int n) {
    }

    protected void notifyIteratorChanged(DCIteratorBinding dCIteratorBinding, boolean bl) {
    }

    protected void rangeRefreshed(DCIteratorBinding dCIteratorBinding, RangeRefreshEvent rangeRefreshEvent) {
    }

    protected void rangeScrolled(DCIteratorBinding dCIteratorBinding, ScrollEvent scrollEvent) {
    }

    protected void rowInserted(DCIteratorBinding dCIteratorBinding, InsertEvent insertEvent) {
    }

    protected void rowDeleted(DCIteratorBinding dCIteratorBinding, DeleteEvent deleteEvent) {
    }

    protected void rowUpdated(DCIteratorBinding dCIteratorBinding, UpdateEvent updateEvent) {
    }

    protected void navigated(DCIteratorBinding dCIteratorBinding, NavigationEvent navigationEvent) {
    }

    public Object callBeforeSetAttribute(DCControlBinding dCControlBinding, Row row, AttributeDef attributeDef, Object object) {
        DCIteratorBinding dCIteratorBinding = dCControlBinding.getDCIteratorBinding();
        if (dCIteratorBinding != null) {
            dCIteratorBinding.insertCreatedRow();
        }
        DCBindingContainerValidationEvent dCBindingContainerValidationEvent = new DCBindingContainerValidationEvent(dCControlBinding, this, dCIteratorBinding, row, attributeDef.getName(), object);
        this.beforeSetAttribute(dCBindingContainerValidationEvent);
        return dCBindingContainerValidationEvent.getNewValue();
    }

    protected boolean isEditingStopped() {
        return true;
    }

    public void callBeforeRowNavigated(DCIteratorBinding dCIteratorBinding) {
        Row row = dCIteratorBinding.getCurrentRow();
        if (row != null) {
            this.beforeCurrencyChange(new DCBindingContainerValidationEvent(this, dCIteratorBinding, row));
        }
    }

    public void callBeforeSaveTransaction(DCDataControl dCDataControl) {
        this.beforeSaveTransaction(new DCBindingContainerValidationEvent(this, dCDataControl));
    }

    public void beforeSetAttribute(DCBindingContainerValidationEvent dCBindingContainerValidationEvent) {
        if (this.mValidationListeners != null) {
            ArrayList arrayList = this.mValidationListeners;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCBindingContainerValidationListener)arrayList.get(n)).beforeSetAttribute(dCBindingContainerValidationEvent);
                ++n;
            }
        }
    }

    public void beforeCurrencyChange(DCBindingContainerValidationEvent dCBindingContainerValidationEvent) {
        if (this.mValidationListeners != null) {
            ArrayList arrayList = this.mValidationListeners;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCBindingContainerValidationListener)arrayList.get(n)).beforeCurrencyChange(dCBindingContainerValidationEvent);
                ++n;
            }
        }
    }

    public void beforeSaveTransaction(DCBindingContainerValidationEvent dCBindingContainerValidationEvent) {
        if (this.mValidationListeners != null) {
            ArrayList arrayList = this.mValidationListeners;
            int n = 0;
            while (n < arrayList.size()) {
                ((DCBindingContainerValidationListener)arrayList.get(n)).beforeSaveTransaction(dCBindingContainerValidationEvent);
                ++n;
            }
        }
    }

    private Object getChildByName(String string) {
        Variable variable;
        VariableValueManager variableValueManager;
        Object var2_2 = null;
        Object v = this.mControls.get(string);
        var2_2 = v;
        if (v != null) {
            return var2_2;
        }
        if (this.mExecutables != null) {
            Object v2 = this.mExecutables.get(string);
            var2_2 = v2;
            if (v2 != null) {
                this.mInternalGet_KeyResolved = true;
                if (var2_2 instanceof DCIExecutableAdapter) {
                    ((DCIExecutableAdapter)var2_2).refreshIfNeeded();
                    return ((DCIExecutableAdapter)var2_2).getAdaptee();
                }
                return var2_2;
            }
        }
        if (this.mParams != null) {
            Object v3 = this.mParams.get(string);
            var2_2 = v3;
            if (v3 != null) {
                this.mInternalGet_KeyResolved = true;
                return ((DCParameter)var2_2).getValue();
            }
        }
        if ((variableValueManager = this.getVariableManager()) != null && (variable = variableValueManager.lookupVariable(string)) != null) {
            this.mInternalGet_KeyResolved = true;
            return variableValueManager.getVariableValue(variable);
        }
        return var2_2;
    }

    protected Object internalGet(String string) {
        string = string.intern();
        Object object = null;
        object = this.getChildByName(string);
        if (object != null || this.mInternalGet_KeyResolved) {
            this.mInternalGet_KeyResolved = true;
            return object;
        }
        if (string == GET_This) {
            this.mInternalGet_KeyResolved = true;
            return this;
        }
        if (string == GET_Viewable) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isViewable());
        }
        if (string == GET_Parameters) {
            this.mInternalGet_KeyResolved = true;
            return this.getParametersMap();
        }
        if (string == GET_Executables) {
            this.mInternalGet_KeyResolved = true;
            return this.getExecutableBindings();
        }
        if (string == GET_StateToken) {
            this.mInternalGet_KeyResolved = true;
            return this.getStateToken();
        }
        if (string == GET_StateTokenId) {
            this.mInternalGet_KeyResolved = true;
            return this.getStateTokenId();
        }
        if (string == GET_EditingMode) {
            this.mInternalGet_KeyResolved = true;
            return this.getEditingMode();
        }
        if (string == GET_ExceptionsList) {
            this.mInternalGet_KeyResolved = true;
            return this.getExceptionsList();
        }
        if (string == GET_VariableManager) {
            this.mInternalGet_KeyResolved = true;
            this.ensureVariableManager();
            return this.getVariableManager();
        }
        if (string == "data") {
            this.mInternalGet_KeyResolved = true;
            return this.getBindingContext();
        }
        return super.internalGet(string);
    }

    public int hashCode() {
        return this.mName.hashCode() + this.mIterBindings.hashCode() + this.mControls.hashCode();
    }

    public final void refresh(int n) {
        this.internalRefreshControl(n, true);
    }

    public final void refresh() {
        this.refreshControl();
    }

    public void refreshControl() {
        this.internalRefreshControl(-1, true);
    }

    protected void internalRefreshControl(int n, boolean bl) {
        this.setRefreshed(true);
        this.mTransientRefreshType = n;
        try {
            DCIteratorBinding dCIteratorBinding;
            if (Diagnostic.isOn()) {
                Diagnostic.println("**** refreshControl() for BindingContainer :" + this.getName());
            }
            int n2 = this.mIterBindingList.size();
            ArrayList<DCDataControl> arrayList = new ArrayList<DCDataControl>(3);
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n2) {
                LocaleContext localeContext;
                DCDataControl dCDataControl;
                dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n3);
                if (bl) {
                    dCIteratorBinding.releaseCurrentRow();
                }
                if (!((dCDataControl = dCIteratorBinding.getDataControl()) == null || (localeContext = dCDataControl.getLocaleContext()) != null && localeContext.equals(this.getLocaleContext()))) {
                    dCDataControl.setLocaleContext(this.getLocaleContext());
                    this.mInited = false;
                }
                if (dCDataControl != null && (dCDataControl.getApplicationModule() != null || dCDataControl.syncNeeded()) && !arrayList.contains(dCDataControl)) {
                    bl2 = bl2 ? true : dCDataControl.syncNeeded();
                    arrayList.add(dCDataControl);
                    dCDataControl.getRootDataControl().getApplicationModule().setExceptionHandler(this);
                }
                if (n == 1) {
                    dCIteratorBinding.setRefreshed(false);
                    dCIteratorBinding.initForRefresh();
                }
                ++n3;
            }
            if ((n == 1 || n == -1) && this.mParamsList != null) {
                this.evaluateParameters();
            }
            if (!this.mInited) {
                this.mInited = true;
                n3 = 0;
                while (n3 < this.mControlList.size()) {
                    ((DCControlBinding)this.mControlList.get(n3)).initResources();
                    ++n3;
                }
                n3 = 0;
                while (n3 < n2) {
                    dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n3);
                    dCIteratorBinding.fetchAttributeProperties();
                    ++n3;
                }
            }
            if (this.mRegionListeners != null) {
                RegionContextImpl regionContextImpl = new RegionContextImpl(this, n);
                ArrayList arrayList2 = (ArrayList)this.mRegionListeners.clone();
                int n4 = 0;
                while (n4 < arrayList2.size()) {
                    if (!((RegionListener)arrayList2.get(n4)).refreshRegion(regionContextImpl) && Diagnostic.isOn()) {
                        Diagnostic.println("BindingContainer :" + this.getName() + " not refreshed due to listener:" + ((RegionListener)arrayList2.get(n4)).getName());
                    }
                    ++n4;
                }
            }
            this.mInited = true;
            boolean bl3 = bl ^ true;
            if (this.mExecutablesList != null) {
                n3 = 0;
                while (n3 < this.mExecutablesList.size()) {
                    DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n3);
                    DCIExecutableDef dCIExecutableDef = dCIExecutable.getExecutableDef();
                    int n5 = dCIExecutable.getExecutableType();
                    if (n == 1) {
                        dCIExecutable.setRefreshed(false);
                    }
                    if (dCIExecutableDef == null || dCIExecutableDef.isRefreshable(this, dCIExecutable, n)) {
                        if (n5 == 0) {
                            if (bl3 && dCIExecutable instanceof DCBindingContainer) {
                                ((DCBindingContainer)dCIExecutable).internalRefreshControl(n, false);
                            } else {
                                RegionBinding regionBinding = (RegionBinding)((Object)dCIExecutable);
                                if (regionBinding.getRegionController() == null) {
                                    regionBinding.refresh(n);
                                } else {
                                    regionBinding.getRegionController().refreshRegion(new RegionContextImpl(regionBinding, n));
                                }
                            }
                        } else if (n5 == 1) {
                            dCIteratorBinding = (DCIteratorBinding)dCIExecutable;
                            dCIteratorBinding.suspendRowSetEventsHandling(true);
                            if (!dCIteratorBinding.isFindMode()) {
                                if (dCIteratorBinding.mRangeSize != DCIteratorBinding.RANGESIZE_DO_NOT_OVERRIDE) {
                                    dCIteratorBinding.setRangeSize(dCIteratorBinding.mRangeSize);
                                }
                                if (bl) {
                                    dCIteratorBinding.executeQueryIfNeeded();
                                } else {
                                    dCIteratorBinding.executeQuery();
                                }
                            } else {
                                dCIteratorBinding.getViewCriteria();
                                dCIExecutable.setRefreshed(dCIteratorBinding.getNavigatableRowIterator() != null);
                            }
                        } else {
                            dCIExecutable.refresh(n);
                            dCIExecutable.setRefreshed(true);
                        }
                    }
                    ++n3;
                }
            }
            if (this.mParent == null) {
                this.fetchAllNestedBatchDCs(arrayList);
                n3 = 0;
                while (n3 < arrayList.size()) {
                    try {
                        ((DCDataControl)arrayList.get(n3)).syncIfNeeded("DCBindingContainer.refresh");
                    }
                    catch (JboException jboException) {
                        this.reportException((DCDataControl)arrayList.get(n3), jboException);
                        Object var20_19 = null;
                        if (this.mParent == null || (bl ^= true)) {
                            this.resetSuspendedExecutables(bl, n);
                            if (this.mParent == null) {
                                this.refreshExecutables(bl, n);
                            }
                        }
                        this.mTransientRefreshType = -1;
                        return;
                    }
                    ++n3;
                }
            }
            Object var20_20 = null;
            if (this.mParent == null || (bl ^= true)) {
                this.resetSuspendedExecutables(bl, n);
                if (this.mParent == null) {
                    this.refreshExecutables(bl, n);
                }
            }
            this.mTransientRefreshType = -1;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            if (this.mParent == null || (bl ^= true)) {
                this.resetSuspendedExecutables(bl, n);
                if (this.mParent == null) {
                    this.refreshExecutables(bl, n);
                }
            }
            this.mTransientRefreshType = -1;
            throw throwable;
        }
    }

    void resetSuspendedExecutables(boolean bl, int n) {
        if (this.mExecutablesList == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.mExecutablesList.size()) {
            DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n2);
            if (dCIExecutable != null) {
                int n3 = dCIExecutable.getExecutableType();
                if (n3 == 0) {
                    if (dCIExecutable instanceof DCBindingContainer) {
                        ((DCBindingContainer)dCIExecutable).resetSuspendedExecutables(bl, n);
                    }
                } else if (n3 == 1) {
                    DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)dCIExecutable;
                    DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
                    if (bl && dCIteratorBinding.hasRSI() && (dCIteratorBindingDef == null || dCIteratorBindingDef.isRefreshable(this, dCIteratorBinding, n))) {
                        dCIteratorBinding.getRowSetIterator().reset();
                    }
                    dCIteratorBinding.suspendRowSetEventsHandling(false);
                }
            }
            ++n2;
        }
    }

    void refreshExecutables(boolean bl, int n) {
        if (this.mExecutablesList == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.mExecutablesList.size()) {
            DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n2);
            int n3 = dCIExecutable.getExecutableType();
            if (n3 == 0) {
                if (dCIExecutable instanceof DCBindingContainer && ((DCBindingContainer)dCIExecutable).getDef().isRefreshable(this, dCIExecutable, n)) {
                    ((DCBindingContainer)dCIExecutable).refreshExecutables(bl, n);
                }
            } else if (n3 == 1) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)dCIExecutable;
                DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
                if (dCIteratorBinding.isRefreshed() || dCIteratorBindingDef == null || dCIteratorBindingDef.isRefreshable(this, dCIteratorBinding, n)) {
                    dCIteratorBinding.refresh(n);
                }
            }
            ++n2;
        }
    }

    private void evaluateParameters() {
        int n = 0;
        while (n < this.mParamsList.size()) {
            ((DCParameter)this.mParamsList.get(n)).reEvaluateValueEagerly();
            ++n;
        }
    }

    void fetchAllNestedBatchDCs(List list) {
        if (this.mExecutablesList == null) {
            return;
        }
        int n = 0;
        while (n < this.mExecutablesList.size()) {
            DCDataControl dCDataControl;
            DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n);
            int n2 = dCIExecutable.getExecutableType();
            if (n2 == 0) {
                if (dCIExecutable instanceof DCBindingContainer) {
                    ((DCBindingContainer)dCIExecutable).fetchAllNestedBatchDCs(list);
                }
            } else if (n2 == 1 && (dCDataControl = ((DCIteratorBinding)dCIExecutable).getDataControl()) != null && (dCDataControl.getApplicationModule() != null || dCDataControl.syncNeeded()) && !list.contains(dCDataControl)) {
                list.add(dCDataControl);
            }
            ++n;
        }
    }

    public void resetInputState() {
        if (this.mExecutables == null) {
            return;
        }
        int n = 0;
        while (n < this.mExecutablesList.size()) {
            DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n);
            if (dCIExecutable != null) {
                int n2 = dCIExecutable.getExecutableType();
                if (n2 == 0) {
                    if (dCIExecutable instanceof DCBindingContainer) {
                        ((DCBindingContainer)dCIExecutable).resetInputState();
                    }
                } else if (n2 == 1 && this.mExcs != null) {
                    ((DCIteratorBinding)dCIExecutable).resetInputState();
                }
            }
            ++n;
        }
        this.mExcs = null;
    }

    public final List getRegionListeners() {
        ArrayList<RegionController> arrayList;
        ArrayList<RegionController> arrayList2 = arrayList = this.mRegionListeners != null ? (ArrayList)this.mRegionListeners.clone() : new ArrayList<RegionController>(0);
        if (this.getRegionController() != null) {
            arrayList.add(this.getRegionController());
        }
        return arrayList;
    }

    public final void addRegionListener(RegionListener regionListener) {
        if (this.mRegionListeners == null) {
            this.mRegionListeners = new ArrayList(4);
        }
        if (!this.mRegionListeners.contains(regionListener)) {
            this.mRegionListeners.add(regionListener);
        }
    }

    public final void removeRegionListener(RegionListener regionListener) {
        if (this.mRegionListeners != null) {
            this.mRegionListeners.remove(regionListener);
        }
    }

    public boolean isViewable() {
        if (this.mRegionListeners != null) {
            boolean bl = false;
            RegionContextImpl regionContextImpl = new RegionContextImpl(this, -1);
            ArrayList arrayList = (ArrayList)this.mRegionListeners.clone();
            int n = 0;
            while (n < arrayList.size()) {
                if (!((RegionListener)arrayList.get(n)).isRegionViewable(regionContextImpl)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                return false;
            }
        }
        return this.internalIsViewable();
    }

    private boolean internalIsViewable() {
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        if (securityContext.isAuthorizationEnabled()) {
            String string = this.mBindingContainerDef.getFullName();
            String string2 = PermissionHelper.getPermissionClassName(2);
            if (string2 == null) {
                return true;
            }
            Permission permission = (Permission)PermissionHelper.createPermissionInstance(string2, string, "View");
            return PermissionHelper.hasPermission(securityContext, permission);
        }
        return true;
    }

    public final ArrayList getValidationListeners() {
        return this.mValidationListeners != null ? (ArrayList)this.mValidationListeners.clone() : new ArrayList(0);
    }

    public final void addValidationListener(DCBindingContainerValidationListener dCBindingContainerValidationListener) {
        if (this.mValidationListeners == null) {
            this.mValidationListeners = new ArrayList(4);
        }
        if (!this.mValidationListeners.contains(dCBindingContainerValidationListener)) {
            this.mValidationListeners.add(dCBindingContainerValidationListener);
        }
    }

    public final void removeValidationListener(DCBindingContainerValidationListener dCBindingContainerValidationListener) {
        if (this.mValidationListeners != null) {
            this.mValidationListeners.remove(dCBindingContainerValidationListener);
        }
    }

    public final void validate() {
        try {
            this.mParentBeingValidated = true;
            RegionContextImpl regionContextImpl = new RegionContextImpl(this, -1);
            if (this.mRegionListeners != null) {
                ArrayList arrayList = (ArrayList)this.mRegionListeners.clone();
                int n = 0;
                while (n < arrayList.size()) {
                    if (!((RegionListener)arrayList.get(n)).validateRegion(regionContextImpl)) {
                        try {
                            Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                            if (clazz == null) {
                                clazz = class$oracle$adf$model$ADFmMessageBundle = DCBindingContainer.class$("oracle.adf.model.ADFmMessageBundle");
                            }
                            throw new ValidationException(clazz, "35005", new Object[]{((RegionListener)arrayList.get(n)).getName(), new Integer(n), this.getName()});
                        }
                        catch (ValidationException validationException) {
                            validationException.setSource(this);
                            this.reportException(validationException);
                        }
                    }
                    ++n;
                }
            }
            if (this.mRegionsList != null) {
                int n = 0;
                while (n < this.mRegionsList.size()) {
                    RegionBinding regionBinding = (RegionBinding)this.mRegionsList.get(n);
                    if (regionBinding.getRegionController() == null) {
                        regionBinding.validate();
                    } else {
                        regionContextImpl.internalSetRegion(regionBinding);
                        regionBinding.getRegionController().validateRegion(regionContextImpl);
                    }
                    ++n;
                }
            }
            Object var8_7 = null;
            this.mParentBeingValidated = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.mParentBeingValidated = false;
            throw throwable;
        }
        this.validateInputValues();
    }

    public void validateInputValues() {
        if (this.getRegionContainer() != null && this.getRegionContainer().mParentBeingValidated) {
            return;
        }
        if (this.mTrackInputs <= 0) {
            int n = 0;
            while (n < this.mIterBindingList.size()) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n);
                if (!dCIteratorBinding.isFindMode() && dCIteratorBinding.doneInput()) {
                    ++this.mTrackInputs;
                }
                ++n;
            }
        }
        if (this.mTrackInputs > 0) {
            this.mTrackInputs = 0;
            ArrayList arrayList = new ArrayList(5);
            this.collectNestedDCsForValidate(arrayList);
            int n = 0;
            while (n < arrayList.size()) {
                try {
                    ((DCDataControl)arrayList.get(n)).validate();
                }
                catch (Exception exception) {
                    this.reportException((DCDataControl)arrayList.get(n), exception);
                }
                ++n;
            }
        } else {
            this.mTrackInputs = 0;
        }
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            this.mPermissionInfo = new PermissionBinding(this.mBindingContainerDef.getFullName(), 2, this.getBindingContext());
        }
        return this.mPermissionInfo;
    }

    private void collectNestedDCsForValidate(ArrayList arrayList) {
        this.mTrackInputs = 0;
        if (this.mExecutablesList == null) {
            return;
        }
        int n = 0;
        while (n < this.mExecutablesList.size()) {
            DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n);
            int n2 = dCIExecutable.getExecutableType();
            if (n2 == 0) {
                if (dCIExecutable instanceof DCBindingContainer) {
                    ((DCBindingContainer)dCIExecutable).collectNestedDCsForValidate(arrayList);
                }
            } else if (n2 == 1) {
                DCDataControl dCDataControl;
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)dCIExecutable;
                if (!dCIteratorBinding.isFindMode() && (dCDataControl = dCIteratorBinding.getDataControl()) != null && !arrayList.contains(dCDataControl)) {
                    arrayList.add(dCDataControl);
                }
                dCIteratorBinding.doneInput();
            }
            ++n;
        }
    }

    void prepareForInput() {
        if (this.getRegionContainer() != null) {
            this.getRegionContainer().prepareForInput();
        } else {
            ++this.mTrackInputs;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processInputValues(Map var1_1) {
        block7: {
            block8: {
                if (var1_1 == null || var1_1.isEmpty()) {
                    return;
                }
                var3_2 = null;
                try {
                    var4_3 = var1_1.keySet().iterator();
                    while (var4_3.hasNext()) {
                        var5_6 = (String)var4_3.next();
                        var6_7 = (AttributeBinding)this.findCtrlBinding(var5_6);
                        if (!var6_7.processNewInputValue(var7_8 = var1_1.get(var5_6))) continue;
                        if (var3_2 == null) {
                            var3_2 = new ArrayList<DCIteratorBinding>();
                        }
                        var2_4 = ((DCControlBinding)var6_7).getDCIteratorBinding();
                        var2_4.internalReserveCurrentRow();
                        var3_2.add(var2_4);
                        var6_7.setInputValue(var7_8);
                    }
                    var10_9 = null;
                    if (var3_2 == null) break block7;
                    var8_11 = 0;
                    ** while (var8_11 < var3_2.size())
                }
                catch (Throwable var9_13) {
                    var10_10 = null;
                    if (var3_2 == null) break block8;
                    var8_12 = 0;
                    ** while (var8_12 < var3_2.size())
                }
lbl-1000:
                // 1 sources

                {
                    var2_4 = (DCIteratorBinding)var3_2.get(var8_11);
                    var2_4.releaseCurrentRow();
                    ++var8_11;
                    continue;
lbl26:
                    // 1 sources

                    break block7;
                }
lbl-1000:
                // 1 sources

                {
                    var2_5 = (DCIteratorBinding)var3_2.get(var8_12);
                    var2_5.releaseCurrentRow();
                    ++var8_12;
                    continue;
                }
            }
            throw var9_13;
        }
    }

    public String toString() {
        return this.getName();
    }

    public void processException(JboException jboException) {
        this.cacheException(jboException);
        if (jboException.getSource() == this) {
            return;
        }
        Throwable[] throwableArray = jboException.getExceptions();
        if (throwableArray != null) {
            int n = 0;
            while (n < throwableArray.length) {
                if (throwableArray[n] instanceof JboException) {
                    this.processException((JboException)throwableArray[n]);
                }
                ++n;
            }
        }
        if (this.mExecutablesList != null) {
            int n = 0;
            while (n < this.mExecutablesList.size()) {
                DCIExecutable dCIExecutable = (DCIExecutable)this.mExecutablesList.get(n);
                int n2 = dCIExecutable.getExecutableType();
                if (n2 == 0) {
                    if (dCIExecutable instanceof DCBindingContainer) {
                        ((DCBindingContainer)dCIExecutable).processException(jboException);
                    }
                } else if (n2 == 1) {
                    ((DCIteratorBinding)dCIExecutable).processInputException(jboException);
                }
                ++n;
            }
        }
        if (this.getBindingContext() != null && this.getBindingContext().isGenericApp()) {
            return;
        }
        throw jboException;
    }

    public ArrayList getExceptionsList() {
        ArrayList arrayList = (ArrayList)DCUtil.getLocalizedExceptionsList(this.mExcs, this.getLocaleContext());
        if (this.mRegionsList != null) {
            int n = 0;
            while (n < this.mRegionsList.size()) {
                ArrayList arrayList2;
                RegionBinding regionBinding = (RegionBinding)this.mRegionsList.get(n);
                if (regionBinding instanceof DCBindingContainer && (arrayList2 = ((DCBindingContainer)regionBinding).getExceptionsList()) != null && arrayList2.size() > 0) {
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        if (this.needToAddException(arrayList, (JboException)arrayList2.get(n2))) {
                            arrayList.add(arrayList2.get(n2));
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public void cacheException(JboException jboException) {
        if (this.mExcs == null) {
            this.mExcs = new ArrayList(5);
        }
        if (this.needToAddException(this.mExcs, jboException)) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("* * * BindingContainer caching EXCEPTION:" + jboException.getClass().getName());
                Throwable[] throwableArray = jboException.getExceptions();
                if (throwableArray != null && throwableArray.length > 0) {
                    Diagnostic.printStackTrace(throwableArray[0]);
                }
            }
            this.mExcs.add(jboException);
        }
    }

    private boolean needToAddException(List list, JboException jboException) {
        if (list == null || list.size() == 0) {
            return true;
        }
        if (list.contains(jboException)) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            JboException jboException2 = (JboException)list.get(n);
            if (jboException2 == jboException) {
                return false;
            }
            if (jboException2.containsException(jboException)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void handleException(Exception exception, boolean bl) {
    }

    public void handleWarning(JboWarning jboWarning) {
        Diagnostic.println("Batch Warning:" + jboWarning.getMessage());
    }

    public void finishedProcessingPiggyback(Exception[] exceptionArray) {
        if (exceptionArray != null && exceptionArray.length > 0) {
            JboException jboException = null;
            int n = 0;
            while (n < exceptionArray.length) {
                jboException = exceptionArray[n] instanceof JboException ? (JboException)exceptionArray[n] : new JboException(exceptionArray[n]);
                this.processException(jboException);
                ++n;
            }
            throw jboException;
        }
    }

    public boolean isErrorHandlerActive() {
        if (this.mDataControl != null) {
            return this.mDataControl.getErrorHandlerActive();
        }
        return true;
    }

    public void setErrorHandlerActive(boolean bl) {
        if (this.mDataControl != null) {
            this.mDataControl.setErrorHandlerActive(bl);
        }
    }

    protected ViewObject[] getOrderedVOUsageList(DCDataControl dCDataControl) {
        int n = this.mIterBindingList.size();
        ArrayList<ViewObject> arrayList = new ArrayList<ViewObject>(n);
        int n2 = 0;
        while (n2 < n) {
            DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n2);
            if (dCIteratorBinding.getDataControl() == dCDataControl) {
                ViewObject viewObject = null;
                if (dCIteratorBinding.hasRSI()) {
                    viewObject = dCIteratorBinding.getViewObject();
                } else {
                    DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
                    if (dCIteratorBindingDef != null && "DCMethodIterator".equals(dCIteratorBindingDef.getSubType()) && "DCAccessorIterator".equals(dCIteratorBindingDef.getSubType())) {
                        Object var11_10;
                        boolean bl = this.isErrorHandlerActive();
                        try {
                            try {
                                this.setErrorHandlerActive(false);
                                viewObject = dCIteratorBinding.getViewObject();
                            }
                            catch (JboException jboException) {
                                var11_10 = null;
                                if (bl) {
                                    this.setErrorHandlerActive(true);
                                }
                            }
                            var11_10 = null;
                            if (bl) {
                                this.setErrorHandlerActive(true);
                            }
                        }
                        catch (Throwable throwable) {
                            var11_10 = null;
                            if (bl) {
                                this.setErrorHandlerActive(true);
                            }
                            throw throwable;
                        }
                    }
                }
                if (viewObject != null && !arrayList.contains(viewObject)) {
                    arrayList.add(viewObject);
                }
            }
            ++n2;
        }
        return arrayList.toArray(new ViewObject[arrayList.size()]);
    }

    public String getStateTokenId() {
        return this.getName() + "State__";
    }

    public String getStateToken() {
        return new DCBindingContainerState(this).toString();
    }

    public void validateToken(String string) {
        try {
            DCBindingContainerState dCBindingContainerState = new DCBindingContainerState(this);
            dCBindingContainerState.validateToken(string);
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public DCDataControl getDataControl() {
        if (this.mDataControl == null && !DCUtil.inDesignTime()) {
            this.initializeApplicationModule();
            if (this.mDataControl == null) {
                int n = 0;
                while (n < this.mIterBindingList.size()) {
                    DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)this.mIterBindingList.get(n);
                    this.mDataControl = dCIteratorBinding.getDataControl();
                    if (this.mDataControl != null) {
                        this.mDataProvider = this.mDataControl.getApplicationModule();
                        break;
                    }
                    ++n;
                }
            }
        }
        return this.mDataControl;
    }

    protected DCDataControl internalGetDataControl() {
        return this.mDataControl;
    }

    public Object findNamedObject(String string) {
        return DCUtil.findSpelObject((Object)this, string, false);
    }

    public final int getExecutableType() {
        return 0;
    }

    public final String getFullName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getRegionContainer() != null) {
            stringBuffer.append(this.getRegionContainer().getFullName());
        } else {
            stringBuffer.append("data");
        }
        stringBuffer.append('.').append(this.getName());
        return stringBuffer.toString();
    }

    public RegionController getRegionController() {
        String string;
        if (this.mRegionController == null && this.getDef() != null && (string = this.getDef().getControllerClassName()) != null) {
            this.mRegionController = (RegionController)JBOClass.newInstance(string);
        }
        return this.mRegionController;
    }

    public Object getActionProcessor() {
        String string;
        if (this.mActionProcessor == null && this.getDef() != null && (string = this.getDef().getActionProcessorClassName()) != null) {
            this.mActionProcessor = JBOClass.newInstance(string);
        }
        return this.mActionProcessor;
    }

    public final boolean hasRefreshParametersChanged() {
        return true;
    }

    public DCIExecutableDef getExecutableDef() {
        return this.getDef();
    }

    public final boolean hasVariables() {
        return this.getVariableManager() != null;
    }

    public final VariableValueManager getVariableManager() {
        VariableManagerOwner variableManagerOwner = this.getVariableManagerOwner();
        return variableManagerOwner != null ? variableManagerOwner.getVariableManager() : null;
    }

    protected VariableManagerOwner getVariableManagerOwner() {
        int n = 0;
        while (n < this.mIterBindingList.size()) {
            Object e = this.mIterBindingList.get(n);
            if (e.getClass().getName().equals("oracle.jbo.uicli.binding.JUVariableIteratorBinding")) {
                return (VariableManagerOwner)e;
            }
            ++n;
        }
        return null;
    }

    public VariableValueManager ensureVariableManager() {
        return null;
    }

    public final Class getMessageBundleClass() {
        return this.getDef().getMessageBundleClass();
    }

    public final int getTransientRefreshFlag() {
        return this.mTransientRefreshType;
    }

    void buildFormToken(StringBuffer stringBuffer) {
        if (!this.hasVariables()) {
            stringBuffer.append(NO_VARIABLE_INDICATOR);
        } else {
            StringBuffer stringBuffer2 = new StringBuffer(VARIABLE_DELIMITER);
            VariableValueManager variableValueManager = this.ensureVariableManager();
            Variable[] variableArray = variableValueManager.getVariables();
            int n = 0;
            while (n < variableArray.length) {
                Object object = variableValueManager.getVariableValueRaw(variableArray[n], false);
                if (object != null) {
                    if (object instanceof NullValue) {
                        stringBuffer2.append(variableArray[n].getName()).append('=').append(VARIABLE_DELIMITER);
                    } else {
                        stringBuffer2.append(variableArray[n].getName()).append('=').append(object).append(VARIABLE_DELIMITER);
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Tokenizing Variable:" + variableArray[n].getName() + '=' + object);
                    }
                }
                ++n;
            }
            if (stringBuffer2.length() > 3) {
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(VARIABLES_END_DELIMITER);
            }
        }
    }

    String processFormToken(String string) {
        if (string.startsWith(NO_VARIABLE_INDICATOR)) {
            return string.substring(NO_VARIABLE_INDICATOR.length());
        }
        String string2 = string;
        if (string.startsWith(VARIABLE_DELIMITER)) {
            int n = string.indexOf(VARIABLES_END_DELIMITER);
            string2 = string.substring(n + 3);
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, VARIABLE_DELIMITER, false);
            VariableValueManager variableValueManager = this.ensureVariableManager();
            String string3 = string;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3 == null) break;
                int n2 = string3.indexOf(61);
                if (n2 == -1) continue;
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Restore Variable:" + string4 + '=' + string5);
                }
                variableValueManager.setVariableValue(string4, (Object)string5);
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RegionContextImpl
    implements RegionContext {
        RegionBinding mRegion;
        int mFlag;

        RegionContextImpl(RegionBinding regionBinding, int n) {
            this.mRegion = regionBinding;
            this.mFlag = n;
        }

        public RegionBinding getRegionBinding() {
            return this.mRegion;
        }

        public int getRefreshFlag() {
            return this.mFlag;
        }

        void internalSetRegion(RegionBinding regionBinding) {
            this.mRegion = regionBinding;
        }
    }
}

