/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.adapter.dataformat.xml.SchemaMetadata;
import oracle.adf.model.adapter.dataformat.xml.SchemaParser;
import oracle.adf.model.adapter.dataformat.xml.TypeMap;
import oracle.adf.model.adapter.utils.Utility;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.StructureDefinition;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.v2.XMLAttr;
import org.w3c.dom.Node;

public class XMLSchemaDef {
    public static final String TYPE = "type";
    public static final String ENUMERATION = "enumeration";
    public static final String MIN_OCCURS = "minOccurs";
    public static final String MAX_OCCURS = "maxOccurs";
    public static final String NILLABLE = "nillable";
    public static final String NAMESPACE = "targetNamespace";
    SchemaParser mParser;
    XMLSchema mXMLSchema;
    Map mTypesSet;
    String[] mNamespaceURLs;
    StructureDefinition mTree;
    private String mRootName;
    private long mID;

    private /* synthetic */ void $init$() {
        this.mID = 0L;
    }

    public XMLSchemaDef() {
        this.$init$();
        this.mParser = new SchemaParser();
    }

    public XMLSchemaDef(String string) {
        this();
        this.mRootName = string;
    }

    public void addSchema(String string) throws AdapterException {
        try {
            this.mParser.addSchema(string);
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public void addSchema(URL uRL) throws AdapterException {
        try {
            this.mParser.addSchema(uRL);
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public void addSchema(Reader reader) {
        this.mParser.addSchema(reader);
    }

    public void addSchema(InputStream inputStream) {
        this.mParser.addSchema(inputStream);
    }

    public void addSchema(Node node) {
        this.mParser.addSchema(node);
    }

    public void build() throws AdapterException {
        try {
            this.mXMLSchema = this.mParser.parse();
            this.mNamespaceURLs = this.getAllTargetNS();
            this.mTypesSet = this.buildElementSet();
            this.mTree = this.buildSchemaTree();
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public StructureDefinition getSchemaTree() {
        return this.mTree;
    }

    public Object getType(String string, String string2) {
        Map map;
        Object var3_3 = null;
        Utility.ASSERT(this.mTypesSet != null);
        if (this.mTypesSet.containsKey(string) && (map = (Map)this.mTypesSet.get(string)).containsKey(string2)) {
            var3_3 = map.get(string2);
        }
        return var3_3;
    }

    public boolean isElementFormDefault(String string) {
        boolean bl = false;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            bl = schemaMetadata.isElementFormDefault();
        }
        return bl;
    }

    public boolean isAttributeFormDefault(String string) {
        boolean bl = false;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            bl = schemaMetadata.isAttributeFormDefault();
        }
        return bl;
    }

    public String getSchemaProperty(String string, String string2) {
        String string3 = null;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            string3 = schemaMetadata.getProperty(string2);
        }
        return string3;
    }

    public boolean isNamespaceDefined(String string) {
        return this.mTypesSet.containsKey(string);
    }

    private String[] getAllTargetNS() {
        Utility.ASSERT(this.mXMLSchema != null);
        String[] stringArray = this.mXMLSchema.getAllTargetNS();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].compareTo("http://www.w3.org/2001/XMLSchema") != 0) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private Map buildElementSet() {
        Utility.ASSERT(this.mXMLSchema != null);
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            XMLSchemaNode xMLSchemaNode = this.mXMLSchema.getSchemaByTargetNS(this.mNamespaceURLs[n]);
            XSDNode[] xSDNodeArray = xMLSchemaNode.getComplexTypeSet();
            XSDNode[] xSDNodeArray2 = xMLSchemaNode.getSimpleTypeSet();
            XSDNode[] xSDNodeArray3 = xMLSchemaNode.getElementSet();
            ArrayList<XSDNode> arrayList = new ArrayList<XSDNode>();
            int n2 = 0;
            while (n2 < xSDNodeArray.length) {
                arrayList.add(xSDNodeArray[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < xSDNodeArray2.length) {
                arrayList.add(xSDNodeArray2[n3]);
                ++n3;
            }
            int n4 = 0;
            while (n4 < xSDNodeArray3.length) {
                arrayList.add(xSDNodeArray3[n4]);
                ++n4;
            }
            hashMap.put(this.mNamespaceURLs[n], arrayList.iterator());
            ++n;
        }
        return hashMap;
    }

    private StructureDefinition buildSchemaTree() {
        StructureDef structureDef = new StructureDef(this.mRootName);
        int n = 0;
        Iterator iterator = this.getTopLevelTypes();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            while (iterator2.hasNext()) {
                XSDNode xSDNode = (XSDNode)iterator2.next();
                int n2 = xSDNode.getNodeType();
                String string = xSDNode.getName();
                String string2 = xSDNode.getTargetNS();
                if (n2 == 2) {
                    int n3 = ((XSDSimpleType)xSDNode).getBasicType();
                    AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n3));
                    this.setAttributeProperty((XSDSimpleType)xSDNode, attributeDef);
                    this.addType(string2, string, (Object)attributeDef);
                    continue;
                }
                if (n2 == 1) {
                    StructureDef structureDef2 = new StructureDef(string, (Definition)structureDef);
                    AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, true);
                    this.resolveComplexType((XSDComplexType)xSDNode, structureDef2);
                    this.addType(string2, string, (Object)accessorDef);
                    continue;
                }
                if (n2 == 3) {
                    XSDNode xSDNode2 = ((XSDElement)xSDNode).getType();
                    string2 = xSDNode2.getTargetNS();
                    int n4 = xSDNode2.getNodeType();
                    if (n4 == 1) {
                        StructureDef structureDef3 = new StructureDef(string, (Definition)structureDef);
                        AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef3, true);
                        this.resolveComplexType((XSDComplexType)xSDNode2, structureDef3);
                        this.setElementProperty((XSDElement)xSDNode, accessorDef);
                        this.addType(string2, string, (Object)accessorDef);
                        structureDef.addAccessor(accessorDef);
                        continue;
                    }
                    if (n4 != 2) continue;
                    int n5 = ((XSDSimpleType)xSDNode2).getBasicType();
                    AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n5));
                    this.setAttributeProperty((XSDSimpleType)xSDNode2, attributeDef);
                    this.setElementProperty((XSDElement)xSDNode, attributeDef);
                    this.addType(string2, string, (Object)attributeDef);
                    structureDef.addAttribute((AttributeDefinition)attributeDef);
                    continue;
                }
                if (n2 != 0) continue;
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                this.addType(string2, "any", (Object)accessorDef);
                structureDef.addAccessor(accessorDef);
            }
            ++n;
        }
        return structureDef;
    }

    private void resolveComplexType(XSDComplexType xSDComplexType, StructureDef structureDef) {
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributeDeclarations();
        int n = 0;
        while (n < xSDAttributeArray.length) {
            String string = xSDAttributeArray[n].getName();
            XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttributeArray[n].getType();
            int n2 = xSDSimpleType.getBasicType();
            AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n2));
            structureDef.addAttribute((AttributeDefinition)attributeDef);
            this.setAttributeProperty(xSDSimpleType, attributeDef);
            XSDAnnotation xSDAnnotation = xSDAttributeArray[n].getAnnotation();
            if (xSDAnnotation != null) {
                HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
                hashMap.put(string, xSDAnnotation.getAttributes());
                attributeDef.addProperties(hashMap);
            }
            ++n;
        }
        XSDNode[] xSDNodeArray = xSDComplexType.getElementSet();
        if (xSDNodeArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < xSDNodeArray.length) {
            String string = xSDNodeArray[n3].getName();
            int n4 = xSDNodeArray[n3].getNodeType();
            StructureDef structureDef2 = null;
            if (n4 == 2) {
                int n5 = ((XSDSimpleType)xSDNodeArray[n3]).getBasicType();
                AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n5));
                this.setAttributeProperty((XSDSimpleType)xSDNodeArray[n3], attributeDef);
                structureDef.addAttribute((AttributeDefinition)attributeDef);
            } else if (n4 == 3) {
                this.resolveElement((XSDElement)xSDNodeArray[n3], structureDef);
            } else if (n4 == 5) {
                if (string == null && (string = ((XSDGroup)xSDNodeArray[n3]).getRefLocalname()) != null) {
                    structureDef2 = new StructureDef(string, (Definition)structureDef);
                    AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, true);
                    this.addType(xSDNodeArray[n3].getTargetNS(), string, (Object)accessorDef);
                    structureDef.addAccessor(accessorDef);
                }
                this.resolveGroup((XSDGroup)xSDNodeArray[n3], structureDef2 == null ? structureDef : structureDef2);
            } else if (n4 == 0) {
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                structureDef.addAccessor(accessorDef);
            }
            ++n3;
        }
    }

    private void resolveGroup(XSDGroup xSDGroup, StructureDef structureDef) {
        Vector vector = xSDGroup.getNodeVector();
        int n = 0;
        while (n < vector.size()) {
            XSDNode xSDNode = (XSDNode)vector.elementAt(n);
            int n2 = xSDNode.getNodeType();
            if (n2 == 5) {
                this.resolveGroup((XSDGroup)xSDNode, structureDef);
            } else if (n2 == 3) {
                this.resolveElement((XSDElement)xSDNode, structureDef);
            } else if (n2 == 0) {
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                structureDef.addAccessor(accessorDef);
            }
            ++n;
        }
    }

    private void resolveElement(XSDElement xSDElement, StructureDef structureDef) {
        XSDNode xSDNode = xSDElement.getType();
        int n = xSDNode.getNodeType();
        String string = xSDElement.getName();
        if (n == 1) {
            Object object = this.getType(xSDElement.getTargetNS(), string);
            AccessorDef accessorDef = null;
            StructureDef structureDef2 = null;
            if (object == null) {
                structureDef2 = new StructureDef(string, (Definition)structureDef);
                accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, true);
                this.resolveComplexType((XSDComplexType)xSDNode, structureDef2);
                this.addType(xSDElement.getTargetNS(), string, (Object)accessorDef);
            } else {
                accessorDef = (AccessorDef)((Object)object);
                structureDef2 = new StructureDef(string, (Definition)structureDef);
                accessorDef = accessorDef.clone(structureDef2, this.getNextID());
            }
            structureDef.addAccessor(accessorDef);
            this.setElementProperty(xSDElement, accessorDef);
        } else if (n == 2) {
            int n2 = ((XSDSimpleType)xSDNode).getBasicType();
            AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n2));
            this.setAttributeProperty((XSDSimpleType)xSDNode, attributeDef);
            structureDef.addAttribute((AttributeDefinition)attributeDef);
            this.setElementProperty(xSDElement, attributeDef);
        }
    }

    private void setElementProperty(XSDElement xSDElement, AttributeDef attributeDef) {
        int n = xSDElement.getMinOccurs();
        int n2 = xSDElement.getMaxOccurs();
        boolean bl = xSDElement.isNillable();
        attributeDef.addProperty(MIN_OCCURS, String.valueOf(n));
        attributeDef.addProperty(MAX_OCCURS, String.valueOf(n2));
        attributeDef.addProperty(NILLABLE, String.valueOf(bl));
        attributeDef.addProperty(NAMESPACE, xSDElement.getTargetNS());
    }

    private void setAttributeProperty(XSDSimpleType xSDSimpleType, AttributeDef attributeDef) throws AdapterException {
        HashMap hashMap = new HashMap();
        this.setBaseType(xSDSimpleType, hashMap);
        this.getFacets(xSDSimpleType, hashMap);
        attributeDef.addProperties(hashMap);
    }

    private void setBaseType(XSDSimpleType xSDSimpleType, Map map) throws AdapterException {
        try {
            XSDSimpleType xSDSimpleType2;
            String string = xSDSimpleType.getName();
            Hashtable hashtable = XSDSimpleType.getBuiltInDatatypes();
            if (string == null) {
                xSDSimpleType2 = xSDSimpleType.getBase();
                if (xSDSimpleType2 == null) {
                    xSDSimpleType2 = xSDSimpleType.getItemType();
                }
                string = xSDSimpleType2.getName();
            } else {
                xSDSimpleType2 = xSDSimpleType;
            }
            while (!hashtable.containsKey(string)) {
                XSDSimpleType xSDSimpleType3 = xSDSimpleType2.getBase();
                string = (xSDSimpleType2 = xSDSimpleType3 == null ? xSDSimpleType2.getItemType() : xSDSimpleType3).getName();
                if (string != null) continue;
                string = XSDTypeConstants.STRING;
                break;
            }
            map.put(TYPE, string);
        }
        catch (XSDException xSDException) {
            throw new AdapterException(xSDException);
        }
    }

    private void getFacets(XSDSimpleType xSDSimpleType, Map map) {
        XSDConstrainingFacet[] xSDConstrainingFacetArray = xSDSimpleType.getFacets();
        if (xSDConstrainingFacetArray != null) {
            int n = 0;
            while (n < xSDConstrainingFacetArray.length) {
                if (xSDConstrainingFacetArray[n] != null) {
                    Object object = xSDConstrainingFacetArray[n].getLexicalEnumeration();
                    if (object == null) {
                        object = xSDConstrainingFacetArray[n].getLexicalValue();
                    }
                    map.put(xSDConstrainingFacetArray[n].getName(), object);
                }
                ++n;
            }
        }
    }

    private boolean addType(String string, String string2, Object object) {
        boolean bl = false;
        if (this.mTypesSet.containsKey(string)) {
            Map map = (Map)this.mTypesSet.get(string);
            if (!map.containsKey(string2)) {
                map.put(string2, object);
            }
            bl = true;
        }
        return bl;
    }

    private Iterator getTopLevelTypes() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            Iterator iterator = (Iterator)this.mTypesSet.get(this.mNamespaceURLs[n]);
            arrayList.add(iterator);
            this.mTypesSet.put(this.mNamespaceURLs[n], new HashMap());
            ++n;
        }
        return arrayList.iterator();
    }

    private String getNextID() {
        return "XSD" + String.valueOf(this.mID++);
    }

    public void printTree(StructureDefinition structureDefinition, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        String string = new String(cArray);
        ArrayListDefinitionContainer arrayListDefinitionContainer = (ArrayListDefinitionContainer)structureDefinition.getAttributeDefinitions();
        int n2 = 0;
        while (n2 < arrayListDefinitionContainer.size()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)arrayListDefinitionContainer.item(n2);
            System.out.println(string + "  " + attributeDefinition.getName() + ": " + attributeDefinition.getJavaTypeString());
            this.printProperties(((AttributeDef)attributeDefinition).getProperties(), string + "  ");
            ++n2;
        }
        ArrayListDefinitionContainer arrayListDefinitionContainer2 = (ArrayListDefinitionContainer)structureDefinition.getAccessorDefinitions();
        int n3 = 0;
        while (n3 < arrayListDefinitionContainer2.size()) {
            AccessorDef accessorDef = (AccessorDef)arrayListDefinitionContainer2.item(n3);
            StructureDef structureDef = (StructureDef)accessorDef.getStructure();
            if (structureDef == null) {
                System.out.println(string + accessorDef.getName() + ": " + accessorDef.getJavaTypeString());
                this.printProperties(accessorDef.getProperties(), string + "  ");
            } else {
                System.out.println(string + structureDef.getName());
                this.printProperties(accessorDef.getProperties(), string);
                this.printTree(structureDef, n + 2);
            }
            ++n3;
        }
    }

    public void printProperties(Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            if (v instanceof Vector) {
                Iterator iterator2 = ((Vector)v).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (e instanceof XMLAttr) {
                        System.out.println(string + "  " + string2 + ":" + ((XMLAttr)e).getNodeValue());
                        continue;
                    }
                    System.out.println(string + "  " + string2 + ":" + e);
                }
                continue;
            }
            if (!(v instanceof String)) continue;
            System.out.println(string + "  " + string2 + ":" + v);
        }
    }

    public void printAllTypes() {
        if (this.mNamespaceURLs == null) {
            System.out.println("Object is not initialised. Call getSchemaTree() method.");
            return;
        }
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            Map map = (Map)this.mTypesSet.get(this.mNamespaceURLs[n]);
            Iterator iterator = map.keySet().iterator();
            System.out.println("-----| Namespace |-----" + this.mNamespaceURLs[n]);
            while (iterator.hasNext()) {
                System.out.println("  " + (String)iterator.next());
            }
            ++n;
        }
    }

    public void printSchemaMetadata() {
        if (this.mNamespaceURLs == null) {
            System.out.println("Object is not initialised. Call getSchemaTree() method.");
            return;
        }
        System.out.println("-----| Schema metadata |-----");
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            System.out.println("Namespace: " + this.mNamespaceURLs[n]);
            System.out.println("  isElementFormDefault: " + this.isElementFormDefault(this.mNamespaceURLs[n]));
            System.out.println("  isAttributeFormDefault: " + this.isAttributeFormDefault(this.mNamespaceURLs[n]));
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            XMLSchemaDef xMLSchemaDef = new XMLSchemaDef("XMLDC1");
            if (stringArray.length < 1) {
                return;
            }
            System.setProperty("http.proxyHost", "www-proxy.us.oracle.com");
            System.setProperty("http.proxyPort", "80");
            int n = 0;
            while (n < stringArray.length) {
                URL uRL = new URL(stringArray[n]);
                InputStream inputStream = uRL.openStream();
                xMLSchemaDef.addSchema(new InputStreamReader(inputStream));
                ++n;
            }
            xMLSchemaDef.build();
            StructureDefinition structureDefinition = xMLSchemaDef.getSchemaTree();
            System.out.println(structureDefinition.getName());
            xMLSchemaDef.printTree(structureDefinition, 0);
            xMLSchemaDef.printAllTypes();
            xMLSchemaDef.printSchemaMetadata();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

