/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import oracle.adf.model.utils.SimpleStringBuffer;

public final class CSVParser {
    public static final String UTF8_ENCODING = "UTF8";
    private static char CHAR_QUOTE = (char)34;
    private static char CHAR_COMMA = (char)44;
    private LineNumberReader mReader;
    private ArrayList mValueArrayList;
    private SimpleStringBuffer mValueBuffer;
    private String mLine;
    private int mLinePosition;
    private int mLineLength;
    private boolean mLastCharIsComma;
    private char[] mSepCharSet;
    private char mQuoteChar;

    private /* synthetic */ void $init$() {
        this.mValueArrayList = new ArrayList();
        this.mValueBuffer = new SimpleStringBuffer(256);
        this.mLine = null;
        this.mLinePosition = -1;
        this.mLineLength = 0;
        this.mLastCharIsComma = false;
        this.mSepCharSet = new char[]{CHAR_COMMA};
        this.mQuoteChar = CHAR_QUOTE;
    }

    public CSVParser(InputStream inputStream) throws Exception {
        this(inputStream, UTF8_ENCODING);
    }

    public CSVParser(InputStream inputStream, String string) throws Exception {
        this.$init$();
        if (inputStream == null) {
            throw new Exception("Null Input Stream.");
        }
        this.mReader = new LineNumberReader(new InputStreamReader(inputStream, string));
    }

    public void setSeparators(char[] cArray) {
        if (cArray != null && cArray.length > 0) {
            this.mSepCharSet = cArray;
        }
    }

    public void setQuoteChar(char c) {
        this.mQuoteChar = c;
    }

    public boolean nextLine() throws Exception {
        this.setLine(this.mReader.readLine());
        if (this.mLine == null) {
            this.mValueArrayList.clear();
            return false;
        }
        this.parseLine();
        return true;
    }

    public String[] getLineValues() throws Exception {
        if (this.mValueArrayList.size() > 0) {
            String[] stringArray = new String[this.mValueArrayList.size()];
            return this.mValueArrayList.toArray(stringArray);
        }
        return null;
    }

    private boolean isSeparator(char c) {
        int n = 0;
        while (n < this.mSepCharSet.length) {
            if (c == this.mSepCharSet[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isEndOfLine() {
        return this.mLinePosition >= this.mLineLength && !this.mLastCharIsComma;
    }

    private void setLine(String string) {
        this.mLine = string;
        if (string != null) {
            this.mLineLength = string.length();
            this.mLinePosition = 0;
        }
    }

    private boolean isNextCharQuote() {
        if (this.mLinePosition + 1 >= this.mLineLength) {
            return false;
        }
        char c = this.mLine.charAt(this.mLinePosition + 1);
        return c == this.mQuoteChar;
    }

    private void parseLine() throws Exception {
        this.mValueArrayList.clear();
        Object var1_1 = null;
        String string = null;
        while (!this.isEndOfLine()) {
            string = this.getNextValue();
            this.mValueArrayList.add(string);
        }
    }

    private String getNextValue() throws Exception {
        this.mLastCharIsComma = false;
        if (this.mValueBuffer.length() > 0) {
            this.mValueBuffer.setLength(0);
        }
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (this.mLinePosition < this.mLineLength && !bl3) {
            boolean bl4 = true;
            char c = this.mLine.charAt(this.mLinePosition);
            if (bl2) {
                if (c == this.mQuoteChar) {
                    bl = true;
                    bl4 = false;
                } else if (this.isSeparator(c)) {
                    bl4 = false;
                    bl3 = true;
                    this.mLastCharIsComma = true;
                }
                bl2 = false;
            } else if (bl) {
                if (c == this.mQuoteChar) {
                    bl4 = false;
                    if (this.isNextCharQuote()) {
                        ++this.mLinePosition;
                    } else {
                        bl = false;
                    }
                }
            } else if (this.isSeparator(c)) {
                bl4 = false;
                bl3 = true;
                this.mLastCharIsComma = true;
            }
            if (bl4) {
                this.mValueBuffer.append(c);
            }
            ++this.mLinePosition;
        }
        if (this.mValueBuffer.length() > 0) {
            return this.mValueBuffer.toString();
        }
        return null;
    }
}

