/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.searchNavigator;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.share.sort.Comparator;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.QueryResult;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.searchNavigator.ResultsBookComparator;
import oracle.help.navigator.searchNavigator.ResultsRankComparator;
import oracle.help.navigator.searchNavigator.ResultsTitleComparator;

public class OHJSearchModelData
extends SortableTwoDModel
implements HeaderItemInputHandler,
SearchModelData {
    private final int _INCREMENT = 10;
    private Object[] _buffer = new Object[10];
    private int _lastColumnClicked = -1;
    private boolean _invertSort = false;
    private static Image _fullImage;
    private static Image _halfImage;
    private static Image _emptyImage;
    private int _maxHitNumber = 1;

    public OHJSearchModelData() {
        super(3, 0);
        this.setColumnComparator(0, new ResultsRankComparator());
        this.setColumnComparator(1, (Comparator)new ResultsTitleComparator());
        this.setColumnComparator(2, (Comparator)new ResultsBookComparator());
        _fullImage = ImageLoader.loadImage(this.getClass(), "images/full.gif");
        _halfImage = ImageLoader.loadImage(this.getClass(), "images/half.gif");
        _emptyImage = ImageLoader.loadImage(this.getClass(), "images/empty.gif");
    }

    public Object getData(int n, int n2) {
        return SearchModel.getData(super.getData(n, n2), n, n2, this);
    }

    public Object getRealData(int n, int n2) {
        return super.getData(n, n2);
    }

    public void resetModel() {
        int n = this.getRowCount();
        if (n > 0) {
            this.removeRows(0, n);
        }
        this._maxHitNumber = 1;
    }

    public Object getRank(QueryResult queryResult) {
        int n = (int)(100.0f * ((float)queryResult.getResultScore() / (float)this._maxHitNumber));
        if (n > 80) {
            return _fullImage;
        }
        if (n > 40) {
            return _halfImage;
        }
        return _emptyImage;
    }

    public void addResults(List list, View view) {
        QueryResult queryResult;
        int n;
        int n2;
        int n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            QueryResult queryResult2 = (QueryResult)iterator.next();
            this._buffer[n3++] = queryResult2;
            if (n3 != 10) continue;
            n2 = this.getRowCount();
            this.addRows(this.getRowCount(), n3);
            n = 0;
            while (n < n3) {
                queryResult = (QueryResult)this._buffer[n];
                if (queryResult.getResultScore() > this._maxHitNumber) {
                    this._maxHitNumber = queryResult.getResultScore();
                }
                this.setData(0, n2 + n, queryResult);
                this.setData(1, n2 + n, queryResult);
                this.setData(2, n2 + n, view);
                ++n;
            }
            n3 = 0;
        }
        if (n3 != 0) {
            n2 = this.getRowCount();
            this.addRows(this.getRowCount(), n3);
            n = 0;
            while (n < n3) {
                queryResult = (QueryResult)this._buffer[n];
                if (queryResult.getResultScore() > this._maxHitNumber) {
                    this._maxHitNumber = queryResult.getResultScore();
                }
                this.setData(0, n2 + n, queryResult);
                this.setData(1, n2 + n, queryResult);
                this.setData(2, n2 + n, view);
                ++n;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        this._invertSort = n == this._lastColumnClicked ? !this._invertSort : false;
        this._lastColumnClicked = n;
        this.sort(n, !this._invertSort);
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
    }

    protected void fireModelEvent(int n, int n2, int n3) {
        try {
            super.fireModelEvent(n, n2, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void fireModelEvent(int n, int n2, int n3, int n4, int n5) {
        try {
            super.fireModelEvent(n, n2, n3, n4, n5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

