/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

public class WindowToolbar {
    public static final int BUTTON_NODEFAULT = 4;
    public static final int BUTTON_NAVIGATOR = 1024;
    public static final int BUTTON_PRINT = 8192;
    public static final int BUTTON_BACK = 16384;
    public static final int BUTTON_SEARCH = 32768;
    public static final int BUTTON_DOCK = 65536;
    private boolean _showToolbar = false;
    private boolean _isDefault = true;
    private boolean _navigatorVisible = false;
    private boolean _printVisible = false;
    private boolean _backVisible = false;
    private boolean _searchVisible = false;
    private boolean _dockVisible = false;
    private int _state;

    public WindowToolbar(int n) {
        this._state = n;
        this._showToolbar = false;
        if ((n & 4) != 0) {
            this._isDefault = false;
            if ((n & 0x400) != 0) {
                this._navigatorVisible = true;
                this._showToolbar = true;
            }
            if ((n & 0x2000) != 0) {
                this._printVisible = true;
                this._showToolbar = true;
            }
            if ((n & 0x4000) != 0) {
                this._backVisible = true;
                this._showToolbar = true;
            }
            if ((n & 0x8000) != 0) {
                this._searchVisible = true;
                this._showToolbar = true;
            }
            if ((n & 0x10000) != 0) {
                this._dockVisible = true;
                this._showToolbar = true;
            }
        } else {
            this._isDefault = true;
            this._showToolbar = true;
            this._navigatorVisible = true;
            this._printVisible = true;
            this._backVisible = true;
            this._searchVisible = true;
            this._dockVisible = true;
        }
    }

    public boolean isToolbarVisible() {
        return this._showToolbar;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public boolean isNavigatorVisible() {
        return this._navigatorVisible;
    }

    public boolean isPrintVisible() {
        return this._printVisible;
    }

    public boolean isBackVisible() {
        return this._backVisible;
    }

    public boolean isSearchVisible() {
        return this._searchVisible;
    }

    public boolean isDockVisible() {
        return this._dockVisible;
    }

    public int getState() {
        return this._state;
    }
}

