/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.library.Book;

public class TopicTree {
    private final Book _book;
    private final String _basePath;
    private final TopicTreeNode _root;
    private Hashtable _urlTable;

    public TopicTree(Book book, String string) {
        this(book, string, new TopicTreeNode(null, null));
    }

    public TopicTree(Book book, String string, TopicTreeNode topicTreeNode) {
        this._book = book;
        this._basePath = string;
        this._root = topicTreeNode;
    }

    public final TopicTreeNode getRoot() {
        return this._root;
    }

    public synchronized Vector findNodesForURL(URL uRL) {
        Vector vector = null;
        if (this._urlTable == null) {
            this._urlTable = new Hashtable();
            if (this._root != null) {
                this._buildTableForNode(this._root);
            }
        }
        if (uRL != null) {
            vector = (Vector)this._urlTable.get(uRL);
        }
        return vector;
    }

    private void _buildTableForNode(TopicTreeNode topicTreeNode) {
        Object object;
        Topic topic = topicTreeNode.getTopic();
        if (topic != null && (object = topic.getTarget()) != null) {
            URL uRL = null;
            try {
                uRL = object.getURL();
            }
            catch (Exception exception) {
                uRL = null;
            }
            if (uRL != null) {
                Vector vector;
                if (this._urlTable.containsKey(uRL)) {
                    vector = (Vector)this._urlTable.get(uRL);
                } else {
                    vector = new Vector();
                    this._urlTable.put(uRL, vector);
                }
                vector.addElement(topicTreeNode);
            }
        }
        if ((object = topicTreeNode.getChildren()) != null) {
            int n = 0;
            while (n < ((ArrayList)object).size()) {
                this._buildTableForNode((TopicTreeNode)((ArrayList)object).get(n));
                ++n;
            }
        }
    }
}

