/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.domain.Number;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUTableBinding;
import oracle.jbo.uicli.jui.SortedListSelectionModel;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public class JUTableSortModel
extends AbstractTableModel
implements TableModelListener {
    final byte DOMAIN_NUMBER;
    final byte DOMAIN_DATE;
    final byte TYPE_STRING;
    final byte TYPE_DATE;
    final byte TYPE_NUMBER;
    final byte TYPE_BOOLEAN;
    final byte TYPE_OBJECT;
    boolean mAscending;
    int mSortColIndex;
    byte mSortColType;
    int mRangeStart;
    int[] mIndices;
    JUTableBinding mModel;
    private static /* synthetic */ Class class$oracle$jbo$domain$Number;
    private static /* synthetic */ Class class$oracle$jbo$domain$Date;
    private static /* synthetic */ Class class$java$lang$Number;
    private static /* synthetic */ Class class$java$util$Date;
    private static /* synthetic */ Class class$java$lang$Boolean;
    private static /* synthetic */ Class class$java$lang$String;

    private /* synthetic */ void $init$() {
        this.DOMAIN_NUMBER = 0;
        this.DOMAIN_DATE = 1;
        this.TYPE_STRING = (byte)2;
        this.TYPE_DATE = (byte)4;
        this.TYPE_NUMBER = (byte)8;
        this.TYPE_BOOLEAN = (byte)16;
        this.TYPE_OBJECT = (byte)32;
        this.mAscending = true;
        this.mSortColIndex = -1;
        this.mSortColType = (byte)32;
        this.mRangeStart = 0;
    }

    public JUTableSortModel() {
        this.$init$();
        this.mIndices = new int[0];
    }

    public JUTableSortModel(JUTableBinding jUTableBinding) {
        this.$init$();
        this.setTableBinding(jUTableBinding);
    }

    protected void setTableBinding(JUTableBinding jUTableBinding) {
        this.mModel = jUTableBinding;
        jUTableBinding.addTableModelListener(this);
        this.reallocateIndexes();
    }

    protected void checkModel() {
        if (this.mIndices != null && this.mIndices.length != this.getRangeSize()) {
            this.resetIndices();
        }
    }

    protected int compareRows(int n, int n2) {
        int n3 = this.compareRowsByColumn(n, n2, this.mSortColIndex);
        return this.mAscending ? n3 : -n3;
    }

    final int getRangeSize() {
        NavigatableRowIterator navigatableRowIterator = this.mModel.getIteratorBinding().getNavigatableRowIterator();
        return navigatableRowIterator != null ? navigatableRowIterator.getRowCountInRange() : 0;
    }

    protected void resetIndices() {
        JUIteratorBinding jUIteratorBinding;
        if (this.mModel != null && (jUIteratorBinding = this.mModel.getIteratorBinding()).isIteratorMadeVisible()) {
            RowSetIterator rowSetIterator = jUIteratorBinding.getRowSetIterator();
            if (jUIteratorBinding.isFindMode() || rowSetIterator != null) {
                int n = this.getRangeSize();
                this.mIndices = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    this.mIndices[n2] = n2;
                    ++n2;
                }
            } else if (this.mIndices == null) {
                this.mIndices = new int[0];
            }
        }
    }

    protected void reallocateIndexes() {
        if (this.mSortColIndex > -1) {
            this.sortByColumn(this.mSortColIndex, this.mAscending);
        } else {
            this.resetIndices();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = this.mModel.getIteratorBinding().getNavigatableRowIterator().getRangeStart();
        this.mRangeStart = n > -1 ? n : 0;
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    protected void initType() {
        JUTableBinding jUTableBinding = this.mModel;
        Class clazz = jUTableBinding.getColumnClass(this.mSortColIndex);
        Class clazz2 = class$oracle$jbo$domain$Number;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$domain$Number = JUTableSortModel.class$("oracle.jbo.domain.Number");
        }
        if (clazz2.isAssignableFrom(clazz)) {
            this.mSortColType = 0;
        } else {
            Class clazz3 = class$oracle$jbo$domain$Date;
            if (clazz3 == null) {
                clazz3 = class$oracle$jbo$domain$Date = JUTableSortModel.class$("oracle.jbo.domain.Date");
            }
            if (clazz3.isAssignableFrom(clazz)) {
                this.mSortColType = 1;
            } else {
                Class clazz4 = class$java$lang$Number;
                if (clazz4 == null) {
                    clazz4 = class$java$lang$Number = JUTableSortModel.class$("java.lang.Number");
                }
                if (clazz4.isAssignableFrom(clazz)) {
                    this.mSortColType = (byte)8;
                } else {
                    Class clazz5 = class$java$util$Date;
                    if (clazz5 == null) {
                        clazz5 = class$java$util$Date = JUTableSortModel.class$("java.util.Date");
                    }
                    if (clazz5.isAssignableFrom(clazz)) {
                        this.mSortColType = (byte)4;
                    } else {
                        Class clazz6 = class$java$lang$Boolean;
                        if (clazz6 == null) {
                            clazz6 = class$java$lang$Boolean = JUTableSortModel.class$("java.lang.Boolean");
                        }
                        if (clazz6.isAssignableFrom(clazz)) {
                            this.mSortColType = (byte)16;
                        } else {
                            Class clazz7 = class$java$lang$String;
                            if (clazz7 == null) {
                                clazz7 = class$java$lang$String = JUTableSortModel.class$("java.lang.String");
                            }
                            this.mSortColType = clazz7.isAssignableFrom(clazz) ? (byte)2 : (byte)32;
                        }
                    }
                }
            }
        }
    }

    public void sortByColumn(int n, boolean bl) {
        JTable jTable = (JTable)this.mModel.getControl();
        int n2 = jTable.getSelectedRow();
        if (this.mSortColIndex != n) {
            this.resetIndices();
            this.mSortColType = (byte)32;
            this.mSortColIndex = n;
        }
        if (this.mSortColIndex > -1) {
            this.mAscending = bl;
            this.checkModel();
            this.initType();
            this.shuttlesort((int[])this.mIndices.clone(), this.mIndices, 0, this.mIndices.length);
        }
        this.fireTableChanged(new TableModelEvent(this));
        if (n2 > -1) {
            NavigatableRowIterator navigatableRowIterator = this.mModel.getIteratorBinding().getNavigatableRowIterator();
            Row row = navigatableRowIterator.getCurrentRow();
            n2 = -1;
            if (row != null) {
                n2 = this.getSortedIndex(navigatableRowIterator.getRangeIndexOf(row));
            }
            if (n2 > -1) {
                jTable.setRowSelectionInterval(n2, n2);
            }
        }
    }

    final int getModelIndex(int n) {
        int n2 = -1;
        if (this.mSortColIndex > -1) {
            int n3 = n - this.mRangeStart;
            if (n3 >= 0 && n3 < this.getRangeSize()) {
                n2 = this.mIndices[n3];
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    final int getSortedIndex(int n) {
        int n2 = -1;
        if (this.mSortColIndex > -1) {
            int n3 = this.mIndices.length;
            --n3;
            while (n3 >= 0) {
                if (this.mIndices[n3] == n) {
                    n2 = n3;
                    break;
                }
                --n3;
            }
        } else {
            n2 = n;
        }
        return n2;
    }

    protected void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compareRows(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compareRows(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    protected void swap(int n, int n2) {
        int n3 = this.mIndices[n];
        this.mIndices[n] = this.mIndices[n2];
        this.mIndices[n2] = n3;
    }

    protected final int compareRowsByColumn(int n, int n2, int n3) {
        JUTableBinding jUTableBinding = this.mModel;
        Object object = jUTableBinding.getValueAt(n + this.mRangeStart, n3);
        Object object2 = jUTableBinding.getValueAt(n2 + this.mRangeStart, n3);
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.mSortColType) {
            case 0: {
                Number number = (Number)object;
                Number number2 = (Number)object2;
                return number.compareTo((NUMBER)number2);
            }
            case 1: {
                oracle.jbo.domain.Date date = (oracle.jbo.domain.Date)object;
                oracle.jbo.domain.Date date2 = (oracle.jbo.domain.Date)object2;
                return date.compareTo((DATE)date2);
            }
            case 8: {
                java.lang.Number number = (java.lang.Number)object;
                double d = number.doubleValue();
                java.lang.Number number3 = (java.lang.Number)object2;
                double d2 = number3.doubleValue();
                return d < d2 ? -1 : (d > d2 ? 1 : 0);
            }
            case 4: {
                Date date = (Date)object;
                long l = date.getTime();
                Date date3 = (Date)object2;
                long l2 = date3.getTime();
                return l < l2 ? -1 : (l > l2 ? 1 : 0);
            }
            case 16: {
                Boolean bl = (Boolean)object;
                boolean bl2 = bl;
                Boolean bl3 = (Boolean)object2;
                boolean bl4 = bl3;
                return bl2 == bl4 ? 0 : (bl2 ? 1 : -1);
            }
            case 2: {
                String string = (String)object;
                String string2 = (String)object2;
                int n4 = string.compareTo(string2);
                return n4 < 0 ? -1 : (n4 > 0 ? 1 : 0);
            }
        }
        return this.compareObjectTypes(object, object2);
    }

    protected int compareObjectTypes(Object object, Object object2) {
        String string;
        String string2 = object.toString();
        int n = string2.compareTo(string = object2.toString());
        return n < 0 ? -1 : (n > 0 ? 1 : 0);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        JUTableSortModel jUTableSortModel = this;
        JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        1 var4_4 = new 1(this, jTable2, jUTableSortModel);
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(var4_4);
    }

    public JUTableBinding getTableBinding() {
        return this.mModel;
    }

    public Object getValueAt(int n, int n2) {
        int n3;
        this.checkModel();
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            return this.mModel.getValueAt(this.mRangeStart + this.mIndices[n3], n2);
        }
        return this.mModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3;
        this.checkModel();
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            this.mModel.setValueAt(object, this.mRangeStart + this.mIndices[n3], n2);
            return;
        }
        this.mModel.setValueAt(object, n, n2);
    }

    public int getRowCount() {
        return this.mModel == null ? 0 : this.mModel.getRowCount();
    }

    public int getColumnCount() {
        return this.mModel == null ? 0 : this.mModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.mModel == null ? null : this.mModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.mModel == null ? null : this.mModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3;
        if (this.mSortColIndex > -1 && (n3 = n - this.mRangeStart) >= 0 && n3 < this.getRangeSize()) {
            Row row;
            NavigatableRowIterator navigatableRowIterator = this.mModel.getIteratorBinding().getNavigatableRowIterator();
            Row row2 = navigatableRowIterator.getCurrentRow();
            if (row2 != (row = navigatableRowIterator.getRowAtRangeIndex(this.mIndices[n3]))) {
                navigatableRowIterator.setCurrentRow(row);
            }
            return this.mModel.isCellEditable(this.mRangeStart + this.mIndices[n3], n2);
        }
        return this.mModel.isCellEditable(n, n2);
    }

    final boolean isUnsortedDisplay() {
        return this.mSortColIndex < 0;
    }

    public static TableModel enableColumnSorting(JTable jTable, JUTableBinding jUTableBinding, JUTableSortModel jUTableSortModel) {
        block4: {
            if (jUTableSortModel == null) {
                jUTableSortModel = new JUTableSortModel(jUTableBinding);
            } else {
                try {
                    jUTableSortModel.setTableBinding(jUTableBinding);
                }
                catch (Exception exception) {
                    jUTableBinding.reportException(exception);
                    if (jUTableSortModel != null) break block4;
                    Diagnostic.println((String)"Failed to create custom SortModel for JTable. Using default implementation");
                    jUTableSortModel = new JUTableSortModel(jUTableBinding);
                }
            }
        }
        jUTableSortModel.addMouseListenerToHeaderInTable(jTable);
        jTable.setModel(jUTableSortModel);
        jTable.setSelectionModel(new SortedListSelectionModel(jUTableSortModel, jTable.getSelectionModel()));
        return jUTableSortModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        private final /* synthetic */ JUTableSortModel v$sorter;
        final /* synthetic */ JUTableSortModel this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.v$tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.v$tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                boolean bl;
                int n3 = mouseEvent.getModifiers() & 1;
                boolean bl2 = bl = n3 == 0;
                if (bl == this.v$sorter.mAscending && n2 == this.v$sorter.mSortColIndex) {
                    n2 = -1;
                }
                this.v$sorter.sortByColumn(n2, bl);
            }
        }

        public /* synthetic */ 1(JUTableSortModel jUTableSortModel, JTable jTable, JUTableSortModel jUTableSortModel2) {
            this.v$sorter = jUTableSortModel2;
            this.v$tableView = jTable;
            this.this$0 = jUTableSortModel;
        }
    }
}

