/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.SortCriteria;
import oracle.jbo.SortCriteriaImpl;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.uicli.UIMessageBundle;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUPanelStopEditingListener;
import oracle.jbo.uicli.jui.JUTableDef;
import oracle.jbo.uicli.jui.JUTableSortModel;

public class JUTableBinding
extends JUCtrlRangeBinding
implements HierarchyListener,
JUPanelStopEditingListener,
TableModel {
    private static final String SYNC_FROM_TABLE_SORT = "JUTableBinding.sort";
    private JUTableModel mTableModel;
    private JScrollPane mScrollPane;
    private JUTableScrollBarListener mScrollBarListener;
    private int mScrollUnit;
    private boolean mParentSearched;
    private int mNumVisRows;
    private JboException mError;
    int mScrollMode;
    HashMap mColumnProperties;
    boolean mTrackScrolling;
    static int DEF_TABLE_ROW_COUNT = 10;
    public static final int TBL_SCROLL_ACTIVE = 0;
    private static final int TBL_SCROLL_NOUPDATE = 1;
    private static final int TBL_SCROLL_CYCLEROWS = 2;
    public static final int TBL_SCROLL_PASSIVE = 3;
    public static final int CS_FULL = 0;
    public static final int CS_NONE = -1;
    public static final int CS_RANGE = 1;
    JUPanelBinding mPanelBinding;
    public boolean mSortAscending;
    public int mSortColumn;
    boolean inStopEditing;

    private /* synthetic */ void $init$() {
        this.mParentSearched = false;
        this.mNumVisRows = 0;
        this.mError = null;
        this.mColumnProperties = null;
        this.mTrackScrolling = false;
        this.mSortAscending = false;
        this.mSortColumn = -1;
        this.inStopEditing = false;
    }

    public Object getControlModel(Object object) {
        this.setControl(object);
        JUTableModel jUTableModel = this.getModelImpl((JTable)object);
        JUTableDef jUTableDef = (JUTableDef)this.getDef();
        switch (jUTableDef.getColumnSortMode()) {
            case 1: {
                TableModel tableModel = JUTableSortModel.enableColumnSorting((JTable)object, this, null);
                this.updateColumnModel((JTable)object);
                return tableModel;
            }
            case 0: {
                1 var5_5 = new 1();
                JTable jTable = (JTable)this.getControl();
                JTableHeader jTableHeader = jTable.getTableHeader();
                jTableHeader.addMouseListener(var5_5);
            }
        }
        return jUTableModel;
    }

    public static TableModel createAttributeListBinding(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray) {
        return JUTableBinding.createAttributeListBinding(jUPanelBinding, jTable, string, string2, string3, stringArray, false, null);
    }

    public static TableModel createAttributeListBinding(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray, boolean bl, JUTableSortModel jUTableSortModel) {
        if (!JUIUtil.inDesignTime()) {
            JUTableBinding jUTableBinding = new JUTableBinding(jTable, jUPanelBinding.getRowIterBinding(string, string2, string3), stringArray);
            jUTableBinding.refreshControl();
            jUTableBinding.mPanelBinding = jUPanelBinding;
            jUTableBinding.findParent();
            JUTableModel jUTableModel = jUTableBinding.getModel();
            if (bl) {
                return JUTableSortModel.enableColumnSorting(jTable, jUTableBinding, jUTableSortModel);
            }
            return jUTableModel;
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJTableBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            int n = 0;
            while (n < constructorArray.length) {
                if (constructorArray[n].getParameterTypes().length == 2) {
                    constructor = constructorArray[n];
                }
                ++n;
            }
            String string4 = "";
            if (stringArray != null && stringArray.length != 0) {
                string4 = stringArray[0];
            }
            int n2 = stringArray == null ? 0 : stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append(",");
                stringBuffer.append(stringArray[n3]);
                ++n3;
            }
            Object[] objectArray = new Object[]{string + "." + stringBuffer.toString(), new Boolean(bl)};
            Object obj = constructor.newInstance(objectArray);
            TableModel tableModel = (TableModel)obj;
            return tableModel;
        }
        catch (Exception exception) {
            TableModel tableModel = null;
            return tableModel;
        }
    }

    public static TableModel getInstance(JUPanelBinding jUPanelBinding, JTable jTable, String string, String string2, String string3, String[] stringArray) {
        return JUTableBinding.createAttributeListBinding(jUPanelBinding, jTable, string, string2, string3, stringArray);
    }

    public JUTableBinding(JTable jTable, JUIteratorBinding jUIteratorBinding, String[] stringArray) {
        super((Object)jTable, (DCIteratorBinding)jUIteratorBinding, stringArray);
        this.$init$();
        this.mPanelBinding = (JUPanelBinding)this.getBindingContainer();
        this.setControl(jTable);
    }

    public void setControl(Object object) {
        JTable jTable = (JTable)object;
        super.setControl((Object)jTable);
        if (jTable != null) {
            if (this.mTableModel != jTable.getModel()) {
                this.mTableModel = this.getModelImpl(jTable);
            }
            this.updateColumnModel(jTable);
            jTable.addHierarchyListener(this);
            this.findParent();
        } else if (this.getControl() != null) {
            jTable = (JTable)this.getControl();
            jTable.removeHierarchyListener(this);
            jTable.setModel(new DefaultTableModel());
        }
    }

    public void setColumnProperties(HashMap hashMap) {
        this.mColumnProperties = hashMap;
    }

    protected void updateColumnModel(JTable jTable) {
        if (jTable == null || this.mColumnProperties == null) {
            return;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n = tableColumn.getModelIndex();
            TableColumn tableColumn2 = (TableColumn)this.mColumnProperties.get(this.getColumnName(n));
            if (tableColumn2 == null) continue;
            if (tableColumn2.getPreferredWidth() > tableColumn.getPreferredWidth()) {
                tableColumn.setPreferredWidth(tableColumn2.getPreferredWidth());
            }
            if (tableColumn2.getCellEditor() != null) {
                tableColumn.setCellEditor(tableColumn2.getCellEditor());
            }
            if (tableColumn2.getCellRenderer() == null) continue;
            tableColumn.setCellRenderer(tableColumn2.getCellRenderer());
        }
    }

    public void stopEditing() {
        if (this.inStopEditing) {
            return;
        }
        JTable jTable = (JTable)this.getControl();
        if (jTable == null) {
            return;
        }
        TableCellEditor tableCellEditor = jTable.getCellEditor();
        if (tableCellEditor != null) {
            DCBindingContainer dCBindingContainer = this.getBindingContainer();
            boolean bl = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    this.inStopEditing = true;
                    tableCellEditor.stopCellEditing();
                }
                catch (JboException jboException) {
                    ((JUPanelBinding)this.getFormBinding()).setEditingStopped(false);
                    if (!bl) {
                        throw jboException;
                    }
                    Diagnostic.println((String)("Ignoring handled exception :" + jboException.getMessage()));
                    Object var7_6 = null;
                    this.inStopEditing = false;
                }
                Object var7_5 = null;
                this.inStopEditing = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.inStopEditing = false;
                throw throwable;
            }
        }
    }

    public JUTableModel getModel() {
        return this.mTableModel;
    }

    protected JUTableModel getModelImpl(JTable jTable) {
        JUTableModel jUTableModel = this.mTableModel;
        if (jUTableModel == null) {
            jUTableModel = new JUTableModel(jTable);
            ((JUPanelBinding)this.getFormBinding()).addBindingWithCellEditor(this);
        }
        return jUTableModel;
    }

    protected boolean isControlQueriable() {
        return true;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    public Object getLayoutObject() {
        if (this.mScrollPane == null) {
            return this.getControl();
        }
        return this.mScrollPane;
    }

    void findParent() {
        if (this.mScrollPane == null && !this.mParentSearched) {
            this.mParentSearched = true;
            JTable jTable = (JTable)this.getControl();
            if (jTable != null) {
                Container container = jTable.getParent();
                while (container != null) {
                    if (container instanceof JScrollPane) break;
                    container = container.getParent();
                }
                if (container != null) {
                    this.setLayoutObject((JScrollPane)container);
                }
            }
        }
    }

    public void setLayoutObject(JScrollPane jScrollPane) {
        if (this.mScrollPane != null) {
            this.mScrollPane.getViewport().removeChangeListener(this.mTableModel);
            if (this.mScrollBarListener != null) {
                this.mScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.mScrollBarListener);
                this.mScrollBarListener = null;
            }
        }
        boolean bl = this.mScrollPane != jScrollPane;
        this.mScrollPane = jScrollPane;
        this.mNumVisRows = 0;
        if (this.mScrollPane != null) {
            this.mScrollPane.getViewport().addChangeListener(this.mTableModel);
            this.mScrollBarListener = new JUTableScrollBarListener();
            JScrollBar jScrollBar = this.mScrollPane.getVerticalScrollBar();
            jScrollBar.getModel().addChangeListener(this.mScrollBarListener);
            jScrollBar.addMouseListener(new PassiveScrollListener());
            jScrollBar.addMouseListener(new ScrollPopupListener(new ScrollPopupMenu(jScrollBar)));
            if (bl) {
                this.mTableModel.stateChanged(null);
            }
        }
    }

    int getScrollUnit() {
        return this.mScrollUnit;
    }

    protected int getDefaultVisibleRowCount() {
        return 10;
    }

    public void updateValuesFromRows(Row[] rowArray, boolean bl) {
        if (this.mTableModel != null) {
            this.mError = null;
            this.mTableModel.refresh(bl);
        }
    }

    public void updateRangeScrolled(ScrollEvent scrollEvent) {
        if (this.mTableModel != null) {
            this.mTableModel.updateRangeScrolled(scrollEvent);
        }
    }

    public void updateRowInserted(InsertEvent insertEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
        super.updateRowInserted(insertEvent);
        if (this.mTableModel != null) {
            this.mTableModel.refresh(true);
        }
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.removeEditor();
        }
        super.updateRowDeleted(deleteEvent);
        if (jTable != null) {
            jTable.clearSelection();
            if (this.mTableModel != null) {
                this.mTableModel.refresh(true);
            }
        }
    }

    public void updateNavigated(NavigationEvent navigationEvent) {
        JTable jTable = (JTable)this.getControl();
        if (jTable != null && jTable.isEditing()) {
            jTable.removeEditor();
        }
        if (this.mTableModel != null) {
            this.mTableModel.updateNavigated(navigationEvent);
        }
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Object object = this.getLayoutObject();
        Object object2 = this.getControl();
        boolean bl = false;
        if (object == object2) {
            this.mParentSearched = false;
            bl = true;
        }
        this.findParent();
        boolean bl2 = bl = bl && this.getLayoutObject() != object2;
        if (this.mTableModel != null && (bl || this.mNumVisRows == 0)) {
            this.mTableModel.stateChanged(null);
        }
    }

    public int getRowCount() {
        if (this.mTableModel != null) {
            return this.mTableModel.getRowCount();
        }
        return (int)this.getEstimatedRowCount();
    }

    public int getColumnCount() {
        if (this.mTableModel != null) {
            return this.mTableModel.getColumnCount();
        }
        return super.getAttributeCount();
    }

    public String getColumnName(int n) {
        if (this.mTableModel != null) {
            return this.mTableModel.getColumnName(n);
        }
        return this.getLabel(this.getAttributeDef(n).getName(), null);
    }

    public Class getColumnClass(int n) {
        if (this.mTableModel != null) {
            return this.mTableModel.getColumnClass(n);
        }
        return this.getAttributeDef(n).getJavaType();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.mTableModel != null) {
            return this.mTableModel.isCellEditable(n, n2);
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (this.mTableModel != null) {
            return this.mTableModel.getValueAt(n, n2);
        }
        return super.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.mTableModel != null) {
            this.mTableModel.setValueAt(object, n, n2);
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        if (this.mTableModel != null) {
            this.mTableModel.addTableModelListener(tableModelListener);
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.mTableModel != null) {
            this.mTableModel.removeTableModelListener(tableModelListener);
        }
    }

    public void release(int n) {
        if (n < 0 || (n & DCDataControl.REL_ALL_REFS) > 0 || (n & DCDataControl.REL_VIEW_REFS) > 0) {
            this.setLayoutObject(null);
            this.mTableModel = null;
        }
        super.release(n);
    }

    JUTableBinding getMyBinding() {
        return this;
    }

    void forceSync() {
        DCDataControl dCDataControl = this.getIteratorBinding().getDataControl();
        if (dCDataControl != null && dCDataControl.syncNeeded()) {
            ((JUPanelBinding)this.getBindingContainer().getRootBindingContainer()).requestRefreshControl();
        }
    }

    public int rowIndexToRangeIndex(int n) {
        return this.getModel().rowIndexToRangeIndex(n);
    }

    public int getScrolMode() {
        return this.mScrollMode;
    }

    public void setScrollMode(int n) {
        this.mScrollMode = n;
    }

    public final class oracle.jbo.uicli.jui.JUTableBinding$1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                int n3 = mouseEvent.getModifiers() & 1;
                boolean bl = n3 == 0;
                JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
                if (bl == JUTableBinding.this.mSortAscending && n2 == JUTableBinding.this.mSortColumn) {
                    JUTableBinding.this.mSortAscending = true;
                    JUTableBinding.this.mSortColumn = -1;
                } else if (jUIteratorBinding.isAttributeSortable(JUTableBinding.this.getAttributeDef(n2))) {
                    JUTableBinding.this.mSortAscending = bl;
                    JUTableBinding.this.mSortColumn = n2;
                } else {
                    return;
                }
                SwingUtilities.invokeLater(new 1());
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
                if (jUIteratorBinding.isAlive() && jUIteratorBinding.isBound()) {
                    SortCriteria[] sortCriteriaArray = JUTableBinding.this.mSortColumn == -1 ? new SortCriteria[]{} : new SortCriteria[]{new SortCriteriaImpl(JUTableBinding.this.getAttributeDef(JUTableBinding.this.mSortColumn).getName(), JUTableBinding.this.mSortAscending ^ true)};
                    Row row = jUIteratorBinding.getCurrentRow();
                    Key key = null;
                    if (row != null) {
                        key = row.getKey();
                    }
                    jUIteratorBinding.applySortCriteria(sortCriteriaArray);
                    if (jUIteratorBinding.getRowSetIterator().getRowSet() != null) {
                        jUIteratorBinding.executeQuery();
                    }
                    if (key != null) {
                        jUIteratorBinding.getDataControl().setCurrentRowWithKey((DCIteratorBinding)jUIteratorBinding, key);
                    }
                    jUIteratorBinding.getDataControl().syncIfNeeded(JUTableBinding.SYNC_FROM_TABLE_SORT);
                }
            }
        }
    }

    protected class JUTableModel
    extends AbstractTableModel
    implements ChangeListener,
    ListSelectionListener {
        private boolean mSelRowInProg;
        private boolean mBatchMode;
        private boolean mDataAccessible;
        private UpdateNavigatedRunnableImpl mRunnableUpdateNavigated;
        private boolean mRunnableRefreshLaterSelectRow;
        private Runnable mRunnableRefeshLater;
        private Runnable mRunnableReportException;
        private static /* synthetic */ Class class$java$lang$String;

        private /* synthetic */ void $init$() {
            this.mSelRowInProg = false;
            this.mBatchMode = false;
            this.mDataAccessible = true;
            this.mRunnableUpdateNavigated = null;
        }

        JUTableModel(JTable jTable) {
            this.$init$();
            Rectangle rectangle = jTable.getVisibleRect();
            if (rectangle != null) {
                JUTableBinding.this.mScrollUnit = jTable.getScrollableUnitIncrement(rectangle, 1, 0);
            } else {
                JUTableBinding.this.mScrollUnit = jTable.getRowHeight();
            }
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof JUTableBinding) {
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.removeListSelectionListener(((JUTableBinding)tableModel).mTableModel);
            }
            if (tableModel instanceof JUTableModel) {
                ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                listSelectionModel.removeListSelectionListener((JUTableModel)tableModel);
            }
            ((JTable)JUTableBinding.this.getMyBinding().getControl()).setModel(this);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.setSelectionMode(0);
            listSelectionModel.addListSelectionListener(this);
        }

        void fireTableDataChangedRestoreSelection(boolean bl) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            if (jTable == null) {
                return;
            }
            int n = jTable.getSelectedRow();
            int n2 = jTable.getSelectedColumn();
            boolean bl2 = jTable.getSelectionModel().getValueIsAdjusting();
            boolean bl3 = jTable.getColumnModel().getSelectionModel().getValueIsAdjusting();
            this.mSelRowInProg = true;
            try {
                this.fireTableDataChanged();
                if (bl && (n >= 0 || n2 >= 0) && this.getRowCount() > 0) {
                    if (jTable.getSelectedRow() < 0 && n >= 0) {
                        if (jTable.getSelectionModel().getValueIsAdjusting() != bl2) {
                            jTable.getSelectionModel().setValueIsAdjusting(bl2);
                        }
                        this.selectRowOfIndex(n);
                    }
                    if (jTable.getSelectedColumn() < 0 && n2 >= 0) {
                        if (jTable.getColumnModel().getSelectionModel().getValueIsAdjusting() != bl3) {
                            jTable.getColumnModel().getSelectionModel().setValueIsAdjusting(bl3);
                        }
                        jTable.setColumnSelectionInterval(n2, n2);
                    }
                }
                Object var8_7 = null;
                this.mSelRowInProg = false;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.mSelRowInProg = false;
                throw throwable;
            }
        }

        void updateRangeScrolled(ScrollEvent scrollEvent) {
            if (JUTableBinding.this.mScrollBarListener != null && !JUTableBinding.this.mScrollBarListener.isInScrollBarStateChange()) {
                JUTableBinding.this.mScrollPane.getVerticalScrollBar().setValue(scrollEvent.getRangeStart() * JUTableBinding.this.mScrollUnit);
            }
            this.fireTableDataChangedRestoreSelection(true);
        }

        void updateNavigated(NavigationEvent navigationEvent) {
            int n = navigationEvent.getRowIndex();
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator != null) {
                int n2 = rowIterator.getRangeStart();
                if (n2 < 0 || this.mBatchMode) {
                    n2 = 0;
                }
                int n3 = n < 0 ? -1 : n + n2;
                JTable jTable = (JTable)JUTableBinding.this.getControl();
                if (jTable.getAutoscrolls()) {
                    if (this.mRunnableUpdateNavigated != null) {
                        this.mRunnableUpdateNavigated.setRowIndex(n3);
                    } else if (jTable != null && n3 >= 0 && jTable.getSelectedRow() != n3) {
                        this.mRunnableUpdateNavigated = new UpdateNavigatedRunnableImpl(n3);
                        SwingUtilities.invokeLater(this.mRunnableUpdateNavigated);
                    }
                }
            }
        }

        private void selectRowOfIndex(int n) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            if (jTable == null) {
                return;
            }
            if (n >= 0) {
                jTable.getSelectionModel().setSelectionInterval(n, n);
            } else {
                jTable.getSelectionModel().clearSelection();
            }
        }

        private void refresh(boolean bl) {
            this.mRunnableRefreshLaterSelectRow = bl;
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            int n = jTable.getEditingColumn();
            int n2 = jTable.getEditingRow();
            if (this.mRunnableRefeshLater == null) {
                this.mRunnableRefeshLater = new 2(this, n, n2);
                SwingUtilities.invokeLater(this.mRunnableRefeshLater);
            }
        }

        private void reportExceptionLater() {
            if (this.mRunnableReportException == null) {
                this.mRunnableReportException = new 1();
                SwingUtilities.invokeLater(this.mRunnableReportException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void _refreshLater(boolean bl) {
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator == null) return;
            if (JUTableBinding.this.mError != null) return;
            DCBindingContainer dCBindingContainer = JUTableBinding.this.getBindingContainer();
            boolean bl2 = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    if (bl2) {
                        dCBindingContainer.setErrorHandlerActive(false);
                    }
                    this.mDataAccessible = true;
                    JTable jTable = (JTable)JUTableBinding.this.getControl();
                    int n = jTable.getSelectedColumn();
                    this.fireTableDataChangedRestoreSelection(bl ^ true);
                    if (bl && rowIterator.getCurrentRowSlot() != 1) {
                        int n2 = -1;
                        int n3 = rowIterator.getCurrentRowIndex();
                        if (n3 >= 0) {
                            int n4 = rowIterator.getRangeStart();
                            if (n4 < 0) {
                                n4 = 0;
                            }
                            if (this.mBatchMode) {
                                n3 -= n4;
                            }
                            n2 = n3 > 0 ? n3 : n4;
                            this.mSelRowInProg = true;
                            try {
                                this.selectRowOfIndex(n2);
                                if (n > 0) {
                                    jTable.setColumnSelectionInterval(n, n);
                                }
                                Object var12_10 = null;
                                this.mSelRowInProg = false;
                            }
                            catch (Throwable throwable) {
                                Object var12_11 = null;
                                this.mSelRowInProg = false;
                                throw throwable;
                            }
                        }
                    }
                    Object var14_13 = null;
                }
                catch (JboException jboException) {
                    dCBindingContainer.setErrorHandlerActive(bl2);
                    if (JUTableBinding.this.mError == null) {
                        JUTableBinding.this.mError = jboException;
                        this.reportExceptionLater();
                    }
                    Object var14_14 = null;
                    dCBindingContainer.setErrorHandlerActive(bl2);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                dCBindingContainer.setErrorHandlerActive(bl2);
                throw throwable;
            }
            dCBindingContainer.setErrorHandlerActive(bl2);
        }

        public String getColumnName(int n) {
            AttributeDef attributeDef = JUTableBinding.this.getAttributeDef(n);
            return attributeDef != null ? JUTableBinding.this.getLabel(attributeDef.getName(), null) : Integer.toString(n);
        }

        public Class getColumnClass(int n) {
            AttributeDef attributeDef;
            if (!JUTableBinding.this.getIteratorBinding().isFindMode() && (attributeDef = JUTableBinding.this.getAttributeDef(n)) != null && !attributeDef.getUIHelper().hasFormatInformation(null)) {
                return JBOClass.getObjectClass((Class)attributeDef.getJavaType());
            }
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = JUTableModel.class$("java.lang.String");
            }
            return clazz;
        }

        public int getColumnCount() {
            return JUTableBinding.this.getAttributeCount();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getRowCount() {
            if (JUTableBinding.this.mError != null) {
                return 0;
            }
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (jUIteratorBinding == null) return 0;
            if (!jUIteratorBinding.isIteratorMadeVisible()) {
                if (!jUIteratorBinding.isFindMode()) return 0;
            }
            DCBindingContainer dCBindingContainer = JUTableBinding.this.getBindingContainer();
            boolean bl = dCBindingContainer.isErrorHandlerActive();
            try {
                try {
                    this.mBatchMode = !jUIteratorBinding.isFindMode() && jUIteratorBinding.getRangeSize() != -1 && jUIteratorBinding.getDataControl() != null && jUIteratorBinding.getDataControl().syncNeeded();
                    if (this.mBatchMode) int n;
                    int n2;
                    return (n2 = jUIteratorBinding.getNavigatableRowIterator().getRangeSize()) > (n = jUIteratorBinding.getNavigatableRowIterator().getRowCountInRange()) ? n : n2;
                    return (int)JUTableBinding.this.getEstimatedRowCount();
                }
                catch (JboException jboException) {
                    if (JUTableBinding.this.mError != null) return 0;
                    JUTableBinding.this.mError = jboException;
                    this.reportExceptionLater();
                    return 0;
                }
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                throw throwable;
            }
        }

        private int rowIndexToRangeIndex(int n) {
            RowIterator rowIterator = JUTableBinding.this.getRowIterator();
            if (rowIterator != null && !this.mBatchMode) {
                int n2 = rowIterator.getRangeStart();
                if (n2 <= 0) {
                    return n;
                }
                return n - n2;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCellEditable(int n, int n2) {
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (JUTableBinding.this.mPanelBinding != null) {
                JUTableBinding.this.mPanelBinding.focusGained((DCIteratorBinding)jUIteratorBinding, (DCControlBinding)JUTableBinding.this.getMyBinding(), -1);
            }
            if (!jUIteratorBinding.getDataControl().isOperationSupported((DCIteratorBinding)jUIteratorBinding, (byte)0)) {
                return false;
            }
            int n3 = this.rowIndexToRangeIndex(n);
            Object object = jUIteratorBinding.getSyncLock();
            synchronized (object) {
                try {
                    Row[] rowArray = JUTableBinding.this.getAllRowsInRange();
                    if (rowArray == null || rowArray.length == 0) {
                        boolean bl = false;
                        return bl;
                    }
                    AttributeDef attributeDef = JUTableBinding.this.getAttributeDef(n2);
                    if (attributeDef != null && n3 >= 0 && n3 < rowArray.length) {
                        boolean bl = rowArray[n3].isAttributeUpdateable(attributeDef.getIndex());
                        return bl;
                    }
                }
                catch (Exception exception) {
                    JUTableBinding.this.reportException(exception);
                }
            }
            return true;
        }

        void unlockRSI() {
            this.mDataAccessible = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getValueAt(int n, int n2) {
            Object object;
            RowSet rowSet;
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            NavigatableRowIterator navigatableRowIterator = jUIteratorBinding.getNavigatableRowIterator();
            if (!this.mDataAccessible) return null;
            if (navigatableRowIterator == null) return null;
            if (!jUIteratorBinding.isFindMode() && (rowSet = ((RowSetIterator)navigatableRowIterator).getRowSet()) != null && !rowSet.isExecuted()) {
                return null;
            }
            int n3 = navigatableRowIterator.getRangeSize();
            int n4 = this.rowIndexToRangeIndex(n);
            if (JUTableBinding.this.mTrackScrolling && JUTableBinding.this.mScrollMode == 2 && n3 > 0) {
                if (n4 >= n3) {
                    n4 %= n3;
                } else if (n4 < 0) {
                    n4 = -1 * n4 % n3;
                }
            }
            if (n4 < 0) return null;
            boolean bl = false;
            try {
                try {
                    if (jUIteratorBinding.getBindingContainer().isErrorHandlerActive()) {
                        bl = true;
                        jUIteratorBinding.getBindingContainer().setErrorHandlerActive(false);
                    }
                    object = JUTableBinding.this.getAttributeFromRow(n4, n2);
                    Object var12_10 = null;
                    if (!bl) return object;
                }
                catch (JboException jboException) {
                    this.mDataAccessible = false;
                    if (bl) {
                        jUIteratorBinding.getBindingContainer().setErrorHandlerActive(bl);
                    }
                    JUTableBinding.this.reportException((Exception)((Object)jboException));
                    Object var12_11 = null;
                    if (!bl) return null;
                    jUIteratorBinding.getBindingContainer().setErrorHandlerActive(bl);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (!bl) throw throwable;
                jUIteratorBinding.getBindingContainer().setErrorHandlerActive(bl);
                throw throwable;
            }
            jUIteratorBinding.getBindingContainer().setErrorHandlerActive(bl);
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (object == null && object2 != null || object2 == null && object != null || object != null && object2 != null && !object.toString().equals(object2.toString())) {
                int n3 = this.rowIndexToRangeIndex(n);
                try {
                    JUTableBinding.this.setAttributeInRow(n3, n2, object, false);
                }
                catch (JboException jboException) {
                    JUTableBinding.this.reportException((Exception)((Object)jboException), true);
                    throw jboException;
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (this.mSelRowInProg || listSelectionModel.getValueIsAdjusting()) {
                return;
            }
            if (!listSelectionModel.isSelectionEmpty()) {
                this.resetRSICurrency(listSelectionModel.getMinSelectionIndex());
            }
        }

        protected void resetRSICurrency(int n) {
            try {
                RowIterator rowIterator = JUTableBinding.this.getRowIterator();
                if (rowIterator == null) {
                    return;
                }
                int n2 = rowIterator.getRangeSize();
                int n3 = rowIterator.getRangeStart();
                if (n3 < 0 || this.mBatchMode) {
                    n3 = 0;
                }
                int n4 = n - n3;
                if (n2 > 0) {
                    if (n4 >= n2) {
                        n4 = n4 - rowIterator.getRangeSize() + 1;
                        rowIterator.scrollRange(n4);
                        n4 = n - rowIterator.getRangeStart();
                    } else if (n4 < 0) {
                        rowIterator.scrollRange(n4);
                        n4 = 0;
                    }
                }
                int n5 = rowIterator.getRangeIndexOf(rowIterator.getCurrentRow());
                Map map = this.saveEditorState();
                if (n5 != n4 && JUTableBinding.this.getFormBinding() != null) {
                    ((JUPanelBinding)JUTableBinding.this.getFormBinding()).callBeforeRowNavigated((DCIteratorBinding)JUTableBinding.this.getIteratorBinding());
                }
                rowIterator.setCurrentRowAtRangeIndex(n4);
                if (map != null) {
                    this.restoreEditorState(map);
                }
            }
            catch (Exception exception) {
                JUTableBinding.this.reportException(exception);
                this.refresh(true);
            }
        }

        protected Map saveEditorState() {
            HashMap<String, Integer> hashMap = null;
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            if (jTable.isEditing()) {
                hashMap = new HashMap<String, Integer>();
                hashMap.put("editingRow", new Integer(jTable.getEditingRow()));
                hashMap.put("editingColumn", new Integer(jTable.getEditingColumn()));
                if (jTable.getEditorComponent() instanceof JTextComponent) {
                    int n = ((JTextComponent)jTable.getEditorComponent()).getCaretPosition();
                    hashMap.put("caretPosition", new Integer(n));
                }
            }
            return hashMap;
        }

        protected void restoreEditorState(Map map) {
            if (map == null) {
                return;
            }
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            int n = (Integer)map.get("editingColumn");
            int n2 = (Integer)map.get("editingRow");
            if (jTable.getSelectedColumn() == n && jTable.getSelectedRow() == n2) {
                JTextComponent jTextComponent;
                jTable.editCellAt(n2, n);
                jTable.getEditorComponent().requestFocusInWindow();
                Integer n3 = (Integer)map.get("caretPosition");
                if (n3 != null && (jTextComponent = (JTextComponent)jTable.getEditorComponent()).getCaretPosition() != n3.intValue()) {
                    jTextComponent.setCaretPosition(n3);
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = -1;
            int n2 = 0;
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (JUTableBinding.this.mScrollPane != null) {
                n2 = JUTableBinding.this.mScrollPane.getViewport().getHeight();
            } else if (jTable != null) {
                n2 = jTable.getHeight();
            }
            if (n2 == 0) {
                n = jUIteratorBinding != null && jUIteratorBinding.getRangeSize() > 1 ? jUIteratorBinding.getRangeSize() : (JUTableBinding.this.mScrollPane == null ? JUTableBinding.this.getDefaultVisibleRowCount() : 0);
            } else {
                int n3 = JUTableBinding.this.mScrollUnit;
                n = n2 / n3;
                if (n2 % n3 != 0) {
                    ++n;
                }
            }
            if (n != 0 && jUIteratorBinding != null) {
                this.resolveRangeSize(n);
            }
        }

        void resolveRangeSize(int n) {
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            int n2 = jUIteratorBinding.getRangeSize();
            if (n2 != n) {
                jUIteratorBinding.resolveRangeSize(n);
                JUTableBinding.this.forceSync();
                JUTableBinding.this.mNumVisRows = jUIteratorBinding.getRangeSize();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public class UpdateNavigatedRunnableImpl
        implements Runnable {
            int rowIndex;

            UpdateNavigatedRunnableImpl(int n) {
                this.rowIndex = n;
            }

            void setRowIndex(int n) {
                this.rowIndex = n;
            }

            public void run() {
                JTable jTable;
                JUTableModel.this.mRunnableUpdateNavigated = null;
                if (Diagnostic.isOn()) {
                    Diagnostic.println((String)("Navigating to " + this.rowIndex));
                }
                if ((jTable = (JTable)JUTableBinding.this.getControl()) != null) {
                    Rectangle rectangle = jTable.getCellRect(this.rowIndex, 0, false);
                    if (rectangle != null) {
                        jTable.scrollRectToVisible(rectangle);
                    }
                    JUTableModel.this.mSelRowInProg = true;
                    try {
                        JUTableModel.this.selectRowOfIndex(this.rowIndex);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        JUTableModel.this.mSelRowInProg = false;
                        throw throwable;
                    }
                    JUTableModel.this.mSelRowInProg = false;
                    {
                    }
                }
            }
        }

        public final class 2
        implements Runnable {
            private final /* synthetic */ int v$editColAtRefresh;
            private final /* synthetic */ int v$editRowAtRefresh;
            final /* synthetic */ JUTableModel this$0;

            public void run() {
                JTable jTable = (JTable)this.this$0.JUTableBinding.this.getControl();
                boolean bl = jTable.isEditing();
                int n = jTable.getEditingRow();
                int n2 = jTable.getEditingColumn();
                if (jTable != null && jTable.isEditing()) {
                    jTable.removeEditor();
                }
                this.this$0.mRunnableRefeshLater = null;
                this.this$0._refreshLater(this.this$0.mRunnableRefreshLaterSelectRow);
                if (bl && (this.v$editColAtRefresh != n2 || this.v$editRowAtRefresh != n)) {
                    jTable.editCellAt(n, n2);
                }
            }

            public /* synthetic */ 2(JUTableModel jUTableModel, int n, int n2) {
                this.v$editRowAtRefresh = n2;
                this.v$editColAtRefresh = n;
                this.this$0 = jUTableModel;
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                if (JUTableBinding.this.mError != null) {
                    JUTableModel.this.mRunnableReportException = null;
                    JUTableBinding.this.reportException((Exception)((Object)JUTableBinding.this.mError));
                }
            }
        }
    }

    public class JUTableScrollBarListener
    implements ChangeListener {
        private boolean mInScrollBarStateChange;

        private /* synthetic */ void $init$() {
            this.mInScrollBarStateChange = false;
        }

        boolean isInScrollBarStateChange() {
            return this.mInScrollBarStateChange;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JUTableBinding.this.mScrollMode != 0 && ((BoundedRangeModel)changeEvent.getSource()).getValueIsAdjusting()) {
                JUTableBinding.this.mTrackScrolling = true;
                return;
            }
            JUTableBinding.this.mTrackScrolling = false;
            JUIteratorBinding jUIteratorBinding = JUTableBinding.this.getIteratorBinding();
            if (jUIteratorBinding == null || !jUIteratorBinding.isIteratorMadeVisible()) {
                return;
            }
            if (!jUIteratorBinding.isFindMode() && jUIteratorBinding.getRangeSize() != -1 && jUIteratorBinding.getDataControl() != null && !jUIteratorBinding.getDataControl().syncNeeded()) {
                int n;
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                int n2 = boundedRangeModel.getValue();
                int n3 = n2 / JUTableBinding.this.mScrollUnit;
                RowIterator rowIterator = JUTableBinding.this.getRowIterator();
                if (rowIterator == null) {
                    return;
                }
                int n4 = rowIterator.getRangeStart();
                if (n4 < 0) {
                    n4 = 0;
                }
                if ((n = n3 - n4) == 0) {
                    return;
                }
                if (this.mInScrollBarStateChange) {
                    return;
                }
                this.mInScrollBarStateChange = true;
                try {
                    rowIterator.scrollRange(n);
                    Object var10_9 = null;
                    this.mInScrollBarStateChange = false;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.mInScrollBarStateChange = false;
                    throw throwable;
                }
            }
        }

        JUTableScrollBarListener() {
            this.$init$();
        }
    }

    private class ScrollPopupListener
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        public ScrollPopupListener(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class PassiveScrollListener
    extends MouseAdapter {
        private ChangeListener[] listeners;
        private int oldValue;

        private /* synthetic */ void $init$() {
            this.listeners = null;
            this.oldValue = 0;
        }

        public PassiveScrollListener() {
            this.$init$();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            BoundedRangeModel boundedRangeModel;
            if (!mouseEvent.isPopupTrigger() && JUTableBinding.this.mScrollMode == 3 && (boundedRangeModel = ((JScrollBar)mouseEvent.getComponent()).getModel()) instanceof DefaultBoundedRangeModel) {
                this.oldValue = ((JScrollBar)mouseEvent.getComponent()).getValue();
                DefaultBoundedRangeModel defaultBoundedRangeModel = (DefaultBoundedRangeModel)boundedRangeModel;
                this.listeners = (ChangeListener[])defaultBoundedRangeModel.getChangeListeners().clone();
                int n = 0;
                while (n < this.listeners.length) {
                    boundedRangeModel.removeChangeListener(this.listeners[n]);
                    ++n;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger() && JUTableBinding.this.mScrollMode == 3) {
                BoundedRangeModel boundedRangeModel = ((JScrollBar)mouseEvent.getComponent()).getModel();
                if (this.listeners != null) {
                    int n = ((JScrollBar)mouseEvent.getComponent()).getValue();
                    boundedRangeModel.setValueIsAdjusting(true);
                    boundedRangeModel.setValue(this.oldValue);
                    int n2 = 0;
                    while (n2 < this.listeners.length) {
                        boundedRangeModel.addChangeListener(this.listeners[n2]);
                        ++n2;
                    }
                    this.listeners = null;
                    boundedRangeModel.setValueIsAdjusting(false);
                    boundedRangeModel.setValue(n);
                }
            }
        }
    }

    private class ScrollPopupMenu
    extends JPopupMenu {
        private static final String PROPERTY_VISIBLE = "visible";
        private final String MENU_TOP;
        private final String MENU_PREVIOUS;
        private final String MENU_HERE;
        private final String MENU_NEXT;
        private final String MENU_BOTTOM;
        private JScrollBar scrollBar;
        private double currentY;

        private /* synthetic */ void $init$() {
            this.MENU_TOP = UIMessageBundle.getResString((String)"02731");
            this.MENU_PREVIOUS = UIMessageBundle.getResString((String)"02732");
            this.MENU_HERE = UIMessageBundle.getResString((String)"02730");
            this.MENU_NEXT = UIMessageBundle.getResString((String)"02733");
            this.MENU_BOTTOM = UIMessageBundle.getResString((String)"02734");
        }

        public ScrollPopupMenu(JScrollBar jScrollBar) {
            this.$init$();
            this.scrollBar = jScrollBar;
            this.registerChangeListener();
            this.buildMenu();
        }

        private void registerChangeListener() {
            ScrollPopupMenu scrollPopupMenu = this;
            this.addPropertyChangeListener(PROPERTY_VISIBLE, new 6(this, scrollPopupMenu));
        }

        private void buildMenu() {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(this.MENU_HERE);
            jMenuItem.addActionListener(new 5());
            this.add(jMenuItem);
            this.addSeparator();
            JMenuItem jMenuItem2 = new JMenuItem();
            jMenuItem2.setText(this.MENU_TOP);
            jMenuItem2.addActionListener(new 4());
            this.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem();
            jMenuItem3.setText(this.MENU_PREVIOUS);
            jMenuItem3.addActionListener(new 3());
            this.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem();
            jMenuItem4.setText(this.MENU_NEXT);
            jMenuItem4.addActionListener(new 2());
            this.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem();
            jMenuItem5.setText(this.MENU_BOTTOM);
            jMenuItem5.addActionListener(new 1());
            this.add(jMenuItem5);
        }

        private void scrollPage(int n) {
            JTable jTable = (JTable)JUTableBinding.this.getControl();
            int n2 = JUTableBinding.this.getRowCount();
            double d = jTable == null ? 0 : jTable.getVisibleRect().height / jTable.getRowHeight();
            if (d > 0.0 && n2 > 0) {
                double d2 = d / (double)n2 * (double)(this.scrollBar.getMaximum() - this.scrollBar.getMinimum());
                double d3 = (double)this.scrollBar.getValue() + d2 * (double)n;
                this.scrollBar.setValue((int)Math.round(d3));
            }
        }

        public final class 6
        implements PropertyChangeListener {
            private final /* synthetic */ JPopupMenu v$menu;
            final /* synthetic */ ScrollPopupMenu this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (this.v$menu.isVisible()) {
                    this.this$0.currentY = this.v$menu.getLocationOnScreen().getY() - this.this$0.scrollBar.getLocationOnScreen().getY();
                }
            }

            public /* synthetic */ 6(ScrollPopupMenu scrollPopupMenu, JPopupMenu jPopupMenu) {
                this.v$menu = jPopupMenu;
                this.this$0 = scrollPopupMenu;
            }
        }

        public final class 5
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                double d = ScrollPopupMenu.this.currentY / ScrollPopupMenu.this.scrollBar.getBounds().getHeight();
                double d2 = d * (double)(ScrollPopupMenu.this.scrollBar.getMaximum() - ScrollPopupMenu.this.scrollBar.getMinimum());
                ScrollPopupMenu.this.scrollBar.setValue((int)Math.round(d2));
            }
        }

        public final class 4
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPopupMenu.this.scrollBar.setValue(ScrollPopupMenu.this.scrollBar.getMinimum());
            }
        }

        public final class 3
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPopupMenu.this.scrollPage(-1);
            }
        }

        public final class 2
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPopupMenu.this.scrollPage(1);
            }
        }

        public final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollPopupMenu.this.scrollBar.setValue(ScrollPopupMenu.this.scrollBar.getMaximum());
            }
        }
    }
}

