/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlListBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.controls.JUMultiAttrListCellRenderer;
import oracle.jbo.uicli.controls.JUMultiAttrListEditor;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUSVFocusAdapter;

public class JUComboBoxBinding
extends JUCtrlListBinding
implements MutableComboBoxModel,
ActionListener {
    private MutableComboBoxModel mComboModel;
    private boolean mSettingValue;
    private ListCellRenderer mCellRenderer;
    private ComboBoxEditor mEditor;

    private /* synthetic */ void $init$() {
        this.mComboModel = null;
        this.mSettingValue = true;
        this.mCellRenderer = null;
        this.mEditor = null;
    }

    public JUComboBoxBinding(JComboBox jComboBox, JUIteratorBinding jUIteratorBinding, String[] stringArray, int n) {
        super((Object)jComboBox, (DCIteratorBinding)jUIteratorBinding, stringArray, n);
        this.$init$();
        this.init(jComboBox);
    }

    public JUComboBoxBinding(JComboBox jComboBox, JUIteratorBinding jUIteratorBinding, String[] stringArray, Object[] objectArray) {
        super((Object)jComboBox, (DCIteratorBinding)jUIteratorBinding, stringArray, objectArray);
        this.$init$();
        this.init(jComboBox);
    }

    public JUComboBoxBinding(JComboBox jComboBox, JUIteratorBinding jUIteratorBinding, String[] stringArray, JUIteratorBinding jUIteratorBinding2, String[] stringArray2, String[] stringArray3) {
        super((Object)jComboBox, (DCIteratorBinding)jUIteratorBinding, stringArray, (DCIteratorBinding)jUIteratorBinding2, stringArray2, stringArray3);
        this.$init$();
        this.init(jComboBox);
    }

    private void init(JComboBox jComboBox) {
        this.mComboModel = this.getModelImpl(jComboBox);
        if (jComboBox != null) {
            if (this.mComboModel != jComboBox.getModel()) {
                jComboBox.setModel(this.mComboModel);
            }
            if (this.mValueList != null && this.mStaticList) {
                this.setupListItems(false, false);
            }
            jComboBox.addFocusListener(new JUSVFocusAdapter((JUControlBinding)this, 0));
        }
    }

    protected MutableComboBoxModel getModelImpl(JComboBox jComboBox) {
        DefaultComboBoxModel defaultComboBoxModel = this.mComboModel;
        if (defaultComboBoxModel == null) {
            if (jComboBox != null) {
                defaultComboBoxModel = (MutableComboBoxModel)jComboBox.getModel();
            }
            if (defaultComboBoxModel == null) {
                defaultComboBoxModel = new DefaultComboBoxModel();
            }
        }
        return defaultComboBoxModel;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    protected boolean isViewInitialized() {
        if (this.mComboModel != null && this.mComboModel.getSize() == 0) {
            return this.mValueList != null && this.mValueList.length == 0;
        }
        return true;
    }

    protected void setupListItems(boolean bl, boolean bl2) {
        JComboBox jComboBox;
        int n;
        JComboBox jComboBox2 = (JComboBox)this.getControl();
        if (jComboBox2 == null) {
            return;
        }
        int n2 = n = bl2 ? jComboBox2.getSelectedIndex() : 0;
        if (this.mValueList == null || bl) {
            super.setupListItems(bl, bl2);
            if (this.hasNullValue() && this.getNullValueString() == null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println((String)("Swing JComboBox cannot handle null values for binding:" + this.getName()));
                }
                super.setNullValueProperties(0);
                super.setupListItems(bl, bl2);
            }
        }
        if ((jComboBox = (JComboBox)this.getControl()) != null) {
            jComboBox.removeActionListener(this);
            if (bl && jComboBox2.getItemCount() > 0) {
                jComboBox.removeAllItems();
            }
        }
        SwingUtilities.invokeLater(new 1mRunnable(this, bl, n));
    }

    public Object getValueAt(int n) {
        return this.mComboModel.getSelectedItem();
    }

    public void setValueAt(Object object, int n) {
        if (n > 0) {
            return;
        }
        Object object2 = this.findAndUpdateSelectedIndex(object, true);
        try {
            this.mSettingValue = true;
            if (this.mComboModel != null) {
                if (object2 != null) {
                    this.mComboModel.setSelectedItem(object2);
                } else if (this.getControl() != null) {
                    JComboBox jComboBox = (JComboBox)this.getControl();
                    if (object instanceof Row) {
                        jComboBox.setSelectedItem(null);
                    } else if (jComboBox.isEditable()) {
                        jComboBox.setSelectedItem(object);
                    } else {
                        jComboBox.setSelectedItem(null);
                    }
                }
            }
            Object var6_5 = null;
            this.mSettingValue = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mSettingValue = false;
            throw throwable;
        }
    }

    public void setDataValueAt(Object object, int n) {
        Object object2 = this.findAndUpdateSelectedIndex(object, true);
        this.mComboModel.setSelectedItem(object2);
    }

    public void setSelectedIndex(int n) {
        super.setSelectedIndexValue(n);
        if (n >= 0) {
            this.setDataValueAt(this.getValueFromList(n), 0);
        } else {
            this.setDataValueAt(null, 0);
        }
    }

    protected boolean isControlQueriable() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.mSettingValue) {
            try {
                if (this.getListOperMode() == JUCtrlListBinding.LIST_OPER_NAVIGATE) {
                    RowIterator rowIterator;
                    int n = ((JComboBox)this.getControl()).getSelectedIndex();
                    if (n >= 0 && (rowIterator = this.getRowIterator()) != null) {
                        ((JUPanelBinding)this.getFormBinding()).callBeforeRowNavigated((DCIteratorBinding)this.getIteratorBinding());
                        rowIterator.setCurrentRowAtRangeIndex(n);
                    }
                } else {
                    this.updateTargetFromSelectedValue(this.mComboModel.getSelectedItem());
                }
            }
            catch (Exception exception) {
                this.reportException(exception, true);
            }
        }
    }

    protected void updateTargetFromSelectedValue(Object object) {
        if (!this.isSingleAttrList()) {
            int n = this.getSelectedIndexValue();
            if (object instanceof Row) {
                this.setListValueAsSelected(object);
            } else {
                object = this.findAndUpdateSelectedIndex(object, true);
            }
            if (this.getIteratorBinding() != null) {
                Row row = this.getCurrentRow();
                if (row == null) {
                    if (object == null) {
                        return;
                    }
                    throw new RowNotFoundException(this.getRowIterator());
                }
                if (n != this.getSelectedIndexValue()) {
                    if (object == this.getNullValueString()) {
                        object = null;
                    }
                    this.setTargetAttrsFromLovRow(row, (Row)object);
                }
            }
            return;
        }
        if (object == this.getNullValueString()) {
            object = null;
        }
        this.compareAndSetAttribute(0, object);
    }

    public void setSelectedItem(Object object) {
        this.mComboModel.setSelectedItem(object);
    }

    public Object getSelectedItem() {
        return this.mComboModel.getSelectedItem();
    }

    public int getSize() {
        return this.mComboModel.getSize();
    }

    public Object getElementAt(int n) {
        return this.mComboModel.getElementAt(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.mComboModel.addListDataListener(listDataListener);
        this.mSettingValue = false;
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.mComboModel.removeListDataListener(listDataListener);
    }

    public void addElement(Object object) {
        if (object != null) {
            this.mComboModel.addElement(object);
        }
    }

    public void removeElement(Object object) {
        if (object != null) {
            this.mComboModel.removeElement(object);
        }
    }

    public void insertElementAt(Object object, int n) {
        if (object != null) {
            this.mComboModel.insertElementAt(object, n);
        }
    }

    public void removeElementAt(int n) {
        this.mComboModel.removeElementAt(n);
    }

    public Object getControlModel(Object object) {
        Object object2 = this.getControl();
        JComboBox jComboBox = (JComboBox)object;
        this.setControl(jComboBox);
        if (object2 != jComboBox) {
            this.init(jComboBox);
            this.refreshControl();
        }
        return this.getModelImpl(jComboBox);
    }

    public void refreshControl() {
        AttributeDef[] attributeDefArray = this.getDisplayAttributeDefs();
        if (attributeDefArray != null) {
            ListCellRenderer listCellRenderer = this.mCellRenderer;
            ComboBoxEditor comboBoxEditor = this.mEditor;
            JComboBox jComboBox = (JComboBox)this.getControl();
            ComboBoxEditor comboBoxEditor2 = jComboBox.getEditor();
            if (comboBoxEditor != null && comboBoxEditor2 != comboBoxEditor) {
                comboBoxEditor = null;
            }
            if (!this.isSingleAttrList() && attributeDefArray.length > 0) {
                if (listCellRenderer == null) {
                    listCellRenderer = new JUMultiAttrListCellRenderer(attributeDefArray);
                }
                if (comboBoxEditor == null) {
                    comboBoxEditor = new JUMultiAttrListEditor(this, attributeDefArray[0].getIndex());
                }
            }
            if (jComboBox != null) {
                if (listCellRenderer != null) {
                    jComboBox.setRenderer(listCellRenderer);
                }
                if (comboBoxEditor != null) {
                    jComboBox.setEditor(comboBoxEditor);
                    this.mEditor = comboBoxEditor;
                }
            }
        }
        if (this.getIteratorBinding() == null && this.mListIterBinding != null) {
            this.mListIterBinding.getRowSetIterator().addListener((Object)this);
        }
        super.refreshControl();
    }

    public static MutableComboBoxModel createEnumerationBinding(JUFormBinding jUFormBinding, JComboBox jComboBox, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (!JUIUtil.inDesignTime()) {
            JUComboBoxBinding jUComboBoxBinding = new JUComboBoxBinding(jComboBox, jUFormBinding.getRowIterBinding(string, string2, string3), new String[]{string4}, objectArray);
            jUComboBoxBinding.refreshControl();
            return jUComboBoxBinding.getModelImpl(null);
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(string).append(".").append(string4);
            Object[] objectArray2 = new Object[]{stringBuffer.toString(), objectArray};
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJEnumComboBoxBinding");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 2) {
                    Object obj = constructor.newInstance(objectArray2);
                    MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)obj;
                    return mutableComboBoxModel;
                }
                ++n;
            }
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
        catch (Exception exception) {
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
    }

    public static MutableComboBoxModel getInstance(JUFormBinding jUFormBinding, JComboBox jComboBox, String string, String string2, String string3, String string4, Object[] objectArray) {
        return JUComboBoxBinding.createEnumerationBinding(jUFormBinding, jComboBox, string, string2, string3, string4, objectArray);
    }

    public static MutableComboBoxModel createLovBinding(JUFormBinding jUFormBinding, JComboBox jComboBox, String string, String string2, String string3, String[] stringArray, String string4, String[] stringArray2, String[] stringArray3, ListCellRenderer listCellRenderer, ComboBoxEditor comboBoxEditor) {
        if (!JUIUtil.inDesignTime()) {
            JUIteratorBinding jUIteratorBinding = string != null ? jUFormBinding.getRowIterBinding(string, string2, string3) : null;
            JUIteratorBinding jUIteratorBinding2 = string4 != null ? jUFormBinding.getRangeIterBinding(string4, null, null, -1) : null;
            JUComboBoxBinding jUComboBoxBinding = new JUComboBoxBinding(jComboBox, jUIteratorBinding, stringArray, jUIteratorBinding2, stringArray2, stringArray3);
            jUComboBoxBinding.mCellRenderer = listCellRenderer;
            jUComboBoxBinding.mEditor = comboBoxEditor;
            jUComboBoxBinding.refreshControl();
            return jUComboBoxBinding.getModelImpl(null);
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJLovBindingDef");
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] objectArray = new Object[]{string4, stringArray3, string, stringArray2, stringArray};
            Class<?> clazz2 = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJComboBoxBinding");
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                Constructor<?> constructor2 = constructorArray[n];
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length == 1) {
                    Object[] objectArray2 = new Object[]{constructor.newInstance(objectArray)};
                    Object obj = constructor2.newInstance(objectArray2);
                    MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)obj;
                    return mutableComboBoxModel;
                }
                ++n;
            }
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
        catch (Exception exception) {
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
    }

    public static MutableComboBoxModel createNavigationBinding(JUFormBinding jUFormBinding, JComboBox jComboBox, String string, String string2, String string3, String[] stringArray, ListCellRenderer listCellRenderer, ComboBoxEditor comboBoxEditor) {
        if (!JUIUtil.inDesignTime()) {
            JUIteratorBinding jUIteratorBinding = jUFormBinding.getRowIterBinding(string, string2, string3);
            JUComboBoxBinding jUComboBoxBinding = new JUComboBoxBinding(jComboBox, jUIteratorBinding, stringArray, JUCtrlListBinding.LIST_OPER_NAVIGATE);
            jUComboBoxBinding.mCellRenderer = listCellRenderer;
            jUComboBoxBinding.mEditor = comboBoxEditor;
            jUComboBoxBinding.refreshControl();
            return jUComboBoxBinding.getModelImpl(null);
        }
        try {
            Class<?> clazz = Class.forName("oracle.jbo.dt.ui.jui.propertyeditors.dtmodels.DTJComboBoxNavigationBinding");
            String string4 = "";
            if (stringArray != null && stringArray.length != 0) {
                string4 = stringArray[0];
            }
            int n = stringArray == null ? 0 : stringArray.length;
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append(",");
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            Object[] objectArray = new Object[]{string + "." + stringBuffer.toString()};
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n3 = 0;
            while (n3 < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n3];
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length == 1) {
                    Object obj = constructor.newInstance(objectArray);
                    MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)obj;
                    return mutableComboBoxModel;
                }
                ++n3;
            }
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
        catch (Exception exception) {
            MutableComboBoxModel mutableComboBoxModel = null;
            return mutableComboBoxModel;
        }
    }

    public static MutableComboBoxModel getInstance(JUFormBinding jUFormBinding, JComboBox jComboBox, String string, String string2, String string3, String[] stringArray, String string4, String[] stringArray2, String[] stringArray3, ListCellRenderer listCellRenderer, ComboBoxEditor comboBoxEditor) {
        return JUComboBoxBinding.createLovBinding(jUFormBinding, jComboBox, string, string2, string3, stringArray, string4, stringArray2, stringArray3, listCellRenderer, comboBoxEditor);
    }

    public void release(int n) {
        JComboBox jComboBox;
        if ((n < 0 || (n & DCDataControl.REL_ALL_REFS) > 0 || (n & DCDataControl.REL_VIEW_REFS) > 0) && (jComboBox = (JComboBox)this.getControl()) != null) {
            jComboBox.removeActionListener(this);
            this.mComboModel = null;
        }
        super.release(n);
    }

    public List getDisplayData() {
        if (this.mValueList == null) {
            super.setupListItems(true, true);
        }
        return super.getDisplayData();
    }

    public class 1mRunnable
    implements Runnable {
        JUComboBoxBinding comboBinding;
        int index;
        boolean clean;

        1mRunnable(JUComboBoxBinding jUComboBoxBinding2, boolean bl, int n) {
            this.comboBinding = jUComboBoxBinding2;
            this.index = n;
            this.clean = bl;
        }

        public void run() {
            Object[] objectArray;
            JComboBox jComboBox = (JComboBox)JUComboBoxBinding.this.getControl();
            if (jComboBox != null) {
                jComboBox.removeActionListener(this.comboBinding);
                if (this.clean && jComboBox.getItemCount() > 0) {
                    jComboBox.removeAllItems();
                }
            }
            int n = (objectArray = JUComboBoxBinding.this.getValueList()) != null ? objectArray.length : 0;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object != null) {
                    JUComboBoxBinding.this.mComboModel.addElement(objectArray[n2]);
                }
                ++n2;
            }
            if (jComboBox != null) {
                if (n > 0) {
                    Row row;
                    if (this.index >= n) {
                        this.index = 0;
                    }
                    if (JUComboBoxBinding.this.getIteratorBinding() != null && (row = JUComboBoxBinding.this.getCurrentRow()) != null) {
                        JUComboBoxBinding.this.updateValuesFromRow(row);
                        this.index = -1;
                    }
                    if (this.index >= 0) {
                        jComboBox.setSelectedIndex(this.index);
                    }
                }
                jComboBox.addActionListener(this.comboBinding);
            }
        }
    }
}

