/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pool;

import java.io.PrintWriter;
import java.util.Date;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.StringManager;
import oracle.jbo.pool.AgeHistogram;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolListener;
import oracle.jbo.pool.ResourcePoolStatistics;

public class ResourcePoolLogger
implements ResourcePoolListener {
    private ResourcePoolStatistics mStatistics;
    private long mAvgNumOfAvailableInstancesAccum;
    private long mAvgNumOfUnavailableInstancesAccum;
    private long mAvgNumOfInstancesAccum;
    private long mAvgCounter;
    private final ResourcePool mPool;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mStatistics = new ResourcePoolStatistics();
        this.mAvgNumOfAvailableInstancesAccum = 0L;
        this.mAvgNumOfUnavailableInstancesAccum = 0L;
        this.mAvgNumOfInstancesAccum = 0L;
        this.mAvgCounter = 0L;
    }

    public ResourcePoolLogger(ResourcePool resourcePool) {
        this.$init$();
        this.mPool = resourcePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(byte by) {
        Object object = this.mPool.getSyncLock();
        synchronized (object) {
            switch (by) {
                case 0: {
                    ++this.getStatisticsHolder().mNumOfInstanceCreations;
                    long l = this.mPool.getResourceCount();
                    if (l <= this.getStatisticsHolder().mMaxNumOfInstances) break;
                    this.getStatisticsHolder().mMaxNumOfInstances = l;
                    break;
                }
                case 1: {
                    ++this.getStatisticsHolder().mNumOfInstanceRemovals;
                    break;
                }
                case 2: {
                    ++this.getStatisticsHolder().mNumOfCheckins;
                    this.calculateAverages(false);
                    break;
                }
                case 3: {
                    ++this.getStatisticsHolder().mNumOfCheckouts;
                    this.calculateAverages(false);
                    break;
                }
                case 9: {
                    ++this.getStatisticsHolder().mNumOfCheckoutFailures;
                }
            }
        }
    }

    protected ResourcePoolStatistics getStatisticsHolder() {
        return this.mStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourcePoolStatistics getResourcePoolStatistics() {
        Object var1_1 = null;
        ResourcePoolStatistics resourcePoolStatistics = null;
        Object object = this.mPool.getSyncLock();
        synchronized (object) {
            ResourcePoolStatistics resourcePoolStatistics2 = this.getStatisticsHolder();
            resourcePoolStatistics2.mResourceCount = this.mPool.getResourceCount();
            resourcePoolStatistics2.mAvailableResourceCount = this.mPool.getAvailableResourceCount();
            this.calculateAverages(true);
            resourcePoolStatistics = (ResourcePoolStatistics)resourcePoolStatistics2.clone();
        }
        this.computeResourceAgeHistogram(resourcePoolStatistics);
        return resourcePoolStatistics;
    }

    protected void computeResourceAgeHistogram(ResourcePoolStatistics resourcePoolStatistics) {
        long l = System.currentTimeMillis();
        Date[] dateArray = new Date[]{new Date(l - 60000L), new Date(l - 300000L), new Date(l - 600000L)};
        resourcePoolStatistics.mResourceAgeHistogram = new AgeHistogram(dateArray);
        this.mPool.computeResourceAgeHistogram(resourcePoolStatistics.mResourceAgeHistogram);
    }

    public void dumpPoolStatistics(PrintWriter printWriter) {
        ResourcePoolStatistics resourcePoolStatistics = this.getResourcePoolStatistics();
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printHeaderLine("10012", clazz, printWriter);
        Class clazz2 = class$oracle$jbo$CSMessageBundle;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10000", clazz2, (Object[])null, resourcePoolStatistics.mNumOfInstanceCreations, printWriter);
        Class clazz3 = class$oracle$jbo$CSMessageBundle;
        if (clazz3 == null) {
            clazz3 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10001", clazz3, (Object[])null, resourcePoolStatistics.mNumOfInstanceRemovals, printWriter);
        Class clazz4 = class$oracle$jbo$CSMessageBundle;
        if (clazz4 == null) {
            clazz4 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printHeaderLine("10013", clazz4, printWriter);
        Class clazz5 = class$oracle$jbo$CSMessageBundle;
        if (clazz5 == null) {
            clazz5 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10002", clazz5, (Object[])null, resourcePoolStatistics.mNumOfCheckouts, printWriter);
        Class clazz6 = class$oracle$jbo$CSMessageBundle;
        if (clazz6 == null) {
            clazz6 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10003", clazz6, (Object[])null, resourcePoolStatistics.mNumOfCheckins, printWriter);
        Class clazz7 = class$oracle$jbo$CSMessageBundle;
        if (clazz7 == null) {
            clazz7 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10016", clazz7, (Object[])null, resourcePoolStatistics.mNumOfCheckoutFailures, printWriter);
        Class clazz8 = class$oracle$jbo$CSMessageBundle;
        if (clazz8 == null) {
            clazz8 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printHeaderLine("10014", clazz8, printWriter);
        Class clazz9 = class$oracle$jbo$CSMessageBundle;
        if (clazz9 == null) {
            clazz9 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10004", clazz9, (Object[])null, resourcePoolStatistics.mResourceCount, printWriter);
        Class clazz10 = class$oracle$jbo$CSMessageBundle;
        if (clazz10 == null) {
            clazz10 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10005", clazz10, (Object[])null, resourcePoolStatistics.mMaxNumOfInstances, printWriter);
        Class clazz11 = class$oracle$jbo$CSMessageBundle;
        if (clazz11 == null) {
            clazz11 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10006", clazz11, (Object[])null, resourcePoolStatistics.mAvgNumOfInstances, printWriter);
        Class clazz12 = class$oracle$jbo$CSMessageBundle;
        if (clazz12 == null) {
            clazz12 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10007", clazz12, (Object[])null, resourcePoolStatistics.mAvailableResourceCount, printWriter);
        Class clazz13 = class$oracle$jbo$CSMessageBundle;
        if (clazz13 == null) {
            clazz13 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10008", clazz13, (Object[])null, resourcePoolStatistics.mAvgNumOfAvailableInstances, printWriter);
        Class clazz14 = class$oracle$jbo$CSMessageBundle;
        if (clazz14 == null) {
            clazz14 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10009", clazz14, (Object[])null, resourcePoolStatistics.mAvgNumOfUnavailableInstances, printWriter);
        Class clazz15 = class$oracle$jbo$CSMessageBundle;
        if (clazz15 == null) {
            clazz15 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printHeaderLine("10015", clazz15, printWriter);
        Class clazz16 = class$oracle$jbo$CSMessageBundle;
        if (clazz16 == null) {
            clazz16 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10010", clazz16, (Object[])new String[]{"10"}, resourcePoolStatistics.mResourceAgeHistogram.mBuckets[3], printWriter);
        Class clazz17 = class$oracle$jbo$CSMessageBundle;
        if (clazz17 == null) {
            clazz17 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10010", clazz17, (Object[])new String[]{"5"}, resourcePoolStatistics.mResourceAgeHistogram.mBuckets[2], printWriter);
        Class clazz18 = class$oracle$jbo$CSMessageBundle;
        if (clazz18 == null) {
            clazz18 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10010", clazz18, (Object[])new String[]{"1"}, resourcePoolStatistics.mResourceAgeHistogram.mBuckets[1], printWriter);
        Class clazz19 = class$oracle$jbo$CSMessageBundle;
        if (clazz19 == null) {
            clazz19 = class$oracle$jbo$CSMessageBundle = ResourcePoolLogger.class$("oracle.jbo.CSMessageBundle");
        }
        this.printStatisticLine("10011", clazz19, (Object[])new String[]{"1"}, resourcePoolStatistics.mResourceAgeHistogram.mBuckets[0], printWriter);
    }

    protected void calculateAverages(boolean bl) {
        ResourcePoolStatistics resourcePoolStatistics = this.getStatisticsHolder();
        if (bl || (resourcePoolStatistics.mNumOfCheckouts + resourcePoolStatistics.mNumOfCheckins) % (long)100 == 0L) {
            ++this.mAvgCounter;
            resourcePoolStatistics.mAvgNumOfAvailableInstances = (this.mAvgNumOfAvailableInstancesAccum += (long)this.mPool.getAvailableResourceCount()) / this.mAvgCounter;
            resourcePoolStatistics.mAvgNumOfUnavailableInstances = (this.mAvgNumOfUnavailableInstancesAccum += (long)(this.mPool.getResourceCount() - this.mPool.getAvailableResourceCount())) / this.mAvgCounter;
            resourcePoolStatistics.mAvgNumOfInstances = (this.mAvgNumOfInstancesAccum += (long)this.mPool.getResourceCount()) / this.mAvgCounter;
        }
    }

    protected void printHeaderLine(String string, Class clazz, PrintWriter printWriter) {
        String string2 = StringManager.getLocalizedString(clazz.getName(), string, null, null, null);
        StringBuffer stringBuffer = new StringBuffer("head:").append(string2);
        printWriter.println(stringBuffer.toString());
    }

    protected void printStatisticLine(String string, Class clazz, Object[] objectArray, float f, PrintWriter printWriter) {
        String string2 = StringManager.getLocalizedString(clazz.getName(), string, null, null, objectArray);
        StringBuffer stringBuffer = new StringBuffer(string2).append(JboEnvUtil.IAS_EM_DIAGNOSTIC_DELIM).append(f);
        printWriter.println(stringBuffer.toString());
    }

    protected void printStatisticLine(String string, Class clazz, Object[] objectArray, long l, PrintWriter printWriter) {
        String string2 = StringManager.getLocalizedString(clazz.getName(), string, null, null, objectArray);
        StringBuffer stringBuffer = new StringBuffer(string2).append(JboEnvUtil.IAS_EM_DIAGNOSTIC_DELIM).append(l);
        printWriter.println(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

