/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom.xml;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.NodeDefNode;
import oracle.jbo.mom.xml.WrapperDefElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementDefElement
extends WrapperDefElement {
    private Element _element;

    public ElementDefElement(Element element) {
        this._element = element;
    }

    public static final DefElement normalize(Object object) {
        if (object instanceof DefElement) {
            return (DefElement)object;
        }
        return new ElementDefElement((Element)object);
    }

    public String getLocalName() {
        return this._element.getLocalName();
    }

    public String getNamespaceURI() {
        return this._element.getNamespaceURI();
    }

    public String getNodeName() {
        return this._element.getNodeName();
    }

    public ArrayList getChildrenList(short[] sArray, String string) {
        ArrayList arrayList = new ArrayList();
        NodeList nodeList = this._element.getChildNodes();
        if (nodeList == null) {
            return arrayList;
        }
        int n = ~WrapperDefElement.getBitmaskOfNodeTypes(sArray);
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            if ((1 << node.getNodeType() & n) == 0 && (string == null || string.equalsIgnoreCase(node.getNodeName()))) {
                arrayList.add((Object)NodeDefNode.normalize(node));
            }
            ++n3;
        }
        return arrayList;
    }

    public ArrayList getSimilarChildrenList(String string) {
        ArrayList arrayList = new ArrayList();
        NodeList nodeList = this._element.getChildNodes();
        if (nodeList == null) {
            return arrayList;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && node.getNodeName().indexOf(string) > -1) {
                arrayList.add((Object)ElementDefElement.normalize(node));
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList getAttrsList() {
        ArrayList arrayList = new ArrayList();
        NamedNodeMap namedNodeMap = this._element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add((Object)ElementDefElement.normalize(namedNodeMap.item(n2)));
            ++n2;
        }
        return arrayList;
    }

    public String readUserNodeValue(String string) {
        String string2 = this._element.getNodeValue();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public String getAttribute(String string) {
        return this._element.getAttribute(string);
    }

    public void setAttribute(String string, String string2) {
        this._element.setAttribute(string, string2);
    }

    public void removeAttribute(String string) {
        this._element.removeAttribute(string);
    }

    public NamedNodeMap getAttributes() {
        return this._element.getAttributes();
    }

    public NodeList getChildNodes() {
        return this._element.getChildNodes();
    }

    public NodeList getChildrenByTagName(String string) {
        return this._element.getElementsByTagName(string);
    }

    public NodeList getChildrenByTagName(String string, String string2) {
        return this._element.getElementsByTagNameNS(string, string2);
    }

    public Document getOwnerDocument() {
        return this._element.getOwnerDocument();
    }

    protected DefElement getFirstChildByTagName(String string) {
        ArrayList arrayList = this.getChildrenByTagNameNoMutate(string);
        if (arrayList.size() > 0) {
            return ElementDefElement.normalize(arrayList.get(0));
        }
        return null;
    }

    protected DefElement getFirstElementByTagName(String string) {
        NodeList nodeList = this._element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            return ElementDefElement.normalize(nodeList.item(0));
        }
        return null;
    }

    private ArrayList getChildrenByTagNameNoMutate(String string) {
        ArrayList arrayList = new ArrayList();
        String string2 = string.intern();
        NodeList nodeList = this._element.getChildNodes();
        int n = nodeList.getLength();
        boolean bl = string.equals("*");
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (bl || node.getNodeName() == string2) {
                arrayList.add((Object)node);
            }
            ++n2;
        }
        return arrayList;
    }
}

