/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import com.sun.java.util.collections.Map;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.mom.DefinitionContext;
import oracle.jbo.mom.DefinitionContextStandard;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.DefinitionMgrListener;
import oracle.jbo.mom.DefinitionObjectInfo;
import oracle.jbo.mom.MOMParser;

public class DefinitionContextAgeable
extends DefinitionContextStandard
implements DefinitionMgrListener {
    private DefinitionMgrListener mListener;
    private int mRetiredCount;
    private DefinitionObjectInfo mFirstAgeable;
    private DefinitionObjectInfo mLastAgeable;
    private DefinitionObjectInfo mFirstRetired;

    private /* synthetic */ void $init$() {
        this.mRetiredCount = 0;
        this.mFirstAgeable = null;
        this.mLastAgeable = null;
        this.mFirstRetired = null;
    }

    DefinitionContextAgeable(DefinitionManager definitionManager, MOMParser mOMParser, DefinitionMgrListener definitionMgrListener) {
        super(definitionManager, mOMParser);
        this.$init$();
        this.mListener = definitionMgrListener != null ? definitionMgrListener : this;
    }

    synchronized int getActiveCount() {
        return this.getDefinitionMap().size() - this.mRetiredCount;
    }

    synchronized int getRetiredCount() {
        return this.mRetiredCount;
    }

    synchronized int adjustRetiredCount(int n) {
        this.mRetiredCount += n;
        return this.mRetiredCount;
    }

    synchronized DefinitionObjectInfo getFirstAgeable() {
        return this.mFirstAgeable;
    }

    synchronized DefinitionObjectInfo getLastAgeable() {
        return this.mLastAgeable;
    }

    public synchronized void retireLeastRecentlyUsed(int n) {
        if (n == 0) {
            return;
        }
        DefinitionObjectInfo definitionObjectInfo = this.mFirstRetired == null ? (this.mFirstRetired = this.mLastAgeable) : this.mFirstRetired.getPrev();
        int n2 = 0;
        while ((n == -1 || n2 < n) && definitionObjectInfo != null) {
            definitionObjectInfo.retire();
            this.adjustRetiredCount(1);
            this.mFirstRetired = definitionObjectInfo;
            definitionObjectInfo = definitionObjectInfo.getPrev();
            ++n2;
        }
    }

    private void updateDefObjUse(String string, DefinitionObjectInfo definitionObjectInfo) {
        definitionObjectInfo.setLastAccessTime();
        if (definitionObjectInfo.isAgeable()) {
            if (definitionObjectInfo.isRetired()) {
                definitionObjectInfo.unretire();
                if (this.mFirstRetired == definitionObjectInfo) {
                    this.mFirstRetired = definitionObjectInfo.getNext();
                }
                this.adjustRetiredCount(-1);
            }
            if (this.mFirstAgeable != definitionObjectInfo) {
                DefinitionObjectInfo definitionObjectInfo2 = definitionObjectInfo.getNext();
                DefinitionObjectInfo definitionObjectInfo3 = definitionObjectInfo.getPrev();
                if (definitionObjectInfo3 != null) {
                    definitionObjectInfo3.setNext(definitionObjectInfo2);
                }
                if (this.mLastAgeable == null) {
                    this.mLastAgeable = definitionObjectInfo;
                } else if (this.mLastAgeable == definitionObjectInfo) {
                    this.mLastAgeable = definitionObjectInfo3;
                }
                if (definitionObjectInfo2 != null) {
                    definitionObjectInfo2.setPrev(definitionObjectInfo3);
                }
                definitionObjectInfo.setNext(this.mFirstAgeable);
                if (this.mFirstAgeable != null) {
                    this.mFirstAgeable.setPrev(definitionObjectInfo);
                }
                this.mFirstAgeable = definitionObjectInfo;
                definitionObjectInfo.setPrev(null);
            }
            this.mListener.objectUseUpdated(this.getManager(), this, string, definitionObjectInfo);
        }
    }

    private void removeDefObjUse(DefinitionObjectInfo definitionObjectInfo) {
        if (definitionObjectInfo.isAgeable()) {
            DefinitionObjectInfo definitionObjectInfo2 = definitionObjectInfo.getNext();
            DefinitionObjectInfo definitionObjectInfo3 = definitionObjectInfo.getPrev();
            if (definitionObjectInfo.isRetired()) {
                if (this.mFirstRetired == definitionObjectInfo) {
                    this.mFirstRetired = definitionObjectInfo2;
                }
                this.adjustRetiredCount(-1);
            }
            if (definitionObjectInfo3 != null) {
                definitionObjectInfo3.setNext(definitionObjectInfo2);
            }
            if (definitionObjectInfo2 != null) {
                definitionObjectInfo2.setPrev(definitionObjectInfo3);
            }
            if (this.mFirstAgeable == definitionObjectInfo) {
                this.mFirstAgeable = definitionObjectInfo2;
            }
            if (this.mLastAgeable == definitionObjectInfo) {
                this.mLastAgeable = definitionObjectInfo3;
            }
        }
    }

    synchronized void insertDefObj(String string, Object object, boolean bl) {
        DefinitionObjectInfo definitionObjectInfo = new DefinitionObjectInfo(string, object, bl, false);
        DefinitionObjectInfo definitionObjectInfo2 = (DefinitionObjectInfo)this.getDefinitionMap().put((Object)string, (Object)definitionObjectInfo);
        if (definitionObjectInfo2 != null) {
            this.removeDefObjUse(definitionObjectInfo2);
        }
        this.updateDefObjUse("insert", definitionObjectInfo);
    }

    synchronized Object removeDefObj(String string) {
        Object object = null;
        DefinitionObjectInfo definitionObjectInfo = (DefinitionObjectInfo)this.getDefinitionMap().remove((Object)string);
        if (definitionObjectInfo != null) {
            this.removeDefObjUse(definitionObjectInfo);
            object = definitionObjectInfo.getDefinitionObject();
        }
        return object;
    }

    synchronized Object findDefObj(String string) {
        Object object = null;
        DefinitionObjectInfo definitionObjectInfo = (DefinitionObjectInfo)this.getDefinitionMap().get((Object)string);
        if (definitionObjectInfo != null) {
            this.updateDefObjUse("find", definitionObjectInfo);
            object = definitionObjectInfo.getDefinitionObject();
        }
        return object;
    }

    synchronized void purgeCache() {
        super.purgeCache();
        this.mRetiredCount = 0;
        this.mFirstAgeable = null;
        this.mLastAgeable = null;
        this.mFirstRetired = null;
    }

    synchronized void dumpMOM(Writer writer, boolean bl) {
        Map map = this.getDefinitionMap();
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("-- " + this.getClass().getName() + ".dumpMOM --");
        if (map != null && map.size() != 0) {
            Object[] objectArray = map.keySet().toArray();
            Arrays.sort(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                Object object2 = map.get(object);
                if (object2 instanceof DefinitionObjectInfo) {
                    this.mListener.dumpDefObjInfo(this.getManager(), n, object, (DefinitionObjectInfo)object2, false, printWriter);
                }
                ++n;
            }
        }
        if (bl) {
            printWriter.println("");
            printWriter.println("Use chain, going foward");
            int n = 0;
            DefinitionObjectInfo definitionObjectInfo = null;
            DefinitionObjectInfo definitionObjectInfo2 = this.getFirstAgeable();
            while (definitionObjectInfo2 != null) {
                Diagnostic.ASSERT(definitionObjectInfo2.getPrev() == definitionObjectInfo, "Previous/next pointer bad");
                this.mListener.dumpDefObjInfo(this.getManager(), n, definitionObjectInfo2.getName(), definitionObjectInfo2, true, printWriter);
                ++n;
                definitionObjectInfo = definitionObjectInfo2;
                definitionObjectInfo2 = definitionObjectInfo2.getNext();
            }
            Diagnostic.ASSERT(definitionObjectInfo.getNext() == null, "Next pointer for last entry not null");
            Diagnostic.ASSERT(this.getLastAgeable() == definitionObjectInfo, "Last pointer does not match");
        }
    }

    public void objectUseUpdated(DefinitionManager definitionManager, DefinitionContext definitionContext, String string, DefinitionObjectInfo definitionObjectInfo) {
    }

    public void dumpDefObjInfo(DefinitionManager definitionManager, int n, Object object, DefinitionObjectInfo definitionObjectInfo, boolean bl, PrintWriter printWriter) {
        definitionManager.dumpDefObjInfo(n, object, definitionObjectInfo, bl, printWriter);
    }
}

