/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import oracle.jbo.AttributeList;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ViewCriteria;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.ws.WSAMComponent;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;

public abstract class WSRowSetIteratorBase
extends WSAMComponent
implements Serializable,
RowSetIterator {
    protected String mName;
    protected transient ArrayList mListeners;
    protected transient ArrayList mMgmtListeners;

    WSRowSetIteratorBase(String string) {
        if (string == null || string.length() == 0) {
            string = JboNameUtil.getLastPartOfName(this.getClass().getName()) + System.currentTimeMillis();
        }
        this.mName = string;
    }

    abstract RowSetIterator getRowSetIterator();

    public final boolean isConnected() {
        return this.getRowSetIterator() != null;
    }

    protected void registerWSListeners() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            if (this.mListeners != null) {
                int n = 0;
                while (n < this.mListeners.size()) {
                    rowSetIterator.addListener(this.mListeners.get(n));
                    ++n;
                }
            }
            this.mListeners = null;
            if (this.mMgmtListeners != null) {
                int n = 0;
                while (n < this.mMgmtListeners.size()) {
                    rowSetIterator.addManagementListener((RowSetManagementListener)this.mMgmtListeners.get(n));
                    ++n;
                }
            }
            this.mMgmtListeners = null;
        }
    }

    public final String getName() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getName();
        }
        return this.mName;
    }

    public final boolean isNameGenerated() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.isNameGenerated();
        }
        return this.mName == null;
    }

    public final Row[] getNextRangeSet() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getNextRangeSet();
        }
        this.invalidOperation("getNextRangeSet");
        return null;
    }

    public final Row[] getPreviousRangeSet() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getPreviousRangeSet();
        }
        this.invalidOperation("getPreviousRangeSet");
        return null;
    }

    public int getEstimatedRangePageCount() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getEstimatedRangePageCount();
        }
        this.invalidOperation("getEstimatedRangePageCount");
        return 1;
    }

    public int scrollToRangePage(int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.scrollToRangePage(n);
        }
        this.invalidOperation("scrollToRangePage");
        return -1;
    }

    public abstract RowSet getRowSet();

    public abstract RowSet[] getDetailRowSets();

    public abstract RowSet createDetailRowSet(String var1, String var2);

    public final void addManagementListener(RowSetManagementListener rowSetManagementListener) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.addManagementListener(rowSetManagementListener);
        } else {
            if (this.mMgmtListeners == null) {
                this.mMgmtListeners = new ArrayList(4);
            }
            if (!this.mMgmtListeners.contains(rowSetManagementListener)) {
                this.mMgmtListeners.add(rowSetManagementListener);
            }
        }
    }

    public final void removeManagementListener(RowSetManagementListener rowSetManagementListener) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.removeManagementListener(rowSetManagementListener);
        } else {
            if (this.mMgmtListeners != null && this.mMgmtListeners.contains(rowSetManagementListener)) {
                this.mMgmtListeners.remove(rowSetManagementListener);
            }
            if (this.mMgmtListeners.size() == 0) {
                this.mMgmtListeners = null;
            }
        }
    }

    public abstract void closeRowSetIterator();

    public abstract Object getSyncLock();

    public final void addListener(Object object) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.addListener(object);
        } else {
            if (this.mListeners == null) {
                this.mListeners = new ArrayList(4);
            }
            if (!this.mListeners.contains(object)) {
                this.mListeners.add(object);
            }
        }
    }

    public final void removeListener(Object object) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.removeListener(object);
        } else {
            if (this.mListeners != null && this.mListeners.contains(object)) {
                this.mListeners.remove(object);
            }
            if (this.mListeners.size() == 0) {
                this.mListeners = null;
            }
        }
    }

    public final Row next() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.next();
        }
        this.invalidOperation("next");
        return null;
    }

    public final Row previous() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.previous();
        }
        this.invalidOperation("previous");
        return null;
    }

    public final Row first() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.first();
        }
        this.invalidOperation("first");
        return null;
    }

    public final Row last() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.last();
        }
        this.invalidOperation("last");
        return null;
    }

    public final void reset() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.reset();
        }
    }

    public final boolean hasNext() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.hasNext();
        }
        this.invalidOperation("hasNext");
        return false;
    }

    public final boolean hasPrevious() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.hasPrevious();
        }
        this.invalidOperation("hasPrevious");
        return false;
    }

    public final int getFetchedRowCount() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getFetchedRowCount();
        }
        return 0;
    }

    public final int getRowCount() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getRowCount();
        }
        this.invalidOperation("getRowCount");
        return -1;
    }

    public final Row getRow(Key key) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getRow(key);
        }
        this.invalidOperation("getRow");
        return null;
    }

    public final Row getRowAtRangeIndex(int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getRowAtRangeIndex(n);
        }
        this.invalidOperation("getRow");
        return null;
    }

    public final Row getCurrentRow() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getCurrentRow();
        }
        return null;
    }

    public final int getCurrentRowIndex() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getCurrentRowIndex();
        }
        return -1;
    }

    public final int getCurrentRowSlot() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getCurrentRowSlot();
        }
        this.invalidOperation("getCurrentRowSlot");
        return 2;
    }

    public final boolean setCurrentRow(Row row) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.setCurrentRow(row);
        }
        this.invalidOperation("setCurrentRow");
        return false;
    }

    public final Row createAndInitRow(AttributeList attributeList) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.createAndInitRow(attributeList);
        }
        this.invalidOperation("createAndInitRow");
        return null;
    }

    public final Row createRow() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.createRow();
        }
        this.invalidOperation("createRow");
        return null;
    }

    public final void insertRow(Row row) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.insertRow(row);
        } else {
            this.invalidOperation("insertRow");
        }
    }

    public final void removeCurrentRow() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.removeCurrentRow();
        } else {
            this.invalidOperation("removeCurrentRow");
        }
    }

    public final void removeCurrentRowFromCollection() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.removeCurrentRowFromCollection();
        } else {
            this.invalidOperation("removeCurrentRowFromCollection");
        }
    }

    public final Row removeCurrentRowAndRetain() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.removeCurrentRowAndRetain();
        }
        this.invalidOperation("removeCurrentRowAndRetain");
        return null;
    }

    public abstract int setRangeSize(int var1);

    public abstract int getRangeSize();

    public abstract int getRangeStart();

    public abstract int setRangeStart(int var1);

    public abstract int scrollRange(int var1);

    public abstract int scrollRangeTo(Row var1, int var2);

    public final boolean setCurrentRowAtRangeIndex(int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.setCurrentRowAtRangeIndex(n);
        }
        this.invalidOperation("setCurrentRowAtRangeIndex");
        return false;
    }

    public final void insertRowAtRangeIndex(int n, Row row) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            rowSetIterator.insertRowAtRangeIndex(n, row);
        } else {
            this.invalidOperation("insertRowAtRangeIndex");
        }
    }

    public final int getRangeIndexOf(Row row) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getRangeIndexOf(row);
        }
        this.invalidOperation("getRangeIndexOf");
        return -1;
    }

    public final int getRowCountInRange() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getRowCountInRange();
        }
        this.invalidOperation("getRowCountInRange");
        return 0;
    }

    public final boolean isRangeAtBottom() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.isRangeAtBottom();
        }
        this.invalidOperation("isRangeAtBottom");
        return false;
    }

    public final boolean isRangeAtTop() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.isRangeAtTop();
        }
        this.invalidOperation("isRangeAtTop");
        return false;
    }

    public final Enumeration enumerateRowsInRange() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.enumerateRowsInRange();
        }
        this.invalidOperation("enumerateRowsInRange");
        return null;
    }

    public final Row[] getAllRowsInRange() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getAllRowsInRange();
        }
        this.invalidOperation("getAllRowsInRange");
        return null;
    }

    public final Row[] getFilteredRows(String string, Object object) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getFilteredRows(string, object);
        }
        this.invalidOperation("getFilteredRows");
        return null;
    }

    public final Row[] getFilteredRowsInRange(String string, Object object) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.getFilteredRowsInRange(string, object);
        }
        this.invalidOperation("getFilteredRowsInRange");
        return null;
    }

    public final Row[] findByKey(Key key, int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.findByKey(key, n);
        }
        this.invalidOperation("findByKey");
        return null;
    }

    public final RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.findByViewCriteria(viewCriteria, n, n2);
        }
        this.invalidOperation("findByViewCriteria");
        return null;
    }

    public final Key createKey(AttributeList attributeList) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.createKey(attributeList);
        }
        this.invalidOperation("createKey");
        return null;
    }

    public final Row[] findByEntity(int n, int n2) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            return rowSetIterator.findByEntity(n, n2);
        }
        this.invalidOperation("findByEntity");
        return null;
    }

    public abstract boolean isRowValidation();

    public abstract void setRowValidation(boolean var1);

    public abstract int getIterMode();

    public abstract void setIterMode(int var1);

    public final void findAndSetCurrentRowByKey(Key key, int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            ((WSRowSetIteratorMarshaller)((Object)rowSetIterator)).findAndSetCurrentRowByKey(key, n);
        }
    }
}

