/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.colo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.jbo.JboException;
import oracle.jbo.client.remote.AbstractAppModuleRequestHandler;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.common.AppModuleRequestHandler;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PiggybackInput;
import oracle.jbo.common.SvcMsgResponseException;
import oracle.jbo.common.colo.ExceptionMarshaller;
import oracle.svcmsg.ResponseValues;
import oracle.svcmsg.ServiceMessage;

public class ColoApplicationModuleImpl
extends AbstractAppModuleRequestHandler {
    private Method mCreateServantMethod;
    private AppModuleRequestHandler mReqHandler;
    private static /* synthetic */ Class class$oracle$svcmsg$ResponseValues;

    ColoApplicationModuleImpl(ApplicationModuleImpl applicationModuleImpl, AppModuleRequestHandler appModuleRequestHandler, ResponseValues responseValues) {
        super(applicationModuleImpl, responseValues);
        this.mReqHandler = appModuleRequestHandler;
    }

    public boolean isLocal() {
        return this.mReqHandler.isLocal();
    }

    public static ColoApplicationModuleImpl createClientApplicationModule(AppModuleRequestHandler appModuleRequestHandler) {
        ResponseValues responseValues = null;
        try {
            responseValues = appModuleRequestHandler.riGetApplicationModuleInfo();
        }
        catch (ExceptionMarshaller exceptionMarshaller) {
            Exception exception = ColoApplicationModuleImpl.getMarshalledException(exceptionMarshaller);
            if (exception instanceof JboException) {
                throw (JboException)exception;
            }
            throw new JboException(exception);
        }
        return ColoApplicationModuleImpl.createInstance(appModuleRequestHandler, responseValues);
    }

    public ServiceMessage doMessage(ServiceMessage serviceMessage) {
        try {
            ServiceMessage serviceMessage2 = this.mReqHandler.doMessage(serviceMessage);
            return serviceMessage2;
        }
        catch (ExceptionMarshaller exceptionMarshaller) {
            this.processRemoteJboException(exceptionMarshaller);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void riRemove() {
        if (this.mReqHandler != null) {
            AppModuleRequestHandler appModuleRequestHandler = this.mReqHandler;
            synchronized (appModuleRequestHandler) {
                if (this.mReqHandler != null && !this.isRemoved()) {
                    this.mReqHandler.riRemove();
                }
                this.mReqHandler = null;
            }
        }
    }

    public void processRemoteJboException(ExceptionMarshaller exceptionMarshaller) throws JboException {
        Exception exception = ColoApplicationModuleImpl.getMarshalledException(exceptionMarshaller);
        if (!(exception instanceof JboException)) {
            throw new JboException(exception);
        }
        this.processJboException((JboException)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = this.getApplicationModule().getSyncLock();
        synchronized (object) {
            this.riRemove();
        }
    }

    public boolean isMarshalledLocally() {
        return false;
    }

    private static Exception getMarshalledException(ExceptionMarshaller exceptionMarshaller) {
        PiggybackInput piggybackInput = new PiggybackInput(exceptionMarshaller.getStreamData());
        SvcMsgResponseException svcMsgResponseException = (SvcMsgResponseException)piggybackInput.getPiggybackEntries()[0];
        return (Exception)svcMsgResponseException.getDetail();
    }

    protected ResponseValues getAMFullRef(ResponseValues responseValues) {
        return responseValues;
    }

    protected ApplicationModuleImpl createProxyApplicationModule(ResponseValues responseValues) {
        if (this.mReqHandler == null) {
            throw new IllegalStateException();
        }
        this.loadServantMethods();
        try {
            AppModuleRequestHandler appModuleRequestHandler = (AppModuleRequestHandler)this.mCreateServantMethod.invoke((Object)this.mReqHandler, responseValues);
            Diagnostic.ASSERT(appModuleRequestHandler != null, "Null servant returned by createServant()");
            ApplicationModuleImpl applicationModuleImpl = ColoApplicationModuleImpl.createInstance(appModuleRequestHandler, responseValues).getApplicationModule();
            return applicationModuleImpl;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JboException) {
                throw (JboException)throwable;
            }
            throw new JboException(throwable);
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    private void loadServantMethods() {
        if (this.mCreateServantMethod == null) {
            try {
                Class<?> clazz = this.mReqHandler.getClass();
                Class[] classArray = new Class[1];
                Class clazz2 = class$oracle$svcmsg$ResponseValues;
                if (clazz2 == null) {
                    clazz2 = class$oracle$svcmsg$ResponseValues = ColoApplicationModuleImpl.class$("oracle.svcmsg.ResponseValues");
                }
                classArray[0] = clazz2;
                this.mCreateServantMethod = clazz.getMethod("createServant", classArray);
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
    }

    private static ColoApplicationModuleImpl createInstance(AppModuleRequestHandler appModuleRequestHandler, ResponseValues responseValues) {
        ApplicationModuleImpl applicationModuleImpl = ApplicationModuleImpl.createInstance(responseValues);
        return new ColoApplicationModuleImpl(applicationModuleImpl, appModuleRequestHandler, responseValues);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

