/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.Principal;
import java.security.Security;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.UserAznCallbackHandler;

public class UserAznUtil {
    static UserAznCallbackHandler handler = null;
    public static final String JAZN_LOGINMODULE = "oracle.security.jazn.realm.RealmLoginModule";
    static final String JAZN_CONFIG = "oracle.security.jazn.config";
    static final String JAZN_JAR = "jazn.jar";
    static final String JAZN_XML = "config/jazn.xml";
    static final String ADFS_JAZN_JAR = "adfs-jazn.jar";
    static final String LOGIN_CONFIG_PROVIDER = "login.configuration.provider";
    static final String JAZN_LOGIN_PROVIDER = "oracle.security.jazn.spi.LoginConfigProvider";
    public static final String LOGINCONTEXT = "javax.security.auth.login.LoginContext";
    static final String APPLICATION_JAZNCONFIG = "/META-INF/jazn.xml";
    static final String APPLICATION_CONFIG = "/META-INF/orion-application.xml";
    private static /* synthetic */ Class class$oracle$jbo$common$CommonMessageBundle;

    public static void authenticateUser(Hashtable hashtable) {
        if (JboEnvUtil.isAuthenticateUser(hashtable)) {
            String string = UserAznUtil.authenticate(hashtable);
            if (string == null && ADFContext.getCurrent().getSecurityContext().isAuthorizationEnabled()) {
                return;
            }
            if (string == null) {
                String string2 = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_ENFORCE.pName);
                if (string2 != null && "Test".equals(string2)) {
                    return;
                }
                Class clazz = class$oracle$jbo$common$CommonMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$CommonMessageBundle = UserAznUtil.class$("oracle.jbo.common.CommonMessageBundle");
                }
                throw new JboException(clazz, "33021", new Object[]{hashtable.get("java.naming.security.principal")});
            }
            hashtable.put(PropertyMetadata.USER_PRINCIPAL.pName, string);
            hashtable.put("jbo.security.authorized", "true");
        }
    }

    public static String authenticate(Hashtable hashtable) {
        LoginContext loginContext = null;
        boolean bl = false;
        try {
            String string = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_LOGINMODULE.pName);
            if (string == null) {
                string = "oracle.security.jazn.tools.Admintool";
            }
            String string2 = (String)hashtable.get("jbo.security.config");
            if (string.equals("oracle.security.jazn.tools.Admintool") && (string2 == null || string2.length() == 0)) {
                string2 = UserAznUtil.findApplicationConfig(hashtable);
            }
            UserAznUtil.setLoginConfigSystemProperty(string, string2);
            UserAznUtil.setLoginConfigProvider(string);
            loginContext = (LoginContext)hashtable.get(LOGINCONTEXT);
            if (loginContext == null) {
                handler = new UserAznCallbackHandler();
                loginContext = new LoginContext(string, handler);
            }
            if (handler != null) {
                handler.setUsername((String)hashtable.get("java.naming.security.principal"));
                handler.setPassword((String)hashtable.get("java.naming.security.credentials"));
                if (string2 != null || string2.length() > 0) {
                    handler.setConfig(string2);
                }
            }
        }
        catch (LoginException loginException) {
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loginContext != null) {
            try {
                loginContext.login();
                bl = true;
            }
            catch (LoginException loginException) {
                Diagnostic.println("Authentication failed:");
                Diagnostic.println("  " + loginException.getMessage());
            }
        }
        String string = null;
        if (bl) {
            hashtable.put(LOGINCONTEXT, loginContext);
            Diagnostic.println("Authentication succeeded!");
            Subject subject = loginContext.getSubject();
            Iterator<Principal> iterator = subject.getPrincipals().iterator();
            String string3 = (String)hashtable.get("java.naming.security.principal");
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                string = principal.getName();
                int n = string.indexOf("/");
                if ((n <= 0 || !string3.regionMatches(0, string, n + 1, string3.length())) && !string3.equals(string)) continue;
                SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
                try {
                    securityContext.addToEnvironment("java.naming.security.principal", (Object)principal);
                    securityContext.addToEnvironment("jaas.subject", (Object)subject);
                }
                catch (NamingException namingException) {
                    namingException.printStackTrace();
                }
                break;
            }
        }
        return string;
    }

    static void setLoginConfigProvider(String string) {
        String string2 = Security.getProperty(LOGIN_CONFIG_PROVIDER);
        if (string2 == null || !string2.equals(JAZN_LOGIN_PROVIDER)) {
            Security.setProperty(LOGIN_CONFIG_PROVIDER, JAZN_LOGIN_PROVIDER);
        }
    }

    public static final void setLoginConfigSystemProperty(String string, String string2) {
        block8: {
            if (string.equals("oracle.security.jazn.tools.Admintool")) {
                if (string2 != null && string2.length() > 0) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(string2);
                        fileInputStream.close();
                        JboEnvUtil.setSystemProperty(JAZN_CONFIG, string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    Class<?> clazz = Class.forName(JAZN_LOGINMODULE);
                    ClassLoader classLoader = clazz.getClassLoader();
                    if (!(classLoader instanceof URLClassLoader)) break block8;
                    URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                    int n = 0;
                    while (n < uRLArray.length) {
                        String string3 = uRLArray[n].getFile();
                        if ((string3 = URLDecoder.decode(string3)).endsWith(JAZN_JAR) && !string3.endsWith(ADFS_JAZN_JAR)) {
                            int n2 = string3.indexOf(JAZN_JAR);
                            string2 = string3.substring(0, n2) + JAZN_XML;
                            JboEnvUtil.setSystemProperty(JAZN_CONFIG, string2);
                            break;
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static final String findJAZNConfig() {
        return null;
    }

    public static final String findApplicationConfig(Hashtable hashtable) {
        String string;
        if (hashtable != null && (string = (String)hashtable.get(PropertyMetadata.ENV_SECURITY_ENFORCE.pName)) != null && "Auth".equals(string)) {
            return null;
        }
        String string2 = APPLICATION_CONFIG;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            uRL = classLoader.getResource(string2.substring(1));
        }
        if (uRL == null && (uRL = classLoader.getResource(string2 = APPLICATION_JAZNCONFIG)) == null) {
            uRL = classLoader.getResource(string2.substring(1));
        }
        if (uRL != null) {
            String string3 = uRL.getPath();
            int n = string3.indexOf("!/");
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3.substring(0, n - 1));
                stringBuffer.append(string2);
                string3 = stringBuffer.toString();
            }
            return string3;
        }
        return null;
    }

    public static void logout(Hashtable hashtable) {
        LoginContext loginContext = (LoginContext)hashtable.get(LOGINCONTEXT);
        if (loginContext != null) {
            try {
                Subject subject = loginContext.getSubject();
                Iterator<Principal> iterator = subject.getPrincipals().iterator();
                while (iterator.hasNext()) {
                    Principal principal = iterator.next();
                }
                loginContext.logout();
                try {
                    ADFContext.getCurrent().getSecurityContext().removeFromEnvironment("java.naming.security.principal");
                }
                catch (Exception exception) {}
            }
            catch (LoginException loginException) {
                Diagnostic.println("Logout failed:");
                Diagnostic.println("  " + loginException.getMessage());
            }
            hashtable.remove(LOGINCONTEXT);
            hashtable.put("jbo.security.authorized", "false");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

