/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.JboWarning;
import oracle.jbo.common.JboExMsgCarrier;
import oracle.jbo.common.JboMessage;
import oracle.jbo.common.SvcMsgResponse;

public class SvcMsgResponseException
extends SvcMsgResponse {
    static final long serialVersionUID = 494258653277703791L;
    private Object mDetail;
    private int mSourceId;
    private boolean mIsForWorkingSet;
    private boolean mHasImplObject;

    private /* synthetic */ void $init$() {
        this.mSourceId = -1;
        this.mIsForWorkingSet = false;
        this.mHasImplObject = true;
    }

    public SvcMsgResponseException(String string, Exception exception, int n, boolean bl, boolean bl2) {
        this(string, exception, n);
        this.mIsForWorkingSet = bl;
        this.mHasImplObject = bl2;
    }

    public SvcMsgResponseException(String string, Exception exception, int n) {
        super(4337, string);
        this.$init$();
        this.mSourceId = n;
        this.mDetail = exception;
    }

    public SvcMsgResponseException(String string, Exception exception) {
        this(string, exception, -1);
    }

    public SvcMsgResponseException(String string, JboWarning jboWarning) {
        super(4337, string);
        this.$init$();
        this.mDetail = jboWarning;
    }

    public int getSourceId() {
        return this.mSourceId;
    }

    public Object getDetail() {
        return this.mDetail;
    }

    public boolean isForWorkingSet() {
        return this.mIsForWorkingSet;
    }

    public boolean hasImplObject() {
        return this.mHasImplObject;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.mSourceId);
        objectOutputStream.writeBoolean(this.mIsForWorkingSet);
        objectOutputStream.writeBoolean(this.mHasImplObject);
        if (this.mDetail instanceof JboMessage) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.mDetail);
        } else {
            objectOutputStream.writeBoolean(false);
            DetailInfo detailInfo = new DetailInfo();
            if (this.mDetail != null) {
                detailInfo.mClassName = this.mDetail.getClass().getName();
                if (this.mDetail instanceof Exception) {
                    detailInfo.mExcMsg = ((Exception)this.mDetail).getLocalizedMessage();
                }
            }
            objectOutputStream.writeObject(detailInfo);
            if (this.mDetail instanceof Serializable) {
                objectOutputStream.writeObject(this.mDetail);
            } else {
                objectOutputStream.writeObject(new DetailEndMarker(this.mDetail == null));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mSourceId = objectInputStream.readInt();
        this.mIsForWorkingSet = objectInputStream.readBoolean();
        this.mHasImplObject = objectInputStream.readBoolean();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.mDetail = objectInputStream.readObject();
        } else {
            Object object = null;
            DetailInfo detailInfo = (DetailInfo)objectInputStream.readObject();
            try {
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null && !(object instanceof DetailEndMarker)) {
                this.mDetail = object;
            } else if (object instanceof DetailEndMarker && ((DetailEndMarker)object).mIsNull) {
                this.mDetail = null;
            } else {
                String string = detailInfo.mClassName;
                String string2 = detailInfo.mExcMsg;
                this.mDetail = new JboExMsgCarrier(string2, string);
            }
        }
    }

    public class DetailInfo
    implements Serializable {
        String mClassName;
        String mExcMsg;

        DetailInfo() {
        }
    }

    public class DetailEndMarker
    implements Serializable {
        boolean mIsNull;

        DetailEndMarker(boolean bl) {
            this.mIsNull = bl;
        }
    }
}

