/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.Serializable;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;

public class Lock
implements Serializable {
    private static final long WAIT_TIME_INCREMENT = 1000L;
    private transient Thread mCurrentThread;
    private transient int mWaiters;
    private transient int mRefCount;
    private static /* synthetic */ Class class$oracle$jbo$common$CommonMessageBundle;

    private /* synthetic */ void $init$() {
        this.mCurrentThread = null;
        this.mWaiters = 0;
        this.mRefCount = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void lock(long l) {
        if (this.hasLock()) {
            ++this.mRefCount;
            return;
        }
        ++this.mWaiters;
        long l2 = l;
        while (this.mCurrentThread != null && (l < 0L || l >= 0L && l2 > 0L)) {
            if (l2 == l) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("WARNING:  The thread, ");
                stringBuffer.append(Thread.currentThread().getName());
                stringBuffer.append(", is waiting for a oracle.jbo.common.Lock");
                Diagnostic.println(stringBuffer.toString());
            }
            long l3 = 1000L;
            if (l >= 0L) {
                if (l2 < 1000L) {
                    l3 = l2;
                }
                l2 -= 1000L;
            }
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.mWaiters;
        if (this.mCurrentThread == null) {
            this.mCurrentThread = Thread.currentThread();
            ++this.mRefCount;
            return;
        }
        Class clazz = class$oracle$jbo$common$CommonMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$common$CommonMessageBundle = Lock.class$("oracle.jbo.common.CommonMessageBundle");
        }
        throw new JboException(clazz, "33022", new Object[]{Thread.currentThread().getName()});
    }

    public synchronized void unlock() {
        this.unlock(false);
    }

    public synchronized void unlock(boolean bl) {
        if (this.hasLock()) {
            --this.mRefCount;
            if (bl) {
                this.mRefCount = 0;
            }
            if (this.mRefCount == 0) {
                this.mCurrentThread = null;
                this.notifyAll();
            }
        } else {
            Class clazz = class$oracle$jbo$common$CommonMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$CommonMessageBundle = Lock.class$("oracle.jbo.common.CommonMessageBundle");
            }
            throw new JboException(clazz, "33023", new Object[]{Thread.currentThread().getName()});
        }
    }

    public synchronized void clearLock() {
        if (this.mWaiters > 0) {
            throw new RuntimeException("Lock timeout occured with threads waiting");
        }
        this.mCurrentThread = null;
        this.mRefCount = 0;
    }

    public synchronized boolean isLocked() {
        return this.mCurrentThread != null;
    }

    public synchronized boolean hasLock() {
        return Thread.currentThread().equals(this.mCurrentThread);
    }

    public Lock() {
        this.$init$();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

