/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import oracle.jbo.CustomClassNotFoundException;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboTypeMapEntries;
import oracle.jbo.common.JboTypeMapLock;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.domain.DataCreationException;

public class JboTypeMap {
    public static final String ARRAY = "Array";
    String mAttrType;
    String mColumnSchema;
    String mColumnType;
    String mSQLType;
    String mJavaType;
    int mSQLTypeId;
    String mSize;
    byte mTypeGroup;
    static ArrayList s_MapList = new ArrayList(1);
    static boolean s_IsPopulated = false;
    static Object s_Lock = new JboTypeMapLock();
    static Object s_FirstMap = null;
    static boolean is_FirstMapJboTypeMapEntry = false;
    public static byte DEFAULT = 0;
    public static byte CHAR = 1;
    public static byte NUMBER = (byte)2;
    public static byte DATE = (byte)3;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$common$JboTypeMapEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repopulateEntries(String string) {
        Object object = s_Lock;
        synchronized (object) {
            s_IsPopulated = false;
            JboTypeMap.populateEntries(string);
        }
    }

    public static ArrayList getMapList() {
        return s_MapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMapList(ArrayList arrayList) {
        Object object = s_Lock;
        synchronized (object) {
            s_MapList = arrayList;
            s_IsPopulated = true;
        }
    }

    public static void populateEntries() {
        JboTypeMap.populateEntries(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateEntries(String string) {
        if (s_IsPopulated) {
            return;
        }
        Object object = s_Lock;
        synchronized (object) {
            if (!s_IsPopulated) {
                String string2;
                if (string == null && (string2 = PropertyMetadata.PN_SQLTYPEMAP.getProperty()) != null && string2.length() > 0) {
                    string = string2;
                }
                s_MapList = new ArrayList(10);
                if (string == null || string.length() == 0 || string.equals("Oracle")) {
                    string = "oracle.jbo.common.OracleTypeMapEntries";
                } else if (string.equals("Java")) {
                    string = "oracle.jbo.common.JavaTypeMapEntries";
                } else if (string.equals("OLite")) {
                    string = "oracle.jbo.common.JavaTypeMapEntries";
                }
                try {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Loading Typemap entries from " + string);
                    }
                    Class clazz = JBOClass.forName(string);
                    s_FirstMap = clazz.newInstance();
                    Class clazz2 = class$oracle$jbo$common$JboTypeMapEntries;
                    if (clazz2 == null) {
                        clazz2 = class$oracle$jbo$common$JboTypeMapEntries = JboTypeMap.class$("oracle.jbo.common.JboTypeMapEntries");
                    }
                    is_FirstMapJboTypeMapEntry = clazz2.isInstance(s_FirstMap);
                }
                catch (Exception exception) {
                    Diagnostic.printStackTrace(exception);
                    throw new CustomClassNotFoundException(string, exception);
                }
                s_IsPopulated = true;
            }
        }
    }

    public static boolean isNumericType(int n) {
        return JboTypeMap.getTypeGroup(n) == NUMBER;
    }

    public static int getTypeGroup(int n) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findBySQLTypeId(n);
        return jboTypeMap != null ? jboTypeMap.mTypeGroup : (byte)0;
    }

    public static boolean isCharType(int n) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findBySQLTypeId(n);
        if (jboTypeMap == null) {
            return false;
        }
        if (jboTypeMap.mTypeGroup == CHAR) {
            return true;
        }
        int n2 = jboTypeMap.getSQLTypeId();
        return n2 == 1 || n2 == 12;
    }

    public static boolean isDateType(int n) {
        return JboTypeMap.getTypeGroup(n) == DATE;
    }

    public JboTypeMap(String string, String string2, String string3, int n, String string4, byte by) {
        this.init(string, string2, string3, n, string4, by);
    }

    public JboTypeMap(String string, String string2, String string3, int n, String string4, boolean bl) {
        this.init(string, string2, string3, n, string4, bl ? NUMBER : (string4 != null ? CHAR : DEFAULT));
    }

    public JboTypeMap(String string, String string2, String string3, int n, String string4) {
        this.init(string, string2, string3, n, string4, string4 != null ? CHAR : DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(String string, String string2, String string3, int n, String string4, byte by) {
        Object object = s_Lock;
        synchronized (object) {
            int n2 = -1;
            if (string != null) {
                n2 = string.indexOf(46);
            }
            if (n2 >= 0) {
                this.mColumnSchema = string.substring(0, n2);
                this.mColumnType = string.substring(n2 + 1);
            } else {
                this.mColumnSchema = null;
                this.mColumnType = string;
            }
            this.mSQLType = string3;
            this.mJavaType = string2;
            this.mSQLTypeId = n;
            this.mSize = string4;
            this.mTypeGroup = by;
            if (!s_IsPopulated) {
                s_MapList.add((Object)this);
            }
        }
    }

    public JboTypeMap(String string, String string2, String string3, String string4, int n, String string5) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = JboTypeMap.class$("oracle.jbo.CSMessageBundle");
        }
        throw new JboException(clazz, "25024", new Object[]{"JboTypeMap(Constructor)"});
    }

    public String getAttrType() {
        if (this.mAttrType == null && this.mJavaType != null) {
            int n = this.mJavaType.lastIndexOf(46);
            this.mAttrType = n > -1 ? this.mJavaType.substring(n + 1) : this.mJavaType;
        }
        return this.mAttrType;
    }

    String getColumnTypeBase() {
        if (this.mColumnSchema != null) {
            return this.mColumnSchema + '.' + this.mColumnType;
        }
        return this.mColumnType;
    }

    public String getSQLType() {
        return this.mSQLType;
    }

    public String getJavaType() {
        return this.mJavaType;
    }

    public int getSQLTypeId() {
        return this.mSQLTypeId;
    }

    public String getSize() {
        return this.mSize;
    }

    public String getColumnType() {
        String string = this.getColumnTypeBase();
        if (this.mSize != null) {
            string = string + this.mSize;
        }
        return string;
    }

    public boolean matchColumnType(String string) {
        int n = -1;
        String string2 = null;
        if (string != null) {
            n = string.indexOf(46);
        }
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (this.mColumnSchema == null) {
            return string.equals(this.mColumnType);
        }
        return this.mColumnSchema.equals(string2) && string.equals(this.mColumnType);
    }

    private static JboTypeMap findByAttrType(String string) {
        JboTypeMap.populateEntries();
        int n = 0;
        while (n < s_MapList.size()) {
            JboTypeMap jboTypeMap = (JboTypeMap)s_MapList.get(n);
            if (string.equals(jboTypeMap.getAttrType())) {
                return jboTypeMap;
            }
            ++n;
        }
        return null;
    }

    public static JboTypeMap findByColumnType(String string) {
        JboTypeMap.populateEntries();
        if (string != null) {
            JboTypeMap jboTypeMap;
            int n = string.indexOf(40);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            String string2 = string.toUpperCase();
            int n2 = 0;
            while (n2 < s_MapList.size()) {
                jboTypeMap = (JboTypeMap)s_MapList.get(n2);
                if (jboTypeMap.matchColumnType(string2)) {
                    return jboTypeMap;
                }
                ++n2;
            }
            n = string2.indexOf(46);
            if (n > 0) {
                string2 = string2.substring(n + 1);
                n2 = 0;
                while (n2 < s_MapList.size()) {
                    jboTypeMap = (JboTypeMap)s_MapList.get(n2);
                    if (jboTypeMap.matchColumnType(string2)) {
                        return jboTypeMap;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private static JboTypeMap findBySQLType(String string) {
        JboTypeMap.populateEntries();
        Object var1_1 = null;
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < s_MapList.size()) {
            JboTypeMap jboTypeMap = (JboTypeMap)s_MapList.get(n);
            if (string2.equals(jboTypeMap.getSQLType())) {
                return jboTypeMap;
            }
            ++n;
        }
        return new JboTypeMap(string, null, string, 0, null, false);
    }

    private static JboTypeMap findByJavaType(String string) {
        JboTypeMap.populateEntries();
        if (string != null) {
            int n = 0;
            while (n < s_MapList.size()) {
                JboTypeMap jboTypeMap = (JboTypeMap)s_MapList.get(n);
                if (string.equals(jboTypeMap.getJavaType())) {
                    return jboTypeMap;
                }
                ++n;
            }
        }
        return null;
    }

    private static JboTypeMap findBySQLTypeId(int n) {
        JboTypeMap.populateEntries();
        int n2 = 0;
        while (n2 < s_MapList.size()) {
            JboTypeMap jboTypeMap = (JboTypeMap)s_MapList.get(n2);
            if (n == jboTypeMap.getSQLTypeId()) {
                return jboTypeMap;
            }
            ++n2;
        }
        return null;
    }

    public static String columnTypeToAttrType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByColumnType(string);
        return jboTypeMap == null ? null : jboTypeMap.getAttrType();
    }

    public static String columnTypeToJavaType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByColumnType(string);
        return jboTypeMap == null ? null : jboTypeMap.getJavaType();
    }

    public static String columnTypeToSQLType(String string) {
        JboTypeMap jboTypeMap;
        JboTypeMap.populateEntries();
        if (string.startsWith("REF ") && string.length() > 4) {
            string = "REF";
        }
        return (jboTypeMap = JboTypeMap.findByColumnType(string)) == null ? null : jboTypeMap.getSQLType();
    }

    public static int columnTypeToSQLTypeId(String string, int n) {
        JboTypeMap jboTypeMap;
        JboTypeMap.populateEntries();
        if (string.startsWith("REF ") && string.length() > 4) {
            string = "REF";
        }
        return (jboTypeMap = JboTypeMap.findByColumnType(string)) == null ? n : jboTypeMap.getSQLTypeId();
    }

    public static String getDefaultColumnLength(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByColumnType(string);
        return jboTypeMap == null ? null : jboTypeMap.getSize();
    }

    public static String sqlTypeToColumnTypeBase(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findBySQLType(string);
        return jboTypeMap == null ? string : jboTypeMap.getColumnTypeBase();
    }

    public static int sqlTypeToSQLTypeId(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findBySQLType(string);
        return jboTypeMap == null ? 0 : jboTypeMap.getSQLTypeId();
    }

    public static String attrTypeToColumnType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByAttrType(string);
        return jboTypeMap == null ? null : jboTypeMap.getColumnType();
    }

    public static String attrTypeToJavaType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByAttrType(string);
        return jboTypeMap == null ? string : jboTypeMap.getJavaType();
    }

    public static String attrTypeToSQLType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByAttrType(string);
        return jboTypeMap == null ? string : jboTypeMap.getSQLType();
    }

    public static String javaTypeToAttrType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByJavaType(string);
        return jboTypeMap == null ? string : jboTypeMap.getAttrType();
    }

    public static String javaTypeToColumnType(String string) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findByJavaType(string);
        return jboTypeMap == null ? string : jboTypeMap.getColumnType();
    }

    public static String javaTypeToSQLType(String string) {
        JboTypeMap jboTypeMap = JboTypeMap.findByJavaType(string);
        return jboTypeMap == null ? null : jboTypeMap.getSQLType();
    }

    public static int javaTypeToSQLTypeId(String string) {
        JboTypeMap jboTypeMap = JboTypeMap.findByJavaType(string);
        return jboTypeMap == null ? 0 : jboTypeMap.getSQLTypeId();
    }

    public static String sqlTypeIdToSQLType(int n) {
        JboTypeMap.populateEntries();
        JboTypeMap jboTypeMap = JboTypeMap.findBySQLTypeId(n);
        return jboTypeMap == null ? null : jboTypeMap.getSQLType();
    }

    public static String[] getAttrTypesForDisplay() {
        JboTypeMap.populateEntries();
        HashMap hashMap = new HashMap(s_MapList.size());
        int n = 0;
        while (n < s_MapList.size()) {
            String string = ((JboTypeMap)s_MapList.get(n)).getAttrType();
            hashMap.put((Object)string, (Object)string);
            ++n;
        }
        String[] stringArray = new String[hashMap.size()];
        Iterator iterator = hashMap.keySet().iterator();
        n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return JboTypeMap.SortStringArray(stringArray);
    }

    static String[] SortStringArray(String[] stringArray) {
        JboTypeMap.populateEntries();
        int n = -1;
        ArrayList arrayList = new ArrayList(stringArray.length);
        arrayList.add((Object)stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (string.compareTo((String)arrayList.get(n3)) < 0) {
                    arrayList.add(n3, (Object)string);
                    break;
                }
                if (n3 == arrayList.size() - 1) {
                    arrayList.add((Object)string);
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        return (String[])arrayList.toArray((Object[])new String[arrayList.size()]);
    }

    public static void populateConversion(HashMap hashMap) {
        JboTypeMap.populateEntries();
        if (is_FirstMapJboTypeMapEntry) {
            ((JboTypeMapEntries)s_FirstMap).populateConversion(hashMap);
        }
    }

    public static Object convertValue(Class clazz, Class clazz2, Object object, int n) {
        JboTypeMap.populateEntries();
        if (s_FirstMap != null) {
            Object[] objectArray = new Object[]{object};
            if (is_FirstMapJboTypeMapEntry && !((JboTypeMapEntries)s_FirstMap).convertValue(clazz, clazz2, objectArray, n)) {
                Class clazz3 = class$oracle$jbo$CSMessageBundle;
                if (clazz3 == null) {
                    clazz3 = class$oracle$jbo$CSMessageBundle = JboTypeMap.class$("oracle.jbo.CSMessageBundle");
                }
                throw new DataCreationException(clazz3, "25041", new Object[]{clazz.getName(), clazz2.getName(), new Integer(n)}, null);
            }
            return objectArray[0];
        }
        return null;
    }

    public static ArrayList getDomainsWithNoXMLFactory() {
        if (is_FirstMapJboTypeMapEntry) {
            return ((JboTypeMapEntries)s_FirstMap).getDomainsWithNoXMLFactory();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

